/*
 * Decompiled with CFR 0.152.
 */
package ucar.netcdf;

import java.io.Serializable;
import java.lang.reflect.Array;
import ucar.netcdf.AttrVal;
import ucar.netcdf.Named;
import ucar.netcdf.NumericAttrVal;
import ucar.netcdf.ProtoVariable;
import ucar.netcdf.StringAttrVal;

public class Attribute
implements Named,
Serializable,
Cloneable {
    private final String name;
    private final AttrVal value;

    public int hashCode() {
        return this.name.hashCode() ^ this.value.hashCode();
    }

    public boolean equals(Object object) {
        Attribute attribute;
        if (this == object) {
            return true;
        }
        if (object instanceof Attribute && this.name.equals((attribute = (Attribute)object).getName())) {
            return this.value.equals(attribute.value);
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toCdl(stringBuffer);
        return stringBuffer.toString();
    }

    public final String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value.getValue();
    }

    public String getStringValue() {
        return (String)this.value.getValue();
    }

    public Object get(int n) {
        return this.value.get(n);
    }

    public Number getNumericValue(int n) {
        return this.value.getNumericValue(n);
    }

    public Number getNumericValue() {
        return this.value.getNumericValue();
    }

    public boolean isString() {
        return this.value instanceof StringAttrVal;
    }

    public Class getComponentType() {
        return this.value.getComponentType();
    }

    public int getLength() {
        return this.value.getLength();
    }

    public void toCdl(StringBuffer stringBuffer) {
        stringBuffer.append(":");
        stringBuffer.append(this.getName());
        stringBuffer.append(" = ");
        this.value.toCdl(stringBuffer);
        stringBuffer.append(" ;");
    }

    static Object arrayClone(Object object) {
        int n = Array.getLength(object);
        Object object2 = Array.newInstance(object.getClass().getComponentType(), n);
        System.arraycopy(object, 0, object2, 0, n);
        return object2;
    }

    static Class primitiveClass(Number number) {
        try {
            return (Class)number.getClass().getDeclaredField("TYPE").get(number);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new Error();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Error();
        }
    }

    public Attribute(String string, Number number) {
        Class clazz = Attribute.primitiveClass(number);
        if (!ProtoVariable.checkComponentType(clazz)) {
            throw new IllegalArgumentException("Invalid Type: " + clazz);
        }
        this.name = string;
        this.value = new NumericAttrVal(number, clazz);
    }

    public Attribute(String string, double d) {
        this.name = string;
        double[] dArray = new double[]{d};
        this.value = new NumericAttrVal(dArray);
    }

    public Attribute(String string, String string2) {
        this.name = string;
        this.value = new StringAttrVal(string2);
    }

    public Attribute(String string, Object object) {
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            throw new IllegalArgumentException("Not an Array");
        }
        Class<?> clazz2 = clazz.getComponentType();
        if (!ProtoVariable.checkComponentType(clazz2)) {
            throw new IllegalArgumentException("Invalid Type: " + clazz2);
        }
        this.name = string;
        this.value = clazz2 == Character.TYPE ? new StringAttrVal((char[])object) : new NumericAttrVal(Attribute.arrayClone(object));
    }
}

