/*
 * Decompiled with CFR 0.152.
 */
package ucar.multiarray;

import java.io.IOException;
import ucar.multiarray.AbstractAccessor;
import ucar.multiarray.MultiArray;
import ucar.multiarray.MultiArrayImpl;
import ucar.multiarray.MultiArrayProxy;
import ucar.multiarray.SliceMap;

public class StringCharAdapter
implements MultiArray {
    private final MultiArray delegate_;
    private final char fillValue_;
    private final int[] lengths_;
    private final int maxStringLen_;

    public char getFillValue() {
        return this.fillValue_;
    }

    public Class getComponentType() {
        try {
            return Class.forName("java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Implementation problem");
        }
    }

    public int getRank() {
        return this.lengths_.length;
    }

    public int[] getLengths() {
        if (this.isUnlimited()) {
            System.arraycopy(this.delegate_.getLengths(), 0, this.lengths_, 0, this.lengths_.length);
        }
        return (int[])this.lengths_.clone();
    }

    public boolean isUnlimited() {
        return this.delegate_.isUnlimited();
    }

    public boolean isScalar() {
        return this.getRank() == 0;
    }

    public Object get(int[] nArray) throws IOException {
        int[] nArray2 = new int[this.lengths_.length + 1];
        System.arraycopy(nArray, 0, nArray2, 0, this.lengths_.length);
        char[] cArray = new char[this.maxStringLen_];
        int n = 0;
        while (n < this.maxStringLen_) {
            nArray2[this.lengths_.length] = n;
            cArray[n] = this.delegate_.getChar(nArray2);
            if (cArray[n] == this.fillValue_) break;
            ++n;
        }
        return new String(cArray, 0, n);
    }

    public boolean getBoolean(int[] nArray) {
        throw new IllegalArgumentException();
    }

    public char getChar(int[] nArray) throws IOException {
        if (nArray.length > this.lengths_.length) {
            return this.delegate_.getChar(nArray);
        }
        throw new IllegalArgumentException();
    }

    public byte getByte(int[] nArray) {
        throw new IllegalArgumentException();
    }

    public short getShort(int[] nArray) {
        throw new IllegalArgumentException();
    }

    public int getInt(int[] nArray) {
        throw new IllegalArgumentException();
    }

    public long getLong(int[] nArray) {
        throw new IllegalArgumentException();
    }

    public float getFloat(int[] nArray) {
        throw new IllegalArgumentException();
    }

    public double getDouble(int[] nArray) {
        throw new IllegalArgumentException();
    }

    public void set(int[] nArray, Object object) throws IOException {
        if (object instanceof String) {
            int[] nArray2 = new int[this.lengths_.length + 1];
            System.arraycopy(nArray, 0, nArray2, 0, this.lengths_.length);
            String string = (String)object;
            int n = ((String)object).length();
            int n2 = 0;
            while (n2 < this.maxStringLen_) {
                nArray2[this.lengths_.length] = n2;
                if (n2 >= n) {
                    this.delegate_.setChar(nArray2, this.fillValue_);
                } else {
                    this.delegate_.setChar(nArray2, ((String)object).charAt(n2));
                }
                ++n2;
            }
            return;
        }
        throw new IllegalArgumentException();
    }

    public void setBoolean(int[] nArray, boolean bl) {
        throw new IllegalArgumentException();
    }

    public void setChar(int[] nArray, char c) {
        throw new IllegalArgumentException();
    }

    public void setByte(int[] nArray, byte by) {
        throw new IllegalArgumentException();
    }

    public void setShort(int[] nArray, short s) {
        throw new IllegalArgumentException();
    }

    public void setInt(int[] nArray, int n) {
        throw new IllegalArgumentException();
    }

    public void setLong(int[] nArray, long l) {
        throw new IllegalArgumentException();
    }

    public void setFloat(int[] nArray, float f) {
        throw new IllegalArgumentException();
    }

    public void setDouble(int[] nArray, double d) {
        throw new IllegalArgumentException();
    }

    public MultiArray copyout(int[] nArray, int[] nArray2) throws IOException {
        int n = this.getRank();
        if (nArray.length != n || nArray2.length != n) {
            throw new IllegalArgumentException("Rank Mismatch");
        }
        MultiArrayImpl multiArrayImpl = new MultiArrayImpl(this.getComponentType(), nArray2);
        AbstractAccessor.copyO(this, nArray, multiArrayImpl, nArray2);
        return multiArrayImpl;
    }

    public void copyin(int[] nArray, MultiArray multiArray) throws IOException {
        int n = this.getRank();
        if (nArray.length != n || multiArray.getRank() != n) {
            throw new IllegalArgumentException("Rank Mismatch");
        }
        if (multiArray.getComponentType() != this.getComponentType()) {
            throw new ArrayStoreException();
        }
        AbstractAccessor.copy(multiArray, multiArray.getLengths(), this, nArray);
    }

    public Object toArray() throws IOException {
        return this.toArray(null, null, null);
    }

    public Object toArray(Object object, int[] nArray, int[] nArray2) throws IOException {
        int n = this.getRank();
        if (nArray == null) {
            nArray = new int[n];
        } else if (nArray.length != n) {
            throw new IllegalArgumentException("Rank Mismatch");
        }
        int[] nArray3 = null;
        if (nArray2 == null) {
            nArray3 = this.getLengths();
        } else if (nArray2.length == n) {
            nArray3 = (int[])nArray2.clone();
        } else {
            throw new IllegalArgumentException("Rank Mismatch");
        }
        int[] nArray4 = new int[n];
        int n2 = MultiArrayImpl.numberOfElements(nArray3, nArray4);
        object = MultiArrayImpl.fixDest(object, n2, this.getComponentType());
        MultiArrayImpl multiArrayImpl = new MultiArrayImpl(nArray3, nArray4, object);
        AbstractAccessor.copyO(this, nArray, multiArrayImpl, nArray3);
        return object;
    }

    private static String MultiArrayToString(MultiArray multiArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = multiArray.getRank();
        if (n > 0) {
            stringBuffer.append("{\n\t");
            int[] nArray = multiArray.getLengths();
            int n2 = nArray[0] - 1;
            int n3 = 0;
            while (n3 <= n2) {
                MultiArrayProxy multiArrayProxy = new MultiArrayProxy(multiArray, new SliceMap(0, n3));
                stringBuffer.append(StringCharAdapter.MultiArrayToString(multiArrayProxy));
                if (n3 != n2) {
                    stringBuffer.append(", ");
                }
                ++n3;
            }
            stringBuffer.append("\n}");
        } else {
            try {
                stringBuffer.append(multiArray.get(null));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        MultiArrayImpl multiArrayImpl = new MultiArrayImpl(Character.TYPE, new int[]{4, 5});
        StringCharAdapter stringCharAdapter = new StringCharAdapter(multiArrayImpl, '\u0000');
        int[] nArray = new int[]{0};
        try {
            stringCharAdapter.set(nArray, "KDEN");
            nArray[0] = nArray[0] + 1;
            stringCharAdapter.set(nArray, "KBOU");
            nArray[0] = nArray[0] + 1;
            stringCharAdapter.set(nArray, "KABQ");
            nArray[0] = nArray[0] + 1;
            stringCharAdapter.set(nArray, "KPHX");
            System.out.println(StringCharAdapter.MultiArrayToString(stringCharAdapter));
            System.out.println(StringCharAdapter.MultiArrayToString(multiArrayImpl));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public StringCharAdapter(MultiArray multiArray, char c) {
        if (multiArray.getComponentType() != Character.TYPE) {
            throw new IllegalArgumentException("Not a Character Array");
        }
        this.delegate_ = multiArray;
        this.fillValue_ = c;
        this.lengths_ = new int[this.delegate_.getRank() - 1];
        int[] nArray = this.delegate_.getLengths();
        System.arraycopy(nArray, 0, this.lengths_, 0, this.lengths_.length);
        this.maxStringLen_ = nArray[this.lengths_.length];
    }
}

