/*
 * Decompiled with CFR 0.152.
 */
package ucar.multiarray;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import ucar.multiarray.AbstractAccessor;
import ucar.multiarray.IndexIterator;
import ucar.multiarray.MultiArray;

public class MultiArrayImpl
implements MultiArray,
Cloneable,
Serializable {
    public final Object storage;
    private final int[] products;
    private final int[] lengths;

    public static int numberOfElements(int[] nArray) {
        int n = 1;
        int n2 = nArray.length - 1;
        while (n2 >= 0) {
            n *= nArray[n2];
            --n2;
        }
        return n;
    }

    public static int numberOfElements(int[] nArray, int[] nArray2) {
        int n = 1;
        int n2 = nArray.length - 1;
        while (n2 >= 0) {
            int n3 = nArray[n2];
            if (n3 < 0) {
                throw new NegativeArraySizeException();
            }
            nArray2[n2] = n;
            n *= n3;
            --n2;
        }
        return n;
    }

    public Class getComponentType() {
        return this.storage.getClass().getComponentType();
    }

    public int getRank() {
        return this.lengths.length;
    }

    public int[] getLengths() {
        return (int[])this.lengths.clone();
    }

    public boolean isUnlimited() {
        return false;
    }

    public boolean isScalar() {
        return this.getRank() == 0;
    }

    public Object get(int[] nArray) {
        return Array.get(this.storage, this.indexMap(nArray));
    }

    public boolean getBoolean(int[] nArray) {
        return Array.getBoolean(this.storage, this.indexMap(nArray));
    }

    public char getChar(int[] nArray) {
        return Array.getChar(this.storage, this.indexMap(nArray));
    }

    public byte getByte(int[] nArray) {
        return Array.getByte(this.storage, this.indexMap(nArray));
    }

    public short getShort(int[] nArray) {
        return Array.getShort(this.storage, this.indexMap(nArray));
    }

    public int getInt(int[] nArray) {
        return Array.getInt(this.storage, this.indexMap(nArray));
    }

    public long getLong(int[] nArray) {
        return Array.getLong(this.storage, this.indexMap(nArray));
    }

    public float getFloat(int[] nArray) {
        return Array.getFloat(this.storage, this.indexMap(nArray));
    }

    public double getDouble(int[] nArray) {
        return Array.getDouble(this.storage, this.indexMap(nArray));
    }

    public void set(int[] nArray, Object object) {
        Array.set(this.storage, this.indexMap(nArray), object);
    }

    public void setBoolean(int[] nArray, boolean bl) {
        Array.setBoolean(this.storage, this.indexMap(nArray), bl);
    }

    public void setChar(int[] nArray, char c) {
        Array.setChar(this.storage, this.indexMap(nArray), c);
    }

    public void setByte(int[] nArray, byte by) {
        Array.setByte(this.storage, this.indexMap(nArray), by);
    }

    public void setShort(int[] nArray, short s) {
        Array.setShort(this.storage, this.indexMap(nArray), s);
    }

    public void setInt(int[] nArray, int n) {
        Array.setInt(this.storage, this.indexMap(nArray), n);
    }

    public void setLong(int[] nArray, long l) {
        Array.setLong(this.storage, this.indexMap(nArray), l);
    }

    public void setFloat(int[] nArray, float f) {
        Array.setFloat(this.storage, this.indexMap(nArray), f);
    }

    public void setDouble(int[] nArray, double d) {
        Array.setDouble(this.storage, this.indexMap(nArray), d);
    }

    public MultiArray copyout(int[] nArray, int[] nArray2) {
        if (nArray.length != this.lengths.length || nArray2.length != this.lengths.length) {
            throw new IllegalArgumentException("Rank Mismatch");
        }
        int n = this.lengths.length - 1;
        while (n >= 0) {
            if (nArray[n] != 0 || nArray2[n] != this.lengths[n]) break;
            --n;
        }
        if (n < 0) {
            return (MultiArrayImpl)this.clone();
        }
        int[] nArray3 = (int[])nArray2.clone();
        int[] nArray4 = new int[nArray3.length];
        int n2 = MultiArrayImpl.numberOfElements(nArray3, nArray4);
        Object object = Array.newInstance(this.getComponentType(), n2);
        int n3 = this.indexMap(nArray);
        if (n == 0) {
            System.arraycopy(this.storage, n3, object, 0, n2);
        } else {
            int n4 = this.products[--n];
            int n5 = nArray4[n];
            int n6 = 0;
            while (n6 < n2) {
                System.arraycopy(this.storage, n3, object, n6, n5);
                n3 += n4;
                n6 += n5;
            }
        }
        return new MultiArrayImpl(nArray3, nArray4, object);
    }

    public void copyin(int[] nArray, MultiArrayImpl multiArrayImpl) {
        if (nArray.length != this.lengths.length || multiArrayImpl.getRank() != this.lengths.length) {
            throw new IllegalArgumentException("Rank Mismatch");
        }
        int n = this.lengths.length - 1;
        while (n >= 0) {
            if (nArray[n] != 0 || multiArrayImpl.lengths[n] != this.lengths[n]) break;
            --n;
        }
        if (n < 0) {
            System.arraycopy(multiArrayImpl.storage, 0, this.storage, 0, Array.getLength(this.storage));
            return;
        }
        int n2 = this.indexMap(nArray);
        if (n == 0) {
            System.arraycopy(multiArrayImpl.storage, 0, this.storage, n2, Array.getLength(this.storage) - n2);
            return;
        }
        int n3 = this.products[--n];
        int n4 = multiArrayImpl.products[n];
        int n5 = Array.getLength(multiArrayImpl.storage);
        int n6 = 0;
        while (n6 < n5) {
            System.arraycopy(multiArrayImpl.storage, n6, this.storage, n2, n4);
            n2 += n3;
            n6 += n4;
        }
    }

    public void copyin(int[] nArray, MultiArray multiArray) throws IOException {
        if (multiArray instanceof MultiArrayImpl) {
            this.copyin(nArray, (MultiArrayImpl)multiArray);
            return;
        }
        if (nArray.length != this.lengths.length || multiArray.getRank() != this.lengths.length) {
            throw new IllegalArgumentException("Rank Mismatch");
        }
        if (multiArray.getComponentType() != this.getComponentType()) {
            throw new ArrayStoreException();
        }
        AbstractAccessor.copy(multiArray, multiArray.getLengths(), this, nArray);
    }

    public static Object fixDest(Object object, int n, Class clazz) {
        if (object == null || Array.getLength(object) < n) {
            Class<?> clazz2 = object == null ? clazz : object.getClass().getComponentType();
            object = Array.newInstance(clazz2, n);
        }
        return object;
    }

    public Object toArray() {
        int n = Array.getLength(this.storage);
        Object object = Array.newInstance(this.getComponentType(), n);
        System.arraycopy(this.storage, 0, object, 0, n);
        return object;
    }

    public Object toArray(Object object, int[] nArray, int[] nArray2) {
        if (nArray.length != this.lengths.length || nArray2.length != this.lengths.length) {
            throw new IllegalArgumentException("Rank Mismatch");
        }
        int n = this.lengths.length - 1;
        while (n >= 0) {
            if (nArray[n] != 0 || nArray2[n] != this.lengths[n]) break;
            --n;
        }
        if (n < 0) {
            int n2 = Array.getLength(this.storage);
            object = MultiArrayImpl.fixDest(object, n2, this.getComponentType());
            System.arraycopy(this.storage, 0, object, 0, n2);
            return object;
        }
        int[] nArray3 = (int[])nArray2.clone();
        int[] nArray4 = new int[nArray3.length];
        int n3 = MultiArrayImpl.numberOfElements(nArray3, nArray4);
        object = MultiArrayImpl.fixDest(object, n3, this.getComponentType());
        int n4 = this.indexMap(nArray);
        if (n == 0) {
            System.arraycopy(this.storage, n4, object, 0, n3);
            return object;
        }
        int n5 = this.products[--n];
        int n6 = nArray4[n];
        int n7 = 0;
        while (n7 < n3) {
            System.arraycopy(this.storage, n4, object, n7, n6);
            n4 += n5;
            n7 += n6;
        }
        return object;
    }

    public Object clone() {
        return new MultiArrayImpl((int[])this.lengths.clone(), (int[])this.products.clone(), this.toArray());
    }

    public int indexMap(int[] nArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.lengths.length) {
            int n3 = nArray[n2];
            if (n3 < 0 || n3 >= this.lengths[n2]) {
                throw new ArrayIndexOutOfBoundsException();
            }
            n += n3 * this.products[n2];
            ++n2;
        }
        return n;
    }

    public static void main(String[] stringArray) {
        Object object;
        int[] nArray = new int[]{48, 64};
        MultiArrayImpl multiArrayImpl = new MultiArrayImpl(Integer.TYPE, nArray);
        int n = MultiArrayImpl.numberOfElements(nArray);
        int n2 = 0;
        while (n2 < n) {
            Array.setInt(multiArrayImpl.storage, n2, n2);
            ++n2;
        }
        int[] nArray2 = new int[]{32, 64};
        int[] nArray3 = new int[]{8, 0};
        MultiArray multiArray = multiArrayImpl.copyout(nArray3, nArray2);
        try {
            System.out.println("Rank  " + multiArray.getRank());
            object = multiArray.getLengths();
            System.out.println("Shape { " + object[0] + ", " + object[1] + " }");
            System.out.println(multiArray.getInt(new int[]{0, 0}));
            System.out.println(multiArray.getInt(new int[]{1, 0}));
            System.out.println(multiArray.getInt(new int[]{(int)(object[0] - true), (int)(object[1] - true)}));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        nArray2 = new int[]{48, 48};
        nArray3 = new int[]{0, 8};
        multiArray = multiArrayImpl.copyout(nArray3, nArray2);
        try {
            System.out.println("Rank  " + multiArray.getRank());
            object = multiArray.getLengths();
            System.out.println("Shape { " + (int)object[0] + ", " + (int)object[1] + " }");
            System.out.println(multiArray.getInt(new int[]{0, 0}));
            System.out.println(multiArray.getInt(new int[]{1, 0}));
            System.out.println(multiArray.getInt(new int[]{(int)(object[0] - true), (int)(object[1] - true)}));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        object = new MultiArrayImpl(Integer.TYPE, nArray);
        try {
            ((MultiArrayImpl)object).copyin(nArray3, multiArray);
            System.out.println("***Rank  " + ((MultiArrayImpl)object).getRank());
            int[] nArray4 = ((MultiArrayImpl)object).getLengths();
            System.out.println("Shape { " + nArray4[0] + ", " + nArray4[1] + " }");
            System.out.println(((MultiArrayImpl)object).getInt(new int[]{0, 0}));
            System.out.println(((MultiArrayImpl)object).getInt(new int[]{0, 7}));
            System.out.println(((MultiArrayImpl)object).getInt(new int[]{0, 8}));
            System.out.println(((MultiArrayImpl)object).getInt(new int[]{47, 55}));
            System.out.println(((MultiArrayImpl)object).getInt(new int[]{47, 56}));
            System.out.println(((MultiArrayImpl)object).getInt(new int[]{47, 63}));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public MultiArrayImpl(Class clazz, int[] nArray) {
        this.lengths = (int[])nArray.clone();
        this.products = new int[nArray.length];
        int n = MultiArrayImpl.numberOfElements(nArray, this.products);
        if (n == 0) {
            n = 1;
        }
        this.storage = Array.newInstance(clazz, n);
    }

    public MultiArrayImpl(MultiArray multiArray) throws IOException {
        this.lengths = (int[])multiArray.getLengths().clone();
        this.products = new int[this.lengths.length];
        int n = MultiArrayImpl.numberOfElements(this.lengths, this.products);
        if (n == 0) {
            n = 1;
        }
        this.storage = Array.newInstance(multiArray.getComponentType(), n);
        IndexIterator indexIterator = new IndexIterator(this.lengths);
        while (indexIterator.notDone()) {
            int[] nArray = indexIterator.value();
            this.set(nArray, multiArray.get(nArray));
            indexIterator.incr();
        }
    }

    public MultiArrayImpl(int[] nArray, Object object) {
        this.lengths = nArray;
        this.products = new int[nArray.length];
        int n = MultiArrayImpl.numberOfElements(this.lengths, this.products);
        if (n > Array.getLength(object)) {
            throw new IllegalArgumentException("Inadequate storage");
        }
        this.storage = object;
    }

    public MultiArrayImpl(int[] nArray, int[] nArray2, Object object) {
        this.lengths = nArray;
        this.products = nArray2;
        this.storage = object;
    }
}

