/*
 * Decompiled with CFR 0.152.
 */
package ucar.multiarray;

import java.lang.reflect.Array;
import ucar.multiarray.IndexMap;

public class ConcreteIndexMap
implements IndexMap {
    protected ZZMap iMap_;
    protected ZZMap lengthsMap_;

    protected final void init(ZZMap zZMap, ZZMap zZMap2) {
        this.iMap_ = zZMap;
        this.lengthsMap_ = zZMap2;
    }

    protected final void init(ZZMap zZMap) {
        this.init(zZMap, new ZZMap());
    }

    protected final void link(ConcreteIndexMap concreteIndexMap, ZZMap zZMap, ZZMap zZMap2) {
        this.iMap_ = concreteIndexMap.iMap_;
        this.lengthsMap_ = zZMap2;
        this.iMap_.setPrev(zZMap);
        this.lengthsMap_.setPrev(concreteIndexMap.lengthsMap_);
    }

    protected final void link(ConcreteIndexMap concreteIndexMap, ZZMap zZMap) {
        this.link(concreteIndexMap, zZMap, new ZZMap());
    }

    public final synchronized int getOutputLength() {
        return this.iMap_.size();
    }

    public final synchronized void setInput(int[] nArray) {
        this.iMap_.rebind(nArray);
    }

    public final synchronized int[] getTransformed(int[] nArray) {
        int n = this.getOutputLength();
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = this.iMap_.get(n2);
            ++n2;
        }
        return nArray;
    }

    public final synchronized int[] transform(int[] nArray, int[] nArray2) {
        this.setInput(nArray2);
        return this.getTransformed(nArray);
    }

    public final synchronized int getRank() {
        return this.lengthsMap_.size();
    }

    public final synchronized void setLengths(int[] nArray) {
        this.lengthsMap_.rebind(nArray);
        if (this.getRank() < 0) {
            throw new IllegalArgumentException("rank < 0");
        }
    }

    public final synchronized int[] getLengths(int[] nArray) {
        int n = this.lengthsMap_.size();
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = this.lengthsMap_.get(n2);
            ++n2;
        }
        return nArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString() + "\n\t");
        stringBuffer.append(this.iMap_.toString() + "\n\t");
        stringBuffer.append(this.lengthsMap_.toString());
        return stringBuffer.toString();
    }

    private static void testZZMap() {
        System.out.println("Testing Inner Class ZZMap");
        ConcreteIndexMap concreteIndexMap = new ConcreteIndexMap();
        System.out.println("Unbound:");
        ConcreteIndexMap concreteIndexMap2 = concreteIndexMap;
        if (concreteIndexMap2 == null) {
            throw null;
        }
        ZZMap zZMap = concreteIndexMap2.new ZZMap();
        System.out.println("\t" + zZMap);
        ConcreteIndexMap concreteIndexMap3 = concreteIndexMap;
        if (concreteIndexMap3 == null) {
            throw null;
        }
        ZZMap zZMap2 = concreteIndexMap3.new ZZMap(zZMap);
        System.out.println("\t" + zZMap2);
        System.out.println("Bernoulli");
        int[] nArray = new int[]{1, 1, 2, 3, 5, 8, 13};
        zZMap.rebind(nArray);
        System.out.println("\t" + zZMap);
        System.out.println("\t" + zZMap2);
        System.out.println("Rebound");
        int[] nArray2 = new int[]{1, 2, 4, 8};
        zZMap2.rebind(nArray2);
        System.out.println("\t" + zZMap);
        System.out.println("\t" + zZMap2);
        System.out.println("End ZZMap Test");
    }

    private static void testInit() {
        ConcreteIndexMap concreteIndexMap;
        ConcreteIndexMap concreteIndexMap2;
        System.out.println("Testing init() and link() ");
        ConcreteIndexMap concreteIndexMap3 = concreteIndexMap2 = new ConcreteIndexMap();
        if (concreteIndexMap3 == null) {
            throw null;
        }
        ConcreteIndexMap concreteIndexMap4 = concreteIndexMap2;
        if (concreteIndexMap4 == null) {
            throw null;
        }
        concreteIndexMap2.init(concreteIndexMap3.new ZZMap(), concreteIndexMap4.new ZZMap());
        System.out.println("Unbound:        " + concreteIndexMap2);
        ConcreteIndexMap concreteIndexMap5 = concreteIndexMap = new ConcreteIndexMap();
        if (concreteIndexMap5 == null) {
            throw null;
        }
        ConcreteIndexMap concreteIndexMap6 = concreteIndexMap;
        if (concreteIndexMap6 == null) {
            throw null;
        }
        concreteIndexMap.link(concreteIndexMap2, concreteIndexMap5.new ZZMap(), concreteIndexMap6.new ZZMap());
        System.out.println("Next Unbound:   " + concreteIndexMap);
        int[] nArray = new int[]{1, 1, 2, 3, 5, 8, 13};
        int[] nArray2 = new int[]{1, 2, 4, 8};
        concreteIndexMap.setInput(nArray);
        concreteIndexMap.setLengths(nArray2);
        System.out.println("forward  :      " + concreteIndexMap2);
        System.out.println("Next forward  : " + concreteIndexMap);
        concreteIndexMap.setInput(nArray2);
        concreteIndexMap.setLengths(nArray);
        System.out.println("reversed:       " + concreteIndexMap2);
        System.out.println("Next reversed:  " + concreteIndexMap);
        System.out.println("End init(), link() test");
    }

    public static void main(String[] stringArray) {
        ConcreteIndexMap.testZZMap();
        ConcreteIndexMap.testInit();
    }

    protected ConcreteIndexMap() {
    }

    protected class ZZMap {
        private Object prev_;

        synchronized int get(int n) {
            if (this.prev_ instanceof ZZMap) {
                return ((ZZMap)this.prev_).get(n);
            }
            try {
                return Array.getInt(this.prev_, n);
            }
            catch (RuntimeException runtimeException) {
                throw new IllegalArgumentException("Improper Binding");
            }
        }

        final synchronized void rebind(int[] nArray) {
            if (this.prev_ instanceof ZZMap) {
                ((ZZMap)this.prev_).rebind(nArray);
                return;
            }
            this.prev_ = nArray;
        }

        synchronized int size() {
            if (this.prev_ instanceof ZZMap) {
                return ((ZZMap)this.prev_).size();
            }
            try {
                return Array.getLength(this.prev_);
            }
            catch (NullPointerException nullPointerException) {
                return 0;
            }
        }

        final synchronized void setPrev(ZZMap zZMap) {
            if (this.prev_ instanceof ZZMap) {
                ((ZZMap)this.prev_).setPrev(zZMap);
                return;
            }
            this.prev_ = zZMap;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(super.toString());
            int n = this.size();
            stringBuffer.append(" [");
            stringBuffer.append(n);
            stringBuffer.append("]");
            stringBuffer.append(" {");
            int n2 = n - 1;
            int n3 = 0;
            while (n3 < n) {
                stringBuffer.append(this.get(n3));
                if (n3 == n2) break;
                stringBuffer.append(", ");
                ++n3;
            }
            stringBuffer.append("}");
            return stringBuffer.toString();
        }

        protected ZZMap() {
            this.rebind(null);
        }

        protected ZZMap(ZZMap zZMap) {
            this.setPrev(zZMap);
        }
    }
}

