/*
 * Decompiled with CFR 0.152.
 */
package ucar.multiarray;

import java.io.IOException;
import java.lang.reflect.Array;
import ucar.multiarray.AbstractAccessor;
import ucar.multiarray.IndexIterator;
import ucar.multiarray.MultiArray;
import ucar.multiarray.MultiArrayImpl;
import ucar.multiarray.OffsetIndexIterator;

public class ArrayMultiArray
implements MultiArray {
    public final Object jla;
    private final int rank;
    private final Class componentType;

    public Class getComponentType() {
        return this.componentType;
    }

    public int getRank() {
        return this.rank;
    }

    public int[] getLengths() {
        int[] nArray = new int[this.rank];
        Object object = this.jla;
        int n = 0;
        while (n < this.rank) {
            nArray[n] = Array.getLength(object);
            object = Array.get(object, 0);
            ++n;
        }
        return nArray;
    }

    public boolean isUnlimited() {
        return false;
    }

    public boolean isScalar() {
        return this.rank == 0;
    }

    public Object get(int[] nArray) {
        if (nArray.length < this.rank) {
            throw new IllegalArgumentException();
        }
        int n = this.rank - 1;
        Object object = this.jla;
        int n2 = 0;
        while (n2 < n) {
            object = Array.get(object, nArray[n2]);
            ++n2;
        }
        return Array.get(object, nArray[n]);
    }

    public boolean getBoolean(int[] nArray) {
        if (nArray.length < this.rank) {
            throw new IllegalArgumentException();
        }
        int n = this.rank - 1;
        Object object = this.jla;
        int n2 = 0;
        while (n2 < n) {
            object = Array.get(object, nArray[n2]);
            ++n2;
        }
        return Array.getBoolean(object, nArray[n]);
    }

    public char getChar(int[] nArray) {
        if (nArray.length < this.rank) {
            throw new IllegalArgumentException();
        }
        int n = this.rank - 1;
        Object object = this.jla;
        int n2 = 0;
        while (n2 < n) {
            object = Array.get(object, nArray[n2]);
            ++n2;
        }
        return Array.getChar(object, nArray[n]);
    }

    public byte getByte(int[] nArray) {
        if (nArray.length < this.rank) {
            throw new IllegalArgumentException();
        }
        int n = this.rank - 1;
        Object object = this.jla;
        int n2 = 0;
        while (n2 < n) {
            object = Array.get(object, nArray[n2]);
            ++n2;
        }
        return Array.getByte(object, nArray[n]);
    }

    public short getShort(int[] nArray) {
        if (nArray.length < this.rank) {
            throw new IllegalArgumentException();
        }
        int n = this.rank - 1;
        Object object = this.jla;
        int n2 = 0;
        while (n2 < n) {
            object = Array.get(object, nArray[n2]);
            ++n2;
        }
        return Array.getShort(object, nArray[n]);
    }

    public int getInt(int[] nArray) {
        if (nArray.length < this.rank) {
            throw new IllegalArgumentException();
        }
        int n = this.rank - 1;
        Object object = this.jla;
        int n2 = 0;
        while (n2 < n) {
            object = Array.get(object, nArray[n2]);
            ++n2;
        }
        return Array.getInt(object, nArray[n]);
    }

    public long getLong(int[] nArray) {
        if (nArray.length < this.rank) {
            throw new IllegalArgumentException();
        }
        int n = this.rank - 1;
        Object object = this.jla;
        int n2 = 0;
        while (n2 < n) {
            object = Array.get(object, nArray[n2]);
            ++n2;
        }
        return Array.getLong(object, nArray[n]);
    }

    public float getFloat(int[] nArray) {
        if (nArray.length < this.rank) {
            throw new IllegalArgumentException();
        }
        int n = this.rank - 1;
        Object object = this.jla;
        int n2 = 0;
        while (n2 < n) {
            object = Array.get(object, nArray[n2]);
            ++n2;
        }
        return Array.getFloat(object, nArray[n]);
    }

    public double getDouble(int[] nArray) {
        if (nArray.length < this.rank) {
            throw new IllegalArgumentException();
        }
        int n = this.rank - 1;
        Object object = this.jla;
        int n2 = 0;
        while (n2 < n) {
            object = Array.get(object, nArray[n2]);
            ++n2;
        }
        return Array.getDouble(object, nArray[n]);
    }

    public void set(int[] nArray, Object object) {
        if (nArray.length < this.rank) {
            throw new IllegalArgumentException();
        }
        int n = this.rank - 1;
        Object object2 = this.jla;
        int n2 = 0;
        while (n2 < n) {
            object2 = Array.get(object2, nArray[n2]);
            ++n2;
        }
        Array.set(object2, nArray[n], object);
    }

    public void setBoolean(int[] nArray, boolean bl) {
        if (nArray.length < this.rank) {
            throw new IllegalArgumentException();
        }
        int n = this.rank - 1;
        Object object = this.jla;
        int n2 = 0;
        while (n2 < n) {
            object = Array.get(object, nArray[n2]);
            ++n2;
        }
        Array.setBoolean(object, nArray[n], bl);
    }

    public void setChar(int[] nArray, char c) {
        if (nArray.length < this.rank) {
            throw new IllegalArgumentException();
        }
        int n = this.rank - 1;
        Object object = this.jla;
        int n2 = 0;
        while (n2 < n) {
            object = Array.get(object, nArray[n2]);
            ++n2;
        }
        Array.setChar(object, nArray[n], c);
    }

    public void setByte(int[] nArray, byte by) {
        if (nArray.length < this.rank) {
            throw new IllegalArgumentException();
        }
        int n = this.rank - 1;
        Object object = this.jla;
        int n2 = 0;
        while (n2 < n) {
            object = Array.get(object, nArray[n2]);
            ++n2;
        }
        Array.setByte(object, nArray[n], by);
    }

    public void setShort(int[] nArray, short s) {
        if (nArray.length < this.rank) {
            throw new IllegalArgumentException();
        }
        int n = this.rank - 1;
        Object object = this.jla;
        int n2 = 0;
        while (n2 < n) {
            object = Array.get(object, nArray[n2]);
            ++n2;
        }
        Array.setShort(object, nArray[n], s);
    }

    public void setInt(int[] nArray, int n) {
        if (nArray.length < this.rank) {
            throw new IllegalArgumentException();
        }
        int n2 = this.rank - 1;
        Object object = this.jla;
        int n3 = 0;
        while (n3 < n2) {
            object = Array.get(object, nArray[n3]);
            ++n3;
        }
        Array.setInt(object, nArray[n2], n);
    }

    public void setLong(int[] nArray, long l) {
        if (nArray.length < this.rank) {
            throw new IllegalArgumentException();
        }
        int n = this.rank - 1;
        Object object = this.jla;
        int n2 = 0;
        while (n2 < n) {
            object = Array.get(object, nArray[n2]);
            ++n2;
        }
        Array.setLong(object, nArray[n], l);
    }

    public void setFloat(int[] nArray, float f) {
        if (nArray.length < this.rank) {
            throw new IllegalArgumentException();
        }
        int n = this.rank - 1;
        Object object = this.jla;
        int n2 = 0;
        while (n2 < n) {
            object = Array.get(object, nArray[n2]);
            ++n2;
        }
        Array.setFloat(object, nArray[n], f);
    }

    public void setDouble(int[] nArray, double d) {
        if (nArray.length < this.rank) {
            throw new IllegalArgumentException();
        }
        int n = this.rank - 1;
        Object object = this.jla;
        int n2 = 0;
        while (n2 < n) {
            object = Array.get(object, nArray[n2]);
            ++n2;
        }
        Array.setDouble(object, nArray[n], d);
    }

    public MultiArray copyout(int[] nArray, int[] nArray2) {
        if (nArray.length != this.rank || nArray2.length != this.rank) {
            throw new IllegalArgumentException("Rank Mismatch");
        }
        int[] nArray3 = (int[])nArray2.clone();
        int[] nArray4 = new int[nArray3.length];
        int n = MultiArrayImpl.numberOfElements(nArray3, nArray4);
        Object object = Array.newInstance(this.getComponentType(), n);
        int n2 = this.rank - 1;
        int n3 = nArray[n2];
        if (n2 == 0) {
            System.arraycopy(this.jla, n3, object, 0, n);
        } else {
            int n4 = nArray4[--n2];
            OffsetIndexIterator offsetIndexIterator = new OffsetIndexIterator(ArrayMultiArray.truncCopy(nArray), this.getTruncLengths());
            int n5 = 0;
            while (n5 < n) {
                System.arraycopy(this.getLeaf(offsetIndexIterator.value()), n3, object, n5, n4);
                offsetIndexIterator.incr();
                n5 += n4;
            }
        }
        return new MultiArrayImpl(nArray3, nArray4, object);
    }

    public void copyin(int[] nArray, MultiArray multiArray) throws IOException {
        if (nArray.length != this.rank || multiArray.getRank() != this.rank) {
            throw new IllegalArgumentException("Rank Mismatch");
        }
        if (multiArray.getComponentType() != this.componentType) {
            throw new ArrayStoreException();
        }
        AbstractAccessor.copy(multiArray, multiArray.getLengths(), this, nArray);
    }

    public Object toArray() {
        return this.toArray(null, null, null);
    }

    public Object toArray(Object object, int[] nArray, int[] nArray2) {
        if (nArray == null) {
            nArray = new int[this.rank];
        } else if (nArray.length != this.rank) {
            throw new IllegalArgumentException("Rank Mismatch");
        }
        int[] nArray3 = null;
        if (nArray2 == null) {
            nArray3 = this.getLengths();
        } else if (nArray2.length == this.rank) {
            nArray3 = (int[])nArray2.clone();
        } else {
            throw new IllegalArgumentException("Rank Mismatch");
        }
        int[] nArray4 = new int[nArray3.length];
        int n = MultiArrayImpl.numberOfElements(nArray3, nArray4);
        object = MultiArrayImpl.fixDest(object, n, this.componentType);
        int n2 = this.rank - 1;
        int n3 = nArray[n2];
        if (n2 == 0) {
            System.arraycopy(this.jla, n3, object, 0, n);
        } else {
            int n4 = nArray4[--n2];
            OffsetIndexIterator offsetIndexIterator = new OffsetIndexIterator(ArrayMultiArray.truncCopy(nArray), this.getTruncLengths());
            int n5 = 0;
            while (n5 < n) {
                System.arraycopy(this.getLeaf(offsetIndexIterator.value()), n3, object, n5, n4);
                offsetIndexIterator.incr();
                n5 += n4;
            }
        }
        return object;
    }

    static int[] truncCopy(int[] nArray) {
        int n = nArray.length - 1;
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    public Object get(int n) {
        if (this.rank == 1) {
            return Array.get(this.jla, n);
        }
        return new ArrayMultiArray(Array.get(this.jla, n), this.rank - 1, this.componentType);
    }

    public Object getLeaf(int[] nArray) {
        int n = this.rank - 2;
        if (nArray.length <= n) {
            throw new IllegalArgumentException();
        }
        Object object = this.jla;
        int n2 = 0;
        while (n2 < n) {
            object = Array.get(object, nArray[n2]);
            ++n2;
        }
        return Array.get(object, nArray[n]);
    }

    private int[] getTruncLengths() {
        int n = this.rank - 1;
        int[] nArray = new int[n];
        Object object = this.jla;
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = Array.getLength(object);
            object = Array.get(object, 0);
            ++n2;
        }
        return nArray;
    }

    public static void main(String[] stringArray) {
        Object object;
        System.out.println(">>  " + System.currentTimeMillis());
        int[] nArray = new int[]{48, 64};
        MultiArrayImpl multiArrayImpl = new MultiArrayImpl(Integer.TYPE, nArray);
        int n = MultiArrayImpl.numberOfElements(nArray);
        int n2 = 0;
        while (n2 < n) {
            Array.setInt(multiArrayImpl.storage, n2, n2);
            ++n2;
        }
        ArrayMultiArray arrayMultiArray = null;
        try {
            arrayMultiArray = new ArrayMultiArray(multiArrayImpl);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        int[] nArray2 = new int[]{32, 64};
        int[] nArray3 = new int[]{8, 0};
        MultiArray multiArray = arrayMultiArray.copyout(nArray3, nArray2);
        try {
            System.out.println("Rank  " + multiArray.getRank());
            object = multiArray.getLengths();
            System.out.println("Shape { " + object[0] + ", " + object[1] + " }");
            System.out.println(multiArray.getInt(new int[]{0, 0}));
            System.out.println(multiArray.getInt(new int[]{1, 0}));
            System.out.println(multiArray.getInt(new int[]{(int)(object[0] - true), (int)(object[1] - true)}));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        nArray2 = new int[]{48, 48};
        nArray3 = new int[]{0, 8};
        multiArray = arrayMultiArray.copyout(nArray3, nArray2);
        try {
            System.out.println("Rank  " + multiArray.getRank());
            object = multiArray.getLengths();
            System.out.println("Shape { " + (int)object[0] + ", " + (int)object[1] + " }");
            System.out.println(multiArray.getInt(new int[]{0, 0}));
            System.out.println(multiArray.getInt(new int[]{1, 0}));
            System.out.println(multiArray.getInt(new int[]{(int)(object[0] - true), (int)(object[1] - true)}));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        object = new ArrayMultiArray(Integer.TYPE, nArray);
        try {
            ((ArrayMultiArray)object).copyin(nArray3, multiArray);
            System.out.println("***Rank  " + ((ArrayMultiArray)object).getRank());
            int[] nArray4 = ((ArrayMultiArray)object).getLengths();
            System.out.println("Shape { " + nArray4[0] + ", " + nArray4[1] + " }");
            System.out.println(((ArrayMultiArray)object).getInt(new int[]{0, 0}));
            System.out.println(((ArrayMultiArray)object).getInt(new int[]{0, 7}));
            System.out.println(((ArrayMultiArray)object).getInt(new int[]{0, 8}));
            System.out.println(((ArrayMultiArray)object).getInt(new int[]{47, 55}));
            System.out.println(((ArrayMultiArray)object).getInt(new int[]{47, 56}));
            System.out.println(((ArrayMultiArray)object).getInt(new int[]{47, 63}));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    ArrayMultiArray(Object object, int n, Class clazz) {
        this.jla = object;
        this.rank = n;
        this.componentType = clazz;
    }

    public ArrayMultiArray(Object object) {
        int n = 0;
        Class<?> clazz = object.getClass();
        while (clazz.isArray()) {
            ++n;
            clazz = clazz.getComponentType();
        }
        if (n == 0) {
            throw new IllegalArgumentException();
        }
        this.jla = object;
        this.rank = n;
        this.componentType = clazz;
    }

    public ArrayMultiArray(Class clazz, int[] nArray) {
        this.rank = nArray.length;
        if (this.rank == 0) {
            throw new IllegalArgumentException();
        }
        this.componentType = clazz;
        this.jla = Array.newInstance(clazz, nArray);
    }

    public ArrayMultiArray(MultiArray multiArray) throws IOException {
        this.rank = multiArray.getRank();
        if (this.rank == 0) {
            throw new IllegalArgumentException();
        }
        this.componentType = multiArray.getComponentType();
        int[] nArray = multiArray.getLengths();
        this.jla = Array.newInstance(this.componentType, nArray);
        IndexIterator indexIterator = new IndexIterator(nArray);
        while (indexIterator.notDone()) {
            int[] nArray2 = indexIterator.value();
            this.set(nArray2, multiArray.get(nArray2));
            indexIterator.incr();
        }
    }
}

