/*
 * Decompiled with CFR 0.152.
 */
package ucar.multiarray;

import java.io.IOException;
import ucar.multiarray.Accessor;
import ucar.multiarray.MultiArray;
import ucar.multiarray.OffsetDualIndexIterator;

public abstract class AbstractAccessor
implements Accessor {
    public static void copy(Accessor accessor, int[] nArray, Accessor accessor2, int[] nArray2) throws IOException {
        OffsetDualIndexIterator offsetDualIndexIterator = new OffsetDualIndexIterator(nArray2, nArray);
        while (offsetDualIndexIterator.notDone()) {
            accessor2.set(offsetDualIndexIterator.offsetValue(), accessor.get(offsetDualIndexIterator.value()));
            offsetDualIndexIterator.incr();
        }
    }

    public static void copyO(Accessor accessor, int[] nArray, Accessor accessor2, int[] nArray2) throws IOException {
        OffsetDualIndexIterator offsetDualIndexIterator = new OffsetDualIndexIterator(nArray, nArray2);
        while (offsetDualIndexIterator.notDone()) {
            accessor2.set(offsetDualIndexIterator.value(), accessor.get(offsetDualIndexIterator.offsetValue()));
            offsetDualIndexIterator.incr();
        }
    }

    public abstract Object get(int[] var1) throws IOException;

    public boolean getBoolean(int[] nArray) throws IOException {
        Boolean bl = (Boolean)this.get(nArray);
        return bl;
    }

    public char getChar(int[] nArray) throws IOException {
        Character c = (Character)this.get(nArray);
        return c.charValue();
    }

    public byte getByte(int[] nArray) throws IOException {
        Number number = (Number)this.get(nArray);
        return number.byteValue();
    }

    public short getShort(int[] nArray) throws IOException {
        Number number = (Number)this.get(nArray);
        return number.shortValue();
    }

    public int getInt(int[] nArray) throws IOException {
        Number number = (Number)this.get(nArray);
        return number.intValue();
    }

    public long getLong(int[] nArray) throws IOException {
        Number number = (Number)this.get(nArray);
        return number.longValue();
    }

    public float getFloat(int[] nArray) throws IOException {
        Number number = (Number)this.get(nArray);
        return number.floatValue();
    }

    public double getDouble(int[] nArray) throws IOException {
        Number number = (Number)this.get(nArray);
        return number.doubleValue();
    }

    public abstract void set(int[] var1, Object var2) throws IOException;

    public void setBoolean(int[] nArray, boolean bl) throws IOException {
        this.set(nArray, new Boolean(bl));
    }

    public void setChar(int[] nArray, char c) throws IOException {
        this.set(nArray, new Character(c));
    }

    public void setByte(int[] nArray, byte by) throws IOException {
        this.set(nArray, new Byte(by));
    }

    public void setShort(int[] nArray, short s) throws IOException {
        this.set(nArray, new Short(s));
    }

    public void setInt(int[] nArray, int n) throws IOException {
        this.set(nArray, new Integer(n));
    }

    public void setLong(int[] nArray, long l) throws IOException {
        this.set(nArray, new Long(l));
    }

    public void setFloat(int[] nArray, float f) throws IOException {
        this.set(nArray, new Float(f));
    }

    public void setDouble(int[] nArray, double d) throws IOException {
        this.set(nArray, new Float(d));
    }

    public abstract MultiArray copyout(int[] var1, int[] var2) throws IOException;

    public void copyin(int[] nArray, MultiArray multiArray) throws IOException {
        OffsetDualIndexIterator offsetDualIndexIterator = new OffsetDualIndexIterator(nArray, multiArray.getLengths());
        while (offsetDualIndexIterator.notDone()) {
            this.set(offsetDualIndexIterator.offsetValue(), multiArray.get(offsetDualIndexIterator.value()));
            offsetDualIndexIterator.incr();
        }
    }

    public abstract Object toArray() throws IOException;

    public abstract Object toArray(Object var1, int[] var2, int[] var3) throws IOException;
}

