/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.DataTable;
import nom.tam.util.TableException;

public class ColumnTable
implements DataTable {
    private Object[] arrays;
    private int[] sizes;
    private int nrow;
    private int chunk;
    private int rowSize;
    private char[] types;
    private Class[] bases;
    private byte[][] bytePointers;
    private short[][] shortPointers;
    private int[][] intPointers;
    private long[][] longPointers;
    private float[][] floatPointers;
    private double[][] doublePointers;
    private char[][] charPointers;
    private boolean[][] booleanPointers;

    protected void setup(Object[] objectArray, int[] nArray) throws TableException {
        this.checkArrayConsistency(objectArray, nArray);
        this.getNumberOfRows();
        this.initializePointers();
    }

    public int getNrow() {
        return this.nrow;
    }

    public int getNcol() {
        return this.arrays.length;
    }

    public Object getColumn(int n) {
        return this.arrays[n];
    }

    public void setColumn(int n, Object object) throws TableException {
        this.arrays[n] = object;
        this.setup(this.arrays, this.sizes);
    }

    public Object getElement(int n, int n2) {
        Object object = Array.newInstance(this.bases[n2], this.sizes[n2]);
        System.arraycopy(this.arrays[n2], this.sizes[n2] * n, object, 0, this.sizes[n2]);
        return object;
    }

    public void setElement(int n, int n2, Object object) throws TableException {
        String string = object.getClass().getName();
        if (!string.equals("[" + this.types[n2])) {
            throw new TableException("setElement: Incompatible element type");
        }
        if (Array.getLength(object) != this.sizes[n2]) {
            throw new TableException("setElement: Incompatible element size");
        }
        System.arraycopy(object, 0, this.arrays[n2], this.sizes[n2] * n, this.sizes[n2]);
    }

    public Object getRow(int n) {
        Object[] objectArray = new Object[this.arrays.length];
        int n2 = 0;
        while (n2 < this.arrays.length) {
            objectArray[n2] = this.getElement(n, n2);
            ++n2;
        }
        return objectArray;
    }

    public void setRow(int n, Object object) throws TableException {
        if (!(object instanceof Object[])) {
            throw new TableException("setRow: Incompatible row");
        }
        int n2 = 0;
        while (n2 < this.arrays.length) {
            this.setElement(n, n2, ((Object[])object)[n2]);
            ++n2;
        }
    }

    protected void checkArrayConsistency(Object[] objectArray, int[] nArray) throws TableException {
        if (objectArray.length != nArray.length) {
            throw new TableException("readArraysAsColumns: Incompatible arrays and sizes.");
        }
        int n = 0;
        int n2 = 0;
        this.types = new char[objectArray.length];
        this.bases = new Class[objectArray.length];
        boolean bl = true;
        int n3 = 0;
        while (n3 < objectArray.length) {
            if (Array.getLength(objectArray[n3]) > 0) {
                bl = false;
                break;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < objectArray.length) {
            String string = objectArray[n3].getClass().getName();
            if (string.charAt(0) != '[' || string.length() != 2) {
                throw new TableException("Non-primitive array");
            }
            int n4 = Array.getLength(objectArray[n3]);
            if (n4 != 0 || nArray[n3] != 0) {
                if (!(n4 != 0 && nArray[n3] > 0 || bl)) {
                    throw new TableException("Invalid size for array: index=" + n3);
                }
                if (n4 % nArray[n3] != 0) {
                    throw new TableException("Row size does not divide array: index=" + n3);
                }
                if (nArray[n3] > 0) {
                    int n5 = n4 / nArray[n3];
                    if (n != 0 && n5 != n) {
                        throw new TableException("Different number of rows in different columns");
                    }
                    n = n5;
                }
                n2 += nArray[n3] * ArrayFuncs.getBaseLength(objectArray[n3]);
                this.types[n3] = string.charAt(1);
                this.bases[n3] = ArrayFuncs.getBaseClass(objectArray[n3]);
            }
            ++n3;
        }
        this.nrow = n;
        this.rowSize = n2;
        this.arrays = objectArray;
        this.sizes = nArray;
    }

    protected void getNumberOfRows() {
        int n = 65536;
        this.chunk = this.rowSize == 0 ? 0 : (this.rowSize > n ? 1 : (n / this.rowSize >= this.nrow ? this.nrow : n / this.rowSize + 1));
    }

    protected void initializePointers() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        while (n9 < this.arrays.length) {
            switch (this.types[n9]) {
                case 'B': {
                    ++n;
                    break;
                }
                case 'S': {
                    ++n2;
                    break;
                }
                case 'I': {
                    ++n3;
                    break;
                }
                case 'L': {
                    ++n4;
                    break;
                }
                case 'F': {
                    ++n5;
                    break;
                }
                case 'D': {
                    ++n6;
                    break;
                }
                case 'C': {
                    ++n7;
                    break;
                }
                case 'Z': {
                    ++n8;
                    break;
                }
            }
            ++n9;
        }
        this.bytePointers = new byte[n][];
        this.shortPointers = new short[n2][];
        this.intPointers = new int[n3][];
        this.longPointers = new long[n4][];
        this.floatPointers = new float[n5][];
        this.doublePointers = new double[n6][];
        this.charPointers = new char[n7][];
        this.booleanPointers = new boolean[n8][];
        n = 0;
        n2 = 0;
        n3 = 0;
        n4 = 0;
        n5 = 0;
        n6 = 0;
        n7 = 0;
        n8 = 0;
        n9 = 0;
        while (n9 < this.arrays.length) {
            switch (this.types[n9]) {
                case 'B': {
                    this.bytePointers[n] = (byte[])this.arrays[n9];
                    ++n;
                    break;
                }
                case 'S': {
                    this.shortPointers[n2] = (short[])this.arrays[n9];
                    ++n2;
                    break;
                }
                case 'I': {
                    this.intPointers[n3] = (int[])this.arrays[n9];
                    ++n3;
                    break;
                }
                case 'L': {
                    this.longPointers[n4] = (long[])this.arrays[n9];
                    ++n4;
                    break;
                }
                case 'F': {
                    this.floatPointers[n5] = (float[])this.arrays[n9];
                    ++n5;
                    break;
                }
                case 'D': {
                    this.doublePointers[n6] = (double[])this.arrays[n9];
                    ++n6;
                    break;
                }
                case 'C': {
                    this.charPointers[n7] = (char[])this.arrays[n9];
                    ++n7;
                    break;
                }
                case 'Z': {
                    this.booleanPointers[n8] = (boolean[])this.arrays[n9];
                    ++n8;
                    break;
                }
            }
            ++n9;
        }
    }

    public int read(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[this.chunk * this.rowSize];
        if (this.rowSize == 0) {
            return 0;
        }
        int n = 0;
        while (n < this.nrow) {
            int n2;
            int n3 = this.chunk;
            if (n + n3 > this.nrow) {
                n3 = this.nrow - n;
            }
            int n4 = n3 * this.rowSize;
            int n5 = 0;
            while (n4 > 0) {
                n2 = inputStream.read(byArray, n5, n4);
                if (n2 <= 0) {
                    throw new EOFException("EOF reached in ColumnarIO.read");
                }
                n4 -= n2;
                n5 += n2;
            }
            n2 = 0;
            int n6 = n;
            while (n6 < n + n3) {
                int n7 = 0;
                int n8 = 0;
                int n9 = 0;
                int n10 = 0;
                int n11 = 0;
                int n12 = 0;
                int n13 = 0;
                int n14 = 0;
                int n15 = 0;
                while (n15 < this.arrays.length) {
                    int n16 = this.sizes[n15] * n6;
                    int n17 = this.sizes[n15];
                    switch (this.types[n15]) {
                        case 'I': {
                            int[] nArray = this.intPointers[n9];
                            ++n9;
                            int n18 = n16;
                            while (n18 < n16 + n17) {
                                nArray[n18] = byArray[n2] << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF;
                                n2 += 4;
                                ++n18;
                            }
                            break;
                        }
                        case 'S': {
                            short[] sArray = this.shortPointers[n8];
                            ++n8;
                            int n18 = n16;
                            while (n18 < n16 + n17) {
                                sArray[n18] = (short)(byArray[n2] << 8 | byArray[n2 + 1] & 0xFF);
                                n2 += 2;
                                ++n18;
                            }
                            break;
                        }
                        case 'B': {
                            byte[] byArray2 = this.bytePointers[n7];
                            ++n7;
                            int n18 = n16;
                            while (n18 < n16 + n17) {
                                byArray2[n18] = byArray[n2];
                                ++n2;
                                ++n18;
                            }
                            break;
                        }
                        case 'F': {
                            int n19;
                            float[] fArray = this.floatPointers[n12];
                            ++n12;
                            int n18 = n16;
                            while (n18 < n16 + n17) {
                                n19 = byArray[n2] << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF;
                                fArray[n18] = Float.intBitsToFloat(n19);
                                n2 += 4;
                                ++n18;
                            }
                            break;
                        }
                        case 'D': {
                            int n20;
                            int n21;
                            double[] dArray = this.doublePointers[n13];
                            ++n13;
                            int n18 = n16;
                            while (n18 < n16 + n17) {
                                n21 = byArray[n2] << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF;
                                n20 = byArray[n2 += 4] << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF;
                                n2 += 4;
                                dArray[n18] = Double.longBitsToDouble((long)n21 << 32 | (long)n20 & 0xFFFFFFFFL);
                                ++n18;
                            }
                            break;
                        }
                        case 'C': {
                            int n19;
                            char[] cArray = this.charPointers[n11];
                            ++n11;
                            int n18 = n16;
                            while (n18 < n16 + n17) {
                                n19 = byArray[n2] << 8 | byArray[n2 + 1] & 0xFF;
                                cArray[n18] = (char)n19;
                                n2 += 2;
                                ++n18;
                            }
                            break;
                        }
                        case 'L': {
                            int n20;
                            int n21;
                            long[] lArray = this.longPointers[n10];
                            ++n10;
                            int n18 = n16;
                            while (n18 < n16 + n17) {
                                n21 = byArray[n2] << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF;
                                n20 = byArray[n2 += 4] << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF;
                                n2 += 4;
                                lArray[n18] = (long)n21 << 32 | (long)n20 & 0xFFFFFFFFL;
                                ++n18;
                            }
                            break;
                        }
                        case 'Z': {
                            boolean[] blArray = this.booleanPointers[n14];
                            ++n14;
                            int n18 = n16;
                            while (n18 < n16 + n17) {
                                blArray[n18] = byArray[n2] == 1;
                                ++n2;
                                ++n18;
                            }
                            break;
                        }
                    }
                    ++n15;
                }
                ++n6;
            }
            n += n3;
        }
        return this.rowSize * this.nrow;
    }

    public int write(OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[this.chunk * this.rowSize];
        if (this.rowSize == 0) {
            return 0;
        }
        int n = 0;
        while (n < this.nrow) {
            int n2 = this.chunk;
            if (n + n2 > this.nrow) {
                n2 = this.nrow - n;
            }
            int n3 = 0;
            int n4 = n;
            while (n4 < n + n2) {
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                int n9 = 0;
                int n10 = 0;
                int n11 = 0;
                int n12 = 0;
                int n13 = 0;
                while (n13 < this.arrays.length) {
                    int n14 = this.sizes[n13] * n4;
                    int n15 = this.sizes[n13];
                    switch (this.types[n13]) {
                        case 'I': {
                            int[] nArray = this.intPointers[n7];
                            ++n7;
                            int n16 = n14;
                            while (n16 < n14 + n15) {
                                byArray[n3] = (byte)(nArray[n16] >>> 24);
                                byArray[n3 + 1] = (byte)(nArray[n16] >>> 16);
                                byArray[n3 + 2] = (byte)(nArray[n16] >>> 8);
                                byArray[n3 + 3] = (byte)nArray[n16];
                                n3 += 4;
                                ++n16;
                            }
                            break;
                        }
                        case 'S': {
                            short[] sArray = this.shortPointers[n6];
                            ++n6;
                            int n16 = n14;
                            while (n16 < n14 + n15) {
                                byArray[n3] = (byte)(sArray[n16] >>> 8);
                                byArray[n3 + 1] = (byte)sArray[n16];
                                n3 += 2;
                                ++n16;
                            }
                            break;
                        }
                        case 'B': {
                            byte[] byArray2 = this.bytePointers[n5];
                            ++n5;
                            System.arraycopy(byArray2, n14, byArray, n3, n15);
                            n3 += n15;
                            break;
                        }
                        case 'F': {
                            float[] fArray = this.floatPointers[n10];
                            ++n10;
                            int n16 = n14;
                            while (n16 < n14 + n15) {
                                int n17 = Float.floatToIntBits(fArray[n16]);
                                byArray[n3] = (byte)(n17 >>> 24);
                                byArray[n3 + 1] = (byte)(n17 >>> 16);
                                byArray[n3 + 2] = (byte)(n17 >>> 8);
                                byArray[n3 + 3] = (byte)n17;
                                n3 += 4;
                                ++n16;
                            }
                            break;
                        }
                        case 'D': {
                            int n18;
                            int n19;
                            double[] dArray = this.doublePointers[n11];
                            ++n11;
                            int n16 = n14;
                            while (n16 < n14 + n15) {
                                long l = Double.doubleToLongBits(dArray[n16]);
                                n19 = (int)(l >>> 32);
                                n18 = (int)l;
                                byArray[n3] = (byte)(n19 >>> 24);
                                byArray[n3 + 1] = (byte)(n19 >>> 16);
                                byArray[n3 + 2] = (byte)(n19 >>> 8);
                                byArray[n3 + 3] = (byte)n19;
                                byArray[n3 += 4] = (byte)(n18 >>> 24);
                                byArray[n3 + 1] = (byte)(n18 >>> 16);
                                byArray[n3 + 2] = (byte)(n18 >>> 8);
                                byArray[n3 + 3] = (byte)n18;
                                n3 += 4;
                                ++n16;
                            }
                            break;
                        }
                        case 'C': {
                            char[] cArray = this.charPointers[n9];
                            ++n9;
                            int n16 = n14;
                            while (n16 < n14 + n15) {
                                byArray[n3] = (byte)(cArray[n16] >>> 8);
                                byArray[n3 + 1] = (byte)cArray[n16];
                                n3 += 2;
                                ++n16;
                            }
                            break;
                        }
                        case 'L': {
                            int n18;
                            int n19;
                            long[] lArray = this.longPointers[n8];
                            ++n8;
                            int n16 = n14;
                            while (n16 < n14 + n15) {
                                n19 = (int)(lArray[n16] >>> 32);
                                n18 = (int)lArray[n16];
                                byArray[n3] = (byte)(n19 >>> 24);
                                byArray[n3 + 1] = (byte)(n19 >>> 16);
                                byArray[n3 + 2] = (byte)(n19 >>> 8);
                                byArray[n3 + 3] = (byte)n19;
                                byArray[n3 += 4] = (byte)(n18 >>> 24);
                                byArray[n3 + 1] = (byte)(n18 >>> 16);
                                byArray[n3 + 2] = (byte)(n18 >>> 8);
                                byArray[n3 + 3] = (byte)n18;
                                n3 += 4;
                                ++n16;
                            }
                            break;
                        }
                        case 'Z': {
                            boolean[] blArray = this.booleanPointers[n12];
                            ++n12;
                            int n16 = n14;
                            while (n16 < n14 + n15) {
                                byArray[n3] = blArray[n16] ? (byte)1 : 0;
                                ++n3;
                                ++n16;
                            }
                            break;
                        }
                    }
                    ++n13;
                }
                ++n4;
            }
            outputStream.write(byArray, 0, this.rowSize * n2);
            n += n2;
        }
        return this.rowSize * this.nrow;
    }

    public Class[] getBases() {
        return this.bases;
    }

    public char[] getTypes() {
        return this.types;
    }

    public ColumnTable(Object[] objectArray, int[] nArray) throws TableException {
        this.setup(objectArray, nArray);
    }
}

