/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import nom.tam.util.BufferedDataInputStream;

public class BufferedDataOutputStream
extends BufferedOutputStream
implements DataOutput {
    public void writeBoolean(boolean bl) throws IOException {
        if (bl) {
            this.write(1);
        } else {
            this.write(0);
        }
    }

    public void writeByte(int n) throws IOException {
        this.write((byte)n);
    }

    public void writeInt(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)(n >>> 24), (byte)(n >>> 16), (byte)(n >>> 8), (byte)n};
        this.write(byArray, 0, 4);
    }

    public void writeShort(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)(n >>> 8), (byte)n};
        this.write(byArray, 0, 2);
    }

    public void writeChar(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)(n >>> 8), (byte)n};
        this.write(byArray, 0, 2);
    }

    public void writeLong(long l) throws IOException {
        byte[] byArray = new byte[]{(byte)(l >>> 56), (byte)(l >>> 48), (byte)(l >>> 40), (byte)(l >>> 32), (byte)(l >>> 24), (byte)(l >>> 16), (byte)(l >>> 8), (byte)l};
        this.write(byArray, 0, 8);
    }

    public void writeFloat(float f) throws IOException {
        int n = Float.floatToIntBits(f);
        byte[] byArray = new byte[]{(byte)(n >>> 24), (byte)(n >>> 16), (byte)(n >>> 8), (byte)n};
        this.write(byArray, 0, 4);
    }

    public void writeDouble(double d) throws IOException {
        long l = Double.doubleToLongBits(d);
        byte[] byArray = new byte[]{(byte)(l >>> 56), (byte)(l >>> 48), (byte)(l >>> 40), (byte)(l >>> 32), (byte)(l >>> 24), (byte)(l >>> 16), (byte)(l >>> 8), (byte)l};
        this.write(byArray, 0, 8);
    }

    public void writeBytes(String string) throws IOException {
        this.write(string.getBytes(), 0, string.length());
    }

    public void writeChars(String string) throws IOException {
        int n = string.length();
        byte[] byArray = new byte[2 * n];
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            byArray[2 * n2] = (byte)(c >> 8);
            byArray[2 * n2 + 1] = (byte)c;
            ++n2;
        }
        this.write(byArray, 0, 2 * n);
    }

    public void writeUTF(String string) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(this);
        dataOutputStream.writeUTF(string);
        dataOutputStream.flush();
    }

    public void writePrimitiveArray(Object object) throws IOException {
        String string = object.getClass().getName();
        if (string.charAt(0) != '[') {
            throw new IOException("Invalid object passed to BufferedDataOutputStream.writeArray:" + string);
        }
        if (string.charAt(1) == '[') {
            int n = 0;
            while (n < ((Object[])object).length) {
                this.writePrimitiveArray(((Object[])object)[n]);
                ++n;
            }
        } else {
            switch (string.charAt(1)) {
                case 'Z': {
                    this.writeBooleanArray((boolean[])object);
                    break;
                }
                case 'B': {
                    this.write((byte[])object, 0, ((byte[])object).length);
                    break;
                }
                case 'C': {
                    this.writeCharArray((char[])object);
                    break;
                }
                case 'S': {
                    this.writeShortArray((short[])object);
                    break;
                }
                case 'I': {
                    this.writeIntArray((int[])object);
                    break;
                }
                case 'J': {
                    this.writeLongArray((long[])object);
                    break;
                }
                case 'F': {
                    this.writeFloatArray((float[])object);
                    break;
                }
                case 'D': {
                    this.writeDoubleArray((double[])object);
                    break;
                }
                case 'L': {
                    if (string.equals("[Ljava.lang.String;")) {
                        this.writeStringArray((String[])object);
                        break;
                    }
                    if (string.equals("[Ljava.lang.Object;")) {
                        int n = 0;
                        while (n < ((Object[])object).length) {
                            this.writePrimitiveArray(((Object[])object)[n]);
                            ++n;
                        }
                        break;
                    }
                    throw new IOException("Invalid object passed to BufferedDataOutputStream.writeArray: " + string);
                }
                default: {
                    throw new IOException("Invalid object passed to BufferedDataOutputStream.writeArray: " + string);
                }
            }
        }
    }

    protected void writeBooleanArray(boolean[] blArray) throws IOException {
        byte[] byArray = new byte[blArray.length];
        int n = 0;
        while (n < blArray.length) {
            byArray[n] = blArray[n] ? (byte)1 : 0;
            ++n;
        }
        this.write(byArray, 0, byArray.length);
    }

    protected void writeShortArray(short[] sArray) throws IOException {
        byte[] byArray = new byte[2 * sArray.length];
        int n = 0;
        while (n < sArray.length) {
            short s = sArray[n];
            byArray[2 * n] = (byte)(s >> 8);
            byArray[2 * n + 1] = (byte)s;
            ++n;
        }
        this.write(byArray, 0, byArray.length);
    }

    protected void writeCharArray(char[] cArray) throws IOException {
        byte[] byArray = new byte[2 * cArray.length];
        int n = 0;
        while (n < cArray.length) {
            char c = cArray[n];
            byArray[2 * n] = (byte)(c >> 8);
            byArray[2 * n + 1] = (byte)c;
            ++n;
        }
        this.write(byArray, 0, byArray.length);
    }

    protected void writeIntArray(int[] nArray) throws IOException {
        byte[] byArray = new byte[4 * nArray.length];
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            byArray[4 * n] = (byte)(n2 >>> 24);
            byArray[4 * n + 1] = (byte)(n2 >>> 16);
            byArray[4 * n + 2] = (byte)(n2 >>> 8);
            byArray[4 * n + 3] = (byte)n2;
            ++n;
        }
        this.write(byArray, 0, byArray.length);
    }

    protected void writeLongArray(long[] lArray) throws IOException {
        byte[] byArray = new byte[8 * lArray.length];
        int n = 0;
        while (n < lArray.length) {
            long l = lArray[n];
            byArray[8 * n] = (byte)(l >>> 56);
            byArray[8 * n + 1] = (byte)(l >>> 48);
            byArray[8 * n + 2] = (byte)(l >>> 40);
            byArray[8 * n + 3] = (byte)(l >>> 32);
            byArray[8 * n + 4] = (byte)(l >>> 24);
            byArray[8 * n + 5] = (byte)(l >>> 16);
            byArray[8 * n + 6] = (byte)(l >>> 8);
            byArray[8 * n + 7] = (byte)l;
            ++n;
        }
        this.write(byArray, 0, byArray.length);
    }

    protected void writeFloatArray(float[] fArray) throws IOException {
        byte[] byArray = new byte[4 * fArray.length];
        int n = 0;
        while (n < fArray.length) {
            int n2 = Float.floatToIntBits(fArray[n]);
            byArray[4 * n] = (byte)(n2 >>> 24);
            byArray[4 * n + 1] = (byte)(n2 >>> 16);
            byArray[4 * n + 2] = (byte)(n2 >>> 8);
            byArray[4 * n + 3] = (byte)n2;
            ++n;
        }
        this.write(byArray, 0, byArray.length);
    }

    protected void writeDoubleArray(double[] dArray) throws IOException {
        byte[] byArray = new byte[8 * dArray.length];
        int n = 0;
        while (n < dArray.length) {
            long l = Double.doubleToLongBits(dArray[n]);
            byArray[8 * n] = (byte)(l >>> 56);
            byArray[8 * n + 1] = (byte)(l >>> 48);
            byArray[8 * n + 2] = (byte)(l >>> 40);
            byArray[8 * n + 3] = (byte)(l >>> 32);
            byArray[8 * n + 4] = (byte)(l >>> 24);
            byArray[8 * n + 5] = (byte)(l >>> 16);
            byArray[8 * n + 6] = (byte)(l >>> 8);
            byArray[8 * n + 7] = (byte)l;
            ++n;
        }
        this.write(byArray, 0, byArray.length);
    }

    protected void writeStringArray(String[] stringArray) throws IOException {
        int n = 0;
        while (n < stringArray.length) {
            this.writeBytes(stringArray[n]);
            ++n;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        BufferedDataInputStream.main(stringArray);
    }

    public BufferedDataOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public BufferedDataOutputStream(OutputStream outputStream, int n) {
        super(outputStream, n);
    }
}

