/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import nom.tam.util.BufferedDataOutputStream;

public class BufferedDataInputStream
extends BufferedInputStream
implements DataInput {
    private long bufferOffset = 0L;
    private int primitiveArrayCount;

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n2 > 0) {
            int n4 = super.read(byArray, n + n3, n2);
            if (n4 <= 0) {
                if (n3 == 0) {
                    throw new EOFException();
                }
                return n3;
            }
            n2 -= n4;
            n3 += n4;
        }
        return n3;
    }

    public int read() throws IOException {
        return super.read();
    }

    public long skip(long l) throws IOException {
        long l2 = 0L;
        while (l > 0L) {
            long l3 = super.skip(l);
            if (l3 == 0L) {
                return l2;
            }
            l -= l3;
            l2 += l3;
        }
        return l2;
    }

    public boolean readBoolean() throws IOException {
        int n = this.read();
        return n == 1;
    }

    public byte readByte() throws IOException {
        return (byte)this.read();
    }

    public int readUnsignedByte() throws IOException {
        return this.read() | 0xFF;
    }

    public int readInt() throws IOException {
        byte[] byArray = new byte[4];
        if (this.read(byArray, 0, 4) < 4) {
            throw new EOFException();
        }
        int n = byArray[0] << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        return n;
    }

    public short readShort() throws IOException {
        byte[] byArray = new byte[2];
        if (this.read(byArray, 0, 2) < 2) {
            throw new EOFException();
        }
        short s = (short)(byArray[0] << 8 | byArray[1] & 0xFF);
        return s;
    }

    public int readUnsignedShort() throws IOException {
        byte[] byArray = new byte[2];
        if (this.read(byArray, 0, 2) < 2) {
            throw new EOFException();
        }
        return (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
    }

    public char readChar() throws IOException {
        byte[] byArray = new byte[2];
        if (this.read(byArray, 0, 2) < 2) {
            throw new EOFException();
        }
        char c = (char)(byArray[0] << 8 | byArray[1] & 0xFF);
        return c;
    }

    public long readLong() throws IOException {
        byte[] byArray = new byte[8];
        if (this.read(byArray, 0, 8) < 8) {
            throw new EOFException();
        }
        int n = byArray[0] << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        int n2 = byArray[4] << 24 | (byArray[5] & 0xFF) << 16 | (byArray[6] & 0xFF) << 8 | byArray[7] & 0xFF;
        return (long)n << 32 | (long)n2 & 0xFFFFFFFFL;
    }

    public float readFloat() throws IOException {
        byte[] byArray = new byte[4];
        if (this.read(byArray, 0, 4) < 4) {
            throw new EOFException();
        }
        int n = byArray[0] << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        return Float.intBitsToFloat(n);
    }

    public double readDouble() throws IOException {
        byte[] byArray = new byte[8];
        if (this.read(byArray, 0, 8) < 8) {
            throw new EOFException();
        }
        int n = byArray[0] << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        int n2 = byArray[4] << 24 | (byArray[5] & 0xFF) << 16 | (byArray[6] & 0xFF) << 8 | byArray[7] & 0xFF;
        return Double.longBitsToDouble((long)n << 32 | (long)n2 & 0xFFFFFFFFL);
    }

    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IOException("Attempt to read outside byte array");
        }
        if (this.read(byArray, n, n2) < n2) {
            throw new EOFException();
        }
    }

    public int skipBytes(int n) throws IOException {
        if (this.skip(n) < (long)n) {
            throw new EOFException();
        }
        return n;
    }

    public String readUTF() throws IOException {
        DataInputStream dataInputStream = new DataInputStream(this);
        return dataInputStream.readUTF();
    }

    public String readLine() throws IOException {
        DataInputStream dataInputStream = new DataInputStream(this);
        return dataInputStream.readLine();
    }

    public int readPrimitiveArray(Object object) throws IOException {
        this.primitiveArrayCount = 0;
        return this.primitiveArrayRecurse(object);
    }

    protected int primitiveArrayRecurse(Object object) throws IOException {
        if (object == null) {
            return this.primitiveArrayCount;
        }
        String string = object.getClass().getName();
        if (string.charAt(0) != '[') {
            throw new IOException("Invalid object passed to BufferedDataInputStream.readArray:" + string);
        }
        if (string.charAt(1) == '[') {
            int n = 0;
            while (n < ((Object[])object).length) {
                this.primitiveArrayRecurse(((Object[])object)[n]);
                ++n;
            }
        } else {
            switch (string.charAt(1)) {
                case 'Z': {
                    this.primitiveArrayCount += this.readBooleanArray((boolean[])object);
                    break;
                }
                case 'B': {
                    int n = this.read((byte[])object, 0, ((byte[])object).length);
                    if (n < ((byte[])object).length) {
                        this.primitiveArrayCount += n;
                        this.primitiveEOFThrower();
                    }
                    this.primitiveArrayCount += n;
                    break;
                }
                case 'C': {
                    this.primitiveArrayCount += this.readCharArray((char[])object);
                    break;
                }
                case 'S': {
                    this.primitiveArrayCount += this.readShortArray((short[])object);
                    break;
                }
                case 'I': {
                    this.primitiveArrayCount += this.readIntArray((int[])object);
                    break;
                }
                case 'J': {
                    this.primitiveArrayCount += this.readLongArray((long[])object);
                    break;
                }
                case 'F': {
                    this.primitiveArrayCount += this.readFloatArray((float[])object);
                    break;
                }
                case 'D': {
                    this.primitiveArrayCount += this.readDoubleArray((double[])object);
                    break;
                }
                case 'L': {
                    if (string.equals("[Ljava.lang.Object;")) {
                        int n = 0;
                        while (n < ((Object[])object).length) {
                            this.primitiveArrayRecurse(((Object[])object)[n]);
                            ++n;
                        }
                        break;
                    }
                    throw new IOException("Invalid object passed to BufferedDataInputStream.readArray: " + string);
                }
                default: {
                    throw new IOException("Invalid object passed to BufferedDataInputStream.readArray: " + string);
                }
            }
        }
        return this.primitiveArrayCount;
    }

    protected int readBooleanArray(boolean[] blArray) throws IOException {
        byte[] byArray = new byte[blArray.length];
        if (this.read(byArray, 0, byArray.length) < byArray.length) {
            this.primitiveEOFThrower();
        }
        int n = 0;
        while (n < blArray.length) {
            blArray[n] = byArray[n] == 1;
            ++n;
        }
        return byArray.length;
    }

    protected int readShortArray(short[] sArray) throws IOException {
        if (sArray.length == 0) {
            return 0;
        }
        byte[] byArray = new byte[2 * sArray.length];
        if (this.read(byArray, 0, byArray.length) < byArray.length) {
            this.primitiveEOFThrower();
        }
        char c = (char)(byArray[0] << 8 | byArray[1]);
        int n = 0;
        while (n < sArray.length) {
            sArray[n] = (short)(byArray[2 * n] << 8 | byArray[2 * n + 1] & 0xFF);
            ++n;
        }
        return byArray.length;
    }

    protected int readCharArray(char[] cArray) throws IOException {
        byte[] byArray = new byte[2 * cArray.length];
        if (this.read(byArray, 0, byArray.length) < byArray.length) {
            this.primitiveEOFThrower();
        }
        int n = 0;
        while (n < cArray.length) {
            cArray[n] = (char)(byArray[2 * n] << 8 | byArray[2 * n + 1] & 0xFF);
            ++n;
        }
        return byArray.length;
    }

    protected int readIntArray(int[] nArray) throws IOException {
        byte[] byArray = new byte[4 * nArray.length];
        if (this.read(byArray, 0, byArray.length) < byArray.length) {
            this.primitiveEOFThrower();
        }
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = byArray[4 * n] << 24 | (byArray[4 * n + 1] & 0xFF) << 16 | (byArray[4 * n + 2] & 0xFF) << 8 | byArray[4 * n + 3] & 0xFF;
            ++n;
        }
        return byArray.length;
    }

    protected int readLongArray(long[] lArray) throws IOException {
        byte[] byArray = new byte[8 * lArray.length];
        if (this.read(byArray, 0, byArray.length) < byArray.length) {
            this.primitiveEOFThrower();
        }
        int n = 0;
        while (n < lArray.length) {
            int n2 = byArray[8 * n] << 24 | (byArray[8 * n + 1] & 0xFF) << 16 | (byArray[8 * n + 2] & 0xFF) << 8 | byArray[8 * n + 3] & 0xFF;
            int n3 = byArray[8 * n + 4] << 24 | (byArray[8 * n + 5] & 0xFF) << 16 | (byArray[8 * n + 6] & 0xFF) << 8 | byArray[8 * n + 7] & 0xFF;
            lArray[n] = (long)n2 << 32 | (long)n3 & 0xFFFFFFFFL;
            ++n;
        }
        return byArray.length;
    }

    protected int readFloatArray(float[] fArray) throws IOException {
        byte[] byArray = new byte[4 * fArray.length];
        if (this.read(byArray, 0, byArray.length) < byArray.length) {
            this.primitiveEOFThrower();
        }
        int n = 0;
        while (n < fArray.length) {
            int n2 = byArray[4 * n] << 24 | (byArray[4 * n + 1] & 0xFF) << 16 | (byArray[4 * n + 2] & 0xFF) << 8 | byArray[4 * n + 3] & 0xFF;
            fArray[n] = Float.intBitsToFloat(n2);
            ++n;
        }
        return byArray.length;
    }

    protected int readDoubleArray(double[] dArray) throws IOException {
        byte[] byArray = new byte[8 * dArray.length];
        if (this.read(byArray, 0, byArray.length) < byArray.length) {
            this.primitiveEOFThrower();
        }
        int n = 0;
        while (n < dArray.length) {
            int n2 = byArray[8 * n] << 24 | (byArray[8 * n + 1] & 0xFF) << 16 | (byArray[8 * n + 2] & 0xFF) << 8 | byArray[8 * n + 3] & 0xFF;
            int n3 = byArray[8 * n + 4] << 24 | (byArray[8 * n + 5] & 0xFF) << 16 | (byArray[8 * n + 6] & 0xFF) << 8 | byArray[8 * n + 7] & 0xFF;
            dArray[n] = Double.longBitsToDouble((long)n2 << 32 | (long)n3 & 0xFFFFFFFFL);
            ++n;
        }
        return byArray.length;
    }

    protected void primitiveEOFThrower() throws EOFException {
        throw new EOFException("EOF on primitive array read after " + this.primitiveArrayCount + " bytes.");
    }

    public void printStatus() {
        System.out.println("BufferedDataInputStream:");
        System.out.println("    count=" + this.count);
        System.out.println("      pos=" + this.pos);
    }

    public String toString() {
        return "BufferedDataInputStream[count=" + this.count + ",pos=" + this.pos + "]";
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        int n2;
        int n3;
        boolean bl = true;
        byte by = 18;
        short s = 4660;
        char c = 'p';
        int n4 = 305419896;
        long l = 81985529205931230L;
        float f = 1.1f;
        double d = 1.2;
        String string = "This is a string";
        boolean[] blArray = new boolean[50];
        byte[][] byArray = new byte[50][50];
        short[] sArray = new short[50];
        char[][] cArray = new char[50][50];
        int[][][] nArray = new int[50][50][50];
        long[] lArray = new long[50];
        float[] fArray = new float[50];
        double[][] dArray = new double[50][50];
        int n5 = 0;
        while (n5 < 50) {
            n3 = 1;
            if (n5 % 2 > 0) {
                n3 = -1;
            }
            blArray[n5] = n5 % 2 == 1;
            sArray[n5] = (short)(n3 * n5 | 0x1234);
            lArray[n5] = (long)n3 * ((long)n5 | 0x1234567890ABCDEL);
            fArray[n5] = (float)n5 + (float)n3 * 2.33f;
            int n6 = 0;
            while (n6 < 50) {
                byArray[n5][n6] = (byte)(n5 - n6);
                cArray[n5][n6] = (char)(n5 + n6);
                dArray[n5][n6] = (double)(n3 * n5 * n6) * 3.97;
                int n7 = 0;
                while (n7 < 50) {
                    nArray[n5][n6][n7] = n3 * (n5 * n6 + n5 * n7 + n6 * n7 + 19088743);
                    ++n7;
                }
                ++n6;
            }
            ++n5;
        }
        BufferedDataOutputStream bufferedDataOutputStream = new BufferedDataOutputStream(new FileOutputStream("BufferedData.test"));
        bufferedDataOutputStream.writeBoolean(bl);
        bufferedDataOutputStream.writePrimitiveArray(blArray);
        bufferedDataOutputStream.writeByte(by);
        bufferedDataOutputStream.writePrimitiveArray(byArray);
        n3 = 0;
        while (n3 < 50) {
            bufferedDataOutputStream.write(byArray[n3]);
            ++n3;
        }
        n3 = 0;
        while (n3 < 50) {
            bufferedDataOutputStream.write(byArray[n3], 0, 25);
            bufferedDataOutputStream.write(byArray[n3], 25, 25);
            ++n3;
        }
        bufferedDataOutputStream.writeShort(s);
        bufferedDataOutputStream.writePrimitiveArray(sArray);
        bufferedDataOutputStream.writeChar(c);
        bufferedDataOutputStream.writePrimitiveArray(cArray);
        bufferedDataOutputStream.writeInt(n4);
        bufferedDataOutputStream.writePrimitiveArray(nArray);
        bufferedDataOutputStream.writeLong(l);
        bufferedDataOutputStream.writePrimitiveArray(lArray);
        bufferedDataOutputStream.writeFloat(f);
        bufferedDataOutputStream.writePrimitiveArray(fArray);
        bufferedDataOutputStream.writeDouble(d);
        bufferedDataOutputStream.writePrimitiveArray(dArray);
        bufferedDataOutputStream.flush();
        bufferedDataOutputStream.close();
        bufferedDataOutputStream = null;
        BufferedDataInputStream bufferedDataInputStream = new BufferedDataInputStream(new FileInputStream("BufferedData.test"));
        System.out.println("Functionality tests (Note String I/O not checked)");
        System.out.println("");
        BufferedDataInputStream.passes(bl == bufferedDataInputStream.readBoolean(), "boolean scalar");
        boolean[] blArray2 = new boolean[50];
        bufferedDataInputStream.readPrimitiveArray(blArray2);
        BufferedDataInputStream.passes(blArray2[0] == blArray[0], "boolean array (start)");
        BufferedDataInputStream.passes(blArray2[49] == blArray[49], "boolean array (end)");
        BufferedDataInputStream.passes(blArray2[22] == blArray[22], "boolean array (middle)");
        BufferedDataInputStream.passes(by == bufferedDataInputStream.readByte(), "byte scalar");
        byte[][] byArray2 = new byte[50][50];
        byte[][] byArray3 = new byte[50][50];
        byte[][] byArray4 = new byte[50][50];
        int n8 = 0;
        while (n8 < 50) {
            bufferedDataInputStream.read(byArray4[n8], 0, 25);
            bufferedDataInputStream.read(byArray4[n8], 25, 25);
            ++n8;
        }
        n8 = 0;
        while (n8 < 50) {
            bufferedDataInputStream.readFully(byArray3[n8]);
            ++n8;
        }
        bufferedDataInputStream.readPrimitiveArray(byArray2);
        BufferedDataInputStream.passes(byArray2[0][0] == byArray[0][0], "byte array(start-method1)");
        BufferedDataInputStream.passes(byArray2[49][49] == byArray[49][49], "byte array(end-method1)");
        BufferedDataInputStream.passes(byArray2[22][22] == byArray[22][22], "byte array(middle-method1");
        BufferedDataInputStream.passes(byArray3[0][0] == byArray[0][0], "byte array(start-method2)");
        BufferedDataInputStream.passes(byArray3[49][49] == byArray[49][49], "byte array(end-method2)");
        BufferedDataInputStream.passes(byArray3[22][22] == byArray[22][22], "byte array(middle-method2");
        BufferedDataInputStream.passes(byArray4[0][0] == byArray[0][0], "byte array(start-method3)");
        BufferedDataInputStream.passes(byArray4[49][49] == byArray[49][49], "byte array(end-method3)");
        BufferedDataInputStream.passes(byArray4[22][22] == byArray[22][22], "byte array(middle-method3");
        BufferedDataInputStream.passes(s == bufferedDataInputStream.readShort(), "short scalar");
        short[] sArray2 = new short[50];
        bufferedDataInputStream.readPrimitiveArray(sArray2);
        BufferedDataInputStream.passes(sArray2[0] == sArray[0], "short array (start)");
        BufferedDataInputStream.passes(sArray2[49] == sArray[49], "short array (end)");
        BufferedDataInputStream.passes(sArray2[22] == sArray[22], "short array (middle)");
        BufferedDataInputStream.passes(c == bufferedDataInputStream.readChar(), "char scalar");
        char[][] cArray2 = new char[50][50];
        bufferedDataInputStream.readPrimitiveArray(cArray2);
        BufferedDataInputStream.passes(cArray2[0][0] == cArray[0][0], "char array (start)");
        BufferedDataInputStream.passes(cArray2[49][49] == cArray[49][49], "char array (end)");
        BufferedDataInputStream.passes(cArray2[22][22] == cArray[22][22], "char array (middle)");
        BufferedDataInputStream.passes(n4 == bufferedDataInputStream.readInt(), "int scalar");
        int[][][] nArray2 = new int[50][50][50];
        bufferedDataInputStream.readPrimitiveArray(nArray2);
        BufferedDataInputStream.passes(nArray2[0][0][0] == nArray[0][0][0], "int array (start)");
        BufferedDataInputStream.passes(nArray2[49][49][49] == nArray[49][49][49], "int array (end)");
        BufferedDataInputStream.passes(nArray2[22][22][22] == nArray[22][22][22], "int array (middle)");
        BufferedDataInputStream.passes(l == bufferedDataInputStream.readLong(), "long scalar");
        long[] lArray2 = new long[50];
        bufferedDataInputStream.readPrimitiveArray(lArray2);
        BufferedDataInputStream.passes(lArray2[0] == lArray[0], "long array (start)");
        BufferedDataInputStream.passes(lArray2[49] == lArray[49], "long array (end)");
        BufferedDataInputStream.passes(lArray2[22] == lArray[22], "long array (middle)");
        BufferedDataInputStream.passes(f == bufferedDataInputStream.readFloat(), "float scalar");
        float[] fArray2 = new float[50];
        bufferedDataInputStream.readPrimitiveArray(fArray2);
        BufferedDataInputStream.passes(fArray2[0] == fArray[0], "float array (start)");
        BufferedDataInputStream.passes(fArray2[49] == fArray[49], "float array (end)");
        BufferedDataInputStream.passes(fArray2[22] == fArray[22], "float array (middle)");
        BufferedDataInputStream.passes(d == bufferedDataInputStream.readDouble(), "double scalar");
        double[][] dArray2 = new double[50][50];
        bufferedDataInputStream.readPrimitiveArray(dArray2);
        BufferedDataInputStream.passes(dArray2[0][0] == dArray[0][0], "double array (start)");
        BufferedDataInputStream.passes(dArray2[49][49] == dArray[49][49], "double array (end)");
        BufferedDataInputStream.passes(dArray2[22][22] == dArray[22][22], "double array (middle)");
        bufferedDataInputStream = null;
        System.out.println("");
        System.out.println("Timing test:  Write and read an 800x800 int array");
        System.out.println("");
        System.out.println("Initializing array");
        int[][] nArray3 = new int[800][800];
        int[][] nArray4 = new int[800][800];
        int n9 = 0;
        while (n9 < nArray3.length) {
            n2 = 0;
            while (n2 < nArray3[0].length) {
                nArray3[n9][n2] = n9 * n2 * (n9 - n2);
                ++n2;
            }
            ++n9;
        }
        System.out.println("");
        System.out.println("Using DataXputStream(BufferedXputStream) at " + new Date());
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream("test_std.data")));
        n2 = 0;
        while (n2 < 800) {
            n = 0;
            while (n < 800) {
                dataOutputStream.writeInt(nArray3[n2][n]);
                ++n;
            }
            ++n2;
        }
        dataOutputStream.flush();
        dataOutputStream.close();
        dataOutputStream = null;
        System.out.println("                          Finished write at:" + new Date());
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream("test_std.data")));
        n = 0;
        while (n < 800) {
            int n10 = 0;
            while (n10 < 800) {
                nArray4[n][n10] = dataInputStream.readInt();
                ++n10;
            }
            ++n;
        }
        dataInputStream = null;
        System.out.println("                          Finished read at: " + new Date());
        System.out.println("");
        System.out.println("Using BufferedDataXputStream at             " + new Date());
        BufferedDataOutputStream bufferedDataOutputStream2 = new BufferedDataOutputStream(new FileOutputStream("test_bd.data"));
        bufferedDataOutputStream2.writePrimitiveArray(nArray3);
        bufferedDataOutputStream2.flush();
        bufferedDataOutputStream2.close();
        bufferedDataOutputStream2 = null;
        System.out.println("                          Finished write at:" + new Date());
        BufferedDataInputStream bufferedDataInputStream2 = new BufferedDataInputStream(new FileInputStream("test_bd.data"));
        bufferedDataInputStream2.readPrimitiveArray(nArray4);
        bufferedDataInputStream2 = null;
        System.out.println("                          Finished read at: " + new Date());
    }

    private static void passes(boolean bl, String string) {
        System.out.print(string + ":");
        if (string.length() < 30) {
            System.out.print("                              ".substring(0, 30 - string.length()));
        }
        if (bl) {
            System.out.println(" passes");
        } else {
            System.out.println(" fails");
        }
    }

    public BufferedDataInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public BufferedDataInputStream(InputStream inputStream, int n) {
        super(inputStream, n);
    }
}

