/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import java.lang.reflect.Array;
import java.util.Date;

public class ArrayFuncs {
    public static int computeSize(Object object) {
        if (object == null) {
            return 0;
        }
        int n = 0;
        String string = object.getClass().getName();
        if (string.substring(0, 2).equals("[[") || string.equals("[Ljava.lang.String;") || string.equals("[Ljava.lang.Object;")) {
            int n2 = 0;
            while (n2 < ((Object[])object).length) {
                n += ArrayFuncs.computeSize(((Object[])object)[n2]);
                ++n2;
            }
            return n;
        }
        if (string.charAt(0) == '[' && string.charAt(1) != 'L') {
            switch (string.charAt(1)) {
                case 'I': {
                    return ((int[])object).length * 4;
                }
                case 'J': {
                    return ((long[])object).length * 8;
                }
                case 'F': {
                    return ((float[])object).length * 4;
                }
                case 'D': {
                    return ((double[])object).length * 8;
                }
                case 'B': {
                    return ((byte[])object).length;
                }
                case 'C': {
                    return ((char[])object).length * 2;
                }
                case 'S': {
                    return ((short[])object).length * 2;
                }
                case 'Z': {
                    return ((boolean[])object).length;
                }
            }
            return 0;
        }
        if (string.substring(0, 10).equals("java.lang.")) {
            if ((string = string.substring(10, string.length() - 1)).equals("Int") || string.equals("Float")) {
                return 4;
            }
            if (string.equals("Double") || string.equals("Long")) {
                return 8;
            }
            if (string.equals("Short") || string.equals("Char")) {
                return 2;
            }
            if (string.equals("Byte") || string.equals("Boolean")) {
                return 1;
            }
            if (string.equals("String")) {
                return ((String)object).length();
            }
            return 0;
        }
        return 0;
    }

    public static Object deepClone(Object object) {
        Class<?> clazz;
        if (object == null) {
            return null;
        }
        String string = object.getClass().getName();
        if (string.charAt(0) != '[') {
            return ArrayFuncs.genericClone(object);
        }
        if (string.charAt(1) != '[' && string.charAt(1) != 'L') {
            try {
                switch (string.charAt(1)) {
                    case 'B': {
                        return ((byte[])object).clone();
                    }
                    case 'Z': {
                        return ((boolean[])object).clone();
                    }
                    case 'C': {
                        return ((char[])object).clone();
                    }
                    case 'S': {
                        return ((short[])object).clone();
                    }
                    case 'I': {
                        return ((int[])object).clone();
                    }
                    case 'J': {
                        return ((long[])object).clone();
                    }
                    case 'F': {
                        return ((float[])object).clone();
                    }
                    case 'D': {
                        return ((double[])object).clone();
                    }
                }
                System.err.println("Unknown primtive array class:" + string);
                return null;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        int n = 1;
        while (string.charAt(n) == '[') {
            ++n;
        }
        if (string.charAt(n) != 'L') {
            clazz = ArrayFuncs.getBaseClass(object);
        } else {
            try {
                clazz = Class.forName(string.substring(n + 1, string.length() - 1));
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("Internal error: class definition inconsistency: " + string);
                return null;
            }
        }
        int[] nArray = new int[n];
        nArray[0] = Array.getLength(object);
        int n2 = 1;
        while (n2 < n) {
            nArray[n2] = 0;
            ++n2;
        }
        Object object2 = Array.newInstance(clazz, nArray);
        int n3 = 0;
        while (n3 < nArray[0]) {
            Array.set(object2, n3, ArrayFuncs.deepClone(Array.get(object, n3)));
            ++n3;
        }
        return object2;
    }

    public static Object genericClone(Object object) {
        if (!(object instanceof Cloneable)) {
            return null;
        }
        Class[] classArray = new Class[]{};
        Object[] objectArray = new Object[]{};
        try {
            return object.getClass().getMethod("clone", classArray).invoke(object, objectArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void copyArray(Object object, Object object2) {
        String string;
        String string2 = object.getClass().getName();
        if (!string2.equals(string = object2.getClass().getName())) {
            return;
        }
        if (string2.charAt(0) != '[') {
            return;
        }
        if (string2.charAt(1) == '[') {
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = (Object[])object2;
            if (objectArray.length != objectArray2.length) {
                return;
            }
            int n = 0;
            while (n < objectArray.length) {
                ArrayFuncs.copyArray(objectArray, objectArray2);
                ++n;
            }
        }
        int n = Array.getLength(object);
        System.arraycopy(object, 0, object2, 0, n);
    }

    public static int[] getDimensions(Object object) {
        if (object == null) {
            return null;
        }
        String string = object.getClass().getName();
        int n = 0;
        while (string.charAt(n) == '[') {
            ++n;
        }
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = -1;
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            nArray[n2] = Array.getLength(object);
            if (nArray[n2] == 0) {
                return nArray;
            }
            if (n2 != n - 1 && (object = ((Object[])object)[0]) == null) {
                return nArray;
            }
            ++n2;
        }
        return nArray;
    }

    public static Class getBaseClass(Object object) {
        if (object == null) {
            return Void.TYPE;
        }
        String string = object.getClass().getName();
        int n = 0;
        while (string.charAt(n) == '[') {
            ++n;
        }
        if (n == 0) {
            return object.getClass();
        }
        switch (string.charAt(n)) {
            case 'Z': {
                return Boolean.TYPE;
            }
            case 'B': {
                return Byte.TYPE;
            }
            case 'S': {
                return Short.TYPE;
            }
            case 'C': {
                return Character.TYPE;
            }
            case 'I': {
                return Integer.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
            case 'L': {
                try {
                    return Class.forName(string.substring(n + 1, string.length() - 1));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
            }
        }
        return null;
    }

    public static int getBaseLength(Object object) {
        if (object == null) {
            return 0;
        }
        String string = object.getClass().getName();
        int n = 0;
        while (string.charAt(n) == '[') {
            ++n;
        }
        if (n == 0) {
            return -1;
        }
        switch (string.charAt(n)) {
            case 'Z': {
                return 1;
            }
            case 'B': {
                return 1;
            }
            case 'S': {
                return 2;
            }
            case 'C': {
                return 2;
            }
            case 'I': {
                return 4;
            }
            case 'J': {
                return 8;
            }
            case 'F': {
                return 4;
            }
            case 'D': {
                return 8;
            }
        }
        return -1;
    }

    public static Object generateArray(Class clazz, int[] nArray) {
        Object object = Array.newInstance(clazz, nArray);
        ArrayFuncs.testPattern(object, (byte)0);
        return object;
    }

    public static byte testPattern(Object object, byte by) {
        block3: {
            int[] nArray;
            block2: {
                nArray = ArrayFuncs.getDimensions(object);
                if (nArray.length <= 1) break block2;
                int n = 0;
                while (n < ((Object[])object).length) {
                    by = ArrayFuncs.testPattern(((Object[])object)[n], by);
                    ++n;
                }
                break block3;
            }
            if (nArray.length != 1) break block3;
            int n = 0;
            while (n < nArray[0]) {
                Array.setByte(object, n, by);
                by = (byte)(by + 1);
                ++n;
            }
        }
        return by;
    }

    public static String arrayDescription(Object object) {
        Class clazz = ArrayFuncs.getBaseClass(object);
        if (clazz == Void.TYPE) {
            return "NULL";
        }
        int[] nArray = ArrayFuncs.getDimensions(object);
        StringBuffer stringBuffer = new StringBuffer();
        if (clazz == Float.TYPE) {
            stringBuffer.append("float");
        } else if (clazz == Integer.TYPE) {
            stringBuffer.append("int");
        } else if (clazz == Double.TYPE) {
            stringBuffer.append("double");
        } else if (clazz == Short.TYPE) {
            stringBuffer.append("short");
        } else if (clazz == Long.TYPE) {
            stringBuffer.append("long");
        } else if (clazz == Character.TYPE) {
            stringBuffer.append("char");
        } else if (clazz == Byte.TYPE) {
            stringBuffer.append("byte");
        } else if (clazz == Boolean.TYPE) {
            stringBuffer.append("boolean");
        } else {
            stringBuffer.append(clazz.getName());
        }
        if (nArray != null) {
            stringBuffer.append("[");
            int n = 0;
            while (n < nArray.length) {
                stringBuffer.append("" + nArray[n]);
                if (n < nArray.length - 1) {
                    stringBuffer.append(",");
                }
                ++n;
            }
            stringBuffer.append("]");
        }
        return new String(stringBuffer);
    }

    public static void examinePrimitiveArray(Object object) {
        String string = object.getClass().getName();
        if (string.substring(0, 2).equals("[[") || string.equals("[Ljava.lang.Object;")) {
            System.out.println("[");
            int n = 0;
            while (n < ((Object[])object).length) {
                ArrayFuncs.examinePrimitiveArray(((Object[])object)[n]);
                ++n;
            }
            System.out.print("]");
        } else if (string.charAt(0) != '[') {
            System.out.println(string);
        } else {
            System.out.println("[" + Array.getLength(object) + "]" + string.substring(1));
        }
    }

    public static Object flatten(Object object) {
        int[] nArray = ArrayFuncs.getDimensions(object);
        if (nArray.length <= 1) {
            return object;
        }
        int n = 1;
        int n2 = 0;
        while (n2 < nArray.length) {
            n *= nArray[n2];
            ++n2;
        }
        Object object2 = Array.newInstance(ArrayFuncs.getBaseClass(object), n);
        if (n == 0) {
            return object2;
        }
        int n3 = 0;
        ArrayFuncs.doFlatten(object, object2, n3);
        return object2;
    }

    protected static int doFlatten(Object object, Object object2, int n) {
        String string = object.getClass().getName();
        if (string.charAt(0) != '[') {
            throw new RuntimeException("Attempt to flatten non-array");
        }
        int n2 = Array.getLength(object);
        if (string.charAt(1) != '[') {
            System.arraycopy(object, 0, object2, n, n2);
            return n2;
        }
        int n3 = 0;
        Object[] objectArray = (Object[])object;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = ArrayFuncs.doFlatten(objectArray[n4], object2, n + n3);
            n3 += n5;
            ++n4;
        }
        return n3;
    }

    public static Object curl(Object object, int[] nArray) {
        String string = object.getClass().getName();
        if (string.charAt(0) != '[' || string.charAt(1) == '[') {
            throw new RuntimeException("Attempt to curl non-1D array");
        }
        int n = Array.getLength(object);
        int n2 = 1;
        int n3 = 0;
        while (n3 < nArray.length) {
            n2 *= nArray[n3];
            ++n3;
        }
        if (n2 != n) {
            throw new RuntimeException("Curled array does not fit desired dimensions");
        }
        Class clazz = ArrayFuncs.getBaseClass(object);
        Object object2 = Array.newInstance(clazz, nArray);
        int n4 = 0;
        ArrayFuncs.doCurl(object, object2, nArray, n4);
        return object2;
    }

    protected static int doCurl(Object object, Object object2, int[] nArray, int n) {
        if (nArray.length == 1) {
            System.arraycopy(object, n, object2, 0, nArray[0]);
            return nArray[0];
        }
        int n2 = 0;
        int[] nArray2 = new int[nArray.length - 1];
        int n3 = 1;
        while (n3 < nArray.length) {
            nArray2[n3 - 1] = nArray[n3];
            ++n3;
        }
        n3 = 0;
        while (n3 < nArray[0]) {
            n2 += ArrayFuncs.doCurl(object, ((Object[])object2)[n3], nArray2, n + n2);
            ++n3;
        }
        return n2;
    }

    public static Object convertArray(Object object, Class clazz) {
        Object object2;
        block67: {
            Class clazz2;
            block103: {
                float[] fArray;
                block109: {
                    block108: {
                        block107: {
                            block106: {
                                block105: {
                                    block104: {
                                        block96: {
                                            long[] lArray;
                                            block102: {
                                                block101: {
                                                    block100: {
                                                        block99: {
                                                            block98: {
                                                                block97: {
                                                                    block89: {
                                                                        int[] nArray;
                                                                        block95: {
                                                                            block94: {
                                                                                block93: {
                                                                                    block92: {
                                                                                        block91: {
                                                                                            block90: {
                                                                                                block82: {
                                                                                                    char[] cArray;
                                                                                                    block88: {
                                                                                                        block87: {
                                                                                                            block86: {
                                                                                                                block85: {
                                                                                                                    block84: {
                                                                                                                        block83: {
                                                                                                                            block75: {
                                                                                                                                short[] sArray;
                                                                                                                                block81: {
                                                                                                                                    block80: {
                                                                                                                                        block79: {
                                                                                                                                            block78: {
                                                                                                                                                block77: {
                                                                                                                                                    block76: {
                                                                                                                                                        block68: {
                                                                                                                                                            byte[] byArray;
                                                                                                                                                            block74: {
                                                                                                                                                                block73: {
                                                                                                                                                                    block72: {
                                                                                                                                                                        block71: {
                                                                                                                                                                            block70: {
                                                                                                                                                                                block69: {
                                                                                                                                                                                    block66: {
                                                                                                                                                                                        String string = object.getClass().getName();
                                                                                                                                                                                        if (string.charAt(0) != '[') {
                                                                                                                                                                                            return null;
                                                                                                                                                                                        }
                                                                                                                                                                                        int n = 1;
                                                                                                                                                                                        while (string.charAt(n) == '[') {
                                                                                                                                                                                            ++n;
                                                                                                                                                                                        }
                                                                                                                                                                                        if (n <= 1) break block66;
                                                                                                                                                                                        Object[] objectArray = (Object[])object;
                                                                                                                                                                                        int[] nArray2 = new int[n];
                                                                                                                                                                                        nArray2[0] = objectArray.length;
                                                                                                                                                                                        object2 = Array.newInstance(clazz, nArray2);
                                                                                                                                                                                        int n2 = 0;
                                                                                                                                                                                        while (n2 < objectArray.length) {
                                                                                                                                                                                            Object object3;
                                                                                                                                                                                            ((Object[])object2)[n2] = object3 = ArrayFuncs.convertArray(objectArray[n2], clazz);
                                                                                                                                                                                            ++n2;
                                                                                                                                                                                        }
                                                                                                                                                                                        break block67;
                                                                                                                                                                                    }
                                                                                                                                                                                    object2 = null;
                                                                                                                                                                                    clazz2 = ArrayFuncs.getBaseClass(object);
                                                                                                                                                                                    if (clazz2 != Byte.TYPE) break block68;
                                                                                                                                                                                    byArray = (byte[])object;
                                                                                                                                                                                    if (clazz != Byte.TYPE) break block69;
                                                                                                                                                                                    byte[] byArray2 = new byte[byArray.length];
                                                                                                                                                                                    object2 = byArray2;
                                                                                                                                                                                    int n = 0;
                                                                                                                                                                                    while (n < byArray.length) {
                                                                                                                                                                                        byArray2[n] = byArray[n];
                                                                                                                                                                                        ++n;
                                                                                                                                                                                    }
                                                                                                                                                                                    break block67;
                                                                                                                                                                                }
                                                                                                                                                                                if (clazz != Short.TYPE) break block70;
                                                                                                                                                                                short[] sArray2 = new short[byArray.length];
                                                                                                                                                                                object2 = sArray2;
                                                                                                                                                                                int n = 0;
                                                                                                                                                                                while (n < byArray.length) {
                                                                                                                                                                                    sArray2[n] = byArray[n];
                                                                                                                                                                                    ++n;
                                                                                                                                                                                }
                                                                                                                                                                                break block67;
                                                                                                                                                                            }
                                                                                                                                                                            if (clazz != Character.TYPE) break block71;
                                                                                                                                                                            char[] cArray2 = new char[byArray.length];
                                                                                                                                                                            object2 = cArray2;
                                                                                                                                                                            int n = 0;
                                                                                                                                                                            while (n < byArray.length) {
                                                                                                                                                                                cArray2[n] = (char)byArray[n];
                                                                                                                                                                                ++n;
                                                                                                                                                                            }
                                                                                                                                                                            break block67;
                                                                                                                                                                        }
                                                                                                                                                                        if (clazz != Integer.TYPE) break block72;
                                                                                                                                                                        int[] nArray3 = new int[byArray.length];
                                                                                                                                                                        object2 = nArray3;
                                                                                                                                                                        int n = 0;
                                                                                                                                                                        while (n < byArray.length) {
                                                                                                                                                                            nArray3[n] = byArray[n];
                                                                                                                                                                            ++n;
                                                                                                                                                                        }
                                                                                                                                                                        break block67;
                                                                                                                                                                    }
                                                                                                                                                                    if (clazz != Long.TYPE) break block73;
                                                                                                                                                                    long[] lArray2 = new long[byArray.length];
                                                                                                                                                                    object2 = lArray2;
                                                                                                                                                                    int n = 0;
                                                                                                                                                                    while (n < byArray.length) {
                                                                                                                                                                        lArray2[n] = byArray[n];
                                                                                                                                                                        ++n;
                                                                                                                                                                    }
                                                                                                                                                                    break block67;
                                                                                                                                                                }
                                                                                                                                                                if (clazz != Float.TYPE) break block74;
                                                                                                                                                                float[] fArray2 = new float[byArray.length];
                                                                                                                                                                object2 = fArray2;
                                                                                                                                                                int n = 0;
                                                                                                                                                                while (n < byArray.length) {
                                                                                                                                                                    fArray2[n] = byArray[n];
                                                                                                                                                                    ++n;
                                                                                                                                                                }
                                                                                                                                                                break block67;
                                                                                                                                                            }
                                                                                                                                                            if (clazz != Double.TYPE) break block67;
                                                                                                                                                            double[] dArray = new double[byArray.length];
                                                                                                                                                            object2 = dArray;
                                                                                                                                                            int n = 0;
                                                                                                                                                            while (n < byArray.length) {
                                                                                                                                                                dArray[n] = byArray[n];
                                                                                                                                                                ++n;
                                                                                                                                                            }
                                                                                                                                                            break block67;
                                                                                                                                                        }
                                                                                                                                                        if (clazz2 != Short.TYPE) break block75;
                                                                                                                                                        sArray = (short[])object;
                                                                                                                                                        if (clazz != Byte.TYPE) break block76;
                                                                                                                                                        byte[] byArray = new byte[sArray.length];
                                                                                                                                                        object2 = byArray;
                                                                                                                                                        int n = 0;
                                                                                                                                                        while (n < sArray.length) {
                                                                                                                                                            byArray[n] = (byte)sArray[n];
                                                                                                                                                            ++n;
                                                                                                                                                        }
                                                                                                                                                        break block67;
                                                                                                                                                    }
                                                                                                                                                    if (clazz != Short.TYPE) break block77;
                                                                                                                                                    short[] sArray3 = new short[sArray.length];
                                                                                                                                                    object2 = sArray3;
                                                                                                                                                    int n = 0;
                                                                                                                                                    while (n < sArray.length) {
                                                                                                                                                        sArray3[n] = sArray[n];
                                                                                                                                                        ++n;
                                                                                                                                                    }
                                                                                                                                                    break block67;
                                                                                                                                                }
                                                                                                                                                if (clazz != Character.TYPE) break block78;
                                                                                                                                                char[] cArray3 = new char[sArray.length];
                                                                                                                                                object2 = cArray3;
                                                                                                                                                int n = 0;
                                                                                                                                                while (n < sArray.length) {
                                                                                                                                                    cArray3[n] = (char)sArray[n];
                                                                                                                                                    ++n;
                                                                                                                                                }
                                                                                                                                                break block67;
                                                                                                                                            }
                                                                                                                                            if (clazz != Integer.TYPE) break block79;
                                                                                                                                            int[] nArray4 = new int[sArray.length];
                                                                                                                                            object2 = nArray4;
                                                                                                                                            int n = 0;
                                                                                                                                            while (n < sArray.length) {
                                                                                                                                                nArray4[n] = sArray[n];
                                                                                                                                                ++n;
                                                                                                                                            }
                                                                                                                                            break block67;
                                                                                                                                        }
                                                                                                                                        if (clazz != Long.TYPE) break block80;
                                                                                                                                        long[] lArray3 = new long[sArray.length];
                                                                                                                                        object2 = lArray3;
                                                                                                                                        int n = 0;
                                                                                                                                        while (n < sArray.length) {
                                                                                                                                            lArray3[n] = sArray[n];
                                                                                                                                            ++n;
                                                                                                                                        }
                                                                                                                                        break block67;
                                                                                                                                    }
                                                                                                                                    if (clazz != Float.TYPE) break block81;
                                                                                                                                    float[] fArray3 = new float[sArray.length];
                                                                                                                                    object2 = fArray3;
                                                                                                                                    int n = 0;
                                                                                                                                    while (n < sArray.length) {
                                                                                                                                        fArray3[n] = sArray[n];
                                                                                                                                        ++n;
                                                                                                                                    }
                                                                                                                                    break block67;
                                                                                                                                }
                                                                                                                                if (clazz != Double.TYPE) break block67;
                                                                                                                                double[] dArray = new double[sArray.length];
                                                                                                                                object2 = dArray;
                                                                                                                                int n = 0;
                                                                                                                                while (n < sArray.length) {
                                                                                                                                    dArray[n] = sArray[n];
                                                                                                                                    ++n;
                                                                                                                                }
                                                                                                                                break block67;
                                                                                                                            }
                                                                                                                            if (clazz2 != Character.TYPE) break block82;
                                                                                                                            cArray = (char[])object;
                                                                                                                            if (clazz != Byte.TYPE) break block83;
                                                                                                                            byte[] byArray = new byte[cArray.length];
                                                                                                                            object2 = byArray;
                                                                                                                            int n = 0;
                                                                                                                            while (n < cArray.length) {
                                                                                                                                byArray[n] = (byte)cArray[n];
                                                                                                                                ++n;
                                                                                                                            }
                                                                                                                            break block67;
                                                                                                                        }
                                                                                                                        if (clazz != Short.TYPE) break block84;
                                                                                                                        short[] sArray = new short[cArray.length];
                                                                                                                        object2 = sArray;
                                                                                                                        int n = 0;
                                                                                                                        while (n < cArray.length) {
                                                                                                                            sArray[n] = (short)cArray[n];
                                                                                                                            ++n;
                                                                                                                        }
                                                                                                                        break block67;
                                                                                                                    }
                                                                                                                    if (clazz != Character.TYPE) break block85;
                                                                                                                    char[] cArray4 = new char[cArray.length];
                                                                                                                    object2 = cArray4;
                                                                                                                    int n = 0;
                                                                                                                    while (n < cArray.length) {
                                                                                                                        cArray4[n] = cArray[n];
                                                                                                                        ++n;
                                                                                                                    }
                                                                                                                    break block67;
                                                                                                                }
                                                                                                                if (clazz != Integer.TYPE) break block86;
                                                                                                                int[] nArray5 = new int[cArray.length];
                                                                                                                object2 = nArray5;
                                                                                                                int n = 0;
                                                                                                                while (n < cArray.length) {
                                                                                                                    nArray5[n] = cArray[n];
                                                                                                                    ++n;
                                                                                                                }
                                                                                                                break block67;
                                                                                                            }
                                                                                                            if (clazz != Long.TYPE) break block87;
                                                                                                            long[] lArray4 = new long[cArray.length];
                                                                                                            object2 = lArray4;
                                                                                                            int n = 0;
                                                                                                            while (n < cArray.length) {
                                                                                                                lArray4[n] = cArray[n];
                                                                                                                ++n;
                                                                                                            }
                                                                                                            break block67;
                                                                                                        }
                                                                                                        if (clazz != Float.TYPE) break block88;
                                                                                                        float[] fArray4 = new float[cArray.length];
                                                                                                        object2 = fArray4;
                                                                                                        int n = 0;
                                                                                                        while (n < cArray.length) {
                                                                                                            fArray4[n] = cArray[n];
                                                                                                            ++n;
                                                                                                        }
                                                                                                        break block67;
                                                                                                    }
                                                                                                    if (clazz != Double.TYPE) break block67;
                                                                                                    double[] dArray = new double[cArray.length];
                                                                                                    object2 = dArray;
                                                                                                    int n = 0;
                                                                                                    while (n < cArray.length) {
                                                                                                        dArray[n] = cArray[n];
                                                                                                        ++n;
                                                                                                    }
                                                                                                    break block67;
                                                                                                }
                                                                                                if (clazz2 != Integer.TYPE) break block89;
                                                                                                nArray = (int[])object;
                                                                                                if (clazz != Byte.TYPE) break block90;
                                                                                                byte[] byArray = new byte[nArray.length];
                                                                                                object2 = byArray;
                                                                                                int n = 0;
                                                                                                while (n < nArray.length) {
                                                                                                    byArray[n] = (byte)nArray[n];
                                                                                                    ++n;
                                                                                                }
                                                                                                break block67;
                                                                                            }
                                                                                            if (clazz != Short.TYPE) break block91;
                                                                                            short[] sArray = new short[nArray.length];
                                                                                            object2 = sArray;
                                                                                            int n = 0;
                                                                                            while (n < nArray.length) {
                                                                                                sArray[n] = (short)nArray[n];
                                                                                                ++n;
                                                                                            }
                                                                                            break block67;
                                                                                        }
                                                                                        if (clazz != Character.TYPE) break block92;
                                                                                        char[] cArray = new char[nArray.length];
                                                                                        object2 = cArray;
                                                                                        int n = 0;
                                                                                        while (n < nArray.length) {
                                                                                            cArray[n] = (char)nArray[n];
                                                                                            ++n;
                                                                                        }
                                                                                        break block67;
                                                                                    }
                                                                                    if (clazz != Integer.TYPE) break block93;
                                                                                    int[] nArray6 = new int[nArray.length];
                                                                                    object2 = nArray6;
                                                                                    int n = 0;
                                                                                    while (n < nArray.length) {
                                                                                        nArray6[n] = nArray[n];
                                                                                        ++n;
                                                                                    }
                                                                                    break block67;
                                                                                }
                                                                                if (clazz != Long.TYPE) break block94;
                                                                                long[] lArray5 = new long[nArray.length];
                                                                                object2 = lArray5;
                                                                                int n = 0;
                                                                                while (n < nArray.length) {
                                                                                    lArray5[n] = nArray[n];
                                                                                    ++n;
                                                                                }
                                                                                break block67;
                                                                            }
                                                                            if (clazz != Float.TYPE) break block95;
                                                                            float[] fArray5 = new float[nArray.length];
                                                                            object2 = fArray5;
                                                                            int n = 0;
                                                                            while (n < nArray.length) {
                                                                                fArray5[n] = nArray[n];
                                                                                ++n;
                                                                            }
                                                                            break block67;
                                                                        }
                                                                        if (clazz != Double.TYPE) break block67;
                                                                        double[] dArray = new double[nArray.length];
                                                                        object2 = dArray;
                                                                        int n = 0;
                                                                        while (n < nArray.length) {
                                                                            dArray[n] = nArray[n];
                                                                            ++n;
                                                                        }
                                                                        break block67;
                                                                    }
                                                                    if (clazz2 != Long.TYPE) break block96;
                                                                    lArray = (long[])object;
                                                                    if (clazz != Byte.TYPE) break block97;
                                                                    byte[] byArray = new byte[lArray.length];
                                                                    object2 = byArray;
                                                                    int n = 0;
                                                                    while (n < lArray.length) {
                                                                        byArray[n] = (byte)lArray[n];
                                                                        ++n;
                                                                    }
                                                                    break block67;
                                                                }
                                                                if (clazz != Short.TYPE) break block98;
                                                                short[] sArray = new short[lArray.length];
                                                                object2 = sArray;
                                                                int n = 0;
                                                                while (n < lArray.length) {
                                                                    sArray[n] = (short)lArray[n];
                                                                    ++n;
                                                                }
                                                                break block67;
                                                            }
                                                            if (clazz != Character.TYPE) break block99;
                                                            char[] cArray = new char[lArray.length];
                                                            object2 = cArray;
                                                            int n = 0;
                                                            while (n < lArray.length) {
                                                                cArray[n] = (char)lArray[n];
                                                                ++n;
                                                            }
                                                            break block67;
                                                        }
                                                        if (clazz != Integer.TYPE) break block100;
                                                        int[] nArray = new int[lArray.length];
                                                        object2 = nArray;
                                                        int n = 0;
                                                        while (n < lArray.length) {
                                                            nArray[n] = (int)lArray[n];
                                                            ++n;
                                                        }
                                                        break block67;
                                                    }
                                                    if (clazz != Long.TYPE) break block101;
                                                    long[] lArray6 = new long[lArray.length];
                                                    object2 = lArray6;
                                                    int n = 0;
                                                    while (n < lArray.length) {
                                                        lArray6[n] = lArray[n];
                                                        ++n;
                                                    }
                                                    break block67;
                                                }
                                                if (clazz != Float.TYPE) break block102;
                                                float[] fArray6 = new float[lArray.length];
                                                object2 = fArray6;
                                                int n = 0;
                                                while (n < lArray.length) {
                                                    fArray6[n] = lArray[n];
                                                    ++n;
                                                }
                                                break block67;
                                            }
                                            if (clazz != Double.TYPE) break block67;
                                            double[] dArray = new double[lArray.length];
                                            object2 = dArray;
                                            int n = 0;
                                            while (n < lArray.length) {
                                                dArray[n] = lArray[n];
                                                ++n;
                                            }
                                            break block67;
                                        }
                                        if (clazz2 != Float.TYPE) break block103;
                                        fArray = (float[])object;
                                        if (clazz != Byte.TYPE) break block104;
                                        byte[] byArray = new byte[fArray.length];
                                        object2 = byArray;
                                        int n = 0;
                                        while (n < fArray.length) {
                                            byArray[n] = (byte)fArray[n];
                                            ++n;
                                        }
                                        break block67;
                                    }
                                    if (clazz != Short.TYPE) break block105;
                                    short[] sArray = new short[fArray.length];
                                    object2 = sArray;
                                    int n = 0;
                                    while (n < fArray.length) {
                                        sArray[n] = (short)fArray[n];
                                        ++n;
                                    }
                                    break block67;
                                }
                                if (clazz != Character.TYPE) break block106;
                                char[] cArray = new char[fArray.length];
                                object2 = cArray;
                                int n = 0;
                                while (n < fArray.length) {
                                    cArray[n] = (char)fArray[n];
                                    ++n;
                                }
                                break block67;
                            }
                            if (clazz != Integer.TYPE) break block107;
                            int[] nArray = new int[fArray.length];
                            object2 = nArray;
                            int n = 0;
                            while (n < fArray.length) {
                                nArray[n] = (int)fArray[n];
                                ++n;
                            }
                            break block67;
                        }
                        if (clazz != Long.TYPE) break block108;
                        long[] lArray = new long[fArray.length];
                        object2 = lArray;
                        int n = 0;
                        while (n < fArray.length) {
                            lArray[n] = (long)fArray[n];
                            ++n;
                        }
                        break block67;
                    }
                    if (clazz != Float.TYPE) break block109;
                    float[] fArray7 = new float[fArray.length];
                    object2 = fArray7;
                    int n = 0;
                    while (n < fArray.length) {
                        fArray7[n] = fArray[n];
                        ++n;
                    }
                    break block67;
                }
                if (clazz != Double.TYPE) break block67;
                double[] dArray = new double[fArray.length];
                object2 = dArray;
                int n = 0;
                while (n < fArray.length) {
                    dArray[n] = fArray[n];
                    ++n;
                }
                break block67;
            }
            if (clazz2 == Double.TYPE) {
                double[] dArray = (double[])object;
                if (clazz == Byte.TYPE) {
                    byte[] byArray = new byte[dArray.length];
                    object2 = byArray;
                    int n = 0;
                    while (n < dArray.length) {
                        byArray[n] = (byte)dArray[n];
                        ++n;
                    }
                } else if (clazz == Short.TYPE) {
                    short[] sArray = new short[dArray.length];
                    object2 = sArray;
                    int n = 0;
                    while (n < dArray.length) {
                        sArray[n] = (short)dArray[n];
                        ++n;
                    }
                } else if (clazz == Character.TYPE) {
                    char[] cArray = new char[dArray.length];
                    object2 = cArray;
                    int n = 0;
                    while (n < dArray.length) {
                        cArray[n] = (char)dArray[n];
                        ++n;
                    }
                } else if (clazz == Integer.TYPE) {
                    int[] nArray = new int[dArray.length];
                    object2 = nArray;
                    int n = 0;
                    while (n < dArray.length) {
                        nArray[n] = (int)dArray[n];
                        ++n;
                    }
                } else if (clazz == Long.TYPE) {
                    long[] lArray = new long[dArray.length];
                    object2 = lArray;
                    int n = 0;
                    while (n < dArray.length) {
                        lArray[n] = (long)dArray[n];
                        ++n;
                    }
                } else if (clazz == Float.TYPE) {
                    float[] fArray = new float[dArray.length];
                    object2 = fArray;
                    int n = 0;
                    while (n < dArray.length) {
                        fArray[n] = (float)dArray[n];
                        ++n;
                    }
                } else if (clazz == Double.TYPE) {
                    double[] dArray2 = new double[dArray.length];
                    object2 = dArray2;
                    int n = 0;
                    while (n < dArray.length) {
                        dArray2[n] = dArray[n];
                        ++n;
                    }
                }
            }
        }
        return object2;
    }

    public static void main(String[] stringArray) {
        int n;
        int n2;
        int[][][] nArray = new int[10][9][8];
        boolean[][] blArray = new boolean[][]{new boolean[5], new boolean[4], new boolean[3], new boolean[2]};
        double[][] dArray = new double[10][20];
        StringBuffer[][] stringBufferArray = new StringBuffer[3][2];
        System.out.println("getBaseClass: test1: Base type of integer array is:" + ArrayFuncs.getBaseClass(nArray));
        System.out.println("getBaseLength: test1: " + ArrayFuncs.getBaseLength(nArray));
        System.out.println("arrayDescription: test1: " + ArrayFuncs.arrayDescription(nArray));
        System.out.println("computeSize: test1:   " + ArrayFuncs.computeSize(nArray));
        System.out.println("getBaseClass: test2: Base type of boolean array is:" + ArrayFuncs.getBaseClass(blArray));
        System.out.println("getBaseLength: test2: " + ArrayFuncs.getBaseLength(blArray));
        System.out.println("arrayDescription: test2: " + ArrayFuncs.arrayDescription(blArray));
        System.out.println("computeSize: test2:   " + ArrayFuncs.computeSize(blArray));
        System.out.println("getBaseClass: test3: Base type of double array is: " + ArrayFuncs.getBaseClass(dArray));
        System.out.println("getBaseLength: test3: " + ArrayFuncs.getBaseLength(dArray));
        System.out.println("arrayDescription: test1: " + ArrayFuncs.arrayDescription(dArray));
        System.out.println("computeSize: test3:   " + ArrayFuncs.computeSize(dArray));
        System.out.println("getBaseClass: test4: Base type of StringBuffer array is: " + ArrayFuncs.getBaseClass(stringBufferArray));
        System.out.println("getBaseLength: test4: " + ArrayFuncs.getBaseLength(stringBufferArray));
        System.out.println("arrayDescription: test1: " + ArrayFuncs.arrayDescription(stringBufferArray));
        System.out.println("computeSize: test4:   " + ArrayFuncs.computeSize(stringBufferArray));
        System.out.println("");
        System.out.println("arrayDescription: test1: Print a simple description of an array:" + ArrayFuncs.arrayDescription(nArray));
        System.out.println("arrayDescription: test2: doesn't handle non-rectangular arrays:" + ArrayFuncs.arrayDescription(blArray));
        System.out.println("");
        System.out.println("examinePrimitiveArray: test1");
        ArrayFuncs.examinePrimitiveArray(nArray);
        System.out.println("");
        System.out.println("examinePrimitiveArray: test2");
        ArrayFuncs.examinePrimitiveArray(blArray);
        System.out.println("");
        System.out.println("    NOTE: this should show that test2 is not a rectangular array");
        System.out.println("");
        System.out.println("Using aggregates:");
        Object[] objectArray = new Object[]{nArray, blArray, dArray, stringBufferArray};
        System.out.println("getBaseClass: agg: Base class of aggregate is:" + ArrayFuncs.getBaseClass(objectArray));
        System.out.println("Size of aggregate is:" + ArrayFuncs.computeSize(objectArray));
        System.out.println("This ignores the array of StringBuffers");
        ArrayFuncs.testPattern(nArray, (byte)0);
        System.out.println("testPattern:");
        int n3 = 0;
        while (n3 < nArray.length) {
            n2 = 0;
            while (n2 < nArray[0].length) {
                n = 0;
                while (n < nArray[0][0].length) {
                    System.out.print(" " + nArray[n3][n2][n]);
                    ++n;
                }
                System.out.println("");
                ++n2;
            }
            System.out.println("");
            ++n3;
        }
        int[][][] nArray2 = (int[][][])ArrayFuncs.deepClone(nArray);
        System.out.println("deepClone: copied array");
        n2 = 0;
        while (n2 < nArray2.length) {
            n = 0;
            while (n < nArray2[0].length) {
                int n4 = 0;
                while (n4 < nArray2[0][0].length) {
                    System.out.print(" " + nArray2[n2][n][n4]);
                    ++n4;
                }
                System.out.println("");
                ++n;
            }
            System.out.println("");
            ++n2;
        }
        nArray2[2][2][2] = 99;
        System.out.println("Demonstrating that this is a deep clone:" + nArray2[2][2][2] + " " + nArray[2][2][2]);
        System.out.println("Flatten an array:");
        int[] nArray3 = (int[])ArrayFuncs.flatten(nArray);
        System.out.println("    arrayDescription: test6:" + ArrayFuncs.arrayDescription(nArray3));
        n = 0;
        while (n < nArray3.length) {
            System.out.print(" " + nArray3[n]);
            if (n > 0 && n % 10 == 0) {
                System.out.println("");
            }
            ++n;
        }
        System.out.println("");
        System.out.println("Curl an array, we'll reformat test1's data");
        int[] nArray4 = new int[]{8, 9, 10};
        int[][][] nArray5 = (int[][][])ArrayFuncs.curl(nArray3, nArray4);
        int n5 = 0;
        while (n5 < nArray2.length) {
            int n6 = 0;
            while (n6 < nArray2[0].length) {
                int n7 = 0;
                while (n7 < nArray2[0][0].length) {
                    System.out.print(" " + nArray2[n5][n6][n7]);
                    ++n7;
                }
                System.out.println("");
                ++n6;
            }
            System.out.println("");
            ++n5;
        }
        System.out.println("");
        System.out.println("Test array conversions");
        byte[][][] byArray = (byte[][][])ArrayFuncs.convertArray(nArray, Byte.TYPE);
        System.out.println("  xtest1 is of type:" + ArrayFuncs.arrayDescription(byArray));
        System.out.println("   test1[3][3][3]=" + nArray[3][3][3] + "  xtest1=" + byArray[3][3][3]);
        System.out.println("Converting float[700][700] to byte at:" + new Date());
        float[][] fArray = new float[700][700];
        byte[][] byArray2 = (byte[][])ArrayFuncs.convertArray(fArray, Byte.TYPE);
        System.out.println("  img=" + ArrayFuncs.arrayDescription(byArray2) + " at " + new Date());
        System.out.println("End of tests");
    }
}

