/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.test;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.util.Date;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.BinaryTable;
import nom.tam.fits.BinaryTableHDU;
import nom.tam.fits.BinaryTableHeaderParser;
import nom.tam.fits.Column;
import nom.tam.fits.Fits;
import nom.tam.fits.HDU;
import nom.tam.fits.Header;
import nom.tam.fits.PrimaryHDU;
import nom.tam.fits.RandomGroupsHDU;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.BufferedDataInputStream;
import nom.tam.util.BufferedDataOutputStream;

public class FitsTester {
    public static void main(String[] stringArray) {
        FitsTester.testSimpleWrite();
        FitsTester.testSimpleRead();
        FitsTester.testNetRead();
        FitsTester.testSkipAndRead();
        FitsTester.testReadByRow();
        FitsTester.testWriteByRow();
        FitsTester.testBuildByColumn();
        FitsTester.testVarCols();
        FitsTester.testRandomGroups();
    }

    static void testRandomGroups() {
        Object object;
        Object[][] objectArray;
        Object object2;
        Object object3;
        FitsTester.start("Write and read a random groups data set");
        try {
            object3 = new short[5];
            object2 = new short[50][50];
            objectArray = new Object[10][2];
            objectArray[0][0] = object3;
            objectArray[0][1] = object2;
            RandomGroupsHDU randomGroupsHDU = new RandomGroupsHDU(objectArray);
            object = new BufferedDataOutputStream(new FileOutputStream("test6.fits"));
            int n = randomGroupsHDU.getData().getPadding();
            randomGroupsHDU.getHeader().write((BufferedDataOutputStream)object);
            int n2 = 0;
            while (n2 < 10) {
                object3[2] = (short)n2;
                object3[3] = (short)(n2 * n2);
                object2[n2][n2] = (short)(n2 * n2 * n2);
                ((BufferedDataOutputStream)object).writePrimitiveArray(object3);
                ((BufferedDataOutputStream)object).writePrimitiveArray(object2);
                ++n2;
            }
            byte[] byArray = new byte[n];
            ((FilterOutputStream)object).write(byArray);
            ((BufferedOutputStream)object).flush();
            ((FilterOutputStream)object).close();
            object = null;
        }
        catch (Exception exception) {
            System.out.println("Error writing random groups data");
            exception.printStackTrace(System.out);
            return;
        }
        try {
            object3 = new Fits("Test6.fits");
            object2 = ((Fits)object3).read();
            object2[0].info();
            objectArray = (Object[][])object2[0].getData().getData();
            int n = 0;
            while (n < 10) {
                object = (short[])objectArray[n][0];
                System.out.println("    Group:" + (n + 1) + " params2,3= " + (int)object[2] + " " + (int)object[3]);
                short[][] sArray = (short[][])objectArray[n][1];
                System.out.println("           Data[i][i] = " + sArray[n][n]);
                ++n;
            }
        }
        catch (Exception exception) {
            System.out.println("Error reading random groups data");
            exception.printStackTrace(System.out);
        }
        FitsTester.end("Test Random Groups");
    }

    static void testVarCols() {
        int[][] nArray;
        BinaryTableHDU binaryTableHDU;
        BasicHDU[] basicHDUArray;
        Fits fits;
        FitsTester.start("Build and read variable length columns");
        try {
            int n;
            fits = new Fits();
            fits.addHDU(new PrimaryHDU());
            fits.addHDU(HDU.create(FitsTester.genTable()));
            basicHDUArray = fits.read();
            binaryTableHDU = (BinaryTableHDU)basicHDUArray[1];
            nArray = new int[8][];
            int n2 = 0;
            while (n2 < 8) {
                nArray[n2] = new int[n2 + 1];
                n = 0;
                while (n <= n2) {
                    nArray[n2][n] = 2 * n;
                    ++n;
                }
                ++n2;
            }
            System.out.println("    Written to FITS:");
            n2 = 0;
            while (n2 < nArray.length) {
                System.out.print("       " + n2 + ":");
                n = 0;
                while (n < nArray[n2].length) {
                    System.out.print(" " + n + ":" + nArray[n2][n]);
                    ++n;
                }
                System.out.println("");
                ++n2;
            }
            Column column = binaryTableHDU.makeVarColumn((Object[])nArray, "J");
            column.addKey(Header.formatFields("TTYPE", "'TestVar '", "Name of variable column"));
            binaryTableHDU.addColumn(column);
            BufferedDataOutputStream bufferedDataOutputStream = new BufferedDataOutputStream(new FileOutputStream("test5.fits"));
            fits.write(bufferedDataOutputStream);
            bufferedDataOutputStream.flush();
            bufferedDataOutputStream.close();
        }
        catch (Exception exception) {
            System.out.println("Exception writing test5.fits:" + exception);
            exception.printStackTrace(System.out);
        }
        try {
            fits = new Fits("test5.fits");
            basicHDUArray = fits.read();
            if (basicHDUArray == null) {
                System.out.println("Error: test5.fits doesn't seem to have any HDUs!");
                return;
            }
            binaryTableHDU = (BinaryTableHDU)basicHDUArray[1];
            binaryTableHDU.info();
            nArray = (int[][])binaryTableHDU.getVarData("TestVar");
            if (nArray == null) {
                System.out.println("Error: test5.fits TestVar data not found");
                return;
            }
            System.out.println("    Read from FITS:");
            int n = 0;
            while (n < nArray.length) {
                System.out.print("       " + n + ":");
                int n3 = 0;
                while (n3 < nArray[n].length) {
                    System.out.print(" " + n3 + ":" + nArray[n][n3]);
                    ++n3;
                }
                System.out.println("");
                ++n;
            }
        }
        catch (Exception exception) {
            System.out.println("Caught exception reading test5.fits: " + exception);
            exception.printStackTrace(System.out);
        }
        FitsTester.end("Test Var columns");
    }

    static void testBuildByColumn() {
        FitsTester.start("Build by Column");
        try {
            Fits fits = new Fits();
            fits.addHDU(new PrimaryHDU());
            BinaryTableHDU binaryTableHDU = new BinaryTableHDU();
            int[][][] nArray = new int[8][][];
            int n = 0;
            while (n < 8) {
                nArray[n] = new int[4][3];
                nArray[n][0][0] = n;
                ++n;
            }
            binaryTableHDU.addColumn((Object[])nArray);
            float[][] fArray = new float[8][10];
            int n2 = 0;
            while (n2 < 8) {
                fArray[n2][0] = 100 * n2;
                ++n2;
            }
            binaryTableHDU.addColumn((Object[])fArray);
            double[][] dArray = new double[8][4];
            binaryTableHDU.addColumn((Object[])dArray);
            fits.addHDU(binaryTableHDU);
            BufferedDataOutputStream bufferedDataOutputStream = new BufferedDataOutputStream(new FileOutputStream("test4.fits"));
            fits.write(bufferedDataOutputStream);
            bufferedDataOutputStream.flush();
            bufferedDataOutputStream.close();
            bufferedDataOutputStream = null;
            fits = new Fits("test4.fits");
            BasicHDU[] basicHDUArray = fits.read();
            if (basicHDUArray == null) {
                System.out.println("Error: test4.fits doesn't seem to have any HDUs!");
                return;
            }
            int n3 = 0;
            while (n3 < basicHDUArray.length) {
                basicHDUArray[n3].info();
                ++n3;
            }
        }
        catch (Exception exception) {
            System.out.println("Caught exception writing/reading test4.fits: " + exception);
            exception.printStackTrace(System.out);
        }
        FitsTester.end("Build by column: ");
    }

    static void testWriteByRow() {
        Object object;
        BasicHDU[] basicHDUArray;
        Object object2;
        FitsTester.start("Write data row by row");
        Object[] objectArray = new Object[]{new int[30], new float[10][10], new double[2][3][4]};
        String[] stringArray = new String[]{"RandomName1", "RandomName2", "RandomName3"};
        int n = 20;
        try {
            object2 = new Object[][]{objectArray};
            basicHDUArray = new BinaryTableHDU((Object[][])object2);
            Header header = basicHDUArray.getHeader();
            header.addIntValue("NAXIS2", n, "Number of rows");
            int n2 = 0;
            while (n2 < 3) {
                header.findKey("TFORM" + (n2 + 1));
                header.addStringValue("TTYPE" + (n2 + 1), stringArray[n2], "");
                ++n2;
            }
            BufferedDataOutputStream bufferedDataOutputStream = new BufferedDataOutputStream(new FileOutputStream("test2.fits"));
            object = new PrimaryHDU();
            ((BasicHDU)object).write(bufferedDataOutputStream);
            header.write(bufferedDataOutputStream);
            int n3 = 0;
            while (n3 < n) {
                ((int[])objectArray[0])[0] = n3++;
                bufferedDataOutputStream.writePrimitiveArray(objectArray);
            }
            n3 = header.paddedDataSize() - header.trueDataSize();
            byte[] byArray = new byte[n3];
            bufferedDataOutputStream.write(byArray);
            bufferedDataOutputStream.flush();
            bufferedDataOutputStream.close();
        }
        catch (Exception exception) {
            System.out.println("Caught exception writing test2.fits: " + exception);
            return;
        }
        try {
            object2 = new Fits("test2.fits");
            basicHDUArray = ((Fits)object2).read();
            if (basicHDUArray == null) {
                System.out.println("Error: test2.fits doesn't seem to have any HDUs!");
                return;
            }
            int n4 = 0;
            while (n4 < basicHDUArray.length) {
                basicHDUArray[n4].info();
                ++n4;
            }
            BinaryTable binaryTable = (BinaryTable)basicHDUArray[1].getData();
            int n5 = 0;
            while (n5 < binaryTable.getNrow()) {
                object = (int[])binaryTable.getElement(n5, 0);
                System.out.println("    Row marker is:" + (int)object[0]);
                ++n5;
            }
        }
        catch (Exception exception) {
            System.out.println("Caught exception reading test2.fits:" + exception);
            exception.printStackTrace(System.out);
        }
        FitsTester.end("Writing data row by row");
    }

    static void testReadByRow() {
        FitsTester.start("Read row by row");
        try {
            Fits fits = new Fits("test1.fits");
            fits.skipHDU(2);
            BufferedDataInputStream bufferedDataInputStream = fits.getStream();
            Header header = Header.readHeader(bufferedDataInputStream);
            if (header == null) {
                System.out.println("Third HDU from test1.fits is null!");
                return;
            }
            Object[] objectArray = new BinaryTableHeaderParser(header).getModelRow();
            int n = header.getIntValue("NAXIS2");
            byte[] byArray = (byte[])objectArray[0];
            int n2 = 0;
            while (n2 < n) {
                bufferedDataInputStream.readPrimitiveArray(objectArray);
                System.out.println("    Reading row:" + (n2 + 1) + " with marker:" + byArray[0]);
                ++n2;
            }
            bufferedDataInputStream.skipBytes(header.paddedDataSize() - header.trueDataSize());
        }
        catch (Exception exception) {
            System.out.println("Caught exception reading by rows:" + exception);
            exception.printStackTrace(System.out);
        }
        FitsTester.end("Reading row by row");
    }

    static void testSkipAndRead() {
        FitsTester.start("Skip to third extension");
        try {
            Fits fits = new Fits("test1.fits");
            fits.skipHDU(2);
            BasicHDU[] basicHDUArray = fits.read();
            if (basicHDUArray == null) {
                System.out.println("Error: test1.fits third extension doesn't exist!");
                return;
            }
            int n = 0;
            while (n < basicHDUArray.length) {
                basicHDUArray[n].info();
                ++n;
            }
        }
        catch (Exception exception) {
            System.out.println("Caught exception in skip and read:" + exception);
        }
        FitsTester.end("Skip to third extension");
    }

    static void testSimpleWrite() {
        FitsTester.start("Write a FITS file");
        try {
            Fits fits = new Fits();
            int[] nArray = new int[]{20, 20, 20};
            fits.addHDU(HDU.create(ArrayFuncs.generateArray(Float.TYPE, nArray)));
            int[] nArray2 = new int[]{2, 2, 2, 8, 16};
            fits.addHDU(HDU.create(ArrayFuncs.generateArray(Integer.TYPE, nArray2)));
            fits.addHDU(HDU.create(FitsTester.genTable()));
            FileOutputStream fileOutputStream = new FileOutputStream("test1.fits");
            BufferedDataOutputStream bufferedDataOutputStream = new BufferedDataOutputStream(fileOutputStream);
            fits.write(bufferedDataOutputStream);
        }
        catch (Exception exception) {
            System.err.println("Exception thrown:" + exception);
            exception.printStackTrace(System.out);
            return;
        }
        FitsTester.end("Write a FITS file");
    }

    static void testSimpleRead() {
        BasicHDU[] basicHDUArray;
        FitsTester.start("Read a FITS file");
        try {
            Fits fits = new Fits("test1.fits");
            basicHDUArray = fits.read();
        }
        catch (Exception exception) {
            System.out.println("Caught an exception reading test1.fits:" + exception);
            exception.printStackTrace(System.out);
            return;
        }
        if (basicHDUArray == null) {
            System.out.println("Error: test1.fits doesn't seem to have any HDUs!");
            return;
        }
        int n = 0;
        while (n < basicHDUArray.length) {
            try {
                if (basicHDUArray[n] == null) {
                    System.out.println("test1.fits HDU#" + n + " is null");
                } else {
                    basicHDUArray[n].info();
                }
            }
            catch (Exception exception) {
                System.out.println("Caught an exception examining test1.fits HDU#" + n + ":" + exception);
                exception.printStackTrace(System.out);
            }
            ++n;
        }
        FitsTester.end("Read a FITS file");
    }

    static void testNetRead() {
        BasicHDU[] basicHDUArray;
        FitsTester.start("Read compressed FITS file over the network");
        String string = "http://legacy.gsfc.nasa.gov/FTP/compton/data/egret/phase01/pnt_0010/counts_vp0010_g001.fits.gz";
        try {
            Fits fits = new Fits(string);
            basicHDUArray = fits.read();
        }
        catch (Exception exception) {
            System.out.println("Caught an exception reading over the net:" + exception);
            exception.printStackTrace(System.out);
            return;
        }
        if (basicHDUArray == null) {
            System.out.println("Error: net file doesn't seem to have any HDUs!");
            return;
        }
        int n = 0;
        while (n < basicHDUArray.length) {
            try {
                basicHDUArray[n].info();
            }
            catch (Exception exception) {
                System.out.println("Caught an exception examining net HDU#" + n + ":" + exception);
                exception.printStackTrace(System.out);
                return;
            }
            ++n;
        }
        FitsTester.end("Read over net");
    }

    static Object[][] genTable() {
        Object[] objectArray = new Object[6];
        int[] nArray = new int[]{10};
        objectArray[0] = ArrayFuncs.generateArray(Byte.TYPE, nArray);
        int[] nArray2 = new int[]{5, 5};
        objectArray[1] = ArrayFuncs.generateArray(Short.TYPE, nArray2);
        int[] nArray3 = new int[]{5, 2};
        objectArray[2] = ArrayFuncs.generateArray(Integer.TYPE, nArray3);
        int[] nArray4 = new int[]{3, 3, 2};
        objectArray[3] = ArrayFuncs.generateArray(Integer.TYPE, nArray4);
        int[] nArray5 = new int[]{4, 3, 2};
        objectArray[4] = ArrayFuncs.generateArray(Float.TYPE, nArray5);
        int[] nArray6 = new int[]{6, 7};
        objectArray[5] = ArrayFuncs.generateArray(Double.TYPE, nArray6);
        Object[][] objectArray2 = new Object[8][6];
        int n = 0;
        while (n < 8) {
            objectArray2[n] = (Object[])ArrayFuncs.deepClone(objectArray);
            byte[] byArray = (byte[])objectArray2[n][0];
            byArray[0] = (byte)n;
            ++n;
        }
        return objectArray2;
    }

    static void start(String string) {
        System.out.println("***************************************");
        System.out.println("Start:  " + string + " @ " + new Date());
    }

    static void end(String string) {
        System.out.println("End:    " + string + " @ " + new Date());
        System.out.println("");
        System.out.println("");
        System.out.println("");
    }
}

