/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import nom.tam.fits.BasicHDU;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.RandomGroupsData;
import nom.tam.util.ArrayFuncs;

public class RandomGroupsHDU
extends BasicHDU {
    static void pointToData(Header header, Object[][] objectArray) throws FitsException {
        Class clazz;
        if (objectArray.length <= 0 || objectArray[0].length != 2) {
            throw new FitsException("Data not conformable to Random Groups");
        }
        int n = objectArray.length;
        Object object = objectArray[0][0];
        Object object2 = objectArray[0][1];
        Class clazz2 = ArrayFuncs.getBaseClass(object);
        if (clazz2 != (clazz = ArrayFuncs.getBaseClass(object2))) {
            throw new FitsException("Data and parameters do not agree in type for random group");
        }
        int[] nArray = ArrayFuncs.getDimensions(object);
        int[] nArray2 = ArrayFuncs.getDimensions(object2);
        if (nArray.length != 1) {
            throw new FitsException("Parameters are not 1 d array for random groups");
        }
        header.setSimple(true);
        if (clazz == Byte.TYPE) {
            header.setBitpix(8);
        } else if (clazz == Short.TYPE) {
            header.setBitpix(16);
        } else if (clazz == Integer.TYPE) {
            header.setBitpix(32);
        } else if (clazz == Long.TYPE) {
            header.setBitpix(64);
        } else if (clazz == Float.TYPE) {
            header.setBitpix(-32);
        } else if (clazz == Double.TYPE) {
            header.setBitpix(-64);
        } else {
            throw new FitsException("Data type:" + clazz + " not supported for random groups");
        }
        header.setNaxes(nArray2.length + 1);
        header.addIntValue("NAXIS1", 0, "");
        int n2 = 2;
        while (n2 <= nArray2.length + 1) {
            header.addIntValue("NAXIS" + n2, nArray2[n2 - 2], "");
            ++n2;
        }
        header.addBooleanValue("GROUPS", true, "");
        header.addIntValue("GCOUNT", objectArray.length, "");
        header.addIntValue("PCOUNT", nArray[0], "");
    }

    public static boolean isHeader(Header header) {
        return header.getBooleanValue("SIMPLE") & header.getBooleanValue("GROUPS");
    }

    public boolean isHeader() {
        return RandomGroupsHDU.isHeader(this.myHeader);
    }

    public Data manufactureData() throws FitsException {
        if (this.myHeader != null) {
            return new RandomGroupsData(this.myHeader);
        }
        return null;
    }

    public void info() {
        System.out.println("Random Groups HDU");
        if (this.myHeader != null) {
            System.out.println("   HeaderInformation:");
            System.out.println("     Ngroups:" + this.myHeader.getIntValue("GCOUNT"));
            System.out.println("     Npar:   " + this.myHeader.getIntValue("PCOUNT"));
            System.out.println("     BITPIX: " + this.myHeader.getIntValue("BITPIX"));
            System.out.println("     NAXIS:  " + this.myHeader.getIntValue("NAXIS"));
            int n = 0;
            while (n < this.myHeader.getIntValue("NAXIS")) {
                System.out.println("      NAXIS" + (n + 1) + "= " + this.myHeader.getIntValue("NAXIS" + (n + 1)));
                ++n;
            }
        } else {
            System.out.println("    No Header Information");
        }
        Object[][] objectArray = null;
        if (this.myData != null) {
            objectArray = (Object[][])this.myData.getData();
        }
        if (objectArray == null || objectArray.length < 1 || objectArray[0].length != 2) {
            System.out.println("    Invalid/unreadable data");
        } else {
            System.out.println("    Number of groups:" + objectArray.length);
            System.out.println("    Parameters: " + ArrayFuncs.arrayDescription(objectArray[0][0]));
            System.out.println("    Data:" + ArrayFuncs.arrayDescription(objectArray[0][1]));
        }
    }

    public RandomGroupsHDU(Header header) throws FitsException {
        super(header);
        this.myData = this.manufactureData();
    }

    public RandomGroupsHDU(Object[][] objectArray) throws FitsException {
        super(new Header());
        this.myData = new RandomGroupsData(objectArray);
        RandomGroupsHDU.pointToData(this.myHeader, objectArray);
    }
}

