/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.lang.reflect.Array;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.util.ArrayFuncs;

public class RandomGroupsData
extends Data {
    public static Object[] generateSampleRow(Header header) throws FitsException {
        Class<Number> clazz;
        int n = header.getIntValue("NAXIS", 0) - 1;
        int[] nArray = new int[n];
        int n2 = header.getIntValue("BITPIX", 0);
        if (n2 == 8) {
            clazz = Byte.TYPE;
        } else if (n2 == 16) {
            clazz = Short.TYPE;
        } else if (n2 == 32) {
            clazz = Integer.TYPE;
        } else if (n2 == 64) {
            clazz = Long.TYPE;
        } else if (n2 == -32) {
            clazz = Float.TYPE;
        } else if (n2 == -64) {
            clazz = Double.TYPE;
        } else {
            throw new FitsException("Invalid BITPIX:" + n2);
        }
        int n3 = 0;
        while (n3 < n) {
            long l = header.getIntValue("NAXIS" + (n3 + 2), 0);
            if (l < 0L) {
                throw new FitsException("Invalid array dimension:" + l);
            }
            nArray[n - n3 - 1] = (int)l;
            ++n3;
        }
        Object[] objectArray = new Object[]{Array.newInstance(clazz, header.getIntValue("PCOUNT")), Array.newInstance(clazz, nArray)};
        return objectArray;
    }

    public int getPadding() {
        Object object = ((Object[][])this.dataArray)[0][0];
        Object object2 = ((Object[][])this.dataArray)[0][1];
        int n = ArrayFuncs.getBaseLength(object);
        int n2 = Array.getLength(object);
        int[] nArray = ArrayFuncs.getDimensions(object2);
        int n3 = ((Object[][])this.dataArray).length;
        int n4 = 1;
        int n5 = 0;
        while (n5 < nArray.length) {
            n4 *= nArray[n5];
            ++n5;
        }
        n4 += n2;
        if ((n4 = n * n3 * n4) % 2880 == 0) {
            return 0;
        }
        return 2880 - n4 % 2880;
    }

    public RandomGroupsData(Header header) throws FitsException {
        int n = header.getIntValue("GCOUNT", -1);
        int n2 = header.getIntValue("PCOUNT", -1);
        if (!header.getBooleanValue("GROUPS") || header.getIntValue("NAXIS1", -1) != 0 || n < 0 || n2 < 0 || header.getIntValue("NAXIS") < 2) {
            throw new FitsException("Invalid Random Groups Parameters");
        }
        this.dataArray = n > 0 ? new Object[n][2] : new Object[0][];
        Object[] objectArray = RandomGroupsData.generateSampleRow(header);
        int n3 = 0;
        while (n3 < n) {
            ((Object[])this.dataArray)[n3] = ArrayFuncs.deepClone(objectArray);
            ++n3;
        }
    }

    public RandomGroupsData() {
        this.dataArray = new Object[0][];
    }

    public RandomGroupsData(Object[][] objectArray) {
        this.dataArray = objectArray;
    }
}

