/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import nom.tam.fits.BadHeaderException;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.ImageData;
import nom.tam.fits.ImageHDU;
import nom.tam.util.ArrayFuncs;

public class PrimaryHDU
extends BasicHDU {
    public static boolean isHeader(Header header) {
        if (header.getBooleanValue("GROUPS") && (header.getIntValue("GCOUNT", 1) > 1 || header.getIntValue("PCOUNT", 0) != 0)) {
            return false;
        }
        String string = header.getCard(0);
        return string != null && string.startsWith("SIMPLE  ");
    }

    public boolean isHeader() {
        return PrimaryHDU.isHeader(this.myHeader);
    }

    public Data manufactureData() throws FitsException {
        return new ImageData(this.myHeader);
    }

    public void info() {
        System.out.println("  Primary Image");
        System.out.println("      Header Information:");
        System.out.println("         BITPIX=" + this.myHeader.getIntValue("BITPIX", -1));
        int n = this.myHeader.getIntValue("NAXIS", -1);
        System.out.println("         NAXIS=" + n);
        int n2 = 1;
        while (n2 <= n) {
            System.out.println("         NAXIS" + n2 + "=" + this.myHeader.getIntValue("NAXIS" + n2, -1));
            ++n2;
        }
        System.out.println("      Data information:");
        if (this.myData.getData() == null) {
            System.out.println("        No Data");
        } else {
            System.out.println("         " + ArrayFuncs.arrayDescription(this.myData.getData()));
        }
    }

    public PrimaryHDU(Header header) throws FitsException {
        super(header);
        if (!this.isHeader()) {
            throw new BadHeaderException("Not a valid primary header or uses random groups");
        }
    }

    public PrimaryHDU(ImageHDU imageHDU) throws FitsException {
        super(imageHDU.myHeader);
        if (this.myHeader != null && !this.myHeader.imageToPrimary()) {
            throw new FitsException("Couldn't create PrimaryHDU from ImageHDU");
        }
        this.myData = imageHDU.myData;
    }

    public PrimaryHDU() throws FitsException {
        super(new Header());
        this.myData = new ImageData();
        this.myHeader.pointToData(this.myData);
    }

    public PrimaryHDU(Object object) throws FitsException {
        super(new Header());
        this.myData = new ImageData(object);
        this.myHeader.pointToData(this.myData);
    }
}

