/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import nom.tam.fits.BadHeaderException;
import nom.tam.fits.Data;
import nom.tam.fits.ExtensionHDU;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.ImageData;
import nom.tam.fits.PrimaryHDU;
import nom.tam.util.ArrayFuncs;

public class ImageHDU
extends ExtensionHDU {
    public static boolean isHeader(Header header) {
        String string = header.getCard(0);
        return string != null && string.startsWith("XTENSION= 'IMAGE   '");
    }

    public boolean isHeader() {
        return ImageHDU.isHeader(this.myHeader);
    }

    public Data manufactureData() throws FitsException {
        return new ImageData(this.myHeader);
    }

    public void info() {
        if (this.isHeader()) {
            System.out.println("  Image Extension");
        } else {
            System.out.println("  Image Extension (bad header)");
        }
        System.out.println("      Header Information:");
        System.out.println("         BITPIX=" + this.myHeader.getIntValue("BITPIX", -1));
        int n = this.myHeader.getIntValue("NAXIS", -1);
        System.out.println("         NAXIS=" + n);
        int n2 = 1;
        while (n2 <= n) {
            System.out.println("         NAXIS" + n2 + "=" + this.myHeader.getIntValue("NAXIS" + n2, -1));
            ++n2;
        }
        System.out.println("      Data information:");
        if (this.myData.getData() == null) {
            System.out.println("        No Data");
        } else {
            System.out.println("         " + ArrayFuncs.arrayDescription(this.myData.getData()));
        }
    }

    public ImageHDU(Header header) throws FitsException {
        super(header);
        if (!this.isHeader()) {
            throw new BadHeaderException("Not a valid image header");
        }
    }

    public ImageHDU(PrimaryHDU primaryHDU) throws FitsException {
        super(primaryHDU.myHeader);
        if (this.myHeader != null && !this.myHeader.primaryToImage()) {
            throw new FitsException("Couldn't create ImageHDU from PrimaryHDU");
        }
        if (!this.isHeader()) {
            throw new FitsException("Header was not converted to a valid image header");
        }
        this.myData = primaryHDU.myData;
    }

    public ImageHDU(Object object) throws FitsException {
        super(new Header());
        this.myData = new ImageData(object);
        this.myHeader.pointToData(this.myData);
        if (!this.myHeader.primaryToImage()) {
            throw new FitsException("Default header was not converted to a valid image header");
        }
    }
}

