/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.lang.reflect.Array;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;

public class ImageData
extends Data {
    public ImageData(Header header) throws FitsException {
        Class<Number> clazz;
        int n = header.getIntValue("GCOUNT", 1);
        int n2 = header.getIntValue("PCOUNT", 0);
        if (n > 1 || n2 != 0) {
            throw new FitsException("Currently unable to handle GROUPed data  GCOUNT=" + n + "; PCOUNT=" + n2);
        }
        int n3 = header.getIntValue("BITPIX", 0);
        if (n3 == 8) {
            clazz = Byte.TYPE;
        } else if (n3 == 16) {
            clazz = Short.TYPE;
        } else if (n3 == 32) {
            clazz = Integer.TYPE;
        } else if (n3 == 64) {
            clazz = Long.TYPE;
        } else if (n3 == -32) {
            clazz = Float.TYPE;
        } else if (n3 == -64) {
            clazz = Double.TYPE;
        } else {
            throw new FitsException("Invalid BITPIX:" + n3);
        }
        int n4 = header.getIntValue("NAXIS   ", 0);
        int[] nArray = new int[n4];
        int n5 = 0;
        while (n5 < n4) {
            long l = header.getIntValue("NAXIS" + (n5 + 1), 0);
            if (l < 0L) {
                throw new FitsException("Invalid array dimension:" + l);
            }
            nArray[n4 - n5 - 1] = (int)l;
            ++n5;
        }
        if (n4 > 0) {
            this.dataArray = Array.newInstance(clazz, nArray);
        } else {
            int[] nArray2 = new int[]{0};
            this.dataArray = Array.newInstance(clazz, nArray2);
        }
    }

    public ImageData() {
        this.dataArray = new byte[0];
    }

    public ImageData(Object object) {
        this.dataArray = object;
    }
}

