/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import nom.tam.fits.HeaderCardException;

public class HeaderCard {
    private static final int MAX_KEYWORD_LENGTH = 8;
    private static final int MAX_VALUE_LENGTH = 70;
    String key;
    String value;
    String comment;
    boolean isString;
    private String space40 = "                                        ";

    public boolean isStringValue() {
        return this.isString;
    }

    public boolean isKeyValuePair() {
        return this.key != null && this.value != null;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public String getComment() {
        return this.comment;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(80);
        if (this.key != null) {
            stringBuffer.append(this.key);
        }
        while (stringBuffer.length() < 8) {
            stringBuffer.append(' ');
        }
        if (this.value != null) {
            stringBuffer.append("= ");
            if (this.isString) {
                stringBuffer.append('\'');
                stringBuffer.append(this.value);
                while (stringBuffer.length() < 19) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append('\'');
            } else {
                int n = stringBuffer.length();
                stringBuffer.append(this.value);
                while (stringBuffer.length() < 30) {
                    stringBuffer.insert(n, ' ');
                }
            }
            if (this.comment != null) {
                stringBuffer.append(" / ");
            }
        } else if (this.comment != null && this.comment.startsWith("= ")) {
            stringBuffer.append("  ");
        }
        if (this.comment != null) {
            stringBuffer.append(this.comment);
        }
        if (stringBuffer.length() > 80) {
            stringBuffer.setLength(80);
        } else {
            if (stringBuffer.length() < 40) {
                stringBuffer.append(this.space40);
            }
            if (stringBuffer.length() < 80) {
                stringBuffer.append(this.space40.substring(0, 80 - stringBuffer.length()));
            }
        }
        return stringBuffer.toString();
    }

    public HeaderCard(String string, String string2, String string3) throws HeaderCardException {
        if (string == null && string2 != null) {
            throw new HeaderCardException("Null keyword with non-null value");
        }
        if (string != null && string.length() > 8) {
            throw new HeaderCardException("Keyword too long");
        }
        if (string2 != null) {
            if ((string2 = string2.trim()).length() > 70) {
                throw new HeaderCardException("Value too long");
            }
            if (string2.charAt(0) == '\'') {
                if (string2.charAt(string2.length() - 1) != '\'') {
                    throw new HeaderCardException("Missing end quote in string value");
                }
                string2 = string2.substring(1, string2.length() - 1).trim();
                this.isString = true;
            }
        }
        this.key = string;
        this.value = string2;
        this.comment = string3;
    }

    public HeaderCard(String string) {
        int n;
        this.key = null;
        this.value = null;
        this.comment = null;
        this.isString = false;
        if (string.length() < 9) {
            this.key = string;
            return;
        }
        this.key = string.substring(0, 8).trim();
        if (this.key.length() == 0) {
            this.key = "";
            this.comment = string.substring(8);
            return;
        }
        if (!string.substring(8, 10).equals("= ")) {
            this.comment = string.substring(8);
            return;
        }
        String string2 = string.substring(10).trim();
        if (string2.length() == 0) {
            this.value = "";
            return;
        }
        int n2 = -1;
        boolean bl = false;
        if (string2.charAt(0) == '\'') {
            n = 1;
            while (n < string2.length()) {
                n2 = string2.indexOf("'", n);
                if (n2 == string2.length() - 1) break;
                if (n2 == -1) {
                    this.key = null;
                    this.comment = string;
                    return;
                }
                if (string2.charAt(n2 + 1) != '\'') break;
                n = n2 + 2;
            }
            this.value = string2.substring(1, n2).trim();
            this.isString = true;
        }
        if ((n = string2.indexOf(47)) != -1) {
            this.comment = string2.substring(n + 1).trim();
            string2 = string2.substring(0, n).trim();
        }
        if (!this.isString) {
            this.value = string2;
        }
    }
}

