/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.EOFException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.NoSuchElementException;
import nom.tam.fits.CardTable;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.HeaderCardException;
import nom.tam.fits.ImageData;
import nom.tam.fits.TruncatedFileException;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.BufferedDataInputStream;
import nom.tam.util.BufferedDataOutputStream;

public class Header {
    private CardTable cards = new CardTable();
    private int mark = -2;

    public int size() {
        return this.cards.size();
    }

    public int trueDataSize() {
        if (!this.isValidHeader()) {
            return 0;
        }
        int n = 1;
        int n2 = this.getIntValue("NAXIS", 0);
        int n3 = 1;
        while (n3 <= n2) {
            int n4 = this.getIntValue("NAXIS" + n3, 0);
            if (n3 != 1 || n4 != 0) {
                n *= n4;
            }
            ++n3;
        }
        n += this.getIntValue("PCOUNT", 0);
        n *= this.getIntValue("GCOUNT", 1);
        return n *= Math.abs(this.getIntValue("BITPIX", 0)) / 8;
    }

    public int paddedDataSize() {
        return (this.trueDataSize() + 2879) / 2880 * 2880;
    }

    public int headerSize() {
        if (!this.isValidHeader()) {
            return 0;
        }
        return (this.cards.size() * 80 + 2879) / 2880 * 2880;
    }

    public boolean isValidHeader() {
        return this.cards != null && this.cards.size() >= 5;
    }

    public String getCard(int n) {
        try {
            if (n >= 0 && n < this.cards.size()) {
                return this.cards.elementAt(n).toString();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return null;
    }

    public String getKey(int n) {
        String string = this.getCard(n);
        if (string == null) {
            return null;
        }
        String string2 = string.substring(0, 8);
        if (string2.charAt(0) == ' ') {
            return "";
        }
        if (string2.indexOf(32) >= 1) {
            string2 = string2.substring(0, string2.indexOf(32));
        }
        return string2;
    }

    public long getLongValue(String string, long l) {
        HeaderCard headerCard = this.findCard(string);
        if (headerCard == null) {
            return l;
        }
        try {
            String string2 = headerCard.getValue();
            if (string2 != null) {
                return Long.parseLong(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return l;
    }

    public double getDoubleValue(String string, double d) {
        HeaderCard headerCard = this.findCard(string);
        if (headerCard == null) {
            return d;
        }
        try {
            String string2 = headerCard.getValue();
            if (string2 != null) {
                return new Double(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return d;
    }

    public boolean getBooleanValue(String string, boolean bl) {
        HeaderCard headerCard = this.findCard(string);
        if (headerCard == null) {
            return bl;
        }
        String string2 = headerCard.getValue();
        if (string2 == null) {
            return bl;
        }
        if (string2.equals("T")) {
            return true;
        }
        if (string2.equals("F")) {
            return false;
        }
        return bl;
    }

    public long getLongValue(String string) {
        return this.getLongValue(string, 0L);
    }

    public double getDoubleValue(String string) {
        return this.getDoubleValue(string, 0.0);
    }

    public boolean getBooleanValue(String string) {
        return this.getBooleanValue(string, false);
    }

    public int getIntValue(String string, int n) {
        return (int)this.getLongValue(string, n);
    }

    public int getIntValue(String string) {
        return (int)this.getLongValue(string);
    }

    public float getFloatValue(String string, float f) {
        return (float)this.getDoubleValue(string, f);
    }

    public float getFloatValue(String string) {
        return (float)this.getDoubleValue(string);
    }

    public String getStringValue(String string) {
        HeaderCard headerCard = this.findCard(string);
        if (headerCard == null || !headerCard.isStringValue()) {
            return null;
        }
        return headerCard.getValue();
    }

    protected void addLine(HeaderCard headerCard) {
        if (headerCard != null) {
            if (this.markSet() && this.getMark() < this.cards.size() - 1) {
                this.cards.insertElementAt(headerCard, this.getMark() + 1);
                this.setMark(this.getMark() + 1);
            } else {
                this.cards.addElement(headerCard);
            }
        }
    }

    protected void addLine(String string) throws HeaderCardException {
        this.addLine(new HeaderCard(string));
    }

    public static Header readHeader(BufferedDataInputStream bufferedDataInputStream) throws TruncatedFileException, IOException {
        Header header = new Header();
        try {
            header.read(bufferedDataInputStream);
        }
        catch (EOFException eOFException) {
            return null;
        }
        return header;
    }

    public void read(BufferedDataInputStream bufferedDataInputStream) throws TruncatedFileException, IOException {
        int n;
        int n2;
        byte[] byArray = new byte[80];
        boolean bl = true;
        while (true) {
            String string;
            n2 = 80;
            try {
                while (n2 > 0) {
                    n = bufferedDataInputStream.read(byArray, 80 - n2, n2);
                    if (n == 0) {
                        throw new TruncatedFileException();
                    }
                    n2 -= n;
                }
            }
            catch (EOFException eOFException) {
                if (bl) {
                    throw eOFException;
                }
                throw new TruncatedFileException(eOFException.getMessage());
            }
            HeaderCard headerCard = new HeaderCard(new String(byArray));
            if (bl && ((string = headerCard.getKey()) == null || !string.equals("SIMPLE") && !string.equals("XTENSION"))) {
                throw new IOException("Not a FITS file");
            }
            this.addLine(headerCard);
            if (!headerCard.isKeyValuePair() && (string = headerCard.getKey()) != null && string.equals("END")) break;
            bl = false;
        }
        n = 36 - this.cards.size() % 36;
        if (n != 36) {
            while (n > 0) {
                int n3 = 80;
                try {
                    while (n3 > 0) {
                        n2 = bufferedDataInputStream.read(byArray, 80 - n3, n3);
                        if (n2 == 0) {
                            throw new TruncatedFileException();
                        }
                        n3 -= n2;
                    }
                }
                catch (EOFException eOFException) {
                    throw new TruncatedFileException(eOFException.getMessage());
                }
                --n;
            }
        }
    }

    protected HeaderCard findCard(String string) {
        HeaderCard headerCard = this.cards.findKey(string);
        if (headerCard == null) {
            this.unsetMark();
            return null;
        }
        int n = this.cards.indexOf(headerCard);
        this.setMark(n);
        return headerCard;
    }

    public String findKey(String string) {
        HeaderCard headerCard = this.findCard(string);
        if (headerCard == null) {
            return null;
        }
        return headerCard.toString();
    }

    boolean replaceKey(String string, String string2) throws HeaderCardException {
        HeaderCard headerCard = this.findCard(string);
        if (headerCard == null) {
            return false;
        }
        String string3 = headerCard.getValue();
        if (string3 != null && headerCard.isStringValue()) {
            string3 = "'" + string3 + "'";
        }
        String string4 = headerCard.getComment();
        HeaderCard headerCard2 = new HeaderCard(string2, string3, string4);
        this.cards.setElementAt(headerCard2, this.getMark());
        return true;
    }

    public void write(BufferedDataOutputStream bufferedDataOutputStream) throws FitsException {
        this.checkEnd();
        if (this.cards.size() <= 0) {
            return;
        }
        String[] stringArray = new String[this.cards.size()];
        int n = 0;
        while (n < this.cards.size()) {
            stringArray[n] = this.cards.elementAt(n).toString();
            ++n;
        }
        try {
            bufferedDataOutputStream.writePrimitiveArray(stringArray);
            n = 36 - this.cards.size() % 36;
            if (n != 36) {
                String string = "                                                                                ";
                int n2 = 0;
                while (n2 < n) {
                    bufferedDataOutputStream.writeBytes(string);
                    ++n2;
                }
            }
        }
        catch (IOException iOException) {
            throw new FitsException("IO Error writing header: " + iOException);
        }
    }

    public void addBooleanValue(String string, boolean bl, String string2) throws HeaderCardException {
        String string3 = bl ? "T" : "F";
        this.replaceCard(string, string3, string2);
    }

    public void addFloatValue(String string, float f, String string2) throws HeaderCardException {
        String string3 = "" + f;
        this.replaceCard(string, string3, string2);
    }

    public void addDoubleValue(String string, double d, String string2) throws HeaderCardException {
        String string3 = "" + d;
        this.replaceCard(string, string3, string2);
    }

    public void addStringValue(String string, String string2, String string3) throws HeaderCardException {
        if (string2 == null) {
            string2 = "";
        }
        if (string2.length() < 8) {
            string2 = (string2 + "        ").substring(0, 8);
        } else if (string2.length() > 67) {
            string2 = string2.substring(0, 67);
        }
        string2 = "'" + string2 + "'";
        this.replaceCard(string, string2, string3);
    }

    public void replaceCard(String string, String string2, String string3) throws HeaderCardException {
        HeaderCard headerCard = new HeaderCard(string, string2, string3);
        int n = this.getMark();
        this.findCard(string);
        if (this.markSet()) {
            this.cards.setElementAt(headerCard, this.getMark());
        } else {
            this.setMark(n);
            this.insertCard(headerCard);
        }
    }

    public void addIntValue(String string, int n, String string2) throws HeaderCardException {
        this.addLongValue(string, n, string2);
    }

    public void addLongValue(String string, long l, String string2) throws HeaderCardException {
        String string3 = "" + l;
        this.replaceCard(string, string3, string2);
    }

    private void insertCard(HeaderCard headerCard) {
        if (this.markSet() && this.getMark() < this.cards.size() - 1) {
            this.cards.insertElementAt(headerCard, this.getMark() + 1);
            ++this.mark;
        } else {
            this.cards.addElement(headerCard);
            this.unsetMark();
        }
    }

    public static String formatFields(String string, String string2, String string3) throws HeaderCardException {
        return new HeaderCard(string, string2, string3).toString();
    }

    public void insertCard(String string) {
        this.insertCard(new HeaderCard(string));
    }

    public void insertCommentStyle(String string, String string2) throws HeaderCardException {
        this.insertCard(new HeaderCard(string, null, string2));
    }

    public void insertComment(String string) throws HeaderCardException {
        this.insertCommentStyle("COMMENT", string);
    }

    public void insertHistory(String string) throws HeaderCardException {
        this.insertCommentStyle("HISTORY", string);
    }

    public boolean markSet() {
        return this.mark >= -1;
    }

    public int getMark() {
        return this.mark;
    }

    public void setMark(int n) {
        this.mark = n;
    }

    public void unsetMark() {
        this.mark = -2;
    }

    public void deleteKey(String string) {
        this.findCard(string);
        if (this.markSet()) {
            this.cards.removeElementAt(this.getMark());
        }
        if (this.getMark() >= this.cards.size()) {
            this.unsetMark();
        }
    }

    public void removeCardAt(int n) {
        if (n < this.cards.size() && n >= 0) {
            this.cards.removeElementAt(n);
        }
        if (n < this.cards.size()) {
            this.setMark(n);
        } else {
            this.unsetMark();
        }
    }

    public final boolean containsKey(String string) {
        return this.cards.containsKey(string);
    }

    public void pointToData(Data data) throws FitsException {
        if (!(data instanceof ImageData)) {
            throw new FitsException("Cannot point to class:" + data.getClass().getName());
        }
        this.pointToImage(data.getData());
    }

    protected void pointToImage(Object object) throws FitsException {
        String string;
        int n;
        if (object == null) {
            this.nullImage();
        }
        String string2 = object.getClass().getName();
        int[] nArray = ArrayFuncs.getDimensions(object);
        if (nArray == null || nArray.length == 0) {
            throw new FitsException("Image data object not array");
        }
        switch (string2.charAt(nArray.length)) {
            case 'B': {
                n = 8;
                break;
            }
            case 'S': {
                n = 16;
                break;
            }
            case 'I': {
                n = 32;
                break;
            }
            case 'J': {
                n = 64;
                break;
            }
            case 'F': {
                n = -32;
                break;
            }
            case 'D': {
                n = -64;
                break;
            }
            default: {
                throw new FitsException("Invalid Object Type for FITS data");
            }
        }
        if (!(this.getBooleanValue("SIMPLE") || (string = this.getStringValue("XTENSION")) != null && string.equals("IMAGE") && this.getMark() == 0)) {
            this.setSimple(true);
        }
        this.setBitpix(n);
        this.setNaxes(nArray.length);
        int n2 = 1;
        while (n2 <= nArray.length) {
            if (nArray[n2 - 1] == -1) {
                throw new FitsException("Unfilled array for dimension: " + n2);
            }
            this.setNaxis(n2, nArray[n2 - 1]);
            ++n2;
        }
        this.setPcount(0);
        this.setGcount(1);
        this.setExtend(true);
    }

    void nullImage() {
        this.setSimple(true);
        this.setBitpix(8);
        this.setNaxes(0);
        this.setPcount(0);
        this.setGcount(0);
        this.setExtend(true);
        int n = 1;
        while (n < 9) {
            this.deleteKey("NAXIS" + n);
            ++n;
        }
    }

    void setSimple(boolean bl) {
        this.deleteKey("SIMPLE");
        this.deleteKey("XTENSION");
        if (this.cards.size() >= 0) {
            this.setMark(-1);
        }
        try {
            this.addBooleanValue("SIMPLE", bl, "Java FITS: " + new Date());
        }
        catch (HeaderCardException headerCardException) {
            throw new RuntimeException("Impossible error: " + headerCardException.getMessage());
        }
    }

    void setXtension(String string) {
        this.deleteKey("SIMPLE");
        this.deleteKey("XTENSION");
        if (this.cards.size() >= 0) {
            this.setMark(-1);
        }
        try {
            this.addStringValue("XTENSION", string, "Java FITS: " + new Date());
        }
        catch (HeaderCardException headerCardException) {
            throw new RuntimeException("Impossible error: " + headerCardException.getMessage());
        }
    }

    void setBitpix(int n) {
        if (this.cards.size() > 1) {
            this.setMark(0);
        }
        try {
            this.addIntValue("BITPIX", n, null);
        }
        catch (HeaderCardException headerCardException) {
            throw new RuntimeException("Impossible error: " + headerCardException.getMessage());
        }
    }

    void setNaxes(int n) {
        if (this.cards.size() > 2) {
            this.setMark(1);
        }
        try {
            this.addIntValue("NAXIS", n, "Dimensionality");
        }
        catch (HeaderCardException headerCardException) {
            throw new RuntimeException("Impossible error: " + headerCardException.getMessage());
        }
    }

    void checkEnd() {
        HeaderCard headerCard = null;
        int n = 0;
        while (n < this.cards.size()) {
            HeaderCard headerCard2 = this.cards.elementAt(n);
            try {
                if (!headerCard2.isKeyValuePair() && headerCard2.getKey().equals("END")) {
                    if (n == this.cards.size() - 1) {
                        return;
                    }
                    if (headerCard == null) {
                        headerCard = new HeaderCard(null, null, null);
                    }
                    this.cards.setElementAt(headerCard, n);
                }
            }
            catch (HeaderCardException headerCardException) {
                // empty catch block
            }
            ++n;
        }
        this.unsetMark();
        try {
            this.addLine("END");
        }
        catch (HeaderCardException headerCardException) {
            throw new RuntimeException("Impossible error: " + headerCardException.getMessage());
        }
    }

    void setNaxis(int n, int n2) {
        if (n <= 0) {
            return;
        }
        if (this.cards.size() > 2 + n) {
            this.setMark(1 + n);
        }
        try {
            this.addIntValue("NAXIS" + n, n2, null);
        }
        catch (HeaderCardException headerCardException) {
            throw new RuntimeException("Impossible error: " + headerCardException.getMessage());
        }
    }

    void setGcount(int n) {
        try {
            this.addIntValue("GCOUNT", n, "Number of Groups");
        }
        catch (HeaderCardException headerCardException) {
            throw new RuntimeException("Impossible error: " + headerCardException.getMessage());
        }
    }

    void setPcount(int n) {
        try {
            this.addIntValue("PCOUNT", n, "Group params/Variable cols buffer");
        }
        catch (HeaderCardException headerCardException) {
            throw new RuntimeException("Impossible error: " + headerCardException.getMessage());
        }
    }

    void setExtend(boolean bl) {
        try {
            this.addBooleanValue("EXTEND", bl, "Can there be extensions?");
        }
        catch (HeaderCardException headerCardException) {
            throw new RuntimeException("Impossible error: " + headerCardException.getMessage());
        }
    }

    protected boolean primaryToImage() {
        if (this.getBooleanValue("SIMPLE") && this.getMark() == 0) {
            this.setXtension("IMAGE");
            return true;
        }
        String string = this.getStringValue("XTENSION");
        if (string == null) {
            this.setXtension("IMAGE");
            return true;
        }
        return string.equals("IMAGE");
    }

    protected boolean imageToPrimary() {
        if (this.getBooleanValue("SIMPLE") && this.getMark() == 0) {
            return true;
        }
        String string = this.getStringValue("XTENSION");
        if (string == null) {
            this.setSimple(true);
            return true;
        }
        if (string.equals("IMAGE") && this.getMark() == 0) {
            this.setSimple(true);
            return true;
        }
        return false;
    }

    protected void dumpHeader(PrintStream printStream) {
        int n = 0;
        while (n < this.cards.size()) {
            printStream.println(this.cards.elementAt(n));
            ++n;
        }
    }

    public Header() {
    }

    public Header(BufferedDataInputStream bufferedDataInputStream) throws TruncatedFileException, IOException {
        this.read(bufferedDataInputStream);
    }

    public Header(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            this.cards.addElement(new HeaderCard(stringArray[n]));
            ++n;
        }
    }
}

