/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.IOException;
import nom.tam.fits.A3DTableHDU;
import nom.tam.fits.AsciiTableHDU;
import nom.tam.fits.BadHeaderException;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.BinaryTableHDU;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.ImageHDU;
import nom.tam.fits.PrimaryHDU;
import nom.tam.fits.RandomGroupsHDU;
import nom.tam.util.BufferedDataInputStream;

public class HDU {
    public static BasicHDU create(Object object) throws FitsException {
        String string = object.getClass().getName();
        if (string.equals("[[Ljava.lang.Object;")) {
            return new BinaryTableHDU((Object[][])object);
        }
        if (string.startsWith("[")) {
            return new ImageHDU(object);
        }
        throw new FitsException("Expected an array of some sort, not " + string);
    }

    public static RandomGroupsHDU createRandomGroups(Object[][] objectArray) throws FitsException {
        return new RandomGroupsHDU(objectArray);
    }

    public static AsciiTableHDU createAsciiTable(Object[][] objectArray) throws FitsException {
        throw new FitsException("ASCII tables not yet supported");
    }

    public static BasicHDU create(Header header) throws FitsException {
        if (PrimaryHDU.isHeader(header)) {
            return new PrimaryHDU(header);
        }
        if (ImageHDU.isHeader(header)) {
            return new ImageHDU(header);
        }
        if (BinaryTableHDU.isHeader(header)) {
            return new BinaryTableHDU(header);
        }
        if (AsciiTableHDU.isHeader(header)) {
            return new AsciiTableHDU(header);
        }
        if (RandomGroupsHDU.isHeader(header)) {
            return new RandomGroupsHDU(header);
        }
        if (A3DTableHDU.isHeader(header)) {
            return new A3DTableHDU(header);
        }
        throw new BadHeaderException("Unknown FITS header: Card 1=" + header.getCard(0).trim() + ")");
    }

    public static BasicHDU readHDU(BufferedDataInputStream bufferedDataInputStream) throws FitsException, IOException {
        BasicHDU basicHDU;
        Header header = Header.readHeader(bufferedDataInputStream);
        if (header == null || !header.isValidHeader()) {
            return null;
        }
        try {
            basicHDU = HDU.create(header);
        }
        catch (BadHeaderException badHeaderException) {
            try {
                BasicHDU.skipData(bufferedDataInputStream, header);
                throw badHeaderException;
            }
            catch (FitsException fitsException) {
                throw new BadHeaderException("Could not skip Data section of unknown FITS header (Card 1=" + header.getCard(0).trim() + ").  Error is: " + fitsException.getMessage());
            }
        }
        basicHDU.readData(bufferedDataInputStream);
        return basicHDU;
    }

    public static boolean skipHDU(BufferedDataInputStream bufferedDataInputStream) throws FitsException, IOException {
        Header header = Header.readHeader(bufferedDataInputStream);
        if (header == null || !header.isValidHeader()) {
            return false;
        }
        try {
            BasicHDU.skipData(bufferedDataInputStream, header);
        }
        catch (IOException iOException) {
            throw new FitsException("Error skipping data section:" + iOException.getMessage());
        }
        return true;
    }
}

