/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import nom.tam.fits.FitsException;

public class FitsDate {
    private int year = -1;
    private int month = -1;
    private int mday = -1;
    private int hour = -1;
    private int minute = -1;
    private int second = -1;
    private int millisecond = -1;
    private Date date = null;

    private void buildOldDate(String string, int n, int n2) {
        int n3 = string.indexOf(47, n + 1);
        if (n3 > n + 2 && n3 < n2) {
            try {
                this.year = Integer.parseInt(string.substring(n3 + 1)) + 1900;
                this.month = Integer.parseInt(string.substring(n + 1, n3));
                this.mday = Integer.parseInt(string.substring(0, n));
            }
            catch (NumberFormatException numberFormatException) {
                this.mday = -1;
                this.month = -1;
                this.year = -1;
            }
        }
    }

    private void parseTime(String string) throws FitsException {
        int n = string.indexOf(58);
        if (n < 0) {
            throw new FitsException("Bad time");
        }
        int n2 = string.length();
        int n3 = string.indexOf(58, n + 1);
        if (n3 > n + 2 && n3 < n2) {
            if (n3 + 3 < n2 && string.charAt(n3 + 3) == '.') {
                double d = Double.valueOf(string.substring(n3 + 3));
                this.millisecond = (int)(d * 1000.0);
                n2 = n3 + 3;
            }
            try {
                this.hour = Integer.parseInt(string.substring(0, n));
                this.minute = Integer.parseInt(string.substring(n + 1, n3));
                this.second = Integer.parseInt(string.substring(n3 + 1, n2));
            }
            catch (NumberFormatException numberFormatException) {
                this.millisecond = -1;
                this.second = -1;
                this.minute = -1;
                this.hour = -1;
            }
        }
    }

    private void buildNewDate(String string, int n, int n2) throws FitsException {
        int n3 = string.indexOf(45, n + 1);
        if (n3 > n + 2 && n3 < n2) {
            try {
                if (n3 + 3 < n2 && string.charAt(n3 + 3) == 'T') {
                    try {
                        this.parseTime(string.substring(n3 + 4));
                    }
                    catch (FitsException fitsException) {
                        throw new FitsException("Bad time in FITS date string \"" + string + "\"");
                    }
                    n2 = n3 + 3;
                }
                this.year = Integer.parseInt(string.substring(0, n));
                this.month = Integer.parseInt(string.substring(n + 1, n3));
                this.mday = Integer.parseInt(string.substring(n3 + 1, n2));
            }
            catch (NumberFormatException numberFormatException) {
                this.millisecond = -1;
                this.second = -1;
                this.minute = -1;
                this.hour = -1;
                this.mday = -1;
                this.month = -1;
                this.year = -1;
            }
        }
    }

    public Date toDate() {
        if (this.date == null && this.year != -1) {
            TimeZone timeZone = TimeZone.getTimeZone("GMT");
            GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
            gregorianCalendar.set(1, this.year);
            gregorianCalendar.set(2, this.month - 1);
            gregorianCalendar.set(5, this.mday);
            if (this.hour == -1) {
                gregorianCalendar.set(11, 0);
                gregorianCalendar.set(12, 0);
                gregorianCalendar.set(13, 0);
                gregorianCalendar.set(14, 0);
            } else {
                gregorianCalendar.set(11, this.hour);
                gregorianCalendar.set(12, this.minute);
                gregorianCalendar.set(13, this.second);
                if (this.millisecond == -1) {
                    gregorianCalendar.set(14, 0);
                } else {
                    gregorianCalendar.set(14, this.millisecond);
                }
            }
            this.date = gregorianCalendar.getTime();
        }
        return this.date;
    }

    public String toString() {
        if (this.year == -1) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(23);
        stringBuffer.append(this.year);
        stringBuffer.append('-');
        if (this.month < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(this.month);
        stringBuffer.append('-');
        if (this.mday < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(this.mday);
        if (this.hour != -1) {
            stringBuffer.append('T');
            if (this.hour < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(this.hour);
            stringBuffer.append(':');
            if (this.minute < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(this.minute);
            stringBuffer.append(':');
            if (this.second < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(this.second);
            if (this.millisecond != -1) {
                stringBuffer.append('.');
                if (this.millisecond < 100) {
                    if (this.millisecond < 10) {
                        stringBuffer.append("00");
                    } else {
                        stringBuffer.append('0');
                    }
                }
                stringBuffer.append(this.millisecond);
            }
        }
        return stringBuffer.toString();
    }

    public static void testArgs(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            try {
                FitsDate fitsDate = new FitsDate(stringArray[n]);
                System.out.println("\"" + stringArray[n] + "\" => " + fitsDate + " => " + fitsDate.toDate());
            }
            catch (Exception exception) {
                System.err.println("Date \"" + stringArray[n] + "\" threw " + exception.getClass().getName() + "(" + exception.getMessage() + ")");
            }
            ++n;
        }
    }

    public static void autotest() {
        String[] stringArray = new String[]{"20/09/79", "1997-07-25", "1987-06-05T04:03:02.01", "1998-03-10T16:58:34", null, "        "};
        FitsDate.testArgs(stringArray);
        String[] stringArray2 = new String[]{"20/09/", "/09/79", "09//79", "20/09/79/"};
        FitsDate.testArgs(stringArray2);
        String[] stringArray3 = new String[]{"1997-07", "-07-25", "1997--07-25", "1997-07-25-"};
        FitsDate.testArgs(stringArray3);
        String[] stringArray4 = new String[]{"5-Aug-1992", "28/02/91 16:32:00", "18-Feb-1993", "nn/nn/nn"};
        FitsDate.testArgs(stringArray4);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            FitsDate.autotest();
        } else {
            FitsDate.testArgs(stringArray);
        }
    }

    public FitsDate(String string) throws FitsException {
        if (string == null) {
            return;
        }
        if ((string = string.trim()).length() == 0) {
            return;
        }
        int n = string.length();
        if (n >= 8) {
            int n2 = string.indexOf(45);
            if (n2 == 4 && n2 < n) {
                this.buildNewDate(string, n2, n);
            } else {
                n2 = string.indexOf(47);
                if (n2 > 1 && n2 < n) {
                    this.buildOldDate(string, n2, n);
                }
            }
        }
        if (this.year == -1) {
            throw new FitsException("Bad FITS date string \"" + string + "\"");
        }
    }
}

