/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import nom.tam.fits.BadHDU;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.FauxHDU;
import nom.tam.fits.FitsException;
import nom.tam.fits.HDU;
import nom.tam.fits.ImageHDU;
import nom.tam.fits.PrimaryHDU;
import nom.tam.fits.SkippedHDU;
import nom.tam.util.BufferedDataInputStream;
import nom.tam.util.BufferedDataOutputStream;

public class Fits {
    private BufferedDataInputStream dataStr;
    private Vector HDUList = new Vector(10);
    private boolean atEOF;

    public static String version() {
        return "0.6";
    }

    protected void streamInit(InputStream inputStream, boolean bl) throws FitsException {
        if (inputStream == null) {
            throw new FitsException("Null input stream");
        }
        if (bl) {
            try {
                inputStream = new GZIPInputStream(inputStream);
            }
            catch (IOException iOException) {
                throw new FitsException("Cannot inflate input stream" + iOException);
            }
        }
        this.dataStr = inputStream instanceof BufferedDataInputStream ? (BufferedDataInputStream)inputStream : new BufferedDataInputStream(inputStream);
    }

    protected void fileInit(File file, boolean bl) throws FitsException {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            this.streamInit(fileInputStream, bl);
        }
        catch (IOException iOException) {
            throw new FitsException("Unable to create Input Stream from File: " + file);
        }
    }

    private static boolean isCompressed(String string) {
        int n = string.length();
        return n > 2 && string.substring(n - 3).equalsIgnoreCase(".gz");
    }

    public BasicHDU[] read() throws FitsException {
        this.readToEnd();
        int n = this.currentSize();
        if (n == 0) {
            return null;
        }
        Object[] objectArray = new BasicHDU[n];
        this.HDUList.copyInto(objectArray);
        return objectArray;
    }

    public BasicHDU readHDU() throws FitsException, IOException {
        BasicHDU basicHDU;
        if (this.dataStr == null || this.atEOF) {
            return null;
        }
        try {
            basicHDU = HDU.readHDU(this.dataStr);
        }
        catch (FitsException fitsException) {
            basicHDU = new BadHDU(fitsException);
        }
        if (basicHDU == null) {
            this.atEOF = true;
        } else {
            this.HDUList.addElement(basicHDU);
        }
        if (basicHDU instanceof FauxHDU) {
            ((FauxHDU)basicHDU).throwException();
        }
        return basicHDU;
    }

    public void skipHDU(int n) throws FitsException, IOException {
        int n2 = 0;
        while (n2 < n) {
            this.skipHDU();
            ++n2;
        }
    }

    public void skipHDU() throws FitsException, IOException {
        if (!this.atEOF && !HDU.skipHDU(this.dataStr)) {
            this.atEOF = true;
        } else {
            this.HDUList.addElement(new SkippedHDU());
        }
    }

    public BasicHDU getHDU(int n) throws FitsException, IOException {
        int n2 = this.currentSize();
        if (n2 > n) {
            BasicHDU basicHDU;
            try {
                basicHDU = (BasicHDU)this.HDUList.elementAt(n);
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new FitsException("Internal Error: Vector mismatch");
            }
            if (basicHDU instanceof FauxHDU) {
                ((FauxHDU)basicHDU).throwException();
            }
            return basicHDU;
        }
        int n3 = n2;
        while (n3 <= n) {
            BasicHDU basicHDU;
            try {
                basicHDU = this.readHDU();
            }
            catch (FitsException fitsException) {
                basicHDU = new BadHDU(fitsException);
            }
            if (basicHDU == null) {
                return null;
            }
            ++n3;
        }
        try {
            return (BasicHDU)this.HDUList.elementAt(n);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new FitsException("Internal Error: HDUList build failed");
        }
    }

    private void readToEnd() throws FitsException {
        while (this.dataStr != null && !this.atEOF) {
            try {
                if (this.readHDU() != null) continue;
                break;
            }
            catch (IOException iOException) {
                throw new FitsException("IO error: " + iOException);
            }
        }
    }

    public int size() throws FitsException {
        this.readToEnd();
        return this.currentSize();
    }

    public void addHDU(BasicHDU basicHDU) throws FitsException {
        if (basicHDU == null) {
            return;
        }
        if (this.currentSize() == 0) {
            if (basicHDU instanceof ImageHDU) {
                basicHDU = new PrimaryHDU((ImageHDU)basicHDU);
            } else if (!(basicHDU instanceof PrimaryHDU)) {
                this.HDUList.addElement(new PrimaryHDU());
            }
        } else if (basicHDU instanceof PrimaryHDU) {
            basicHDU = new ImageHDU((PrimaryHDU)basicHDU);
        }
        this.HDUList.addElement(basicHDU);
    }

    public void insertHDU(BasicHDU basicHDU, int n) throws FitsException {
        if (basicHDU == null) {
            return;
        }
        if (n < 0 || n >= this.currentSize()) {
            throw new FitsException("Attempt to insert HDU at invalid location: " + n);
        }
        try {
            this.HDUList.insertElementAt(basicHDU, n);
            if (n == 0) {
                PrimaryHDU primaryHDU = (PrimaryHDU)this.HDUList.elementAt(1);
                this.HDUList.setElementAt(new ImageHDU(primaryHDU), 1);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new FitsException("Internal Error: HDUList Vector Inconsistency");
        }
    }

    public void deleteHDU(int n) throws FitsException {
        int n2 = this.currentSize();
        if (n < 0 || n >= n2) {
            throw new FitsException("Attempt to delete non-existent HDU:" + n);
        }
        try {
            this.HDUList.removeElementAt(n);
            if (n == 0 && n2 > 0 && !(this.HDUList.elementAt(0) instanceof PrimaryHDU)) {
                this.insertHDU(new PrimaryHDU(), 0);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new FitsException("Internal Error: HDUList Vector Inconsitency");
        }
    }

    public void write(OutputStream outputStream) throws FitsException {
        BufferedDataOutputStream bufferedDataOutputStream = outputStream instanceof BufferedDataOutputStream ? (BufferedDataOutputStream)outputStream : new BufferedDataOutputStream(outputStream);
        int n = 0;
        while (n < this.currentSize()) {
            try {
                BasicHDU basicHDU = (BasicHDU)this.HDUList.elementAt(n);
                basicHDU.write(bufferedDataOutputStream);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new FitsException("Internal Error: Vector Inconsistency");
            }
            ++n;
        }
    }

    public void read(InputStream inputStream) throws FitsException, IOException {
        this.dataStr = inputStream instanceof BufferedDataInputStream ? (BufferedDataInputStream)inputStream : new BufferedDataInputStream(inputStream);
        this.read();
    }

    public int currentSize() {
        return this.HDUList.size();
    }

    public BufferedDataInputStream getStream() {
        return this.dataStr;
    }

    public void setStream(BufferedDataInputStream bufferedDataInputStream) {
        this.dataStr = bufferedDataInputStream;
        this.atEOF = false;
    }

    public static void main(String[] stringArray) throws FitsException {
        if (stringArray.length != 1) {
            System.err.println("Usage: Fits file");
            System.exit(1);
            return;
        }
        Fits fits = new Fits(stringArray[0]);
        try {
            System.out.println("Fits: " + fits);
        }
        catch (Exception exception) {
            System.err.println(stringArray[0] + " print threw " + exception.getMessage());
            exception.printStackTrace(System.err);
            System.exit(1);
            return;
        }
        int n = 0;
        while (true) {
            BasicHDU basicHDU;
            try {
                basicHDU = fits.getHDU(n);
                if (basicHDU == null) {
                    break;
                }
            }
            catch (Exception exception) {
                System.err.println(stringArray[0] + "#" + n + " fetch threw " + exception.getMessage());
                exception.printStackTrace(System.err);
                System.exit(1);
                return;
            }
            try {
                System.out.println("Fits: " + stringArray[0] + "#" + n + "= " + basicHDU);
            }
            catch (Exception exception) {
                System.err.println(stringArray[0] + "#" + n + " print threw " + exception.getMessage());
                exception.printStackTrace(System.err);
                System.exit(1);
                return;
            }
            ++n;
        }
    }

    public Fits() {
    }

    public Fits(InputStream inputStream) throws FitsException {
        this(inputStream, false);
    }

    public Fits(InputStream inputStream, boolean bl) throws FitsException {
        this.streamInit(inputStream, bl);
    }

    public Fits(File file, boolean bl) throws FitsException {
        this.fileInit(file, bl);
    }

    public Fits(File file) throws FitsException {
        this(file, false);
    }

    public Fits(String string) throws FitsException {
        if (string == null) {
            throw new FitsException("Null FITS Identifier String");
        }
        boolean bl = Fits.isCompressed(string);
        int n = string.length();
        if (n > 4 && string.substring(0, 5).equalsIgnoreCase("http:")) {
            URL uRL;
            try {
                uRL = new URL(string);
            }
            catch (IOException iOException) {
                throw new FitsException("Unable to convert string to URL: " + string);
            }
            try {
                InputStream inputStream = uRL.openStream();
                this.streamInit(inputStream, bl);
            }
            catch (IOException iOException) {
                throw new FitsException("Unable to open stream from URL:" + string + " Exception=" + iOException);
            }
        }
        this.fileInit(new File(string), bl);
    }

    public Fits(URL uRL, boolean bl) throws FitsException {
        try {
            this.streamInit(uRL.openStream(), bl);
        }
        catch (IOException iOException) {
            throw new FitsException("Unable to open input from URL:" + uRL);
        }
    }

    public Fits(URL uRL) throws FitsException {
        this(uRL, Fits.isCompressed(uRL.getFile()));
    }
}

