/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.EOFException;
import java.io.IOException;
import nom.tam.fits.FitsException;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.BufferedDataInputStream;
import nom.tam.util.BufferedDataOutputStream;

public abstract class Data {
    protected Object dataArray;

    public void write(BufferedDataOutputStream bufferedDataOutputStream) throws FitsException {
        this.writeTrueData(bufferedDataOutputStream);
        byte[] byArray = new byte[this.getPadding()];
        try {
            bufferedDataOutputStream.writePrimitiveArray(byArray);
        }
        catch (IOException iOException) {
            throw new FitsException("Error writing padding: " + iOException);
        }
    }

    public void read(BufferedDataInputStream bufferedDataInputStream) throws FitsException {
        this.readTrueData(bufferedDataInputStream);
        int n = this.getPadding();
        try {
            byte[] byArray = new byte[n];
            while (n > 0) {
                int n2 = bufferedDataInputStream.read(byArray, 0, n);
                if (n2 == 0) {
                    throw new FitsException("Data Padding EOF");
                }
                n -= n2;
            }
        }
        catch (EOFException eOFException) {
        }
        catch (IOException iOException) {
            throw new FitsException("Error skipping padding:" + iOException);
        }
    }

    protected void writeTrueData(BufferedDataOutputStream bufferedDataOutputStream) throws FitsException {
        try {
            bufferedDataOutputStream.writePrimitiveArray(this.dataArray);
        }
        catch (IOException iOException) {
            throw new FitsException("FITS Output Error: " + iOException);
        }
    }

    protected void readTrueData(BufferedDataInputStream bufferedDataInputStream) throws FitsException {
        try {
            bufferedDataInputStream.readPrimitiveArray(this.dataArray);
        }
        catch (IOException iOException) {
            throw new FitsException("FITS Input Error: " + iOException);
        }
    }

    public int getPadding() {
        int n = this.getTrueSize() % 2880;
        if (n == 0) {
            return 0;
        }
        return 2880 - n;
    }

    public int getTrueSize() {
        int n = ArrayFuncs.computeSize(this.dataArray);
        return n;
    }

    public int getPaddedSize() {
        return this.getTrueSize() + this.getPadding();
    }

    public Object getData() {
        return this.dataArray;
    }
}

