/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.lang.reflect.Array;
import nom.tam.fits.BinaryTable;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.util.ArrayFuncs;

public class BinaryTableHeaderParser {
    Header myHeader;

    public Object[] getModelRow() throws FitsException {
        int n = this.myHeader.getIntValue("TFIELDS");
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (n2 < n) {
            Object object = this.getColumnDef(n2 + 1);
            if (object == null) {
                throw new FitsException("Invalid TFORM for column " + (n2 + 1));
            }
            objectArray[n2] = object;
            ++n2;
        }
        return objectArray;
    }

    protected void checkLT0(int n, String string) throws FitsException {
        if (n < 0) {
            throw new FitsException(string);
        }
    }

    protected Object getColumnDef(int n) throws FitsException {
        int[] nArray;
        Class<Number> clazz;
        String string = this.myHeader.getStringValue("TFORM" + n);
        if (string == null) {
            throw new FitsException("No TFORM for column " + n);
        }
        int n2 = 0;
        while (n2 < string.length()) {
            if (!Character.isSpaceChar(string.charAt(n2))) break;
            ++n2;
        }
        while (n2 < string.length()) {
            if (!Character.isDigit(string.charAt(n2))) break;
            ++n2;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (n2 >= string.length()) {
            throw new FitsException("Invalid TFORM value for column " + n);
        }
        int n3 = n2 > 0 ? Integer.parseInt(string.substring(0, n2)) : 1;
        switch (string.charAt(n2)) {
            case 'X': {
                clazz = Byte.TYPE;
                bl2 = true;
                break;
            }
            case 'A': 
            case 'B': 
            case 'L': {
                clazz = Byte.TYPE;
                break;
            }
            case 'I': {
                clazz = Short.TYPE;
                break;
            }
            case 'J': {
                clazz = Integer.TYPE;
                break;
            }
            case 'K': {
                clazz = Long.TYPE;
                break;
            }
            case 'E': {
                clazz = Float.TYPE;
                break;
            }
            case 'D': {
                clazz = Double.TYPE;
                break;
            }
            case 'C': {
                clazz = Float.TYPE;
                bl = true;
                break;
            }
            case 'M': {
                clazz = Double.TYPE;
                bl = true;
                break;
            }
            case 'P': {
                clazz = Integer.TYPE;
                bl3 = true;
                if (n3 > 0) {
                    n3 = 2;
                    break;
                }
                n3 = 0;
                break;
            }
            default: {
                throw new FitsException("Invalid TFORM code '" + string.charAt(n2) + "' for column " + n);
            }
        }
        String string2 = this.myHeader.getStringValue("TDIM" + n);
        if (string2 != null && !bl3 && !bl2) {
            nArray = BinaryTableHeaderParser.getTDims(string2, n3);
        } else {
            if (bl2) {
                n3 /= 8;
            }
            nArray = new int[]{n3};
        }
        if (bl) {
            int[] nArray2 = new int[nArray.length + 1];
            nArray2[0] = 2;
            n2 = 1;
            while (n2 <= nArray.length) {
                nArray2[n2] = nArray[n2 - 1];
                ++n2;
            }
            nArray = nArray2;
        }
        try {
            return Array.newInstance(clazz, nArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FitsException("Invalid datatype");
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            throw new FitsException("Negative dimensions");
        }
    }

    public static int[] getTDims(String string, int n) {
        int n2;
        int[] nArray = new int[]{n};
        int n3 = 0;
        int n4 = 0;
        while (n4 < string.length()) {
            if (string.charAt(n4) == ',') {
                ++n3;
            }
            ++n4;
        }
        int[] nArray2 = new int[n3 + 1];
        int n5 = string.indexOf(40) + 1;
        if (n5 < 0) {
            return nArray;
        }
        int n6 = 0;
        while (n6 < n3) {
            n2 = string.indexOf(44, n5);
            if (n2 < 0) {
                return nArray;
            }
            nArray2[n6] = Integer.parseInt(string.substring(n5, n2));
            n5 = n2 + 1;
            ++n6;
        }
        n2 = string.indexOf(41, n5);
        if (n2 < 0) {
            return nArray;
        }
        nArray2[n3] = Integer.parseInt(string.substring(n5, n2));
        int[] nArray3 = new int[nArray2.length];
        int n7 = 0;
        while (n7 < nArray2.length) {
            nArray3[n7] = nArray2[nArray2.length - n7 - 1];
            ++n7;
        }
        return nArray3;
    }

    public static Header pointToTable(BinaryTable binaryTable) throws FitsException {
        if (binaryTable == null) {
            throw new FitsException("Cannot create header for null table");
        }
        Header header = new Header();
        return BinaryTableHeaderParser.pointToTable(binaryTable, header);
    }

    public static Header pointToTable(BinaryTable binaryTable, Header header) throws FitsException {
        header.setXtension("BINTABLE");
        header.setBitpix(8);
        header.setNaxes(2);
        header.setNaxis(1, 0);
        header.setNaxis(2, binaryTable.getNrow());
        header.setPcount(0);
        header.setGcount(1);
        int[][] nArray = binaryTable.getDimens();
        int[] nArray2 = binaryTable.getSizes();
        char[] cArray = binaryTable.getTypes();
        header.addIntValue("TFIELDS", nArray.length, "Number of fields in table");
        int n = header.getMark();
        String string = header.getCard(n);
        if (string != null && (string.substring(0, 8).equals("COMMENT ") || string.substring(0, 8).equals("        "))) {
            while (string.substring(0, 8).equals("COMMENT ") || string.substring(0, 8).equals("        ")) {
                string = header.getCard(++n);
            }
        } else {
            header.insertCommentStyle("", "");
            header.insertComment("End of required structural keywords");
            header.insertCommentStyle("", "");
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < nArray.length) {
            BinaryTableHeaderParser.pointToCol(header, n3, nArray2[n3], nArray[n3], cArray[n3]);
            int n4 = nArray2[n3];
            if (cArray[n3] == 'S') {
                n4 *= 2;
            } else if (cArray[n3] == 'I' || cArray[n3] == 'F') {
                n4 *= 4;
            } else if (cArray[n3] == 'L' || cArray[n3] == 'D') {
                n4 *= 8;
            }
            n2 += n4;
            ++n3;
        }
        header.addIntValue("NAXIS1", n2, "Number of bytes in row");
        return header;
    }

    public static void addColumn(int n, Object[] objectArray, Header header) throws FitsException {
        int n2;
        int n3;
        int n4;
        int[] nArray = ArrayFuncs.getDimensions(objectArray[0]);
        if (nArray.length == 0) {
            n4 = 1;
            nArray = new int[]{1};
        } else {
            n4 = 1;
            n3 = 0;
            while (n3 < nArray.length) {
                n4 *= nArray[n3];
                ++n3;
            }
        }
        Class clazz = ArrayFuncs.getBaseClass(objectArray[0]);
        if (clazz == Boolean.TYPE) {
            n2 = 1;
            n3 = 90;
        } else if (clazz == Byte.TYPE) {
            n2 = 1;
            n3 = 66;
        } else if (clazz == Short.TYPE || clazz == Character.TYPE) {
            n3 = 83;
            n2 = 2;
        } else if (clazz == Integer.TYPE) {
            n3 = 73;
            n2 = 4;
        } else if (clazz == Long.TYPE) {
            n3 = 74;
            n2 = 8;
        } else if (clazz == Float.TYPE) {
            n3 = 70;
            n2 = 4;
        } else if (clazz == Double.TYPE) {
            n3 = 68;
            n2 = 8;
        } else {
            throw new FitsException("Invalid Column type");
        }
        BinaryTableHeaderParser.pointToCol(header, n, n4, nArray, (char)n3);
        header.addIntValue("TFIELDS", header.getIntValue("TFIELDS") + 1, "Number of columns");
        header.addIntValue("NAXIS1", header.getIntValue("NAXIS1") + n2 * n4, "Bytes per row");
        if (n == 0) {
            header.addIntValue("NAXIS2", objectArray.length, "Number of rows");
        }
    }

    static void pointToCol(Header header, int n, int n2, int[] nArray, char c) throws FitsException {
        String string;
        char c2;
        switch (c) {
            case 'Z': {
                c2 = 'L';
                break;
            }
            case 'B': {
                c2 = 'B';
                break;
            }
            case 'I': {
                c2 = 'J';
                break;
            }
            case 'J': {
                c2 = 'K';
                break;
            }
            case 'S': {
                c2 = 'I';
                break;
            }
            case 'F': {
                c2 = 'E';
                break;
            }
            case 'D': {
                c2 = 'D';
                break;
            }
            default: {
                throw new FitsException("Invalid data type at column:" + n);
            }
        }
        StringBuffer stringBuffer = new StringBuffer("(");
        int n3 = 0;
        while (n3 < nArray.length) {
            int n4 = nArray[nArray.length - n3 - 1];
            if (n3 > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(n4);
            ++n3;
        }
        stringBuffer.append(")");
        if (n2 == 2 && c2 == 'J' && (string = header.getStringValue("TFORM" + (n + 1))) != null && (string.length() > 1 && string.charAt(0) == 'P' || string.length() > 2 && string.substring(0, 2).equals("1P"))) {
            return;
        }
        header.addStringValue("TFORM" + (n + 1), "" + n2 + c2, null);
        header.addStringValue("TDIM" + (n + 1), new String(stringBuffer), null);
    }

    public BinaryTableHeaderParser(Header header) throws FitsException {
        int n = header.getIntValue("NAXIS1", 0);
        this.checkLT0(n, "NAXIS1 < 0 for binary table");
        int n2 = header.getIntValue("NAXIS2", 0);
        this.checkLT0(n2, "NAXIS2 < 0 for binary table");
        int n3 = header.getIntValue("TFIELDS", 0);
        this.checkLT0(n3, "NFIELDS < 0 for binary table");
        this.myHeader = header;
    }
}

