/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import nom.tam.fits.BadHeaderException;
import nom.tam.fits.BinaryTable;
import nom.tam.fits.BinaryTableHeaderParser;
import nom.tam.fits.Column;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.TableHDU;
import nom.tam.util.ArrayFuncs;

public class BinaryTableHDU
extends TableHDU {
    public static boolean isHeader(Header header) {
        String string = header.getCard(0);
        return string != null && string.startsWith("XTENSION= 'BINTABLE'");
    }

    public boolean isHeader() {
        return BinaryTableHDU.isHeader(this.myHeader);
    }

    protected void setColumnStrings() {
        this.addColumnString("TTYPE");
        this.addColumnString("TFORM");
        this.addColumnString("TDIM");
        this.addColumnString("TSCAL");
        this.addColumnString("TZERO");
    }

    public void addColumn(Object[] objectArray) throws FitsException {
        BinaryTable binaryTable = (BinaryTable)this.myData;
        binaryTable.addColumn(objectArray);
        int n = binaryTable.getNcol();
        if (n > 1) {
            int n2 = -2;
            int n3 = 0;
            while (n3 < this.columnStrings.size()) {
                String string = (String)this.columnStrings.elementAt(n3) + (n - 1);
                this.myHeader.findKey(string);
                if (this.myHeader.getMark() > n2) {
                    n2 = this.myHeader.getMark();
                }
                ++n3;
            }
            this.myHeader.setMark(n2);
        } else {
            this.myHeader.findKey("TFIELDS");
            int n4 = this.myHeader.getMark();
            int n5 = 1;
            while (true) {
                String string;
                if ((string = this.myHeader.getCard(n4 + n5)) == null) {
                    this.myHeader.unsetMark();
                    break;
                }
                if (!string.substring(0, 8).equals("COMMENT ") && !string.substring(0, 8).equals("        ")) {
                    this.myHeader.setMark(n4 + n5);
                    break;
                }
                ++n5;
            }
        }
        BinaryTableHeaderParser.addColumn(n - 1, objectArray, this.myHeader);
    }

    public int findColumn(String string) {
        int n = 1;
        while (n <= this.myHeader.getIntValue("TFIELDS", 0)) {
            String string2 = this.myHeader.getStringValue("TTYPE" + n);
            if (string2 != null && string2.equals(string)) {
                return n - 1;
            }
            ++n;
        }
        return -1;
    }

    public Column getColumn(String string) throws FitsException {
        int n = this.findColumn(string);
        if (n < 0) {
            return null;
        }
        return this.getColumn(n);
    }

    public Column getColumn(int n) throws FitsException {
        Column column = new Column();
        Object[] objectArray = ((BinaryTable)this.myData).getColumn(n);
        column.setData(objectArray);
        int n2 = 0;
        while (n2 < this.columnStrings.size()) {
            String string = this.myHeader.findKey((String)this.columnStrings.elementAt(n2) + n);
            if (string != null) {
                column.addKey(string);
            }
            ++n2;
        }
        return column;
    }

    public void addColumn(Column column) throws FitsException {
        BinaryTable binaryTable = (BinaryTable)this.myData;
        this.addColumn(column.getData());
        int n = binaryTable.getNcol();
        String[] stringArray = column.getKeys(n);
        this.myHeader.deleteKey("TDIMS" + n);
        this.myHeader.getStringValue("TFORM" + n);
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].substring(0, 5).equals("TFORM")) {
                HeaderCard headerCard = new HeaderCard(stringArray[n2]);
                this.myHeader.addStringValue(headerCard.getKey(), headerCard.getValue(), headerCard.getComment());
            } else {
                this.myHeader.addLine(stringArray[n2]);
            }
            ++n2;
        }
    }

    public Column makeVarColumn(Object[] objectArray) throws FitsException {
        return this.makeVarColumn(objectArray, null, null);
    }

    public Column makeVarColumn(Object[] objectArray, String string) throws FitsException {
        return this.makeVarColumn(objectArray, string, null);
    }

    public Column makeVarColumn(Object[] objectArray, String string, String[] stringArray) throws FitsException {
        char c;
        Class clazz = ArrayFuncs.getBaseClass(objectArray);
        if (clazz == Byte.TYPE) {
            c = string != null && string.equals("S") ? (char)'S' : (string != null && string.equals("L") ? (char)'L' : 'B');
        } else if (clazz == Integer.TYPE) {
            c = 'J';
        } else if (clazz == Short.TYPE) {
            c = 'I';
        } else if (clazz == Float.TYPE) {
            c = string != null && string.equals("C") ? (char)'C' : 'E';
        } else if (clazz == Double.TYPE) {
            c = string != null && string.equals("M") ? (char)'M' : 'D';
        } else {
            throw new FitsException("Invalid Base class for variable column");
        }
        Column column = ((BinaryTable)this.myData).addVarData(objectArray);
        column.addKey(Header.formatFields("TFORM", "'1P" + c + "     '", "VariableLength Column"));
        this.myHeader.addIntValue("PCOUNT", ((BinaryTable)this.myData).getHeapSize(), "Size of Heap Area");
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                column.addKey(stringArray[n]);
                ++n;
            }
        }
        return column;
    }

    public Object getVarData(String string) throws FitsException {
        int n = this.findColumn(string);
        if (n < 0) {
            return null;
        }
        return this.getVarData(n);
    }

    public Object getVarData(int n) throws FitsException {
        Class<Number> clazz;
        char c;
        String string = this.myHeader.getStringValue("TFORM" + (n + 1));
        if (string == null) {
            throw new FitsException("TFORM not found for column(0 indexed):" + n);
        }
        if (string.substring(0, 2).equals("1P")) {
            c = string.charAt(2);
        } else if (string.charAt(0) == 'P') {
            c = string.charAt(1);
        } else {
            throw new FitsException("Requested column does not seem to be variable: TFORM=" + string);
        }
        boolean bl = false;
        switch (c) {
            case 'B': 
            case 'L': 
            case 'S': {
                clazz = Byte.TYPE;
                break;
            }
            case 'I': {
                clazz = Short.TYPE;
                break;
            }
            case 'J': {
                clazz = Integer.TYPE;
                break;
            }
            case 'K': {
                clazz = Long.TYPE;
                break;
            }
            case 'E': {
                clazz = Float.TYPE;
                break;
            }
            case 'D': {
                clazz = Double.TYPE;
                break;
            }
            case 'C': {
                bl = true;
                clazz = Float.TYPE;
                break;
            }
            case 'M': {
                bl = true;
                clazz = Double.TYPE;
                break;
            }
            default: {
                throw new FitsException("Unable to understand variable column format:" + string);
            }
        }
        return ((BinaryTable)this.myData).getVarData(n, clazz, bl);
    }

    public Data manufactureData() throws FitsException {
        this.setColumnStrings();
        return new BinaryTable(this.myHeader);
    }

    public int getNumColumns() {
        return this.myHeader.getIntValue("TFIELDS", 0);
    }

    public int getNumRows() {
        return this.myHeader.getIntValue("NAXIS2", 0);
    }

    public String getColumnName(int n) throws FitsException {
        int n2 = this.myHeader.getIntValue("TFIELDS", 0);
        if (n < 0 || n >= n2) {
            throw new FitsException("Bad column index " + n + " (only " + n2 + " columns)");
        }
        return this.getTrimmedString("TTYPE" + (n + 1));
    }

    public String getColumnFITSType(int n) throws FitsException {
        int n2 = this.myHeader.getIntValue("TFIELDS", 0);
        if (n < 0 || n >= n2) {
            throw new FitsException("Bad column index " + n + " (only " + n2 + " columns)");
        }
        return this.getTrimmedString("TFORM" + (n + 1));
    }

    public void info() {
        BinaryTable binaryTable = (BinaryTable)this.myData;
        System.out.println("  Binary Table");
        System.out.println("      Header Information:");
        int n = this.myHeader.getIntValue("TFIELDS", -1);
        int n2 = this.myHeader.getIntValue("NAXIS2", -1);
        int n3 = this.myHeader.getIntValue("NAXIS1", -1);
        System.out.print("          " + n + " fields");
        System.out.println(", " + n2 + " rows of length " + n3);
        int n4 = 1;
        while (n4 <= n) {
            System.out.print("           " + n4 + ":");
            this.checkField("TTYPE" + n4);
            this.checkField("TFORM" + n4);
            this.checkField("TDIM" + n4);
            System.out.println(" ");
            ++n4;
        }
        System.out.println("      Data Information:");
        if (binaryTable == null || binaryTable.getNrow() == 0 || binaryTable.getNcol() == 0) {
            System.out.println("         No data present");
            if (binaryTable.getHeapSize() > 0) {
                System.out.println("         Heap size is: " + binaryTable.getHeapSize() + " bytes");
            }
        } else {
            System.out.println("         Number of rows=" + binaryTable.getNrow());
            System.out.println("         Number of columns=" + binaryTable.getNcol());
            if (binaryTable.getHeapSize() > 0) {
                System.out.println("         Heap size is: " + binaryTable.getHeapSize() + " bytes");
            }
            int[][] nArray = binaryTable.getDimens();
            char[] cArray = binaryTable.getTypes();
            int n5 = 0;
            while (n5 < binaryTable.getNcol()) {
                System.out.print("         " + (n5 + 1) + ":" + cArray[n5] + " [");
                int n6 = 32;
                int n7 = 0;
                while (n7 < nArray[n5].length) {
                    System.out.print("" + (char)n6 + nArray[n5][n7]);
                    n6 = 44;
                    ++n7;
                }
                System.out.println(" ]");
                ++n5;
            }
        }
    }

    public BinaryTableHDU(Header header) throws FitsException {
        super(header);
        if (!this.isHeader()) {
            throw new BadHeaderException("Not a valid binary table header");
        }
    }

    public BinaryTableHDU(Object[][] objectArray) throws FitsException {
        super(null);
        this.myData = objectArray == null ? new BinaryTable() : new BinaryTable(objectArray);
        this.myHeader = BinaryTableHeaderParser.pointToTable((BinaryTable)this.myData);
        this.setColumnStrings();
    }

    public BinaryTableHDU() throws FitsException {
        this((Object[][])null);
    }
}

