/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Vector;
import nom.tam.fits.BinaryTableHeaderParser;
import nom.tam.fits.Column;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.BufferedDataInputStream;
import nom.tam.util.BufferedDataOutputStream;
import nom.tam.util.ColumnTable;
import nom.tam.util.TableException;

public class BinaryTable
extends Data {
    byte[] hashArea = new byte[0];
    int hashPtr = 0;
    Vector columns;
    int[] sizes;
    int[][] dimens;
    Object[] modelRow;
    ColumnTable table;

    protected int useModelRow(Object[] objectArray, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < objectArray.length) {
            Class clazz = ArrayFuncs.getBaseClass(objectArray[n3]);
            this.dimens[n3] = ArrayFuncs.getDimensions(objectArray[n3]);
            int n4 = 1;
            int n5 = 0;
            while (n5 < this.dimens[n3].length) {
                n4 *= this.dimens[n3][n5];
                ++n5;
            }
            this.sizes[n3] = n4;
            Object object = Array.newInstance(clazz, n4 * n);
            this.columns.addElement(object);
            n2 += n4 * n * ArrayFuncs.getBaseLength(objectArray[n3]);
            ++n3;
        }
        return n2;
    }

    private void rowToColumn(Object[][] objectArray) {
        int n = 0;
        while (n < this.modelRow.length) {
            Object e = this.columns.elementAt(n);
            int n2 = 0;
            while (n2 < objectArray.length) {
                System.arraycopy(ArrayFuncs.flatten(objectArray[n2][n]), 0, e, n2 * this.sizes[n], this.sizes[n]);
                ++n2;
            }
            ++n;
        }
    }

    public Object[] getRow(int n) throws FitsException {
        if (!this.validRow(n)) {
            throw new FitsException("Invalid row");
        }
        Object[] objectArray = new Object[this.modelRow.length];
        int n2 = 0;
        while (n2 < this.modelRow.length) {
            objectArray[n2] = ArrayFuncs.curl(this.table.getElement(n, n2), this.dimens[n2]);
            ++n2;
        }
        return objectArray;
    }

    public void setRow(int n, Object[] objectArray) throws FitsException {
        if (objectArray.length != this.getNcol()) {
            throw new FitsException("Updated row size does not agree with table");
        }
        Object[] objectArray2 = new Object[objectArray.length];
        int n2 = 0;
        while (n2 < objectArray.length) {
            objectArray2[n2] = ArrayFuncs.flatten(objectArray[n2]);
            ++n2;
        }
        try {
            this.table.setRow(n, objectArray2);
        }
        catch (TableException tableException) {
            throw new FitsException("Error modifying table: " + tableException);
        }
    }

    public void setColumn(int n, Object[] objectArray) throws FitsException {
        int n2 = objectArray.length;
        if (n2 != this.getNrow()) {
            throw new FitsException("Replacement column had wrong number of rows");
        }
        int[] nArray = ArrayFuncs.getDimensions(objectArray[0]);
        int n3 = 1;
        int n4 = 0;
        while (n4 < nArray.length) {
            n3 *= nArray[n4];
            ++n4;
        }
        if (n3 != this.sizes[n]) {
            throw new FitsException("Replacement column has size mismatch");
        }
        Object e = this.columns.elementAt(n);
        if (ArrayFuncs.getBaseClass(objectArray) != ArrayFuncs.getBaseClass(e)) {
            throw new FitsException("Replactment column has type mismatch");
        }
        int n5 = 0;
        while (n5 < n2) {
            System.arraycopy(ArrayFuncs.flatten(objectArray[n5]), 0, e, n5 * n3, n3);
            ++n5;
        }
    }

    public void setFlattenedColumn(int n, Object object) throws FitsException {
        Object e = this.columns.elementAt(n);
        if (e.getClass() != object.getClass() || Array.getLength(e) != Array.getLength(object)) {
            throw new FitsException("Replacement column mismatch");
        }
        System.arraycopy(object, 0, e, 0, this.sizes[n]);
    }

    public Object[] getColumn(int n) throws FitsException {
        if (!this.validColumn(n)) {
            throw new FitsException("Invalid column");
        }
        int[] nArray = new int[this.dimens[n].length + 1];
        System.arraycopy(this.dimens[n], 0, nArray, 0, this.dimens[n].length);
        nArray[this.dimens[n].length] = this.getNrow();
        return (Object[])ArrayFuncs.curl(this.columns.elementAt(n), nArray);
    }

    public Object getFlattenedColumn(int n) throws FitsException {
        if (!this.validColumn(n)) {
            throw new FitsException("Invalid column");
        }
        return this.columns.elementAt(n);
    }

    public Object getElement(int n, int n2) throws FitsException {
        if (!this.validRow(n) || !this.validColumn(n2)) {
            throw new FitsException("No such element");
        }
        return this.table.getElement(n, n2);
    }

    public void addRow(Object[] objectArray) throws FitsException {
        Vector vector = new Vector(this.columns.size());
        int n = 0;
        while (n < this.columns.size()) {
            Object e = this.columns.elementAt(n);
            int n2 = Array.getLength(e);
            Class clazz = ArrayFuncs.getBaseClass(e);
            Object object = Array.newInstance(clazz, n2 + this.sizes[n]);
            System.arraycopy(e, 0, object, 0, n2);
            System.arraycopy(ArrayFuncs.flatten(objectArray[n]), 0, object, n2, this.sizes[n]);
            ++n;
        }
        this.columns = vector;
        Object[] objectArray2 = new Object[this.columns.size()];
        this.columns.copyInto(objectArray2);
        try {
            this.table = new ColumnTable(objectArray2, this.sizes);
        }
        catch (TableException tableException) {
            throw new FitsException("Unable to modify table:" + tableException);
        }
    }

    public void addColumn(Object[] objectArray) throws FitsException {
        int[] nArray = ArrayFuncs.getDimensions(objectArray[0]);
        this.addFlattenedColumn(ArrayFuncs.flatten(objectArray), nArray);
    }

    public void addFlattenedColumn(Object object, int[] nArray) throws FitsException {
        int[] nArray2 = new int[this.sizes.length + 1];
        int[][] nArray3 = new int[this.dimens.length + 1][];
        Object[] objectArray = new Object[this.modelRow.length + 1];
        int n = 1;
        int n2 = 0;
        while (n2 < nArray.length) {
            n *= nArray[n2];
            ++n2;
        }
        n2 = 0;
        while (n2 < this.sizes.length) {
            nArray2[n2] = this.sizes[n2];
            nArray3[n2] = this.dimens[n2];
            objectArray[n2] = this.modelRow[n2];
            ++n2;
        }
        this.sizes = nArray2;
        this.dimens = nArray3;
        this.modelRow = objectArray;
        this.sizes[this.sizes.length - 1] = n;
        this.dimens[this.sizes.length - 1] = nArray;
        this.modelRow[this.sizes.length - 1] = Array.newInstance(ArrayFuncs.getBaseClass(object), nArray);
        this.columns.addElement(object);
        Object[] objectArray2 = new Object[this.columns.size()];
        this.columns.copyInto(objectArray2);
        try {
            this.table = new ColumnTable(objectArray2, this.sizes);
        }
        catch (TableException tableException) {
            throw new FitsException("Unable to modify table:" + tableException);
        }
        this.dataArray = this.table;
    }

    public int getNrow() {
        return this.table.getNrow();
    }

    public int getNcol() {
        return this.table.getNcol();
    }

    protected boolean validRow(int n) {
        return this.getNrow() > 0 && n >= 0 && n < this.getNrow();
    }

    protected boolean validColumn(int n) {
        return n >= 0 && n < this.getNcol();
    }

    public void setElement(int n, int n2, Object object) throws FitsException {
        try {
            this.table.setElement(n, n2, ArrayFuncs.flatten(object));
        }
        catch (TableException tableException) {
            throw new FitsException("Error modifying table:" + tableException);
        }
    }

    protected void expandHashArea(int n) {
        if (this.hashPtr + n > this.hashArea.length) {
            int n2 = (int)((double)(this.hashPtr + n) * 1.5);
            if (n2 < 16384) {
                n2 = 16384;
            }
            byte[] byArray = new byte[n2];
            System.arraycopy(this.hashArea, 0, byArray, 0, this.hashPtr);
            this.hashArea = byArray;
        }
    }

    protected void writeTrueData(BufferedDataOutputStream bufferedDataOutputStream) throws FitsException {
        try {
            this.table.write(bufferedDataOutputStream);
            bufferedDataOutputStream.write(this.hashArea, 0, this.hashPtr);
        }
        catch (IOException iOException) {
            throw new FitsException("Error writing binary table data:" + iOException);
        }
    }

    public void read(BufferedDataInputStream bufferedDataInputStream) throws FitsException {
        this.readTrueData(bufferedDataInputStream);
    }

    protected void readTrueData(BufferedDataInputStream bufferedDataInputStream) throws FitsException {
        try {
            int n = this.table.read(bufferedDataInputStream);
            if (this.hashArea.length > 0) {
                bufferedDataInputStream.readPrimitiveArray(this.hashArea);
            }
            if ((n += this.hashArea.length) % 2880 != 0) {
                byte[] byArray = new byte[2880 - n % 2880];
                bufferedDataInputStream.readPrimitiveArray(byArray);
            }
        }
        catch (IOException iOException) {
            throw new FitsException("Error reading binary table data:" + iOException);
        }
    }

    public int getTrueSize() {
        return super.getTrueSize() + this.hashPtr;
    }

    public Column addVarData(Object[] objectArray) throws FitsException {
        int n = ArrayFuncs.computeSize(objectArray);
        int n2 = ArrayFuncs.getBaseLength(objectArray);
        if (objectArray instanceof Object[][]) {
            n2 *= 2;
        }
        int n3 = this.hashPtr;
        this.expandHashArea(n);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        try {
            BufferedDataOutputStream bufferedDataOutputStream = new BufferedDataOutputStream(byteArrayOutputStream);
            bufferedDataOutputStream.writePrimitiveArray(objectArray);
            bufferedDataOutputStream.flush();
            bufferedDataOutputStream.close();
        }
        catch (IOException iOException) {
            throw new FitsException("Unable to write variable column length data");
        }
        System.arraycopy(byteArrayOutputStream.toByteArray(), 0, this.hashArea, this.hashPtr, n);
        this.hashPtr += n;
        int n4 = objectArray.length;
        int[][] nArray = new int[n4][2];
        int n5 = 0;
        int n6 = 0;
        while (n6 < n4) {
            int n7;
            nArray[n6][0] = n7 = Array.getLength(objectArray[n6]);
            nArray[n6][1] = n3;
            n3 += n7 * n2;
            if (n7 > n5) {
                n5 = n7;
            }
            ++n6;
        }
        Column column = new Column();
        column.setData((Object[])nArray);
        return column;
    }

    public Object getVarData(int n, Class clazz, boolean bl) throws FitsException {
        int[] nArray;
        if (n < 0 || n >= this.getNcol()) {
            throw new FitsException("Invalid column specified for variable length extraction");
        }
        if (bl) {
            nArray = new int[3];
            nArray[2] = 0;
        } else {
            nArray = new int[]{this.getNrow(), 0};
        }
        Object[] objectArray = (Object[])Array.newInstance(clazz, nArray);
        int n2 = ArrayFuncs.getBaseLength(objectArray);
        if (bl) {
            n2 *= 2;
        }
        int n3 = 0;
        BufferedDataInputStream bufferedDataInputStream = new BufferedDataInputStream(new ByteArrayInputStream(this.hashArea));
        int[] nArray2 = (int[])this.table.getColumn(n);
        int n4 = 0;
        while (n4 < this.getNrow()) {
            if (nArray2[2 * n4 + 1] < n3) {
                bufferedDataInputStream = new BufferedDataInputStream(new ByteArrayInputStream(this.hashArea));
                n3 = 0;
            }
            try {
                bufferedDataInputStream.skipBytes(nArray2[2 * n4 + 1] - n3);
                int[] nArray3 = bl ? new int[]{nArray2[2 * n4], 2} : new int[]{nArray2[2 * n4]};
                objectArray[n4] = Array.newInstance(clazz, nArray3);
                bufferedDataInputStream.readPrimitiveArray(objectArray[n4]);
                n3 += n2 * nArray2[2 * n4];
            }
            catch (IOException iOException) {
                throw new FitsException("Error decoding hash area at offset=" + n3 + ".  Exception: Exception " + iOException);
            }
            ++n4;
        }
        return objectArray;
    }

    public void write(BufferedDataOutputStream bufferedDataOutputStream) throws FitsException {
        try {
            int n = this.table.write(bufferedDataOutputStream);
            if (this.hashPtr > 0) {
                bufferedDataOutputStream.write(this.hashArea);
            }
            if ((n += this.hashPtr) % 2880 != 0) {
                byte[] byArray = new byte[2880 - n % 2880];
                int n2 = 0;
                while (n2 < byArray.length) {
                    byArray[n2] = 0;
                    ++n2;
                }
                bufferedDataOutputStream.write(byArray);
            }
        }
        catch (IOException iOException) {
            throw new FitsException("Unable to write table:" + iOException);
        }
    }

    public int getHeapSize() {
        return this.hashPtr;
    }

    public int[][] getDimens() {
        return this.dimens;
    }

    public Class[] getBases() {
        return this.table.getBases();
    }

    public char[] getTypes() {
        return this.table.getTypes();
    }

    public int[] getSizes() {
        return this.sizes;
    }

    public BinaryTable() throws FitsException {
        this.columns = new Vector();
        try {
            this.table = new ColumnTable(new Object[0], new int[0]);
        }
        catch (TableException tableException) {
            throw new FitsException("Unable to create table:" + tableException);
        }
        this.dataArray = this.table;
        this.dimens = new int[0][];
        this.sizes = new int[0];
        this.modelRow = new Object[0];
    }

    public BinaryTable(Header header) throws FitsException {
        BinaryTableHeaderParser binaryTableHeaderParser = new BinaryTableHeaderParser(header);
        this.modelRow = binaryTableHeaderParser.getModelRow();
        int n = header.getIntValue("NAXIS2");
        int n2 = header.getIntValue("TFIELDS");
        this.columns = new Vector(n2);
        this.sizes = new int[n2];
        this.dimens = new int[n2][];
        this.modelRow = binaryTableHeaderParser.getModelRow();
        int n3 = this.useModelRow(this.modelRow, n);
        Object[] objectArray = new Object[n2];
        this.columns.copyInto(objectArray);
        try {
            this.table = new ColumnTable(objectArray, this.sizes);
        }
        catch (TableException tableException) {
            throw new FitsException("Unable to create table:" + tableException);
        }
        int n4 = header.trueDataSize();
        if (n3 < n4) {
            this.hashArea = new byte[n4 - n3];
            this.hashPtr = this.hashArea.length;
        } else if (n3 > n4) {
            throw new FitsException("Size inconsistency in header and data: Check NAXIS1 and PCOUNT");
        }
    }

    public BinaryTable(Object[][] objectArray) throws FitsException {
        this.modelRow = objectArray[0];
        this.dimens = new int[this.modelRow.length][];
        this.sizes = new int[this.modelRow.length];
        this.columns = new Vector(this.modelRow.length);
        this.useModelRow(this.modelRow, objectArray.length);
        this.hashPtr = 0;
        this.rowToColumn(objectArray);
        Object[] objectArray2 = new Object[this.columns.size()];
        this.columns.copyInto(objectArray2);
        try {
            this.table = new ColumnTable(objectArray2, this.sizes);
        }
        catch (TableException tableException) {
            throw new FitsException("Error creating ColumnTable");
        }
    }
}

