/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.IOException;
import java.util.Date;
import nom.tam.fits.Data;
import nom.tam.fits.FitsDate;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.util.BufferedDataInputStream;
import nom.tam.util.BufferedDataOutputStream;

public abstract class BasicHDU {
    public static final int BITPIX_BYTE = 8;
    public static final int BITPIX_SHORT = 16;
    public static final int BITPIX_INT = 32;
    public static final int BITPIX_LONG = 64;
    public static final int BITPIX_FLOAT = -32;
    public static final int BITPIX_DOUBLE = -64;
    Header myHeader = null;
    Data myData = null;

    abstract Data manufactureData() throws FitsException;

    public static void skipData(BufferedDataInputStream bufferedDataInputStream, Header header) throws IOException {
        bufferedDataInputStream.skipBytes(header.paddedDataSize());
    }

    public void skipData(BufferedDataInputStream bufferedDataInputStream) throws IOException {
        BasicHDU.skipData(bufferedDataInputStream, this.myHeader);
    }

    public void readData(BufferedDataInputStream bufferedDataInputStream) throws FitsException {
        this.myData = null;
        try {
            this.myData = this.manufactureData();
        }
        finally {
            Object var3_2 = null;
            if (this.myData == null) {
                try {
                    BasicHDU.skipData(bufferedDataInputStream, this.myHeader);
                }
                catch (Exception exception) {}
            }
        }
        this.myData.read(bufferedDataInputStream);
    }

    public Header getHeader() {
        return this.myHeader;
    }

    public Data getData() {
        return this.myData;
    }

    public int getSize() {
        int n = 0;
        if (this.myHeader != null) {
            n += this.myHeader.headerSize();
        }
        if (this.myData != null) {
            n += this.myData.getPaddedSize();
        }
        return n;
    }

    public static boolean isHeader(Header header) {
        return false;
    }

    public abstract void info();

    boolean checkField(String string) {
        String string2 = this.myHeader.getStringValue(string);
        if (string2 == null) {
            return false;
        }
        System.out.print(" " + string + "=" + string2 + ";");
        return true;
    }

    public void write(BufferedDataOutputStream bufferedDataOutputStream) throws FitsException {
        if (this.myHeader != null) {
            this.myHeader.write(bufferedDataOutputStream);
        }
        if (this.myData != null) {
            this.myData.write(bufferedDataOutputStream);
        }
        try {
            bufferedDataOutputStream.flush();
        }
        catch (IOException iOException) {
            throw new FitsException("Error flushing at end of HDU: " + iOException.getMessage());
        }
    }

    public String getTrimmedString(String string) {
        String string2 = this.myHeader.getStringValue(string);
        if (string2 != null) {
            string2 = string2.trim();
        }
        return string2;
    }

    public int getBitPix() throws FitsException {
        int n = this.myHeader.getIntValue("BITPIX", -1);
        switch (n) {
            case -64: 
            case -32: 
            case 8: 
            case 16: 
            case 32: {
                break;
            }
            default: {
                throw new FitsException("Unknown BITPIX type " + n);
            }
        }
        return n;
    }

    public int[] getAxes() throws FitsException {
        int n = this.myHeader.getIntValue("NAXIS", 0);
        if (n < 0) {
            throw new FitsException("Negative NAXIS value " + n);
        }
        if (n > 999) {
            throw new FitsException("NAXIS value " + n + " too large");
        }
        if (n == 0) {
            return null;
        }
        int[] nArray = new int[n];
        int n2 = 1;
        while (n2 <= n) {
            nArray[n - n2] = this.myHeader.getIntValue("NAXIS" + n2, 0);
            ++n2;
        }
        return nArray;
    }

    public int getParameterCount() {
        return this.myHeader.getIntValue("PCOUNT", 0);
    }

    public int getGroupCount() {
        return this.myHeader.getIntValue("GCOUNT", 1);
    }

    public double getBScale() {
        return this.myHeader.getDoubleValue("BSCALE", 1.0);
    }

    public double getBZero() {
        return this.myHeader.getDoubleValue("BZERO", 0.0);
    }

    public String getBUnit() {
        return this.getTrimmedString("BUNIT");
    }

    public int getBlankValue() throws FitsException {
        if (!this.myHeader.containsKey("BLANK")) {
            throw new FitsException("BLANK undefined");
        }
        return this.myHeader.getIntValue("BLANK");
    }

    public Date getCreationDate() {
        try {
            return new FitsDate(this.myHeader.getStringValue("DATE")).toDate();
        }
        catch (FitsException fitsException) {
            return null;
        }
    }

    public Date getObservationDate() {
        try {
            return new FitsDate(this.myHeader.getStringValue("DATE-OBS")).toDate();
        }
        catch (FitsException fitsException) {
            return null;
        }
    }

    public String getOrigin() {
        return this.getTrimmedString("ORIGIN");
    }

    public String getTelescope() {
        return this.getTrimmedString("TELESCOP");
    }

    public String getInstrument() {
        return this.getTrimmedString("INSTRUME");
    }

    public String getObserver() {
        return this.getTrimmedString("OBSERVER");
    }

    public String getObject() {
        return this.getTrimmedString("OBJECT");
    }

    public double getEquinox() {
        return this.myHeader.getDoubleValue("EQUINOX", -1.0);
    }

    public double getEpoch() {
        return this.myHeader.getDoubleValue("EPOCH", -1.0);
    }

    public String getAuthor() {
        return this.getTrimmedString("AUTHOR");
    }

    public String getReference() {
        return this.getTrimmedString("REFERENC");
    }

    public double getMaximumValue() {
        return this.myHeader.getDoubleValue("DATAMAX");
    }

    public double getMinimumValue() {
        return this.myHeader.getDoubleValue("DATAMIN");
    }

    public BasicHDU(Header header) {
        this.myHeader = header;
        if (this.myHeader != null) {
            this.myHeader.unsetMark();
        }
    }
}

