/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.hdf5lib.exceptions;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;

public class HDF5LibraryException
extends HDF5Exception {
    public native int getMajorErrorNumber();

    public native int getMinorErrorNumber();

    public String getMinorError(int n) {
        switch (n) {
            case 0: {
                return "no error";
            }
            case 1: {
                return "information is unitialized";
            }
            case 2: {
                return "feature is unsupported";
            }
            case 3: {
                return "incorrect type found";
            }
            case 4: {
                return "argument out of range";
            }
            case 5: {
                return "bad value for argument";
            }
            case 6: {
                return "no space available for allocation";
            }
            case 7: {
                return "unable to copy object";
            }
            case 9: {
                return "file already exists";
            }
            case 10: {
                return "file already open";
            }
            case 11: {
                return "Can't create file";
            }
            case 12: {
                return "Can't open file";
            }
            case 13: {
                return "not an HDF5 format file";
            }
            case 14: {
                return "bad file ID accessed";
            }
            case 15: {
                return "file has been truncated";
            }
            case 16: {
                return "file mount error";
            }
            case 17: {
                return "seek failed";
            }
            case 18: {
                return "read failed";
            }
            case 19: {
                return "write failed";
            }
            case 20: {
                return "close failed";
            }
            case 21: {
                return "address overflowed";
            }
            case 22: {
                return "Can't initialize";
            }
            case 23: {
                return "object already initialized";
            }
            case 24: {
                return "Can't find atom information";
            }
            case 25: {
                return "Can't register new atom";
            }
            case 26: {
                return "Can't flush object from cache";
            }
            case 27: {
                return "Can't load object into cache";
            }
            case 28: {
                return "protected object error";
            }
            case 29: {
                return "object not currently cached";
            }
            case 30: {
                return "object not found";
            }
            case 31: {
                return "object already exists";
            }
            case 32: {
                return "Can't encode value";
            }
            case 33: {
                return "Can't decode value";
            }
            case 34: {
                return "Can't split node";
            }
            case 35: {
                return "Can't insert object";
            }
            case 36: {
                return "Can't list node";
            }
            case 37: {
                return "bad object header link count";
            }
            case 38: {
                return "wrong version number";
            }
            case 39: {
                return "alignment error";
            }
            case 40: {
                return "unrecognized message";
            }
            case 41: {
                return "Can't delete message";
            }
            case 42: {
                return "Can't open object";
            }
            case 43: {
                return "name component is too long";
            }
            case 44: {
                return "problem with current working group";
            }
            case 45: {
                return "link count failure";
            }
            case 46: {
                return "symbolic link error";
            }
            case 47: {
                return "some MPI function failed";
            }
        }
        return "undefined error";
    }

    public void printStackTrace() {
        System.err.println(this);
        this.printStackTrace0(null);
        super.printStackTrace();
    }

    public void printStackTrace(File file) {
        if (file == null || !file.exists() || file.isDirectory() || !file.canWrite()) {
            this.printStackTrace();
        } else {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                PrintWriter printWriter = new PrintWriter(fileOutputStream);
                printWriter.println(this);
                printWriter.close();
            }
            catch (Exception exception) {
                System.err.println(this);
            }
            this.printStackTrace0(file.getPath());
            super.printStackTrace();
        }
    }

    private native void printStackTrace0(String var1);

    public HDF5LibraryException() {
        try {
            H5.H5open();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.detailMessage = this.getMinorError(this.getMinorErrorNumber());
    }

    public HDF5LibraryException(String string) {
        super(string);
        try {
            H5.H5open();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

