/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.hdf5lib;

import java.io.File;
import ncsa.hdf.hdf5lib.HDF5GroupInfo;
import ncsa.hdf.hdf5lib.HDFArray;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.hdf5lib.exceptions.HDF5LibraryException;

public class H5 {
    public static final String H5PATH_PROPERTY_KEY = "ncsa.hdf.hdf5lib.H5.hdf5lib";

    public static native int J2C(int var0);

    private static native int H5error_off();

    public static native int H5open() throws HDF5LibraryException;

    public static native int H5close() throws HDF5LibraryException;

    private static native int H5dont_atexit() throws HDF5LibraryException;

    public static native int H5get_libversion(int[] var0) throws HDF5LibraryException;

    public static native int H5check_version(int var0, int var1, int var2);

    public static native int H5Eclear() throws HDF5LibraryException;

    public static native int H5Acreate(int var0, String var1, int var2, int var3, int var4) throws HDF5LibraryException, NullPointerException;

    public static native int H5Aopen_name(int var0, String var1) throws HDF5LibraryException, NullPointerException;

    public static native int H5Aopen_idx(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Awrite(int var0, int var1, byte[] var2) throws HDF5LibraryException, NullPointerException;

    public static int H5Awrite(int n, int n2, Object object) throws HDF5Exception, NullPointerException {
        HDFArray hDFArray = new HDFArray(object);
        byte[] byArray = hDFArray.byteify();
        int n3 = H5.H5Awrite(n, n2, byArray);
        byArray = null;
        hDFArray = null;
        return n3;
    }

    public static native int H5Aread(int var0, int var1, byte[] var2) throws HDF5LibraryException, NullPointerException;

    public static int H5Aread(int n, int n2, Object object) throws HDF5Exception, NullPointerException {
        HDFArray hDFArray = new HDFArray(object);
        byte[] byArray = hDFArray.emptyBytes();
        int n3 = H5.H5Aread(n, n2, byArray);
        if (n3 >= 0) {
            object = hDFArray.arrayify(byArray);
        }
        return n3;
    }

    public static native int H5Aget_space(int var0) throws HDF5LibraryException;

    public static native int H5Aget_type(int var0) throws HDF5LibraryException;

    public static native long H5Aget_name(int var0, long var1, String[] var3) throws ArrayIndexOutOfBoundsException, ArrayStoreException, HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static native int H5Aget_num_attrs(int var0) throws HDF5LibraryException;

    public static native int H5Adelete(int var0, String var1) throws HDF5LibraryException, NullPointerException;

    public static native int H5Aclose(int var0) throws HDF5LibraryException;

    public static native int H5Dcreate(int var0, String var1, int var2, int var3, int var4) throws HDF5LibraryException, NullPointerException;

    public static native int H5Dopen(int var0, String var1) throws HDF5LibraryException, NullPointerException;

    public static native int H5Dget_space(int var0) throws HDF5LibraryException;

    public static native int H5Dget_type(int var0) throws HDF5LibraryException;

    public static native int H5Dget_create_plist(int var0) throws HDF5LibraryException;

    public static native int H5Dread(int var0, int var1, int var2, int var3, int var4, byte[] var5) throws HDF5LibraryException, NullPointerException;

    public static int H5Dread(int n, int n2, int n3, int n4, int n5, Object object) throws HDF5Exception, HDF5LibraryException, NullPointerException {
        HDFArray hDFArray = new HDFArray(object);
        byte[] byArray = hDFArray.emptyBytes();
        int n6 = H5.H5Dread(n, n2, n3, n4, n5, byArray);
        if (n6 >= 0) {
            object = hDFArray.arrayify(byArray);
        }
        byArray = null;
        hDFArray = null;
        return n6;
    }

    public static native int H5Dwrite(int var0, int var1, int var2, int var3, int var4, byte[] var5) throws HDF5LibraryException, NullPointerException;

    public static int H5Dwrite(int n, int n2, int n3, int n4, int n5, Object object) throws HDF5Exception, HDF5LibraryException, NullPointerException {
        HDFArray hDFArray = new HDFArray(object);
        byte[] byArray = hDFArray.byteify();
        int n6 = H5.H5Dwrite(n, n2, n3, n4, n5, byArray);
        byArray = null;
        hDFArray = null;
        return n6;
    }

    public static native int H5Dextend(int var0, long[] var1) throws HDF5LibraryException, NullPointerException;

    public static native int H5Dclose(int var0) throws HDF5LibraryException;

    public static native long H5Dget_storage_size(int var0) throws HDF5LibraryException;

    public static native int H5Fopen(String var0, int var1, int var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Fcreate(String var0, int var1, int var2, int var3) throws HDF5LibraryException, NullPointerException;

    public static native int H5Fflush(int var0, int var1) throws HDF5LibraryException;

    public static native boolean H5Fis_hdf5(String var0) throws HDF5LibraryException, NullPointerException;

    public static native int H5Fget_create_plist(int var0) throws HDF5LibraryException;

    public static native int H5Fget_access_plist(int var0) throws HDF5LibraryException;

    public static native int H5Fclose(int var0) throws HDF5LibraryException;

    public static native int H5Fmount(int var0, String var1, int var2, int var3) throws HDF5LibraryException, NullPointerException;

    public static native int H5Funmount(int var0, String var1) throws HDF5LibraryException, NullPointerException;

    public static native int H5Freopen(int var0) throws HDF5LibraryException;

    public static native int H5Gcreate(int var0, String var1, int var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Gopen(int var0, String var1) throws HDF5LibraryException, NullPointerException;

    public static native int H5Gclose(int var0) throws HDF5LibraryException;

    public static native int H5Glink(int var0, int var1, String var2, String var3) throws HDF5LibraryException, NullPointerException;

    public static native int H5Gunlink(int var0, String var1) throws HDF5LibraryException, NullPointerException;

    public static native int H5Gn_members(int var0, String var1) throws HDF5LibraryException, NullPointerException;

    public static native int H5Gget_obj_info_idx(int var0, String var1, int var2, String[] var3, int[] var4) throws HDF5LibraryException, NullPointerException;

    public static native int H5Gmove(int var0, String var1, String var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Gget_objinfo(int var0, String var1, boolean var2, long[] var3, long[] var4, int[] var5, long[] var6) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static int H5Gget_objinfo(int n, String string, boolean bl, HDF5GroupInfo hDF5GroupInfo) throws HDF5LibraryException, NullPointerException {
        int n2 = -1;
        long[] lArray = new long[2];
        long[] lArray2 = new long[2];
        int[] nArray = new int[3];
        long[] lArray3 = new long[1];
        n2 = H5.H5Gget_objinfo(n, string, bl, lArray, lArray2, nArray, lArray3);
        if (n2 >= 0) {
            hDF5GroupInfo.setGroupInfo(lArray, lArray2, nArray[0], nArray[1], lArray3[0], nArray[2]);
        }
        return n2;
    }

    public static native int H5Gget_linkval(int var0, String var1, int var2, String[] var3) throws ArrayIndexOutOfBoundsException, ArrayStoreException, HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static native int H5Gset_comment(int var0, String var1, String var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Gget_comment(int var0, String var1, int var2, String[] var3) throws ArrayIndexOutOfBoundsException, ArrayStoreException, HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static native int H5Iget_type(int var0) throws HDF5LibraryException;

    public static native int H5Pcreate(int var0) throws HDF5LibraryException;

    public static native int H5Pclose(int var0) throws HDF5LibraryException;

    public static native int H5Pget_class(int var0) throws HDF5LibraryException;

    public static native int H5Pcopy(int var0) throws HDF5LibraryException;

    public static native int H5Pget_version(int var0, int[] var1) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static native int H5Pset_userblock(int var0, long var1) throws HDF5LibraryException;

    public static native int H5Pget_userblock(int var0, long[] var1) throws HDF5LibraryException, NullPointerException;

    public static native int H5Pset_sizes(int var0, int var1, int var2) throws HDF5LibraryException;

    public static native int H5Pget_sizes(int var0, int[] var1) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static native int H5Pset_sym_k(int var0, int var1, int var2) throws HDF5LibraryException;

    public static native int H5Pget_sym_k(int var0, int[] var1) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static native int H5Pset_istore_k(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Pget_istore_k(int var0, int[] var1) throws HDF5LibraryException, NullPointerException;

    public static native int H5Pset_layout(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Pget_layout(int var0) throws HDF5LibraryException;

    public static native int H5Pset_chunk(int var0, int var1, long[] var2) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static native int H5Pget_chunk(int var0, int var1, long[] var2) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static native int H5Pset_alignment(int var0, long var1, long var3) throws HDF5LibraryException;

    public static native int H5Pget_alignment(int var0, long[] var1) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static native int H5Pset_external(int var0, String var1, long var2, long var4) throws HDF5LibraryException, NullPointerException;

    public static native int H5Pget_external_count(int var0) throws HDF5LibraryException;

    public static native int H5Pget_external(int var0, int var1, int var2, String[] var3, long[] var4) throws ArrayIndexOutOfBoundsException, ArrayStoreException, HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static native int H5Pset_fill_value(int var0, int var1, byte[] var2) throws HDF5Exception;

    public static int H5Pset_fill_value(int n, int n2, Object object) throws HDF5Exception {
        HDFArray hDFArray = new HDFArray(object);
        byte[] byArray = hDFArray.byteify();
        int n3 = H5.H5Pset_fill_value(n, n2, byArray);
        byArray = null;
        hDFArray = null;
        return n3;
    }

    public static native int H5Pget_fill_value(int var0, int var1, byte[] var2) throws HDF5Exception;

    public static int H5Pget_fill_value(int n, int n2, Object object) throws HDF5Exception {
        HDFArray hDFArray = new HDFArray(object);
        byte[] byArray = hDFArray.emptyBytes();
        int n3 = H5.H5Pget_fill_value(n, n2, byArray);
        if (n3 >= 0) {
            object = hDFArray.arrayify(byArray);
        }
        return n3;
    }

    public static native int H5Pset_filter(int var0, int var1, int var2, int var3, int[] var4) throws HDF5LibraryException;

    public static native int H5Pget_nfilters(int var0) throws HDF5LibraryException;

    public static native int H5Pget_filter(int var0, int var1, int[] var2, int[] var3, int[] var4, int var5, String[] var6) throws ArrayIndexOutOfBoundsException, ArrayStoreException, HDF5LibraryException, NullPointerException;

    public static native int H5Pget_driver(int var0) throws HDF5LibraryException;

    public static native int H5Pset_stdio(int var0) throws HDF5LibraryException;

    public static native boolean H5Pget_stdio(int var0);

    public static native int H5Pset_sec2(int var0) throws HDF5LibraryException;

    public static native boolean H5Pget_sec2(int var0) throws HDF5LibraryException;

    public static native int H5Pset_core(int var0, int var1) throws HDF5LibraryException;

    public static native boolean H5Pget_core(int var0, int[] var1) throws HDF5LibraryException;

    public static native int H5Pset_split(int var0, String var1, int var2, String var3, int var4) throws HDF5LibraryException, NullPointerException;

    public static native boolean H5Pget_split(int var0, int var1, String[] var2, int[] var3, int var4, String[] var5, int[] var6) throws ArrayIndexOutOfBoundsException, ArrayStoreException, HDF5LibraryException, NullPointerException;

    public static native int H5Pset_family(int var0, long var1, int var3) throws HDF5LibraryException;

    public static native int H5Pget_family(int var0, long[] var1, int[] var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Pset_cache(int var0, int var1, int var2, int var3, double var4) throws HDF5LibraryException;

    public static native int H5Pget_cache(int var0, int[] var1, int[] var2, int[] var3, double[] var4) throws HDF5LibraryException, NullPointerException;

    public static native int H5Pset_preserve(int var0, boolean var1) throws HDF5LibraryException, IllegalArgumentException;

    public static native int H5Pget_preserve(int var0) throws HDF5LibraryException;

    public static native boolean H5Pset_deflate(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Pset_gc_references(int var0, boolean var1) throws HDF5LibraryException;

    public static native int H5Pget_gc_reference(int var0, boolean[] var1) throws HDF5LibraryException, NullPointerException;

    public static native int H5Pset_hyper_cache(int var0, boolean var1, int var2) throws HDF5LibraryException;

    public static native int H5Pget_hyper_cache(int var0, boolean[] var1, int[] var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Pset_btree_ratios(int var0, double var1, double var3, double var5) throws HDF5LibraryException;

    public static native int H5Pget_btree_ratios(int var0, double[] var1, double[] var2, double[] var3) throws HDF5LibraryException, NullPointerException;

    private static native int H5Rcreate(byte[] var0, int var1, String var2, int var3, int var4) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static byte[] H5Rcreate(int n, String string, int n2, int n3) throws HDF5LibraryException, NullPointerException, IllegalArgumentException {
        int n4 = 8;
        if (n2 == 1) {
            n4 = 12;
        }
        byte[] byArray = new byte[n4];
        H5.H5Rcreate(byArray, n, string, n2, n3);
        return byArray;
    }

    public static native int H5Rdereference(int var0, int var1, byte[] var2) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static native int H5Rget_region(int var0, int var1, byte[] var2) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static native int H5Rget_object_type(int var0, byte[] var1) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static native int H5Screate(int var0) throws HDF5LibraryException;

    public static native int H5Screate_simple(int var0, long[] var1, long[] var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Scopy(int var0) throws HDF5LibraryException;

    private static native int H5Sselect_elements(int var0, int var1, int var2, byte[] var3) throws HDF5LibraryException, NullPointerException;

    public static int H5Sselect_elements(int n, int n2, int n3, long[][] lArray) throws HDF5Exception, HDF5LibraryException, NullPointerException {
        if (lArray == null) {
            return -1;
        }
        HDFArray hDFArray = new HDFArray(lArray);
        byte[] byArray = hDFArray.byteify();
        int n4 = H5.H5Sselect_elements(n, n2, n3, byArray);
        byArray = null;
        hDFArray = null;
        return n4;
    }

    public static native int H5Sselect_all(int var0) throws HDF5LibraryException;

    public static native int H5Sselect_none(int var0) throws HDF5LibraryException;

    public static native boolean H5Sselect_valid(int var0) throws HDF5LibraryException;

    public static native long H5Sget_simple_extent_npoints(int var0) throws HDF5LibraryException;

    public static native long H5Sget_select_npoints(int var0) throws HDF5LibraryException;

    public static native int H5Sget_simple_extent_ndims(int var0) throws HDF5LibraryException;

    public static native int H5Sget_simple_extent_dims(int var0, long[] var1, long[] var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Sget_simple_extent_type(int var0) throws HDF5LibraryException;

    public static native int H5Sset_extent_simple(int var0, int var1, long[] var2, long[] var3) throws HDF5LibraryException, NullPointerException;

    public static native boolean H5Sis_simple(int var0) throws HDF5LibraryException;

    public static native int H5Soffset_simple(int var0, long[] var1) throws HDF5LibraryException, NullPointerException;

    public static native int H5Sextent_copy(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Sset_extent_none(int var0) throws HDF5LibraryException;

    public static native int H5Sselect_hyperslab(int var0, int var1, long[] var2, long[] var3, long[] var4, long[] var5) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static native int H5Sclose(int var0) throws HDF5LibraryException;

    public static native long H5Sget_select_hyper_nblocks(int var0) throws HDF5LibraryException;

    public static native long H5Sget_select_elem_npoints(int var0) throws HDF5LibraryException;

    public static native int H5Sget_select_hyper_blocklist(int var0, long var1, long var3, long[] var5) throws HDF5LibraryException, NullPointerException;

    public static native int H5Sget_select_elem_pointlist(int var0, long var1, long var3, long[] var5) throws HDF5LibraryException, NullPointerException;

    public static native int H5Sget_select_bounds(int var0, long[] var1, long[] var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Topen(int var0, String var1) throws HDF5LibraryException, NullPointerException;

    public static native int H5Tcommit(int var0, String var1, int var2) throws HDF5LibraryException, NullPointerException;

    public static native boolean H5Tcommitted(int var0) throws HDF5LibraryException;

    public static native int H5Tcreate(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Tcopy(int var0) throws HDF5LibraryException;

    public static native boolean H5Tequal(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Tlock(int var0) throws HDF5LibraryException;

    public static native int H5Tget_class(int var0) throws HDF5LibraryException;

    public static native int H5Tget_size(int var0) throws HDF5LibraryException;

    public static native int H5Tset_size(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Tget_order(int var0) throws HDF5LibraryException;

    public static native int H5Tset_order(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Tget_precision(int var0) throws HDF5LibraryException;

    public static native int H5Tset_precision(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Tget_offset(int var0) throws HDF5LibraryException;

    public static native int H5Tset_offset(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Tget_pad(int var0, int[] var1) throws HDF5LibraryException, NullPointerException;

    public static native int H5Tset_pad(int var0, int var1, int var2) throws HDF5LibraryException;

    public static native int H5Tget_sign(int var0) throws HDF5LibraryException;

    public static native int H5Tset_sign(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Tget_fields(int var0, int[] var1) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static native int H5Tset_fields(int var0, int var1, int var2, int var3, int var4, int var5) throws HDF5LibraryException;

    public static native int H5Tget_ebias(int var0) throws HDF5LibraryException;

    public static native int H5Tset_ebias(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Tget_norm(int var0) throws HDF5LibraryException;

    public static native int H5Tset_norm(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Tget_inpad(int var0) throws HDF5LibraryException;

    public static native int H5Tset_inpad(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Tget_cset(int var0) throws HDF5LibraryException;

    public static native int H5Tset_cset(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Tget_strpad(int var0) throws HDF5LibraryException;

    public static native int H5Tset_strpad(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Tget_nmembers(int var0) throws HDF5LibraryException;

    public static native String H5Tget_member_name(int var0, int var1);

    public static native int H5Tget_member_dims(int var0, int var1, int[] var2, int[] var3) throws HDF5LibraryException, NullPointerException;

    public static native int H5Tget_member_type(int var0, int var1) throws HDF5LibraryException;

    public static native long H5Tget_member_offset(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Tinsert(int var0, String var1, long var2, int var4) throws HDF5LibraryException, NullPointerException;

    public static native int H5Tpack(int var0) throws HDF5LibraryException;

    public static native int H5Tinsert_array(int var0, String var1, int var2, int var3, int[] var4, int[] var5, int var6) throws HDF5LibraryException, NullPointerException;

    public static native int H5Tclose(int var0) throws HDF5LibraryException;

    public static native int H5Tenum_create(int var0) throws HDF5LibraryException;

    public static native int H5Tenum_insert(int var0, String var1, int[] var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Tenum_nameof(int var0, int[] var1, String[] var2, int var3) throws HDF5LibraryException, NullPointerException;

    public static native int H5Tenum_valueof(int var0, String var1, int[] var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Tvlen_create(int var0) throws HDF5LibraryException;

    public static native int H5Tset_tag(int var0, String var1) throws HDF5LibraryException;

    public static native String H5Tget_tag(int var0) throws HDF5LibraryException;

    public static native int H5Tget_super(int var0) throws HDF5LibraryException;

    public static native int H5Tget_member_value(int var0, int var1, int[] var2) throws HDF5LibraryException, NullPointerException;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        Comparable<File> comparable;
        String string = null;
        string = System.getProperty(H5PATH_PROPERTY_KEY, null);
        if (string != null && string.length() > 0) {
            comparable = new File(string);
            if (!((File)comparable).exists() || !((File)comparable).canRead() || !((File)comparable).isFile()) throw new UnsatisfiedLinkError("Invalid HDF5 library, " + string);
            System.load(string);
        } else {
            System.loadLibrary("jhdf5");
        }
        try {
            H5.H5dont_atexit();
        }
        catch (HDF5LibraryException hDF5LibraryException) {
            System.exit(1);
        }
        H5.H5error_off();
        comparable = Integer.getInteger("ncsa.hdf.hdf5lib.H5.hdf5maj", null);
        Integer n = Integer.getInteger("ncsa.hdf.hdf5lib.H5.hdf5min", null);
        Integer n2 = Integer.getInteger("ncsa.hdf.hdf5lib.H5.hdf5rel", null);
        if (comparable == null || n == null || n2 == null) return;
        H5.H5check_version((Integer)comparable, n, n2);
    }
}

