/*
 * Decompiled with CFR 0.152.
 */
package ij.text;

import ij.IJ;
import ij.ImageJ;
import ij.io.OpenDialog;
import ij.text.TextPanel;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public class TextWindow
extends Frame {
    private TextPanel textPanel;

    public void append(String string) {
        this.textPanel.append(string);
    }

    public void setFont(Font font) {
        this.textPanel.setFont(font);
    }

    boolean openFile(String string) {
        OpenDialog openDialog = new OpenDialog("Open Text File...", string);
        String string2 = openDialog.getDirectory();
        String string3 = openDialog.getFileName();
        if (string3 == null) {
            return false;
        }
        string = string2 + string3;
        IJ.showStatus("Opening: " + string);
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string2 + string3));
            this.load(bufferedReader);
        }
        catch (Exception exception) {
            IJ.error(exception.getMessage());
            return true;
        }
        this.textPanel.setTitle(string3);
        this.setTitle(string3);
        IJ.showStatus("");
        return true;
    }

    public TextPanel getTextPanel() {
        return this.textPanel;
    }

    public void load(BufferedReader bufferedReader) throws IOException {
        String string;
        boolean bl = false;
        while ((string = bufferedReader.readLine()) != null) {
            this.textPanel.appendLine(string);
        }
    }

    public void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            ((Component)this).setVisible(false);
            this.dispose();
            this.textPanel.flush();
        }
    }

    public TextWindow(String string, String string2, int n, int n2) {
        this(string, "", string2, n, n2);
    }

    public TextWindow(String string, String string2, String string3, int n, int n2) {
        super(string);
        Image image;
        this.enableEvents(64L);
        this.textPanel = new TextPanel();
        this.textPanel.setTitle(string);
        this.add("Center", this.textPanel);
        this.textPanel.setColumnHeadings(string2);
        this.textPanel.append(string3);
        ImageJ imageJ = IJ.getInstance();
        if (imageJ != null && (image = imageJ.getIconImage()) != null) {
            this.setIconImage(image);
        }
        ((Component)this).setSize(n, n2);
        ((Component)this).setVisible(true);
    }

    public TextWindow(String string, int n, int n2) {
        super("");
        this.enableEvents(64L);
        this.textPanel = new TextPanel();
        this.add("Center", this.textPanel);
        if (this.openFile(string)) {
            ((Component)this).setSize(n, n2);
            ((Component)this).setVisible(true);
        } else {
            this.dispose();
        }
    }
}

