/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.measure.Calibration;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;

public class ShortStatistics
extends ImageStatistics {
    void getRawMinAndMax(int[] nArray, int n, int n2) {
        int n3 = n;
        while (nArray[n3] == 0 && n3 < 65535) {
            ++n3;
        }
        this.min = n3;
        int n4 = n2;
        while (nArray[n4] == 0 && n4 > 0) {
            --n4;
        }
        this.max = n4;
    }

    void getStatistics(int[] nArray, int n, int n2, float[] fArray) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = (double)(this.nBins - 1) / (this.histMax - this.histMin);
        int n3 = (int)this.histMin;
        this.binSize = (this.histMax - this.histMin) / (double)this.nBins;
        this.histogram = new int[this.nBins];
        int n4 = n;
        while (n4 <= n2) {
            int n5 = nArray[n4];
            this.pixelCount += n5;
            double d4 = fArray == null ? (float)n4 : fArray[n4];
            d += d4 * (double)n5;
            d2 += d4 * d4 * (double)n5;
            int n6 = (int)(d3 * (double)(n4 - n3));
            this.histogram[n6] = this.histogram[n6] + n5;
            ++n4;
        }
        this.area = (double)this.pixelCount * this.pw * this.ph;
        this.umean = this.mean = d / (double)this.pixelCount;
        this.calculateStdDev(this.pixelCount, d, d2);
        this.histMin = n;
        this.histMax = n2;
    }

    void getMode(float[] fArray) {
        this.maxCount = 0;
        int n = 0;
        while (n < this.nBins) {
            int n2 = this.histogram[n];
            if (n2 > this.maxCount) {
                this.maxCount = n2;
                this.mode = n;
            }
            ++n;
        }
        this.dmode = this.histMin + (double)this.mode * this.binSize + this.binSize / 2.0;
        if (fArray != null) {
            this.dmode = fArray[(int)this.dmode];
        }
    }

    void getCenterOfMass(ImageProcessor imageProcessor, float[] fArray) {
        short[] sArray = (short[])imageProcessor.getPixels();
        int[] nArray = imageProcessor.getMask();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n = this.ry;
        int n2 = 0;
        while (n < this.ry + this.rh) {
            int n3 = n * this.width + this.rx;
            int n4 = n2 * this.rw;
            int n5 = this.rx;
            while (n5 < this.rx + this.rw) {
                if (nArray == null || nArray[n4++] == ImageProcessor.BLACK) {
                    int n6 = sArray[n3] & 0xFFFF;
                    double d4 = (double)(fArray != null ? fArray[n6] : (float)n6) + Double.MIN_VALUE;
                    d += (double)n6;
                    d2 += (double)(n5 * n6);
                    d3 += (double)(n * n6);
                }
                ++n3;
                ++n5;
            }
            ++n;
            ++n2;
        }
        this.xCenterOfMass = (d2 / d + 0.5) * this.pw;
        this.yCenterOfMass = (d3 / d + 0.5) * this.ph;
    }

    void getCalibratedMinAndMax(int[] nArray, int n, int n2, float[] fArray) {
        this.min = Double.MAX_VALUE;
        this.max = -1.7976931348623157E308;
        double d = 0.0;
        int n3 = n;
        while (n3 < n2) {
            if (nArray[n3] > 0) {
                d = fArray[n3];
                if (d < this.min) {
                    this.min = d;
                }
                if (d > this.max) {
                    this.max = d;
                }
            }
            ++n3;
        }
    }

    public ShortStatistics(ImageProcessor imageProcessor) {
        this(imageProcessor, 27, null);
    }

    public ShortStatistics(ImageProcessor imageProcessor, int n, Calibration calibration) {
        this.width = imageProcessor.getWidth();
        this.height = imageProcessor.getHeight();
        this.setup(imageProcessor, calibration);
        this.nBins = 256;
        int n2 = 0;
        int n3 = 65535;
        int[] nArray = imageProcessor.getHistogram();
        float[] fArray = calibration != null ? calibration.getCTable() : null;
        this.getRawMinAndMax(nArray, n2, n3);
        this.histMin = this.min;
        this.histMax = this.max;
        this.getStatistics(nArray, (int)this.min, (int)this.max, fArray);
        if ((n & 8) != 0) {
            this.getMode(fArray);
        }
        if ((n & 0x20) != 0) {
            this.getCentroid(imageProcessor);
        }
        if ((n & 0x40) != 0) {
            this.getCenterOfMass(imageProcessor, fArray);
        }
        if ((n & 0x10) != 0 && fArray != null) {
            this.getCalibratedMinAndMax(nArray, (int)this.min, (int)this.max, fArray);
        }
    }
}

