/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.process.ImageProcessor;
import ij.process.ShortBlitter;
import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;

public class ShortProcessor
extends ImageProcessor {
    private int min;
    private int max;
    private int snapshotMin;
    private int snapshotMax;
    private short[] pixels;
    private short[] snapshotPixels;
    private byte[] pixels8;
    private byte[] LUT;
    private boolean fixedScale;

    public void findMinAndMax() {
        if (this.fixedScale) {
            return;
        }
        int n = this.width * this.height;
        this.min = 65535;
        this.max = 0;
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.pixels[n2] & 0xFFFF;
            if (n3 < this.min) {
                this.min = n3;
            }
            if (n3 > this.max) {
                this.max = n3;
            }
            ++n2;
        }
        this.hideProgress();
    }

    public Image createImage() {
        boolean bl = !this.lutAnimation || this.pixels8 == null;
        this.lutAnimation = false;
        if (this.pixels8 == null) {
            this.pixels8 = new byte[this.width * this.height];
        }
        if (this.cm == null) {
            this.makeDefaultColorModel();
        }
        if (bl) {
            double d = 255.0 / (double)(this.max - this.min);
            int n = 0;
            while (n < this.width * this.height) {
                int n2 = (this.pixels[n] & 0xFFFF) - this.min;
                if (n2 < 0) {
                    n2 = 0;
                }
                if ((n2 = (int)((double)n2 * d)) > 255) {
                    n2 = 255;
                }
                this.pixels8[n] = (byte)n2;
                ++n;
            }
        }
        MemoryImageSource memoryImageSource = new MemoryImageSource(this.width, this.height, this.cm, this.pixels8, 0, this.width);
        return Toolkit.getDefaultToolkit().createImage(memoryImageSource);
    }

    public ImageProcessor createProcessor(int n, int n2) {
        ShortProcessor shortProcessor = new ShortProcessor(n, n2, new short[n * n2], this.getColorModel());
        ((ImageProcessor)shortProcessor).setMinAndMax(this.getMin(), this.getMax());
        return shortProcessor;
    }

    public void snapshot() {
        this.snapshotWidth = this.width;
        this.snapshotHeight = this.height;
        this.snapshotMin = this.min;
        this.snapshotMax = this.max;
        if (this.snapshotPixels == null || this.snapshotPixels != null && this.snapshotPixels.length != this.pixels.length) {
            this.snapshotPixels = new short[this.width * this.height];
        }
        System.arraycopy(this.pixels, 0, this.snapshotPixels, 0, this.width * this.height);
        this.newSnapshot = true;
    }

    public void reset() {
        if (this.snapshotPixels == null) {
            return;
        }
        this.min = this.snapshotMin;
        this.max = this.snapshotMax;
        System.arraycopy(this.snapshotPixels, 0, this.pixels, 0, this.width * this.height);
        this.newSnapshot = true;
    }

    public void reset(int[] nArray) {
        if (nArray == null || this.snapshotPixels == null || nArray.length != this.roiWidth * this.roiHeight) {
            return;
        }
        int n = this.roiY;
        int n2 = 0;
        while (n < this.roiY + this.roiHeight) {
            int n3 = n * this.width + this.roiX;
            int n4 = n2 * this.roiWidth;
            int n5 = this.roiX;
            while (n5 < this.roiX + this.roiWidth) {
                if (nArray[n4++] != -16777216) {
                    this.pixels[n3] = this.snapshotPixels[n3];
                }
                ++n3;
                ++n5;
            }
            ++n;
            ++n2;
        }
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMinAndMax(double d, double d2) {
        if (d == 0.0 && d2 == 0.0) {
            this.resetMinAndMax();
            return;
        }
        if (d < 0.0) {
            d = 0.0;
        }
        if (d2 > 65535.0) {
            d2 = 65535.0;
        }
        this.min = (int)d;
        this.max = (int)d2;
        this.fixedScale = true;
        this.setThreshold(-808080.0, 0.0, 0);
    }

    public void resetMinAndMax() {
        this.fixedScale = false;
        this.findMinAndMax();
        this.setThreshold(-808080.0, 0.0, 0);
    }

    public int getPixel(int n, int n2) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            int n3 = this.pixels[n2 * this.width + n] & 0xFFFF;
            return n3;
        }
        return 0;
    }

    public double getInterpolatedPixel(double d, double d2) {
        int n = (int)d;
        int n2 = (int)d2;
        if (n >= 0 && n + 1 < this.width && n2 >= 0 && n2 + 1 < this.height) {
            return this.getInterpolatedPixel(d, d2, this.pixels);
        }
        return 0.0;
    }

    public void putPixel(int n, int n2, int n3) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            this.pixels[n2 * this.width + n] = (short)n3;
        }
    }

    public void putPixelValue(int n, int n2, double d) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            this.pixels[n2 * this.width + n] = (short)d;
        }
    }

    public void drawPixel(int n, int n2) {
        this.putPixel(n, n2, this.fgColor);
    }

    public float getPixelValue(int n, int n2) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            if (this.cTable == null) {
                return this.pixels[n2 * this.width + n] & 0xFFFF;
            }
            return this.cTable[this.pixels[n2 * this.width + n] & 0xFFFF];
        }
        return 0.0f;
    }

    public Object getPixels() {
        return this.pixels;
    }

    public Object getPixelsCopy() {
        if (this.newSnapshot) {
            return this.snapshotPixels;
        }
        short[] sArray = new short[this.width * this.height];
        System.arraycopy(this.pixels, 0, sArray, 0, this.width * this.height);
        return sArray;
    }

    public void setPixels(Object object) {
        this.pixels = (short[])object;
        this.snapshotPixels = null;
    }

    void getRow2(int n, int n2, int[] nArray, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            nArray[n4] = this.pixels[n2 * this.width + n + n4] & 0xFFFF;
            ++n4;
        }
    }

    void putColumn2(int n, int n2, int[] nArray, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            this.pixels[(n2 + n4) * this.width + n] = (short)nArray[n4];
            ++n4;
        }
    }

    public void copyBits(ImageProcessor imageProcessor, int n, int n2, int n3) {
        if (!(imageProcessor instanceof ShortProcessor)) {
            throw new IllegalArgumentException("16-bit image required");
        }
        new ShortBlitter(this).copyBits(imageProcessor, n, n2, n3);
    }

    public void applyTable(int[] nArray) {
        if (nArray.length != 65536) {
            throw new IllegalArgumentException("lut.length!=65536");
        }
        int n = this.roiY;
        while (n < this.roiY + this.roiHeight) {
            int n2;
            int n3 = n * this.width + this.roiX;
            int n4 = n2 = n3 + this.roiWidth;
            while (--n4 >= n3) {
                int n5 = nArray[this.pixels[n4] & 0xFFFF];
                this.pixels[n4] = (short)n5;
            }
            ++n;
        }
        this.findMinAndMax();
    }

    private void process(int n, double d) {
        double d2 = this.max - this.min;
        int n2 = this.roiY;
        while (n2 < this.roiY + this.roiHeight) {
            int n3 = n2 * this.width + this.roiX;
            int n4 = this.roiX;
            while (n4 < this.roiX + this.roiWidth) {
                int n5;
                int n6 = this.pixels[n3] & 0xFFFF;
                switch (n) {
                    case 0: {
                        n5 = this.max - (n6 - this.min);
                        break;
                    }
                    case 1: {
                        n5 = this.fgColor;
                        break;
                    }
                    case 2: {
                        n5 = n6 + (int)d;
                        break;
                    }
                    case 3: {
                        n5 = (int)Math.round((double)n6 * d);
                        break;
                    }
                    case 4: {
                        n5 = n6 & (int)d;
                        break;
                    }
                    case 5: {
                        n5 = n6 | (int)d;
                        break;
                    }
                    case 6: {
                        n5 = n6 ^ (int)d;
                        break;
                    }
                    case 7: {
                        if (d2 <= 0.0 || n6 == this.min) {
                            n5 = n6;
                            break;
                        }
                        n5 = (int)(Math.exp(d * Math.log((double)(n6 - this.min) / d2)) * d2 + (double)this.min);
                        break;
                    }
                    case 8: {
                        if (n6 <= 0) {
                            n5 = 0;
                            break;
                        }
                        n5 = (int)(Math.log(n6) * ((double)this.max / Math.log(this.max)));
                        break;
                    }
                    default: {
                        n5 = n6;
                    }
                }
                if (n5 < 0) {
                    n5 = 0;
                }
                if (n5 > 65535) {
                    n5 = 65535;
                }
                this.pixels[n3++] = (short)n5;
                ++n4;
            }
            if (n2 % 20 == 0) {
                this.showProgress((double)(n2 - this.roiY) / (double)this.roiHeight);
            }
            ++n2;
        }
        this.findMinAndMax();
        this.showProgress(1.0);
    }

    public void invert() {
        this.resetMinAndMax();
        this.process(0, 0.0);
    }

    public void add(int n) {
        this.process(2, n);
    }

    public void multiply(double d) {
        this.process(3, d);
    }

    public void and(int n) {
        this.process(4, n);
    }

    public void or(int n) {
        this.process(5, n);
    }

    public void xor(int n) {
        this.process(6, n);
    }

    public void gamma(double d) {
        this.process(7, d);
    }

    public void log() {
        this.process(8, 0.0);
    }

    public void fill() {
        this.process(1, 0.0);
    }

    public void fill(int[] nArray) {
        int n = this.roiY;
        int n2 = 0;
        while (n < this.roiY + this.roiHeight) {
            int n3 = n * this.width + this.roiX;
            int n4 = n2 * this.roiWidth;
            int n5 = this.roiX;
            while (n5 < this.roiX + this.roiWidth) {
                if (nArray[n4++] == -16777216) {
                    this.pixels[n3] = (short)this.fgColor;
                }
                ++n3;
                ++n5;
            }
            ++n;
            ++n2;
        }
    }

    public void convolve3x3(int[] nArray) {
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        int n4 = nArray[3];
        int n5 = nArray[4];
        int n6 = nArray[5];
        int n7 = nArray[6];
        int n8 = nArray[7];
        int n9 = nArray[8];
        int n10 = 0;
        int n11 = 0;
        while (n11 < nArray.length) {
            n10 += nArray[n11];
            ++n11;
        }
        if (n10 == 0) {
            n10 = 1;
        }
        if ((n11 = this.roiHeight / 25) < 1) {
            n11 = 1;
        }
        short[] sArray = (short[])this.getPixelsCopy();
        int n12 = this.width;
        int n13 = this.yMin;
        while (n13 <= this.yMax) {
            int n14 = this.xMin + n13 * this.width;
            int n15 = 0;
            int n16 = sArray[n14 - n12 - 1] & 0xFFFF;
            int n17 = sArray[n14 - n12] & 0xFFFF;
            int n18 = 0;
            int n19 = sArray[n14 - 1] & 0xFFFF;
            int n20 = sArray[n14] & 0xFFFF;
            int n21 = 0;
            int n22 = sArray[n14 + n12 - 1] & 0xFFFF;
            int n23 = sArray[n14 + n12] & 0xFFFF;
            int n24 = this.xMin;
            while (n24 <= this.xMax) {
                n15 = n16;
                n16 = n17;
                n17 = sArray[n14 - n12 + 1] & 0xFFFF;
                n18 = n19;
                n19 = n20;
                n20 = sArray[n14 + 1] & 0xFFFF;
                n21 = n22;
                n22 = n23;
                n23 = sArray[n14 + n12 + 1] & 0xFFFF;
                int n25 = n * n15 + n2 * n16 + n3 * n17 + n4 * n18 + n5 * n19 + n6 * n20 + n7 * n21 + n8 * n22 + n9 * n23;
                this.pixels[n14++] = (short)(n25 /= n10);
                ++n24;
            }
            if (n13 % n11 == 0) {
                this.showProgress((double)(n13 - this.roiY) / (double)this.roiHeight);
            }
            ++n13;
        }
        this.hideProgress();
    }

    public void filter(int n) {
        int n2 = this.roiHeight / 25;
        if (n2 < 1) {
            n2 = 1;
        }
        short[] sArray = (short[])this.getPixelsCopy();
        int n3 = 0;
        int n4 = this.width;
        int n5 = this.yMin;
        while (n5 <= this.yMax) {
            int n6 = this.xMin + n5 * this.width;
            int n7 = 0;
            int n8 = sArray[n6 - n4 - 1] & 0xFFFF;
            int n9 = sArray[n6 - n4] & 0xFFFF;
            int n10 = 0;
            int n11 = sArray[n6 - 1] & 0xFFFF;
            int n12 = sArray[n6] & 0xFFFF;
            int n13 = 0;
            int n14 = sArray[n6 + n4 - 1] & 0xFFFF;
            int n15 = sArray[n6 + n4] & 0xFFFF;
            int n16 = this.xMin;
            while (n16 <= this.xMax) {
                n7 = n8;
                n8 = n9;
                n9 = sArray[n6 - n4 + 1] & 0xFFFF;
                n10 = n11;
                n11 = n12;
                n12 = sArray[n6 + 1] & 0xFFFF;
                n13 = n14;
                n14 = n15;
                n15 = sArray[n6 + n4 + 1] & 0xFFFF;
                switch (n) {
                    case 0: {
                        n3 = (n7 + n8 + n9 + n10 + n11 + n12 + n13 + n14 + n15) / 9;
                        break;
                    }
                    case 1: {
                        int n17 = n7 + 2 * n8 + n9 - n13 - 2 * n14 - n15;
                        int n18 = n7 + 2 * n10 + n13 - n9 - 2 * n12 - n15;
                        n3 = (int)Math.sqrt(n17 * n17 + n18 * n18);
                        break;
                    }
                }
                this.pixels[n6++] = (short)n3;
                ++n16;
            }
            if (n5 % n2 == 0) {
                this.showProgress((double)(n5 - this.roiY) / (double)this.roiHeight);
            }
            ++n5;
        }
        if (n == 0) {
            this.hideProgress();
        } else {
            this.findMinAndMax();
        }
    }

    public void rotate(double d) {
        short[] sArray = (short[])this.getPixelsCopy();
        double d2 = (double)this.roiX + (double)this.roiWidth / 2.0;
        double d3 = (double)this.roiY + (double)this.roiHeight / 2.0;
        int n = this.roiX + this.roiWidth - 1;
        double d4 = -d / 57.29577951308232;
        double d5 = Math.cos(d4);
        double d6 = Math.sin(d4);
        double d7 = d3 * d6 - d2 * d5;
        double d8 = -d2 * d6 - d3 * d5;
        int n2 = this.roiY;
        while (n2 < this.roiY + this.roiHeight) {
            int n3 = n2 * this.width + this.roiX;
            double d9 = d7 - (double)n2 * d6 + d2;
            double d10 = d8 + (double)n2 * d5 + d3;
            int n4 = this.roiX;
            while (n4 <= n) {
                double d11 = (double)n4 * d5 + d9;
                double d12 = (double)n4 * d6 + d10;
                this.pixels[n3++] = d11 >= 0.0 && d11 < (double)this.width && d12 >= 0.0 && d12 < (double)this.height ? (this.interpolate ? (short)(this.getInterpolatedPixel(d11, d12, sArray) + 0.5) : sArray[this.width * (int)d12 + (int)d11]) : (short)0;
                ++n4;
            }
            if (n2 % 20 == 0) {
                this.showProgress((double)(n2 - this.roiY) / (double)this.roiHeight);
            }
            ++n2;
        }
        this.hideProgress();
    }

    public void scale(double d, double d2) {
        int n;
        int n2;
        int n3;
        int n4;
        double d3 = (double)this.roiX + (double)this.roiWidth / 2.0;
        double d4 = (double)this.roiY + (double)this.roiHeight / 2.0;
        if (d > 1.0 && d2 > 1.0) {
            n4 = (int)(d3 - (d3 - (double)this.roiX) * d);
            if (n4 < 0) {
                n4 = 0;
            }
            if ((n3 = n4 + (int)((double)this.roiWidth * d) - 1) >= this.width) {
                n3 = this.width - 1;
            }
            if ((n2 = (int)(d4 - (d4 - (double)this.roiY) * d2)) < 0) {
                n2 = 0;
            }
            if ((n = n2 + (int)((double)this.roiHeight * d2) - 1) >= this.height) {
                n = this.height - 1;
            }
        } else {
            n4 = this.roiX;
            n3 = this.roiX + this.roiWidth - 1;
            n2 = this.roiY;
            n = this.roiY + this.roiHeight - 1;
        }
        short[] sArray = (short[])this.getPixelsCopy();
        boolean bl = d < 1.0 || d2 < 1.0;
        int n5 = n2;
        while (n5 <= n) {
            double d5 = ((double)n5 - d4) / d2 + d4;
            int n6 = (int)d5;
            int n7 = n5 * this.width + n4;
            int n8 = this.width * (int)d5;
            int n9 = n4;
            while (n9 <= n3) {
                double d6 = ((double)n9 - d3) / d + d3;
                int n10 = (int)d6;
                this.pixels[n7++] = bl && (n10 < n4 || n10 > n3 || n6 < n2 || d5 > (double)n) ? (short)this.min : (this.interpolate ? (short)(this.getInterpolatedPixel(d6, d5, sArray) + 0.5) : sArray[n8 + n10]);
                ++n9;
            }
            if (n5 % 20 == 0) {
                this.showProgress((double)(n5 - n2) / (double)this.height);
            }
            ++n5;
        }
        this.hideProgress();
    }

    private final double getInterpolatedPixel(double d, double d2, short[] sArray) {
        int n = (int)d;
        int n2 = (int)d2;
        double d3 = d - (double)n;
        double d4 = d2 - (double)n2;
        int n3 = n2 * this.width + n;
        int n4 = sArray[n3] & 0xFFFF;
        if (n >= this.width - 1 || n2 >= this.height - 1) {
            return n4;
        }
        int n5 = sArray[n3 + 1] & 0xFFFF;
        int n6 = sArray[n3 + this.width + 1] & 0xFFFF;
        int n7 = sArray[n3 + this.width] & 0xFFFF;
        double d5 = (double)n7 + d3 * (double)(n6 - n7);
        double d6 = (double)n4 + d3 * (double)(n5 - n4);
        return d6 + d4 * (d5 - d6);
    }

    public ImageProcessor resize(int n, int n2) {
        double d = (double)this.roiX + (double)this.roiWidth / 2.0;
        double d2 = (double)this.roiY + (double)this.roiHeight / 2.0;
        double d3 = (double)n / 2.0;
        double d4 = (double)n2 / 2.0;
        double d5 = (double)n / (double)this.roiWidth;
        double d6 = (double)n2 / (double)this.roiHeight;
        ImageProcessor imageProcessor = this.createProcessor(n, n2);
        short[] sArray = (short[])imageProcessor.getPixels();
        double d7 = 0.0;
        int n3 = 0;
        while (n3 <= n2 - 1) {
            int n4 = this.width * (int)d7;
            int n5 = n3 * n;
            d7 = ((double)n3 - d4) / d6 + d2;
            int n6 = 0;
            while (n6 <= n - 1) {
                double d8 = ((double)n6 - d3) / d5 + d;
                sArray[n5++] = this.interpolate ? (short)(this.getInterpolatedPixel(d8, d7, this.pixels) + 0.5) : this.pixels[n4 + (int)d8];
                ++n6;
            }
            if (n3 % 20 == 0) {
                this.showProgress((double)n3 / (double)n2);
            }
            ++n3;
        }
        this.hideProgress();
        return imageProcessor;
    }

    public ImageProcessor crop() {
        ImageProcessor imageProcessor = this.createProcessor(this.roiWidth, this.roiHeight);
        short[] sArray = (short[])imageProcessor.getPixels();
        int n = this.roiY;
        while (n < this.roiY + this.roiHeight) {
            int n2 = (n - this.roiY) * this.roiWidth;
            int n3 = n * this.width + this.roiX;
            int n4 = 0;
            while (n4 < this.roiWidth) {
                sArray[n2++] = this.pixels[n3++];
                ++n4;
            }
            ++n;
        }
        return imageProcessor;
    }

    public void setColor(Color color) {
        int n = this.getBestIndex(color);
        if (n > 0 && this.getMin() == 0.0 && this.getMax() == 0.0) {
            this.setValue(n);
            this.setMinAndMax(0.0, 255.0);
        } else if (n == 0 && this.getMin() > 0.0 && (color.getRGB() & 0xFFFFFF) == 0) {
            this.setValue(0.0);
        } else {
            this.fgColor = (int)(this.getMin() + (this.getMax() - this.getMin()) * ((double)n / 255.0));
        }
    }

    public void setValue(double d) {
        this.fgColor = (int)d;
        if (this.fgColor < 0) {
            this.fgColor = 0;
        }
        if (this.fgColor > 65535) {
            this.fgColor = 65535;
        }
    }

    public int[] getHistogram() {
        if (this.mask != null) {
            return this.getHistogram(this.mask);
        }
        int[] nArray = new int[65536];
        int n = this.roiY;
        while (n < this.roiY + this.roiHeight) {
            int n2 = n * this.width + this.roiX;
            int n3 = this.roiX;
            while (n3 < this.roiX + this.roiWidth) {
                int n4 = this.pixels[n2++] & 0xFFFF;
                nArray[n4] = nArray[n4] + 1;
                ++n3;
            }
            ++n;
        }
        return nArray;
    }

    int[] getHistogram(int[] nArray) {
        int[] nArray2 = new int[65536];
        int n = this.roiY;
        int n2 = 0;
        while (n < this.roiY + this.roiHeight) {
            int n3 = n * this.width + this.roiX;
            int n4 = n2 * this.roiWidth;
            int n5 = this.roiX;
            while (n5 < this.roiX + this.roiWidth) {
                if (nArray[n4++] == -16777216) {
                    int n6 = this.pixels[n3] & 0xFFFF;
                    nArray2[n6] = nArray2[n6] + 1;
                }
                ++n3;
                ++n5;
            }
            ++n;
            ++n2;
        }
        return nArray2;
    }

    public void setThreshold(double d, double d2, int n) {
        if (d != -808080.0 && this.max > this.min) {
            double d3 = (d - (double)this.min) / (double)(this.max - this.min) * 255.0;
            double d4 = (d2 - (double)this.min) / (double)(this.max - this.min) * 255.0;
            super.setThreshold(d3, d4, n);
            this.minThreshold = d;
            this.maxThreshold = d2;
        } else {
            super.setThreshold(-808080.0, 0.0, 0);
        }
    }

    public void noise(double d) {
    }

    public void threshold(int n) {
    }

    public void autoThreshold() {
    }

    public void medianFilter() {
    }

    public void erode() {
    }

    public void dilate() {
    }

    public ShortProcessor(int n, int n2, short[] sArray, ColorModel colorModel) {
        this.width = n;
        this.height = n2;
        this.pixels = sArray;
        this.cm = colorModel;
        this.setRoi(null);
        this.findMinAndMax();
        this.fgColor = this.max;
    }

    public ShortProcessor(int n, int n2) {
        this(n, n2, new short[n * n2], null);
    }

    public ShortProcessor(int n, int n2, short[] sArray, ColorModel colorModel, boolean bl) {
        this(n, n2, sArray, colorModel);
    }

    public ShortProcessor(int n, int n2, boolean bl) {
        this(n, n2);
    }
}

