/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.process.ByteProcessor;
import ij.process.ByteStatistics;
import ij.process.ColorProcessor;
import ij.process.ColorStatistics;
import ij.process.FloatStatistics;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import ij.process.ShortStatistics;
import java.awt.Rectangle;

public class ImageStatistics
implements Measurements {
    public int[] histogram;
    public int pixelCount;
    public int mode;
    public double dmode;
    public double area;
    public double min;
    public double max;
    public double mean;
    public double stdDev;
    public double xCentroid;
    public double yCentroid;
    public double xCenterOfMass;
    public double yCenterOfMass;
    public double roiX;
    public double roiY;
    public double roiWidth;
    public double roiHeight;
    public double umean;
    public double histMin;
    public double histMax;
    public int maxCount;
    public int nBins = 256;
    public double binSize = 1.0;
    protected int width;
    protected int height;
    protected int rx;
    protected int ry;
    protected int rw;
    protected int rh;
    protected double pw;
    protected double ph;

    public static ImageStatistics getStatistics(ImageProcessor imageProcessor, int n, Calibration calibration) {
        if (imageProcessor instanceof ByteProcessor) {
            return new ByteStatistics(imageProcessor, n, calibration);
        }
        if (imageProcessor instanceof ShortProcessor) {
            return new ShortStatistics(imageProcessor, n, calibration);
        }
        if (imageProcessor instanceof ColorProcessor) {
            return new ColorStatistics(imageProcessor, n, calibration);
        }
        return new FloatStatistics(imageProcessor, n, calibration);
    }

    void getRawMinAndMax(int n, int n2) {
        int n3 = n;
        while (this.histogram[n3] == 0 && n3 < 255) {
            ++n3;
        }
        this.min = n3;
        int n4 = n2;
        while (this.histogram[n4] == 0 && n4 > 0) {
            --n4;
        }
        this.max = n4;
    }

    void getRawStatistics(int n, int n2) {
        double d = 0.0;
        double d2 = 0.0;
        int n3 = n;
        while (n3 <= n2) {
            int n4 = this.histogram[n3];
            this.pixelCount += n4;
            d += (double)(n3 * n4);
            double d3 = n3;
            d2 += d3 * d3 * (double)n4;
            if (n4 > this.maxCount) {
                this.maxCount = n4;
                this.mode = n3;
            }
            ++n3;
        }
        this.area = (double)this.pixelCount * this.pw * this.ph;
        this.umean = this.mean = d / (double)this.pixelCount;
        this.dmode = this.mode;
        this.calculateStdDev(this.pixelCount, d, d2);
        this.histMin = 0.0;
        this.histMax = 255.0;
    }

    void calculateStdDev(int n, double d, double d2) {
        if (n > 0) {
            this.stdDev = ((double)n * d2 - d * d) / (double)n;
            this.stdDev = this.stdDev > 0.0 ? Math.sqrt(this.stdDev / ((double)n - 1.0)) : 0.0;
        } else {
            this.stdDev = 0.0;
        }
    }

    void setup(ImageProcessor imageProcessor, Calibration calibration) {
        this.width = imageProcessor.getWidth();
        this.height = imageProcessor.getHeight();
        Rectangle rectangle = imageProcessor.getRoi();
        if (rectangle != null) {
            this.rx = rectangle.x;
            this.ry = rectangle.y;
            this.rw = rectangle.width;
            this.rh = rectangle.height;
        } else {
            this.rx = 0;
            this.ry = 0;
            this.rw = this.width;
            this.rh = this.height;
        }
        if (calibration != null) {
            this.pw = calibration.pixelWidth;
            this.ph = calibration.pixelHeight;
        } else {
            this.pw = 1.0;
            this.ph = 1.0;
        }
        this.roiX = (double)this.rx * this.pw;
        this.roiY = (double)this.ry * this.ph;
        this.roiWidth = (double)this.rw * this.pw;
        this.roiHeight = (double)this.rh * this.ph;
    }

    void getCentroid(ImageProcessor imageProcessor) {
        int[] nArray = imageProcessor.getMask();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.ry;
        int n5 = 0;
        while (n4 < this.ry + this.rh) {
            int n6 = n5 * this.rw;
            int n7 = this.rx;
            while (n7 < this.rx + this.rw) {
                if (nArray == null || nArray[n6++] == ImageProcessor.BLACK) {
                    ++n;
                    n2 += n7;
                    n3 += n4;
                }
                ++n7;
            }
            ++n4;
            ++n5;
        }
        this.xCentroid = ((double)n2 / (double)n + 0.5) * this.pw;
        this.yCentroid = ((double)n3 / (double)n + 0.5) * this.pw;
    }
}

