/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.gui.ProgressBar;
import ij.process.ColorProcessor;
import ij.process.TypeConverter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;

public abstract class ImageProcessor {
    public static final int BLACK = -16777216;
    public static final double NO_THRESHOLD = -808080.0;
    public static final int RED_LUT = 0;
    public static final int BLACK_AND_WHITE_LUT = 1;
    public static final int NO_LUT_UPDATE = 2;
    static final int INVERT = 0;
    static final int FILL = 1;
    static final int ADD = 2;
    static final int MULT = 3;
    static final int AND = 4;
    static final int OR = 5;
    static final int XOR = 6;
    static final int GAMMA = 7;
    static final int LOG = 8;
    static final int BLUR_MORE = 0;
    static final int FIND_EDGES = 1;
    static final int MEDIAN_FILTER = 2;
    static final int MIN = 3;
    static final int MAX = 4;
    static final double rWeight = 0.3;
    static final double gWeight = 0.59;
    static final double bWeight = 0.11;
    static Frame frame;
    int fgColor = 0;
    protected int lineWidth = 1;
    protected int cx;
    protected int cy;
    protected Font font;
    protected FontMetrics fontMetrics;
    ProgressBar progressBar;
    boolean pixelsModified;
    protected int width;
    protected int snapshotWidth;
    protected int height;
    protected int snapshotHeight;
    protected int roiX;
    protected int roiY;
    protected int roiWidth;
    protected int roiHeight;
    protected int xMin;
    protected int xMax;
    protected int yMin;
    protected int yMax;
    boolean newSnapshot = false;
    int[] mask = null;
    protected ColorModel baseCM;
    protected ColorModel cm;
    protected byte[] rLUT1;
    protected byte[] gLUT1;
    protected byte[] bLUT1;
    protected byte[] rLUT2;
    protected byte[] gLUT2;
    protected byte[] bLUT2;
    protected ImageProducer imageSource;
    protected boolean interpolate = false;
    protected double minThreshold = -808080.0;
    protected double maxThreshold = -808080.0;
    protected int histogramSize = 256;
    protected float[] cTable;
    protected boolean lutAnimation;
    protected boolean inversionTested = false;
    protected boolean invertedLut;

    protected void showProgress(double d) {
        if (this.progressBar != null) {
            this.progressBar.show(d);
        }
    }

    protected void hideProgress() {
        this.showProgress(1.0);
        this.newSnapshot = false;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public ColorModel getColorModel() {
        if (this.baseCM != null) {
            return this.baseCM;
        }
        return this.cm;
    }

    public void setColorModel(ColorModel colorModel) {
        if (!(this instanceof ColorProcessor) && !(colorModel instanceof IndexColorModel)) {
            throw new IllegalArgumentException("Must be IndexColorModel");
        }
        this.cm = colorModel;
        this.baseCM = null;
        this.rLUT2 = null;
        this.rLUT1 = null;
        this.imageSource = null;
        this.inversionTested = false;
        this.minThreshold = -808080.0;
    }

    protected void makeDefaultColorModel() {
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byte[] byArray3 = new byte[256];
        int n = 0;
        while (n < 256) {
            byArray[n] = (byte)n;
            byArray2[n] = (byte)n;
            byArray3[n] = (byte)n;
            ++n;
        }
        this.cm = new IndexColorModel(8, 256, byArray, byArray2, byArray3);
    }

    public void invertLut() {
        if (this.cm == null) {
            this.makeDefaultColorModel();
        }
        IndexColorModel indexColorModel = (IndexColorModel)this.cm;
        int n = indexColorModel.getMapSize();
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[n];
        byte[] byArray4 = new byte[n];
        byte[] byArray5 = new byte[n];
        byte[] byArray6 = new byte[n];
        indexColorModel.getReds(byArray);
        indexColorModel.getGreens(byArray2);
        indexColorModel.getBlues(byArray3);
        int n2 = 0;
        while (n2 < n) {
            byArray4[n2] = (byte)(byArray[n - n2 - 1] & 0xFF);
            byArray5[n2] = (byte)(byArray2[n - n2 - 1] & 0xFF);
            byArray6[n2] = (byte)(byArray3[n - n2 - 1] & 0xFF);
            ++n2;
        }
        this.cm = new IndexColorModel(8, n, byArray4, byArray5, byArray6);
        this.imageSource = null;
        this.baseCM = null;
        this.rLUT2 = null;
        this.rLUT1 = null;
        this.inversionTested = false;
    }

    public int getBestIndex(Color color) {
        if (this.cm == null) {
            this.makeDefaultColorModel();
        }
        IndexColorModel indexColorModel = (IndexColorModel)this.cm;
        int n = indexColorModel.getMapSize();
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[n];
        indexColorModel.getReds(byArray);
        indexColorModel.getGreens(byArray2);
        indexColorModel.getBlues(byArray3);
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        int n4 = color.getRed();
        int n5 = color.getGreen();
        int n6 = color.getBlue();
        int n7 = 0;
        while (n7 < n) {
            int n8 = byArray[n7] & 0xFF;
            int n9 = byArray2[n7] & 0xFF;
            int n10 = byArray3[n7] & 0xFF;
            int n11 = (n8 - n4) * (n8 - n4) + (n9 - n5) * (n9 - n5) + (n10 - n6) * (n10 - n6);
            if (n11 < n2) {
                n2 = n11;
                n3 = n7;
            }
            if ((double)n2 == 0.0) break;
            ++n7;
        }
        return n3;
    }

    public boolean isInvertedLut() {
        if (this.inversionTested) {
            return this.invertedLut;
        }
        this.inversionTested = true;
        if (this.cm == null) {
            this.invertedLut = false;
            return false;
        }
        if (this.rLUT2 != null) {
            this.invertedLut = true;
            int n = 1;
            while (n < 255) {
                if ((this.rLUT2[n - 1] & 0xFF) < (this.rLUT2[n] & 0xFF)) {
                    this.invertedLut = false;
                    break;
                }
                ++n;
            }
            return this.invertedLut;
        }
        IndexColorModel indexColorModel = (IndexColorModel)this.cm;
        int n = indexColorModel.getMapSize();
        if (n != 256) {
            this.invertedLut = false;
            return false;
        }
        byte[] byArray = new byte[n];
        indexColorModel.getReds(byArray);
        this.invertedLut = true;
        int n2 = byArray[0] & 0xFF;
        int n3 = 1;
        while (n3 < n) {
            int n4 = byArray[n3] & 0xFF;
            if (n2 < n4) {
                this.invertedLut = false;
                break;
            }
            n2 = n4;
            ++n3;
        }
        return this.invertedLut;
    }

    public abstract void setColor(Color var1);

    public void setColor(int n) {
        this.fgColor = n;
    }

    public abstract void setValue(double var1);

    public abstract double getMin();

    public abstract double getMax();

    public abstract void setMinAndMax(double var1, double var3);

    public void resetMinAndMax() {
    }

    public void setThreshold(double d, double d2, int n) {
        if (this instanceof ColorProcessor) {
            return;
        }
        this.minThreshold = d;
        this.maxThreshold = d2;
        if (d == -808080.0) {
            if (this.baseCM != null) {
                this.cm = this.baseCM;
                this.baseCM = null;
            }
            this.rLUT2 = null;
            this.rLUT1 = null;
            this.inversionTested = false;
            this.imageSource = null;
            return;
        }
        if (n == 2) {
            return;
        }
        if (this.rLUT1 == null) {
            if (this.cm == null) {
                this.makeDefaultColorModel();
            }
            this.baseCM = this.cm;
            IndexColorModel indexColorModel = (IndexColorModel)this.cm;
            this.rLUT1 = new byte[256];
            this.gLUT1 = new byte[256];
            this.bLUT1 = new byte[256];
            indexColorModel.getReds(this.rLUT1);
            indexColorModel.getGreens(this.gLUT1);
            indexColorModel.getBlues(this.bLUT1);
            this.rLUT2 = new byte[256];
            this.gLUT2 = new byte[256];
            this.bLUT2 = new byte[256];
        }
        int n2 = (int)d;
        int n3 = (int)d2;
        if (n == 0) {
            int n4 = 0;
            while (n4 < 256) {
                if (n4 >= n2 && n4 <= n3) {
                    this.rLUT2[n4] = -1;
                    this.gLUT2[n4] = 0;
                    this.bLUT2[n4] = 0;
                } else {
                    this.rLUT2[n4] = this.rLUT1[n4];
                    this.gLUT2[n4] = this.gLUT1[n4];
                    this.bLUT2[n4] = this.bLUT1[n4];
                }
                ++n4;
            }
        } else {
            int n5 = 0;
            while (n5 < 256) {
                if (n5 >= n2 && n5 <= n3) {
                    this.rLUT2[n5] = 0;
                    this.gLUT2[n5] = 0;
                    this.bLUT2[n5] = 0;
                } else {
                    this.rLUT2[n5] = -1;
                    this.gLUT2[n5] = -1;
                    this.bLUT2[n5] = -1;
                }
                ++n5;
            }
        }
        this.cm = new IndexColorModel(8, 256, this.rLUT2, this.gLUT2, this.bLUT2);
        this.imageSource = null;
    }

    public double getMinThreshold() {
        return this.minThreshold;
    }

    public double getMaxThreshold() {
        return this.maxThreshold;
    }

    public void setRoi(Rectangle rectangle) {
        if (rectangle == null) {
            this.setRoi(0, 0, this.width, this.height);
        } else {
            this.setRoi(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void setRoi(int n, int n2, int n3, int n4) {
        this.roiX = Math.max(0, n);
        this.roiWidth = Math.min(this.width, n + n3) - this.roiX;
        this.roiY = Math.max(0, n2);
        this.roiHeight = Math.min(this.height, n2 + n4) - this.roiY;
        this.xMin = Math.max(this.roiX, 1);
        this.xMax = Math.min(this.roiX + this.roiWidth - 1, this.width - 2);
        this.yMin = Math.max(this.roiY, 1);
        this.yMax = Math.min(this.roiY + this.roiHeight - 1, this.height - 2);
        this.mask = null;
    }

    public Rectangle getRoi() {
        return new Rectangle(this.roiX, this.roiY, this.roiWidth, this.roiHeight);
    }

    public void setMask(int[] nArray) {
        this.mask = nArray;
    }

    public int[] getMask() {
        return this.mask;
    }

    public void setProgressBar(ProgressBar progressBar) {
        this.progressBar = progressBar;
    }

    public void setInterpolate(boolean bl) {
        this.interpolate = bl;
    }

    public boolean isKillable() {
        return false;
    }

    private void process(int n, double d) {
        double d2 = 255.0 / Math.log(255.0);
        int[] nArray = new int[256];
        int n2 = 0;
        while (n2 < 256) {
            int n3;
            switch (n) {
                case 0: {
                    n3 = 255 - n2;
                    break;
                }
                case 1: {
                    n3 = this.fgColor;
                    break;
                }
                case 2: {
                    n3 = n2 + (int)d;
                    break;
                }
                case 3: {
                    n3 = (int)Math.round((double)n2 * d);
                    break;
                }
                case 4: {
                    n3 = n2 & (int)d;
                    break;
                }
                case 5: {
                    n3 = n2 | (int)d;
                    break;
                }
                case 6: {
                    n3 = n2 ^ (int)d;
                    break;
                }
                case 7: {
                    n3 = (int)(Math.exp(Math.log((double)n2 / 255.0) * d) * 255.0);
                    break;
                }
                case 8: {
                    if (n2 == 0) {
                        n3 = 0;
                        break;
                    }
                    n3 = (int)(Math.log(n2) * d2);
                    break;
                }
                default: {
                    n3 = n2;
                }
            }
            if (n3 < 0) {
                n3 = 0;
            }
            if (n3 > 255) {
                n3 = 255;
            }
            nArray[n2] = n3;
            ++n2;
        }
        this.applyTable(nArray);
    }

    public double[] getLine(double d, double d2, double d3, double d4) {
        double d5 = d3 - d;
        double d6 = d4 - d2;
        int n = (int)Math.round(Math.sqrt(d5 * d5 + d6 * d6));
        double d7 = d5 / (double)n;
        double d8 = d6 / (double)n;
        double[] dArray = new double[++n];
        double d9 = d;
        double d10 = d2;
        if (this.interpolate) {
            int n2 = 0;
            while (n2 < n) {
                dArray[n2] = this.getInterpolatedPixel(d9, d10);
                d9 += d7;
                d10 += d8;
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                dArray[n3] = this.getPixelValue((int)(d9 + 0.5), (int)(d10 + 0.5));
                d9 += d7;
                d10 += d8;
                ++n3;
            }
        }
        return dArray;
    }

    public void getRow(int n, int n2, int[] nArray, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            nArray[n4] = this.getPixel(n++, n2);
            ++n4;
        }
    }

    public void getColumn(int n, int n2, int[] nArray, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            nArray[n4] = this.getPixel(n, n2++);
            ++n4;
        }
    }

    public void putRow(int n, int n2, int[] nArray, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            this.putPixel(n++, n2, nArray[n4]);
            ++n4;
        }
    }

    public void putColumn(int n, int n2, int[] nArray, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            this.putPixel(n, n2++, nArray[n4]);
            ++n4;
        }
    }

    public void moveTo(int n, int n2) {
        this.cx = n;
        this.cy = n2;
    }

    public void setLineWidth(int n) {
        this.lineWidth = n;
        if (this.lineWidth < 1) {
            this.lineWidth = 1;
        }
    }

    public void lineTo(int n, int n2) {
        int n3 = n - this.cx;
        int n4 = n2 - this.cy;
        int n5 = n3 >= 0 ? n3 : -n3;
        int n6 = n4 >= 0 ? n4 : -n4;
        int n7 = n6 > n5 ? n6 : n5;
        double d = (double)n3 / (double)n7;
        double d2 = (double)n4 / (double)n7;
        double d3 = (double)this.cx + 0.5;
        double d4 = (double)this.cy + 0.5;
        ++n7;
        do {
            if (this.lineWidth == 1) {
                this.drawPixel((int)d3, (int)d4);
            } else if (this.lineWidth == 2) {
                this.drawDot2((int)d3, (int)d4);
            } else {
                this.drawDot((int)d3, (int)d4);
            }
            d3 += d;
            d4 += d2;
        } while (--n7 > 0);
        this.cx = n;
        this.cy = n2;
    }

    public void drawDot2(int n, int n2) {
        this.drawPixel(n, n2);
        this.drawPixel(n - 1, n2);
        this.drawPixel(n, n2 - 1);
        this.drawPixel(n - 1, n2 - 1);
    }

    public void drawDot(int n, int n2) {
        int n3 = this.lineWidth / 2;
        int n4 = n3 * n3 + 1;
        int n5 = -n3;
        while (n5 <= n3) {
            int n6 = -n3;
            while (n6 <= n3) {
                if (n5 * n5 + n6 * n6 <= n4) {
                    this.drawPixel(n + n5, n2 + n6);
                }
                ++n6;
            }
            ++n5;
        }
    }

    public void drawString(String string) {
        if (frame == null) {
            frame = new Frame();
            frame.pack();
            ((Component)frame).setBackground(Color.white);
        }
        if (this.font == null) {
            this.font = new Font("SansSerif", 0, 9);
        }
        if (this.fontMetrics == null) {
            this.fontMetrics = frame.getFontMetrics(this.font);
        }
        int n = this.fontMetrics.stringWidth(string);
        int n2 = this.fontMetrics.getHeight();
        Image image = frame.createImage(n, n2);
        Graphics graphics = image.getGraphics();
        graphics.setColor(Color.black);
        FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
        int n3 = fontMetrics.getHeight();
        int n4 = fontMetrics.getDescent();
        graphics.setFont(this.font);
        graphics.drawString(string, 0, n2 - n4);
        graphics.dispose();
        ColorProcessor colorProcessor = new ColorProcessor(image);
        this.setRoi(this.cx, this.cy - n2, n, n2);
        this.fill((int[])((ImageProcessor)colorProcessor).getPixels());
        this.setRoi(null);
        this.cy += n2;
    }

    public void setFont(Font font) {
        this.font = font;
        this.fontMetrics = null;
    }

    public int getStringWidth(String string) {
        if (this.font == null) {
            this.font = new Font("SansSerif", 0, 9);
        }
        if (this.fontMetrics == null) {
            if (frame == null) {
                frame = new Frame();
                frame.pack();
            }
            this.fontMetrics = frame.getFontMetrics(this.font);
        }
        return this.fontMetrics.stringWidth(string);
    }

    public ImageProducer getImageSource() {
        return this.imageSource;
    }

    public void smooth() {
        this.filter(0);
    }

    public void sharpen() {
        int[] nArray = new int[]{-1, -1, -1, -1, 12, -1, -1, -1, -1};
        this.convolve3x3(nArray);
    }

    public void findEdges() {
        this.filter(1);
    }

    public void flipVertical() {
        int[] nArray = new int[this.roiWidth];
        int[] nArray2 = new int[this.roiWidth];
        int n = 0;
        while (n < this.roiHeight / 2) {
            this.getRow(this.roiX, this.roiY + n, nArray, this.roiWidth);
            this.getRow(this.roiX, this.roiY + this.roiHeight - n - 1, nArray2, this.roiWidth);
            this.putRow(this.roiX, this.roiY + n, nArray2, this.roiWidth);
            this.putRow(this.roiX, this.roiY + this.roiHeight - n - 1, nArray, this.roiWidth);
            ++n;
        }
        this.newSnapshot = false;
    }

    public void flipHorizontal() {
        int[] nArray = new int[this.roiHeight];
        int[] nArray2 = new int[this.roiHeight];
        int n = 0;
        while (n < this.roiWidth / 2) {
            this.getColumn(this.roiX + n, this.roiY, nArray, this.roiHeight);
            this.getColumn(this.roiX + this.roiWidth - n - 1, this.roiY, nArray2, this.roiHeight);
            this.putColumn(this.roiX + n, this.roiY, nArray2, this.roiHeight);
            this.putColumn(this.roiX + this.roiWidth - n - 1, this.roiY, nArray, this.roiHeight);
            ++n;
        }
        this.newSnapshot = false;
    }

    public ImageProcessor rotateRight() {
        int n = this.height;
        int n2 = this.width;
        ImageProcessor imageProcessor = this.createProcessor(n, n2);
        int[] nArray = new int[this.width];
        int n3 = 0;
        while (n3 < this.height) {
            this.getRow(0, n3, nArray, this.width);
            imageProcessor.putColumn(n - n3 - 1, 0, nArray, n2);
            ++n3;
        }
        return imageProcessor;
    }

    public ImageProcessor rotateLeft() {
        int n = this.height;
        int n2 = this.width;
        ImageProcessor imageProcessor = this.createProcessor(n, n2);
        int[] nArray = new int[this.width];
        int[] nArray2 = new int[this.width];
        int n3 = 0;
        while (n3 < this.height) {
            this.getRow(0, n3, nArray, this.width);
            int n4 = 0;
            while (n4 < this.width) {
                nArray2[n4] = nArray[this.width - n4 - 1];
                ++n4;
            }
            imageProcessor.putColumn(n3, 0, nArray2, n2);
            ++n3;
        }
        return imageProcessor;
    }

    public void insert(ImageProcessor imageProcessor, int n, int n2) {
        this.copyBits(imageProcessor, n, n2, 0);
    }

    public String toString() {
        return "width=" + this.width + ", height=" + this.height + ", min=" + this.getMin() + ", max=" + this.getMax() + ", v=" + this.getPixel(0, 0);
    }

    public void fill() {
        this.process(1, 0.0);
    }

    public abstract void fill(int[] var1);

    public void setCalibrationTable(float[] fArray) {
        this.cTable = fArray;
    }

    public void setHistogramSize(int n) {
        this.histogramSize = n;
    }

    public int getHistogramSize() {
        return this.histogramSize;
    }

    public abstract Object getPixels();

    public abstract Object getPixelsCopy();

    public abstract int getPixel(int var1, int var2);

    public abstract double getInterpolatedPixel(double var1, double var3);

    public abstract void putPixel(int var1, int var2, int var3);

    public abstract float getPixelValue(int var1, int var2);

    public abstract void putPixelValue(int var1, int var2, double var3);

    public abstract void drawPixel(int var1, int var2);

    public abstract void setPixels(Object var1);

    public abstract void copyBits(ImageProcessor var1, int var2, int var3, int var4);

    public abstract void applyTable(int[] var1);

    public void invert() {
        this.process(0, 0.0);
    }

    public void add(int n) {
        this.process(2, n);
    }

    public void multiply(double d) {
        this.process(3, d);
    }

    public void and(int n) {
        this.process(4, n);
    }

    public void or(int n) {
        this.process(5, n);
    }

    public void xor(int n) {
        this.process(6, n);
    }

    public void gamma(double d) {
        this.process(7, d);
    }

    public void log() {
        this.process(8, 0.0);
    }

    public abstract Image createImage();

    public abstract ImageProcessor createProcessor(int var1, int var2);

    public abstract void snapshot();

    public abstract void reset();

    public abstract void reset(int[] var1);

    public abstract void convolve3x3(int[] var1);

    public abstract void filter(int var1);

    public abstract void medianFilter();

    public abstract void noise(double var1);

    public abstract ImageProcessor crop();

    public ImageProcessor duplicate() {
        Rectangle rectangle = this.getRoi();
        this.setRoi(null);
        ImageProcessor imageProcessor = this.crop();
        this.setRoi(rectangle);
        return imageProcessor;
    }

    public abstract void scale(double var1, double var3);

    public abstract ImageProcessor resize(int var1, int var2);

    public abstract void rotate(double var1);

    public abstract void autoThreshold();

    public abstract int[] getHistogram();

    public abstract void erode();

    public abstract void dilate();

    public void setLutAnimation(boolean bl) {
        this.lutAnimation = bl;
    }

    public ImageProcessor convertToByte(boolean bl) {
        TypeConverter typeConverter = new TypeConverter(this, bl);
        return typeConverter.convertToByte();
    }

    public ImageProcessor convertToShort(boolean bl) {
        TypeConverter typeConverter = new TypeConverter(this, bl);
        return typeConverter.convertToShort();
    }

    public ImageProcessor convertToFloat() {
        TypeConverter typeConverter = new TypeConverter(this, false);
        return typeConverter.convertToFloat(this.cTable);
    }

    public ImageProcessor convertToRGB() {
        TypeConverter typeConverter = new TypeConverter(this, true);
        return typeConverter.convertToRGB();
    }
}

