/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.measure.Calibration;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;

public class FloatStatistics
extends ImageStatistics {
    void getStatistics(ImageProcessor imageProcessor) {
        double d;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        float[] fArray = (float[])imageProcessor.getPixels();
        this.nBins = imageProcessor.getHistogramSize();
        this.histogram = new int[this.nBins];
        double d2 = 0.0;
        double d3 = 0.0;
        int[] nArray = imageProcessor.getMask();
        double d4 = Double.MAX_VALUE;
        double d5 = -1.7976931348623157E308;
        if (nArray != null) {
            n5 = this.ry;
            n4 = 0;
            while (n5 < this.ry + this.rh) {
                n3 = n5 * this.width + this.rx;
                n2 = n4 * this.rw;
                n = this.rx;
                while (n < this.rx + this.rw) {
                    if (nArray[n2++] == ImageProcessor.BLACK) {
                        d = fArray[n3];
                        if (d < d4) {
                            d4 = d;
                        }
                        if (d > d5) {
                            d5 = d;
                        }
                    }
                    ++n3;
                    ++n;
                }
                ++n5;
                ++n4;
            }
        } else {
            n5 = this.ry;
            while (n5 < this.ry + this.rh) {
                n4 = n5 * this.width + this.rx;
                n3 = this.rx;
                while (n3 < this.rx + this.rw) {
                    int n6 = n4++;
                    d = fArray[n6];
                    if (d < d4) {
                        d4 = d;
                    }
                    if (d > d5) {
                        d5 = d;
                    }
                    ++n3;
                }
                ++n5;
            }
        }
        this.min = d4;
        this.max = d5;
        this.histMin = this.min;
        this.histMax = this.max;
        this.binSize = (this.histMax - this.histMin) / (double)this.nBins;
        double d6 = (double)(this.nBins - 1) / (this.histMax - this.histMin);
        if (nArray != null) {
            this.pixelCount = 0;
            n3 = this.ry;
            n2 = 0;
            while (n3 < this.ry + this.rh) {
                n = n3 * this.width + this.rx;
                int n7 = n2 * this.rw;
                int n8 = this.rx;
                while (n8 < this.rx + this.rw) {
                    if (nArray[n7++] == ImageProcessor.BLACK) {
                        d = fArray[n];
                        ++this.pixelCount;
                        d2 += d;
                        d3 += d * d;
                        int n9 = (int)(d6 * (d - this.histMin));
                        this.histogram[n9] = this.histogram[n9] + 1;
                    }
                    ++n;
                    ++n8;
                }
                ++n3;
                ++n2;
            }
            this.min = d4;
            this.max = d5;
        } else {
            n3 = this.ry;
            while (n3 < this.ry + this.rh) {
                n2 = n3 * this.width + this.rx;
                n = this.rx;
                while (n < this.rx + this.rw) {
                    d = fArray[n2++];
                    d2 += d;
                    d3 += d * d;
                    int n10 = (int)(d6 * (d - this.histMin));
                    this.histogram[n10] = this.histogram[n10] + 1;
                    ++n;
                }
                ++n3;
            }
            this.pixelCount = this.rw * this.rh;
        }
        this.area = (double)this.pixelCount * this.pw * this.ph;
        this.mean = d2 / (double)this.pixelCount;
        this.calculateStdDev(this.pixelCount, d2, d3);
    }

    void getMode() {
        this.maxCount = 0;
        int n = 0;
        while (n < this.nBins) {
            int n2 = this.histogram[n];
            if (n2 > this.maxCount) {
                this.maxCount = n2;
                this.mode = n;
            }
            ++n;
        }
        this.dmode = this.histMin + (double)this.mode * this.binSize + this.binSize / 2.0;
    }

    void getCenterOfMass(ImageProcessor imageProcessor) {
        float[] fArray = (float[])imageProcessor.getPixels();
        int[] nArray = imageProcessor.getMask();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n = this.ry;
        int n2 = 0;
        while (n < this.ry + this.rh) {
            int n3 = n * this.width + this.rx;
            int n4 = n2 * this.rw;
            int n5 = this.rx;
            while (n5 < this.rx + this.rw) {
                if (nArray == null || nArray[n4++] == ImageProcessor.BLACK) {
                    double d4 = (double)fArray[n3] + Double.MIN_VALUE;
                    d += d4;
                    d2 += (double)n5 * d4;
                    d3 += (double)n * d4;
                }
                ++n3;
                ++n5;
            }
            ++n;
            ++n2;
        }
        this.xCenterOfMass = (d2 / d + 0.5) * this.pw;
        this.yCenterOfMass = (d3 / d + 0.5) * this.ph;
    }

    public FloatStatistics(ImageProcessor imageProcessor) {
        this(imageProcessor, 27, null);
    }

    public FloatStatistics(ImageProcessor imageProcessor, int n, Calibration calibration) {
        this.width = imageProcessor.getWidth();
        this.height = imageProcessor.getHeight();
        this.setup(imageProcessor, calibration);
        this.getStatistics(imageProcessor);
        if ((n & 8) != 0) {
            this.getMode();
        }
        if ((n & 0x20) != 0) {
            this.getCentroid(imageProcessor);
        }
        if ((n & 0x40) != 0) {
            this.getCenterOfMass(imageProcessor);
        }
    }
}

