/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.process.FloatBlitter;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.util.Random;

public class FloatProcessor
extends ImageProcessor {
    private float min;
    private float max;
    private float snapshotMin;
    private float snapshotMax;
    private float[] pixels;
    private byte[] pixels8;
    private float[] snapshotPixels = null;
    private byte[] LUT = null;
    private float fillColor = Float.MAX_VALUE;
    private boolean fixedScale = false;

    public void findMinAndMax() {
        if (this.fixedScale) {
            return;
        }
        this.min = Float.MAX_VALUE;
        this.max = -3.4028235E38f;
        int n = 0;
        while (n < this.width * this.height) {
            float f = this.pixels[n];
            if (f < this.min) {
                this.min = f;
            }
            if (f > this.max) {
                this.max = f;
            }
            ++n;
        }
        this.pixelsModified = true;
        this.hideProgress();
    }

    public void setMinAndMax(double d, double d2) {
        if (d == 0.0 && d2 == 0.0) {
            this.resetMinAndMax();
            return;
        }
        this.min = (float)d;
        this.max = (float)d2;
        this.fixedScale = true;
        this.setThreshold(-808080.0, 0.0, 0);
    }

    public void resetMinAndMax() {
        this.fixedScale = false;
        this.findMinAndMax();
        this.setThreshold(-808080.0, 0.0, 0);
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public Image createImage() {
        boolean bl = !this.lutAnimation || this.pixels8 == null;
        this.lutAnimation = false;
        if (this.pixels8 == null) {
            this.pixels8 = new byte[this.width * this.height];
        }
        if (this.cm == null) {
            this.makeDefaultColorModel();
        }
        float f = 255.0f / (this.max - this.min);
        if (bl) {
            int n = 0;
            while (n < this.width * this.height) {
                int n2;
                float f2 = this.pixels[n] - this.min;
                if (f2 < 0.0f) {
                    f2 = 0.0f;
                }
                if ((n2 = (int)(f2 * f)) > 255) {
                    n2 = 255;
                }
                this.pixels8[n] = (byte)n2;
                ++n;
            }
        }
        MemoryImageSource memoryImageSource = new MemoryImageSource(this.width, this.height, this.cm, this.pixels8, 0, this.width);
        return Toolkit.getDefaultToolkit().createImage(memoryImageSource);
    }

    public ImageProcessor createProcessor(int n, int n2) {
        FloatProcessor floatProcessor = new FloatProcessor(n, n2, new float[n * n2], this.getColorModel());
        ((ImageProcessor)floatProcessor).setMinAndMax(this.getMin(), this.getMax());
        return floatProcessor;
    }

    public void snapshot() {
        this.snapshotWidth = this.width;
        this.snapshotHeight = this.height;
        this.snapshotMin = this.min;
        this.snapshotMax = this.max;
        if (this.snapshotPixels == null || this.snapshotPixels != null && this.snapshotPixels.length != this.pixels.length) {
            this.snapshotPixels = new float[this.width * this.height];
        }
        System.arraycopy(this.pixels, 0, this.snapshotPixels, 0, this.width * this.height);
        this.pixelsModified = false;
        this.newSnapshot = true;
    }

    public void reset() {
        if (this.snapshotPixels == null) {
            return;
        }
        this.min = this.snapshotMin;
        this.max = this.snapshotMax;
        System.arraycopy(this.snapshotPixels, 0, this.pixels, 0, this.width * this.height);
    }

    public void reset(int[] nArray) {
        if (nArray == null || this.snapshotPixels == null || nArray.length != this.roiWidth * this.roiHeight) {
            return;
        }
        int n = this.roiY;
        int n2 = 0;
        while (n < this.roiY + this.roiHeight) {
            int n3 = n * this.width + this.roiX;
            int n4 = n2 * this.roiWidth;
            int n5 = this.roiX;
            while (n5 < this.roiX + this.roiWidth) {
                if (nArray[n4++] != -16777216) {
                    this.pixels[n3] = this.snapshotPixels[n3];
                }
                ++n3;
                ++n5;
            }
            ++n;
            ++n2;
        }
        this.newSnapshot = true;
    }

    public int getPixel(int n, int n2) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            return Float.floatToIntBits(this.pixels[n2 * this.width + n]);
        }
        return 0;
    }

    public double getInterpolatedPixel(double d, double d2) {
        int n = (int)d;
        int n2 = (int)d2;
        if (n >= 0 && n + 1 < this.width && n2 >= 0 && n2 + 1 < this.height) {
            return this.getInterpolatedPixel(d, d2, this.pixels);
        }
        return 0.0;
    }

    public void putPixel(int n, int n2, int n3) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            this.pixels[n2 * this.width + n] = Float.intBitsToFloat(n3);
        }
    }

    public void putPixelValue(int n, int n2, double d) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            this.pixels[n2 * this.width + n] = (float)d;
        }
    }

    public float getPixelValue(int n, int n2) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            return this.pixels[n2 * this.width + n];
        }
        return 0.0f;
    }

    public void drawPixel(int n, int n2) {
        this.putPixel(n, n2, Float.floatToIntBits(this.fillColor));
    }

    public Object getPixels() {
        return this.pixels;
    }

    public Object getPixelsCopy() {
        if (this.newSnapshot) {
            return this.snapshotPixels;
        }
        float[] fArray = new float[this.width * this.height];
        System.arraycopy(this.pixels, 0, fArray, 0, this.width * this.height);
        return fArray;
    }

    public void setPixels(Object object) {
        this.pixels = (float[])object;
        this.snapshotPixels = null;
    }

    public void copyBits(ImageProcessor imageProcessor, int n, int n2, int n3) {
        if (!(imageProcessor instanceof FloatProcessor)) {
            throw new IllegalArgumentException("32-bit (real) image required");
        }
        new FloatBlitter(this).copyBits(imageProcessor, n, n2, n3);
    }

    public void applyTable(int[] nArray) {
    }

    private float[] getCopyOfPixels() {
        if (this.pixelsModified) {
            float[] fArray = new float[this.width * this.height];
            System.arraycopy(this.pixels, 0, fArray, 0, this.width * this.height);
            return fArray;
        }
        return this.snapshotPixels;
    }

    private void process(int n, double d) {
        float f = (float)d;
        int n2 = this.roiY;
        while (n2 < this.roiY + this.roiHeight) {
            int n3 = n2 * this.width + this.roiX;
            int n4 = this.roiX;
            while (n4 < this.roiX + this.roiWidth) {
                float f2;
                float f3 = this.pixels[n3];
                switch (n) {
                    case 0: {
                        f2 = this.max - (f3 - this.min);
                        break;
                    }
                    case 1: {
                        f2 = this.fillColor;
                        break;
                    }
                    case 2: {
                        f2 = f3 + f;
                        break;
                    }
                    case 3: {
                        f2 = f3 * f;
                        break;
                    }
                    case 7: {
                        if (f3 <= 0.0f) {
                            f2 = 0.0f;
                            break;
                        }
                        f2 = (float)Math.exp((double)f * Math.log(f3));
                        break;
                    }
                    case 8: {
                        if (f3 <= 0.0f) {
                            f2 = 0.0f;
                            break;
                        }
                        f2 = (float)Math.log(f3);
                        break;
                    }
                    default: {
                        f2 = f3;
                    }
                }
                this.pixels[n3++] = f2;
                ++n4;
            }
            if (n2 % 20 == 0) {
                this.showProgress((double)(n2 - this.roiY) / (double)this.roiHeight);
            }
            ++n2;
        }
        this.findMinAndMax();
    }

    public void invert() {
        this.process(0, 0.0);
    }

    public void add(int n) {
        this.process(2, n);
    }

    public void multiply(double d) {
        this.process(3, d);
    }

    public void and(int n) {
    }

    public void or(int n) {
    }

    public void xor(int n) {
    }

    public void gamma(double d) {
        this.process(7, d);
    }

    public void log() {
        this.process(8, 0.0);
    }

    public void fill() {
        this.process(1, 0.0);
    }

    public void fill(int[] nArray) {
        int n = this.roiY;
        int n2 = 0;
        while (n < this.roiY + this.roiHeight) {
            int n3 = n * this.width + this.roiX;
            int n4 = n2 * this.roiWidth;
            int n5 = this.roiX;
            while (n5 < this.roiX + this.roiWidth) {
                if (nArray[n4++] == -16777216) {
                    this.pixels[n3] = this.fillColor;
                }
                ++n3;
                ++n5;
            }
            ++n;
            ++n2;
        }
    }

    public void convolve3x3(int[] nArray) {
        float f = nArray[0];
        float f2 = nArray[1];
        float f3 = nArray[2];
        float f4 = nArray[3];
        float f5 = nArray[4];
        float f6 = nArray[5];
        float f7 = nArray[6];
        float f8 = nArray[7];
        float f9 = nArray[8];
        float f10 = 0.0f;
        int n = 0;
        while (n < nArray.length) {
            f10 += (float)nArray[n];
            ++n;
        }
        if (f10 == 0.0f) {
            f10 = 1.0f;
        }
        if ((n = this.roiHeight / 25) < 1) {
            n = 1;
        }
        float[] fArray = (float[])this.getPixelsCopy();
        int n2 = this.width;
        int n3 = this.yMin;
        while (n3 <= this.yMax) {
            int n4 = this.xMin + n3 * this.width;
            float f11 = 0.0f;
            float f12 = fArray[n4 - n2 - 1];
            float f13 = fArray[n4 - n2];
            float f14 = 0.0f;
            float f15 = fArray[n4 - 1];
            float f16 = fArray[n4];
            float f17 = 0.0f;
            float f18 = fArray[n4 + n2 - 1];
            float f19 = fArray[n4 + n2];
            int n5 = this.xMin;
            while (n5 <= this.xMax) {
                f11 = f12;
                f12 = f13;
                f13 = fArray[n4 - n2 + 1];
                f14 = f15;
                f15 = f16;
                f16 = fArray[n4 + 1];
                f17 = f18;
                f18 = f19;
                f19 = fArray[n4 + n2 + 1];
                float f20 = f * f11 + f2 * f12 + f3 * f13 + f4 * f14 + f5 * f15 + f6 * f16 + f7 * f17 + f8 * f18 + f9 * f19;
                this.pixels[n4++] = f20 /= f10;
                ++n5;
            }
            if (n3 % n == 0) {
                this.showProgress((double)(n3 - this.roiY) / (double)this.roiHeight);
            }
            ++n3;
        }
        this.hideProgress();
    }

    public void filter(int n) {
        int n2 = this.roiHeight / 25;
        if (n2 < 1) {
            n2 = 1;
        }
        float[] fArray = (float[])this.getPixelsCopy();
        int n3 = this.width;
        int n4 = this.yMin;
        while (n4 <= this.yMax) {
            int n5 = this.xMin + n4 * this.width;
            float f = 0.0f;
            float f2 = fArray[n5 - n3 - 1];
            float f3 = fArray[n5 - n3];
            float f4 = 0.0f;
            float f5 = fArray[n5 - 1];
            float f6 = fArray[n5];
            float f7 = 0.0f;
            float f8 = fArray[n5 + n3 - 1];
            float f9 = fArray[n5 + n3];
            int n6 = this.xMin;
            while (n6 <= this.xMax) {
                f = f2;
                f2 = f3;
                f3 = fArray[n5 - n3 + 1];
                f4 = f5;
                f5 = f6;
                f6 = fArray[n5 + 1];
                f7 = f8;
                f8 = f9;
                f9 = fArray[n5 + n3 + 1];
                switch (n) {
                    case 0: {
                        this.pixels[n5++] = (f + f2 + f3 + f4 + f5 + f6 + f7 + f8 + f9) / 9.0f;
                        break;
                    }
                    case 1: {
                        float f10 = f + 2.0f * f2 + f3 - f7 - 2.0f * f8 - f9;
                        float f11 = f + 2.0f * f4 + f7 - f3 - 2.0f * f6 - f9;
                        this.pixels[n5++] = (float)Math.sqrt(f10 * f10 + f11 * f11);
                        break;
                    }
                }
                ++n6;
            }
            if (n4 % n2 == 0) {
                this.showProgress((double)(n4 - this.roiY) / (double)this.roiHeight);
            }
            ++n4;
        }
        if (n == 0) {
            this.hideProgress();
        } else {
            this.findMinAndMax();
        }
    }

    public void rotate(double d) {
        float[] fArray = (float[])this.getPixelsCopy();
        double d2 = (double)this.roiX + (double)this.roiWidth / 2.0;
        double d3 = (double)this.roiY + (double)this.roiHeight / 2.0;
        int n = this.roiX + this.roiWidth - 1;
        double d4 = -d / 57.29577951308232;
        double d5 = Math.cos(d4);
        double d6 = Math.sin(d4);
        double d7 = d3 * d6 - d2 * d5;
        double d8 = -d2 * d6 - d3 * d5;
        int n2 = this.roiY;
        while (n2 < this.roiY + this.roiHeight) {
            int n3 = n2 * this.width + this.roiX;
            double d9 = d7 - (double)n2 * d6 + d2;
            double d10 = d8 + (double)n2 * d5 + d3;
            int n4 = this.roiX;
            while (n4 <= n) {
                double d11 = (double)n4 * d5 + d9;
                double d12 = (double)n4 * d6 + d10;
                this.pixels[n3++] = d11 >= 0.0 && d11 < (double)this.width && d12 >= 0.0 && d12 < (double)this.height ? (this.interpolate ? (float)(this.getInterpolatedPixel(d11, d12, fArray) + 0.5) : fArray[this.width * (int)d12 + (int)d11]) : 0.0f;
                ++n4;
            }
            if (n2 % 20 == 0) {
                this.showProgress((double)(n2 - this.roiY) / (double)this.roiHeight);
            }
            ++n2;
        }
        this.hideProgress();
    }

    public void noise(double d) {
        Random random = new Random();
        int n = this.roiY;
        while (n < this.roiY + this.roiHeight) {
            int n2 = n * this.width + this.roiX;
            int n3 = this.roiX;
            while (n3 < this.roiX + this.roiWidth) {
                float f = (float)(random.nextGaussian() * d);
                this.pixels[n2] = this.pixels[n2] + f;
                ++n2;
                ++n3;
            }
            if (n % 20 == 0) {
                this.showProgress((double)(n - this.roiY) / (double)this.roiHeight);
            }
            ++n;
        }
        this.findMinAndMax();
    }

    public ImageProcessor crop() {
        ImageProcessor imageProcessor = this.createProcessor(this.roiWidth, this.roiHeight);
        float[] fArray = (float[])imageProcessor.getPixels();
        int n = this.roiY;
        while (n < this.roiY + this.roiHeight) {
            int n2 = (n - this.roiY) * this.roiWidth;
            int n3 = n * this.width + this.roiX;
            int n4 = 0;
            while (n4 < this.roiWidth) {
                fArray[n2++] = this.pixels[n3++];
                ++n4;
            }
            ++n;
        }
        return imageProcessor;
    }

    public void scale(double d, double d2) {
        int n;
        int n2;
        int n3;
        int n4;
        double d3 = (double)this.roiX + (double)this.roiWidth / 2.0;
        double d4 = (double)this.roiY + (double)this.roiHeight / 2.0;
        if (d > 1.0 && d2 > 1.0) {
            n4 = (int)(d3 - (d3 - (double)this.roiX) * d);
            if (n4 < 0) {
                n4 = 0;
            }
            if ((n3 = n4 + (int)((double)this.roiWidth * d) - 1) >= this.width) {
                n3 = this.width - 1;
            }
            if ((n2 = (int)(d4 - (d4 - (double)this.roiY) * d2)) < 0) {
                n2 = 0;
            }
            if ((n = n2 + (int)((double)this.roiHeight * d2) - 1) >= this.height) {
                n = this.height - 1;
            }
        } else {
            n4 = this.roiX;
            n3 = this.roiX + this.roiWidth - 1;
            n2 = this.roiY;
            n = this.roiY + this.roiHeight - 1;
        }
        float[] fArray = (float[])this.getPixelsCopy();
        boolean bl = d < 1.0 || d2 < 1.0;
        int n5 = n2;
        while (n5 <= n) {
            double d5 = ((double)n5 - d4) / d2 + d4;
            int n6 = (int)d5;
            int n7 = n5 * this.width + n4;
            int n8 = this.width * (int)d5;
            int n9 = n4;
            while (n9 <= n3) {
                double d6 = ((double)n9 - d3) / d + d3;
                int n10 = (int)d6;
                this.pixels[n7++] = bl && (n10 < n4 || n10 > n3 || n6 < n2 || d5 > (double)n) ? this.min : (this.interpolate ? (float)this.getInterpolatedPixel(d6, d5, fArray) : fArray[n8 + n10]);
                ++n9;
            }
            if (n5 % 20 == 0) {
                this.showProgress((double)(n5 - n2) / (double)this.height);
            }
            ++n5;
        }
        this.hideProgress();
    }

    private final double getInterpolatedPixel(double d, double d2, float[] fArray) {
        int n = (int)d;
        int n2 = (int)d2;
        double d3 = d - (double)n;
        double d4 = d2 - (double)n2;
        int n3 = n2 * this.width + n;
        double d5 = fArray[n3];
        if (n >= this.width - 1 || n2 >= this.height - 1) {
            return d5;
        }
        double d6 = fArray[n3 + 1];
        double d7 = fArray[n3 + this.width + 1];
        double d8 = fArray[n3 + this.width];
        double d9 = d8 + d3 * (d7 - d8);
        double d10 = d5 + d3 * (d6 - d5);
        return d10 + d4 * (d9 - d10);
    }

    public ImageProcessor resize(int n, int n2) {
        double d = (double)this.roiX + (double)this.roiWidth / 2.0;
        double d2 = (double)this.roiY + (double)this.roiHeight / 2.0;
        double d3 = (double)n / 2.0;
        double d4 = (double)n2 / 2.0;
        double d5 = (double)n / (double)this.roiWidth;
        double d6 = (double)n2 / (double)this.roiHeight;
        ImageProcessor imageProcessor = this.createProcessor(n, n2);
        float[] fArray = (float[])imageProcessor.getPixels();
        double d7 = 0.0;
        int n3 = 0;
        while (n3 <= n2 - 1) {
            int n4 = this.width * (int)d7;
            int n5 = n3 * n;
            d7 = ((double)n3 - d4) / d6 + d2;
            int n6 = 0;
            while (n6 <= n - 1) {
                double d8 = ((double)n6 - d3) / d5 + d;
                fArray[n5++] = this.interpolate ? (float)this.getInterpolatedPixel(d8, d7, this.pixels) : this.pixels[n4 + (int)d8];
                ++n6;
            }
            if (n3 % 20 == 0) {
                this.showProgress((double)n3 / (double)n2);
            }
            ++n3;
        }
        this.hideProgress();
        return imageProcessor;
    }

    public void setColor(Color color) {
        int n = this.getBestIndex(color);
        if (n > 0 && this.getMin() == 0.0 && this.getMax() == 0.0) {
            this.fillColor = n;
            this.setMinAndMax(0.0, 255.0);
        } else {
            this.fillColor = n == 0 && this.getMin() > 0.0 && (color.getRGB() & 0xFFFFFF) == 0 ? 0.0f : (float)((double)this.min + (double)(this.max - this.min) * ((double)n / 255.0));
        }
    }

    public void setValue(double d) {
        this.fillColor = (float)d;
    }

    public void setThreshold(double d, double d2, int n) {
        if (d != -808080.0 && this.max > this.min) {
            double d3 = (d - (double)this.min) / (double)(this.max - this.min) * 255.0;
            double d4 = (d2 - (double)this.min) / (double)(this.max - this.min) * 255.0;
            super.setThreshold(d3, d4, n);
            this.minThreshold = d;
            this.maxThreshold = d2;
        } else {
            super.setThreshold(-808080.0, 0.0, 0);
        }
    }

    public void threshold(int n) {
    }

    public void autoThreshold() {
    }

    public void medianFilter() {
    }

    public int[] getHistogram() {
        return null;
    }

    public void erode() {
    }

    public void dilate() {
    }

    public FloatProcessor(int n, int n2, float[] fArray, ColorModel colorModel) {
        this.width = n;
        this.height = n2;
        this.pixels = fArray;
        this.cm = colorModel;
        this.setRoi(null);
        this.findMinAndMax();
    }

    public FloatProcessor(int n, int n2) {
        this(n, n2, new float[n * n2], null);
    }
}

