/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;

public class ByteStatistics
extends ImageStatistics {
    void getCalibratedStatistics(int n, int n2, float[] fArray) {
        double d = 0.0;
        double d2 = 0.0;
        int n3 = 0;
        int n4 = n;
        while (n4 <= n2) {
            int n5 = this.histogram[n4];
            this.pixelCount += n5;
            double d3 = fArray[n4];
            d += d3 * (double)n5;
            n3 += n4 * n5;
            d2 += d3 * d3 * (double)n5;
            if (n5 > this.maxCount) {
                this.maxCount = n5;
                this.mode = n4;
            }
            ++n4;
        }
        this.area = (double)this.pixelCount * this.pw * this.ph;
        this.mean = d / (double)this.pixelCount;
        this.umean = (double)n3 / (double)this.pixelCount;
        this.dmode = fArray[this.mode];
        this.calculateStdDev(this.pixelCount, d, d2);
        this.histMin = 0.0;
        this.histMax = 255.0;
    }

    void getCentroid(ImageProcessor imageProcessor, int n, int n2) {
        byte[] byArray = (byte[])imageProcessor.getPixels();
        int[] nArray = imageProcessor.getMask();
        boolean bl = n > 0 || n2 < 255;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = this.ry;
        int n7 = 0;
        while (n6 < this.ry + this.rh) {
            int n8 = n6 * this.width + this.rx;
            int n9 = n7 * this.rw;
            int n10 = this.rx;
            while (n10 < this.rx + this.rw) {
                if (nArray == null || nArray[n9++] == ImageProcessor.BLACK) {
                    if (bl) {
                        int n11 = byArray[n8] & 0xFF;
                        if (n11 >= n && n11 <= n2) {
                            ++n3;
                            n4 += n10;
                            n5 += n6;
                        }
                    } else {
                        ++n3;
                        n4 += n10;
                        n5 += n6;
                    }
                }
                ++n8;
                ++n10;
            }
            ++n6;
            ++n7;
        }
        this.xCentroid = ((double)n4 / (double)n3 + 0.5) * this.pw;
        this.yCentroid = ((double)n5 / (double)n3 + 0.5) * this.ph;
    }

    void getCenterOfMass(ImageProcessor imageProcessor, int n, int n2, float[] fArray) {
        byte[] byArray = (byte[])imageProcessor.getPixels();
        int[] nArray = imageProcessor.getMask();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n3 = this.ry;
        int n4 = 0;
        while (n3 < this.ry + this.rh) {
            int n5 = n3 * this.width + this.rx;
            int n6 = n4 * this.rw;
            int n7 = this.rx;
            while (n7 < this.rx + this.rw) {
                int n8;
                if ((nArray == null || nArray[n6++] == ImageProcessor.BLACK) && (n8 = byArray[n5] & 0xFF) >= n && n8 <= n2) {
                    double d4 = (double)(fArray != null ? fArray[n8] : (float)n8) + Double.MIN_VALUE;
                    d += d4;
                    d2 += (double)n7 * d4;
                    d3 += (double)n3 * d4;
                }
                ++n5;
                ++n7;
            }
            ++n3;
            ++n4;
        }
        this.xCenterOfMass = (d2 / d + 0.5) * this.pw;
        this.yCenterOfMass = (d3 / d + 0.5) * this.ph;
    }

    void getCalibratedMinAndMax(int n, int n2, float[] fArray) {
        this.min = Double.MAX_VALUE;
        this.max = -1.7976931348623157E308;
        double d = 0.0;
        int n3 = n;
        while (n3 <= n2) {
            if (this.histogram[n3] > 0) {
                d = fArray[n3];
                if (d < this.min) {
                    this.min = d;
                }
                if (d > this.max) {
                    this.max = d;
                }
            }
            ++n3;
        }
    }

    public ByteStatistics(ImageProcessor imageProcessor) {
        this(imageProcessor, 27, null);
    }

    public ByteStatistics(ImageProcessor imageProcessor, int n, Calibration calibration) {
        float[] fArray;
        int n2;
        int n3;
        ByteProcessor byteProcessor = (ByteProcessor)imageProcessor;
        this.histogram = byteProcessor.getHistogram();
        this.setup(imageProcessor, calibration);
        double d = imageProcessor.getMinThreshold();
        if ((n & 0x100) == 0 || d == ImageProcessor.NO_THRESHOLD) {
            n3 = 0;
            n2 = 255;
        } else {
            n3 = (int)d;
            n2 = (int)imageProcessor.getMaxThreshold();
        }
        float[] fArray2 = fArray = calibration != null ? calibration.getCTable() : null;
        if (fArray != null) {
            this.getCalibratedStatistics(n3, n2, fArray);
        } else {
            this.getRawStatistics(n3, n2);
        }
        if ((n & 0x10) != 0) {
            if (fArray != null) {
                this.getCalibratedMinAndMax(n3, n2, fArray);
            } else {
                this.getRawMinAndMax(n3, n2);
            }
        }
        if ((n & 0x20) != 0) {
            this.getCentroid(imageProcessor, n3, n2);
        }
        if ((n & 0x40) != 0) {
            this.getCenterOfMass(imageProcessor, n3, n2, fArray);
        }
    }
}

