/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.GenericDialog;
import ij.gui.Toolbar;
import ij.gui.YesNoCancelDialog;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.plugin.PlugIn;
import ij.plugin.frame.PlugInFrame;
import ij.plugin.frame.ThresholdPlot;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.ShortProcessor;
import ij.process.StackProcessor;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.WindowEvent;

public class ThresholdAdjuster
extends PlugInFrame
implements PlugIn,
Measurements,
Runnable,
ActionListener,
AdjustmentListener {
    static final double defaultMinThreshold = 85.0;
    static final double defaultMaxThreshold = 170.0;
    static boolean fill1 = true;
    static boolean fill2 = true;
    static boolean useBW = true;
    static Frame instance;
    static final int RESET = 0;
    static final int AUTO = 1;
    static final int HIST = 2;
    static final int APPLY = 3;
    static final int STATE_CHANGE = 4;
    static final int MIN_THRESHOLD = 5;
    static final int MAX_THRESHOLD = 6;
    static final int SET = 7;
    ThresholdPlot plot = new ThresholdPlot();
    Thread thread;
    int minValue = -1;
    int maxValue = -1;
    int sliderRange = 256;
    boolean doAutoAdjust;
    boolean doReset;
    boolean doApplyLut;
    boolean doStateChange;
    boolean doSet;
    Panel panel;
    Button autoB;
    Button resetB;
    Button applyB;
    Button stateB;
    Button setB;
    int previousImageID;
    int previousImageType;
    double previousMin;
    double previousMax;
    ImageJ ij;
    double minThreshold;
    double maxThreshold;
    Scrollbar minSlider;
    Scrollbar maxSlider;
    Label label1;
    Label label2;
    boolean done;
    boolean invertedLut;
    boolean blackAndWhite;
    int lutColor = 0;
    private static /* synthetic */ Class class$Lij$plugin$frame$PasteController;

    public synchronized void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent.getSource() == this.minSlider) {
            this.minValue = this.minSlider.getValue();
        } else {
            this.maxValue = this.maxSlider.getValue();
        }
        this.notify();
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        Button button = (Button)actionEvent.getSource();
        if (button == null) {
            return;
        }
        if (button == this.resetB) {
            this.doReset = true;
        } else if (button == this.autoB) {
            this.doAutoAdjust = true;
        } else if (button == this.applyB) {
            this.doApplyLut = true;
        } else if (button == this.stateB) {
            this.blackAndWhite = this.stateB.getLabel().equals("B&W");
            if (this.blackAndWhite) {
                this.stateB.setLabel("Red");
                this.lutColor = 1;
            } else {
                this.stateB.setLabel("B&W");
                this.lutColor = 0;
            }
            this.doStateChange = true;
        } else if (button == this.setB) {
            this.doSet = true;
        }
        this.notify();
    }

    ImageProcessor setup(ImagePlus imagePlus) {
        int n = imagePlus.getType();
        if (n == 4) {
            return null;
        }
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        boolean bl = false;
        if (n == 1 || n == 2) {
            if (imageProcessor.getMin() != this.previousMin || imageProcessor.getMax() != this.previousMax) {
                bl = true;
            }
            this.previousMin = imageProcessor.getMin();
            this.previousMax = imageProcessor.getMax();
        }
        int n2 = imagePlus.getID();
        if (bl || n2 != this.previousImageID || n != this.previousImageType) {
            this.invertedLut = imagePlus.isInvertedLut();
            this.minThreshold = imageProcessor.getMinThreshold();
            this.maxThreshold = imageProcessor.getMaxThreshold();
            if (this.minThreshold == ImageProcessor.NO_THRESHOLD) {
                this.minThreshold = 85.0;
                this.maxThreshold = 170.0;
            }
            this.plot.setHistogram(imagePlus);
            this.scaleUpAndSet(imageProcessor, this.minThreshold, this.maxThreshold);
            this.updateLabels(imagePlus, imageProcessor);
            this.updatePlot();
            this.updateScrollBars();
            imagePlus.updateAndDraw();
        }
        this.previousImageID = n2;
        this.previousImageType = n;
        return imageProcessor;
    }

    void scaleUpAndSet(ImageProcessor imageProcessor, double d, double d2) {
        if (!(imageProcessor instanceof ByteProcessor) && d != -808080.0) {
            double d3 = imageProcessor.getMin();
            double d4 = imageProcessor.getMax();
            if (d4 > d3) {
                d = d3 + d / 255.0 * (d4 - d3);
                d2 = d3 + d2 / 255.0 * (d4 - d3);
            } else {
                d = -808080.0;
            }
        }
        imageProcessor.setThreshold(d, d2, this.lutColor);
    }

    double scaleDown(ImageProcessor imageProcessor, double d) {
        double d2 = imageProcessor.getMin();
        double d3 = imageProcessor.getMax();
        if (d3 > d2) {
            return (d - d2) / (d3 - d2) * 255.0;
        }
        return -808080.0;
    }

    double scaleUp(ImageProcessor imageProcessor, double d) {
        double d2 = imageProcessor.getMin();
        double d3 = imageProcessor.getMax();
        if (d3 > d2) {
            return d2 + d / 255.0 * (d3 - d2);
        }
        return -808080.0;
    }

    void updatePlot() {
        this.plot.minThreshold = this.minThreshold;
        this.plot.maxThreshold = this.maxThreshold;
        this.plot.blackAndWhite = this.blackAndWhite;
        this.plot.repaint();
    }

    void updateLabels(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        double d = imageProcessor.getMinThreshold();
        double d2 = imageProcessor.getMaxThreshold();
        if (d == -808080.0) {
            this.label1.setText("");
            this.label2.setText("");
        } else {
            Calibration calibration = imagePlus.getCalibration();
            if (calibration.calibrated()) {
                d = calibration.getCValue((int)d);
                d2 = calibration.getCValue((int)d2);
            }
            if ((double)((int)d) == d && (double)((int)d2) == d2 || imageProcessor instanceof ShortProcessor) {
                this.label1.setText("" + (int)d);
                this.label2.setText("" + (int)d2);
            } else {
                this.label1.setText("" + IJ.d2s(d, 2));
                this.label2.setText("" + IJ.d2s(d2, 2));
            }
        }
    }

    void updateScrollBars() {
        this.minSlider.setValue((int)this.minThreshold);
        this.maxSlider.setValue((int)this.maxThreshold);
    }

    void doMasking(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        int[] nArray = imagePlus.getMask();
        if (nArray != null) {
            imageProcessor.reset(nArray);
        }
    }

    void adjustMinThreshold(ImagePlus imagePlus, ImageProcessor imageProcessor, double d) {
        if (IJ.altKeyDown()) {
            double d2 = this.maxThreshold - this.minThreshold;
            if (d2 < 1.0) {
                d2 = 1.0;
            }
            this.minThreshold = d;
            this.maxThreshold = this.minThreshold + d2;
            if (this.minThreshold + d2 > 255.0) {
                this.minThreshold = 255.0 - d2;
                this.maxThreshold = this.minThreshold + d2;
                this.minSlider.setValue((int)this.minThreshold);
            }
            this.maxSlider.setValue((int)this.maxThreshold);
            this.scaleUpAndSet(imageProcessor, this.minThreshold, this.maxThreshold);
            return;
        }
        this.minThreshold = d;
        if (this.maxThreshold < this.minThreshold) {
            this.maxThreshold = this.minThreshold;
            this.maxSlider.setValue((int)this.maxThreshold);
        }
        this.scaleUpAndSet(imageProcessor, this.minThreshold, this.maxThreshold);
    }

    void adjustMaxThreshold(ImagePlus imagePlus, ImageProcessor imageProcessor, int n) {
        this.maxThreshold = n;
        if (this.minThreshold > this.maxThreshold) {
            this.minThreshold = this.maxThreshold;
            this.minSlider.setValue((int)this.minThreshold);
        }
        this.scaleUpAndSet(imageProcessor, this.minThreshold, this.maxThreshold);
    }

    void reset(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        this.plot.setHistogram(imagePlus);
        imageProcessor.setThreshold(-808080.0, 0.0, 0);
        this.updateScrollBars();
    }

    void doSet(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        boolean bl;
        double d = imageProcessor.getMinThreshold();
        double d2 = imageProcessor.getMaxThreshold();
        if (d == -808080.0) {
            d = this.scaleUp(imageProcessor, 85.0);
            d2 = this.scaleUp(imageProcessor, 170.0);
        }
        GenericDialog genericDialog = new GenericDialog("Set Threshold Levels");
        genericDialog.addNumericField("Lower Threshold Level: ", d, 0);
        genericDialog.addNumericField("Upper Threshold Level: ", d2, 0);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        d = genericDialog.getNextNumber();
        d2 = genericDialog.getNextNumber();
        if (d2 < d) {
            d2 = d;
        }
        double d3 = imageProcessor.getMin();
        double d4 = imageProcessor.getMax();
        imageProcessor.resetMinAndMax();
        double d5 = imageProcessor.getMin();
        double d6 = imageProcessor.getMax();
        if (d < d5) {
            d = d5;
        }
        if (d2 > d6) {
            d2 = d6;
        }
        boolean bl2 = bl = d < d3 || d2 > d4;
        if (bl) {
            this.plot.setHistogram(imagePlus);
        } else {
            imageProcessor.setMinAndMax(d3, d4);
        }
        this.minThreshold = this.scaleDown(imageProcessor, d);
        this.maxThreshold = this.scaleDown(imageProcessor, d2);
        this.scaleUpAndSet(imageProcessor, this.minThreshold, this.maxThreshold);
        this.updateScrollBars();
    }

    void apply(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        boolean bl;
        boolean bl2;
        boolean bl3 = bl2 = !(imageProcessor instanceof ByteProcessor);
        if (bl2) {
            double d = imageProcessor.getMin();
            double d2 = imageProcessor.getMax();
            imageProcessor.setMinAndMax(d, d2);
            imageProcessor = new ByteProcessor(imageProcessor.createImage());
        }
        if (!(bl = this.stateB.getLabel().equals("Red"))) {
            GenericDialog genericDialog = new GenericDialog("Apply Lut", this);
            genericDialog.addCheckbox("Set thresholded pixels to foreground color", fill1);
            genericDialog.addCheckbox("Set remaining pixels to background color", fill2);
            genericDialog.addMessage("");
            genericDialog.addCheckbox("Black forground, white background", useBW);
            genericDialog.showDialog();
            if (genericDialog.wasCanceled()) {
                return;
            }
            fill1 = genericDialog.getNextBoolean();
            fill2 = genericDialog.getNextBoolean();
            useBW = bl = genericDialog.getNextBoolean();
        } else {
            fill1 = true;
            fill2 = true;
        }
        Undo.setup(1, imagePlus);
        imageProcessor.snapshot();
        this.reset(imagePlus, imageProcessor);
        int n = imageProcessor.getPixel(0, 0);
        if (bl) {
            imageProcessor.setColor(Color.black);
        } else {
            imageProcessor.setColor(Toolbar.getForegroundColor());
        }
        imageProcessor.drawPixel(0, 0);
        int n2 = imageProcessor.getPixel(0, 0);
        if (bl) {
            imageProcessor.setColor(Color.white);
        } else {
            imageProcessor.setColor(Toolbar.getBackgroundColor());
        }
        imageProcessor.drawPixel(0, 0);
        int n3 = imageProcessor.getPixel(0, 0);
        imageProcessor.setColor(Toolbar.getForegroundColor());
        imageProcessor.putPixel(0, 0, n);
        int[] nArray = new int[256];
        int n4 = 0;
        while (n4 < 256) {
            nArray[n4] = (double)n4 >= this.minThreshold && (double)n4 <= this.maxThreshold ? (int)((byte)(fill1 ? n2 : (byte)n4)) : (int)((byte)(fill2 ? n3 : (byte)n4));
            ++n4;
        }
        if (bl2) {
            imageProcessor.applyTable(nArray);
            new ImagePlus(imagePlus.getTitle(), imageProcessor).show();
        }
        if (imagePlus.getStackSize() > 1) {
            ImageStack imageStack = imagePlus.getStack();
            YesNoCancelDialog yesNoCancelDialog = new YesNoCancelDialog((Frame)this, "Entire Stack?", "Apply threshold to all " + imageStack.getSize() + " slices in the stack?");
            if (yesNoCancelDialog.cancelPressed()) {
                return;
            }
            if (yesNoCancelDialog.yesPressed()) {
                new StackProcessor(imageStack, imageProcessor).applyTable(nArray);
            } else {
                imageProcessor.applyTable(nArray);
            }
        } else {
            imageProcessor.applyTable(nArray);
        }
        imagePlus.changes = true;
        if (this.plot.histogram != null) {
            this.plot.setHistogram(imagePlus);
        }
    }

    void changeState(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        this.scaleUpAndSet(imageProcessor, this.minThreshold, this.maxThreshold);
        this.updateScrollBars();
    }

    void autoThreshold(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        if (!(imageProcessor instanceof ByteProcessor)) {
            return;
        }
        ImageStatistics imageStatistics = imagePlus.getStatistics(24);
        int n = ((ByteProcessor)imageProcessor).getAutoThreshold();
        if (imageStatistics.max - (double)imageStatistics.mode < (double)imageStatistics.mode - imageStatistics.min) {
            this.minThreshold = imageStatistics.min;
            this.maxThreshold = n;
        } else {
            this.minThreshold = n;
            this.maxThreshold = imageStatistics.max;
        }
        this.scaleUpAndSet(imageProcessor, this.minThreshold, this.maxThreshold);
        this.updateScrollBars();
    }

    public void run() {
        while (!this.done) {
            ThresholdAdjuster thresholdAdjuster = this;
            synchronized (thresholdAdjuster) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.doUpdate();
        }
    }

    void doUpdate() {
        int n;
        int n2 = this.minValue;
        int n3 = this.maxValue;
        if (this.doReset) {
            n = 0;
        } else if (this.doAutoAdjust) {
            n = 1;
        } else if (this.doApplyLut) {
            n = 3;
        } else if (this.doStateChange) {
            n = 4;
        } else if (this.doSet) {
            n = 7;
        } else if (this.minValue >= 0) {
            n = 5;
        } else if (this.maxValue >= 0) {
            n = 6;
        } else {
            return;
        }
        this.minValue = -1;
        this.maxValue = -1;
        this.doReset = false;
        this.doAutoAdjust = false;
        this.doApplyLut = false;
        this.doStateChange = false;
        this.doSet = false;
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            IJ.beep();
            IJ.showStatus("No image");
            return;
        }
        if (!imagePlus.lock()) {
            imagePlus = null;
            return;
        }
        ImageProcessor imageProcessor = this.setup(imagePlus);
        if (imageProcessor == null) {
            imagePlus.unlock();
            IJ.beep();
            IJ.showStatus("RGB images cannot be thresolded");
            return;
        }
        switch (n) {
            case 0: {
                this.reset(imagePlus, imageProcessor);
                break;
            }
            case 1: {
                this.autoThreshold(imagePlus, imageProcessor);
                break;
            }
            case 3: {
                this.apply(imagePlus, imageProcessor);
                break;
            }
            case 4: {
                this.changeState(imagePlus, imageProcessor);
                break;
            }
            case 7: {
                this.doSet(imagePlus, imageProcessor);
                break;
            }
            case 5: {
                this.adjustMinThreshold(imagePlus, imageProcessor, n2);
                break;
            }
            case 6: {
                this.adjustMaxThreshold(imagePlus, imageProcessor, n3);
                break;
            }
        }
        this.updatePlot();
        this.updateLabels(imagePlus, imageProcessor);
        imageProcessor.setLutAnimation(true);
        imagePlus.updateAndDraw();
        imagePlus.unlock();
    }

    public void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            instance = null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ThresholdAdjuster() {
        super("Threshold");
        if (instance != null) {
            instance.toFront();
            return;
        }
        instance = this;
        IJ.register(class$Lij$plugin$frame$PasteController != null ? class$Lij$plugin$frame$PasteController : (class$Lij$plugin$frame$PasteController = ThresholdAdjuster.class$("ij.plugin.frame.PasteController")));
        this.ij = IJ.getInstance();
        Font font = new Font("SansSerif", 0, 10);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        int n = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.anchor = GridBagConstraints.CENTER;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)this.plot, gridBagConstraints);
        this.minSlider = new Scrollbar(0, this.sliderRange / 3, 1, 0, this.sliderRange);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = IJ.isMacintosh() ? 90 : 100;
        gridBagConstraints.fill = GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.add((Component)this.minSlider, gridBagConstraints);
        this.minSlider.addAdjustmentListener(this);
        this.minSlider.setUnitIncrement(1);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = IJ.isMacintosh() ? 10 : 0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 10);
        this.label1 = new Label("       ", 2);
        this.label1.setFont(font);
        this.add((Component)this.label1, gridBagConstraints);
        this.maxSlider = new Scrollbar(0, this.sliderRange * 2 / 3, 1, 0, this.sliderRange);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.add((Component)this.maxSlider, gridBagConstraints);
        this.maxSlider.addAdjustmentListener(this);
        this.maxSlider.setUnitIncrement(1);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.label2 = new Label("       ", 2);
        this.label2.setFont(font);
        this.add((Component)this.label2, gridBagConstraints);
        this.panel = new Panel();
        this.autoB = new Button("Auto");
        this.autoB.addActionListener(this);
        this.autoB.addKeyListener(this.ij);
        this.panel.add(this.autoB);
        this.applyB = new Button("Apply");
        this.applyB.addActionListener(this);
        this.applyB.addKeyListener(this.ij);
        this.panel.add(this.applyB);
        this.resetB = new Button("Reset");
        this.resetB.addActionListener(this);
        this.resetB.addKeyListener(this.ij);
        this.panel.add(this.resetB);
        this.stateB = new Button("B&W");
        this.stateB.addActionListener(this);
        this.stateB.addKeyListener(this.ij);
        this.panel.add(this.stateB);
        this.setB = new Button("Set");
        this.setB.addActionListener(this);
        this.setB.addKeyListener(this.ij);
        this.panel.add(this.setB);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.add((Component)this.panel, gridBagConstraints);
        this.addKeyListener(this.ij);
        this.pack();
        GUI.center(this);
        ((Component)this).setVisible(true);
        this.thread = new Thread((Runnable)this, "ThresholdAdjuster");
        this.thread.start();
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus != null) {
            this.setup(imagePlus);
        }
    }
}

