/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.Menus;
import ij.gui.GenericDialog;
import ij.gui.SaveChangesDialog;
import ij.plugin.frame.PlugInFrame;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class Editor
extends PlugInFrame
implements ActionListener,
TextListener {
    public static final int MAX_SIZE = 28000;
    private static String searchString = "";
    private static int lineNumber = 1;
    private TextArea ta;
    private String path;
    private boolean changes;

    public void create(String string, String string2) {
        this.ta.append(string2);
        this.ta.setCaretPosition(0);
        this.setTitle(string);
        this.changes = true;
        ((Component)this).setVisible(true);
    }

    public void open(String string, String string2) {
        this.path = string + string2;
        File file = new File(this.path);
        int n = (int)file.length();
        if (n > 28000 && !IJ.isMacintosh()) {
            IJ.error("This file is too large for ImageJ to open.\n \n    File size: " + n + " bytes\n" + "    Max. size: " + "28000" + " bytes");
            this.dispose();
            return;
        }
        try {
            String string3;
            StringBuffer stringBuffer = new StringBuffer(5000);
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string3 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string3 + "\n");
            }
            this.create(string2, new String(stringBuffer));
            this.changes = false;
        }
        catch (Exception exception) {
            IJ.error(exception.getMessage());
            return;
        }
    }

    public void display(String string, String string2) {
        this.ta.selectAll();
        this.ta.replaceRange(string2, this.ta.getSelectionStart(), this.ta.getSelectionEnd());
        this.ta.setCaretPosition(0);
        this.setTitle(string);
        this.changes = false;
        ((Component)this).setVisible(true);
    }

    void save() {
        if (this.path == null) {
            return;
        }
        String string = this.ta.getText();
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new CharArrayReader(cArray));
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.path));
            while ((string2 = bufferedReader.readLine()) != null) {
                bufferedWriter.write(string2, 0, string2.length());
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
            this.changes = false;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void compileAndRun() {
        if (this.path == null) {
            this.saveAs();
        }
        if (this.path != null) {
            this.save();
            IJ.runPlugIn("ij.plugin.Compiler", this.path);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("Save".equals(string)) {
            this.save();
        } else if ("Compile and Run".equals(string)) {
            this.compileAndRun();
        } else if ("Save As...".equals(string)) {
            this.saveAs();
        } else if ("Find...".equals(string)) {
            this.find(null);
        } else if ("Find Next".equals(string)) {
            this.find(searchString);
        } else if ("Go to Line...".equals(string)) {
            this.gotoLine();
        }
    }

    public void textValueChanged(TextEvent textEvent) {
        this.changes = true;
    }

    public void processWindowEvent(WindowEvent windowEvent) {
        boolean bl = true;
        if (windowEvent.getID() == 201) {
            if (this.getTitle().equals("Errors") || this.close()) {
                ((Component)this).setVisible(false);
                this.dispose();
            }
        } else {
            super.processWindowEvent(windowEvent);
        }
    }

    boolean close() {
        boolean bl = true;
        if (this.changes) {
            SaveChangesDialog saveChangesDialog = new SaveChangesDialog((Frame)this, this.getTitle());
            if (saveChangesDialog.cancelPressed()) {
                bl = false;
            } else if (saveChangesDialog.savePressed()) {
                this.save();
            }
        }
        return bl;
    }

    void saveAs() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Save As...", 1);
        fileDialog.setFile(this.getTitle());
        fileDialog.setDirectory(Menus.getPlugInsPath());
        ((Component)fileDialog).setVisible(true);
        String string = fileDialog.getFile();
        String string2 = fileDialog.getDirectory();
        fileDialog.dispose();
        if (string != null) {
            this.path = string2 + string;
            this.save();
            this.changes = false;
            this.setTitle(string);
        }
    }

    void find(String string) {
        Object object;
        if (string == null) {
            object = new GenericDialog("Find", this);
            ((GenericDialog)object).addStringField("Find: ", searchString, 20);
            ((GenericDialog)object).showDialog();
            if (((GenericDialog)object).wasCanceled()) {
                return;
            }
            string = ((GenericDialog)object).getNextString();
        }
        if (string.equals("")) {
            return;
        }
        object = this.ta.getText();
        int n = ((String)object).indexOf(string, this.ta.getCaretPosition() + 1);
        if (n < 0) {
            IJ.beep();
            return;
        }
        this.ta.setSelectionStart(n);
        this.ta.setSelectionEnd(n + string.length());
        searchString = string;
    }

    void gotoLine() {
        GenericDialog genericDialog = new GenericDialog("Go to Line", this);
        genericDialog.addNumericField("Go to line number: ", lineNumber, 0);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        int n = (int)genericDialog.getNextNumber();
        if (n < 1) {
            return;
        }
        String string = this.ta.getText();
        char[] cArray = new char[string.length()];
        cArray = string.toCharArray();
        int n2 = 1;
        int n3 = 0;
        int n4 = 0;
        while (n4 < cArray.length) {
            if (cArray[n4] == '\n') {
                ++n2;
            }
            if (n2 == n) {
                n3 = n4 + 1;
                break;
            }
            ++n4;
        }
        this.ta.setCaretPosition(n3);
        lineNumber = n;
    }

    public Editor() {
        super("Editor");
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("File");
        menu.add(new MenuItem("Save", new MenuShortcut(83)));
        menu.add(new MenuItem("Save As..."));
        menu.add(new MenuItem("Compile and Run", new MenuShortcut(82)));
        menu.addActionListener(this);
        menuBar.add(menu);
        menu = new Menu("Edit");
        menu.add(new MenuItem("Find...", new MenuShortcut(70)));
        menu.add(new MenuItem("Find Next", new MenuShortcut(71)));
        menu.add(new MenuItem("Go to Line...", new MenuShortcut(76)));
        menu.addActionListener(this);
        menuBar.add(menu);
        this.setMenuBar(menuBar);
        this.ta = new TextArea();
        this.ta.addTextListener(this);
        this.add(this.ta);
        this.pack();
    }
}

