/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.process.ImageStatistics;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

class ContrastPlot
extends Canvas
implements MouseListener {
    static final int WIDTH = 120;
    static final int HEIGHT = 80;
    double defaultMin = 0.0;
    double defaultMax = 255.0;
    double min = 0.0;
    double max = 255.0;
    int[] histogram;
    int hmax;
    Image os;
    Graphics osg;

    void setHistogram(ImageStatistics imageStatistics) {
        int n = 0;
        this.histogram = imageStatistics.histogram;
        int n2 = 0;
        while (n2 < imageStatistics.nBins) {
            if (this.histogram[n2] > n && n2 != imageStatistics.mode) {
                n = this.histogram[n2];
            }
            ++n2;
        }
        this.hmax = imageStatistics.maxCount;
        if (this.hmax > n * 2 && n != 0) {
            this.histogram[imageStatistics.mode] = this.hmax = (int)((double)n * 1.5);
        }
        this.os = null;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        double d = 120.0 / (this.defaultMax - this.defaultMin);
        double d2 = 0.0;
        if (this.max != this.min) {
            d2 = 80.0 / (this.max - this.min);
        }
        if (this.min >= this.defaultMin) {
            n4 = (int)(d * (this.min - this.defaultMin));
            n3 = 80;
        } else {
            n4 = 0;
            n3 = this.max > this.min ? 80 - (int)((this.defaultMin - this.min) * d2) : 80;
        }
        if (this.max <= this.defaultMax) {
            n2 = (int)(d * (this.max - this.defaultMin));
            n = 0;
        } else {
            n2 = 120;
            n = this.max > this.min ? 80 - (int)((this.defaultMax - this.min) * d2) : 0;
        }
        if (this.histogram != null) {
            if (this.os == null) {
                this.os = this.createImage(120, 80);
                this.osg = this.os.getGraphics();
                this.osg.setColor(Color.white);
                this.osg.fillRect(0, 0, 120, 80);
                this.osg.setColor(Color.gray);
                int n5 = 0;
                while (n5 < 120) {
                    this.osg.drawLine(n5, 80, n5, 80 - 80 * this.histogram[n5 * 2] / this.hmax);
                    ++n5;
                }
                this.osg.dispose();
            }
            graphics.drawImage(this.os, 0, 0, this);
        } else {
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, 120, 80);
        }
        graphics.setColor(Color.black);
        graphics.drawLine(n4, n3, n2, n);
        graphics.drawRect(0, 0, 120, 80);
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public ContrastPlot() {
        this.addMouseListener(this);
        this.setSize(121, 81);
    }
}

