/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.LookUpTable;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.Roi;
import ij.gui.YesNoCancelDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.plugin.frame.ContrastPlot;
import ij.plugin.frame.PlugInFrame;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.ShortProcessor;
import ij.process.StackProcessor;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.WindowEvent;
import java.awt.image.IndexColorModel;

public class ContrastAdjuster
extends PlugInFrame
implements PlugIn,
Runnable,
ActionListener,
AdjustmentListener {
    private static Frame instance;
    static final int RESET = 0;
    static final int AUTO = 1;
    static final int HIST = 2;
    static final int APPLY = 3;
    static final int THRESHOLD = 4;
    static final int BRIGHTNESS = 5;
    static final int CONTRAST = 6;
    static final int UPDATE = 7;
    ContrastPlot plot = new ContrastPlot();
    Thread thread;
    int brightnessValue = -1;
    int contrastValue = -1;
    int sliderRange = 256;
    boolean doAutoAdjust;
    boolean doReset;
    boolean doHistogram;
    boolean doApplyLut;
    boolean doThreshold;
    boolean doUpdate;
    Panel panel;
    Panel tPanel;
    Button autoB;
    Button resetB;
    Button histB;
    Button applyB;
    Button threshB;
    Button updateB;
    int previousImageID;
    int previousType;
    ImageJ ij;
    double min;
    double max;
    double defaultMin;
    double defaultMax;
    int contrast;
    int brightness;
    boolean RGBImage;
    Scrollbar contrastSlider;
    Scrollbar brightnessSlider;
    Label minLabel;
    Label maxLabel;
    Label brightnessLabel;
    Label contrastLabel;
    boolean done;
    private static /* synthetic */ Class class$Lij$plugin$frame$ContrastAdjuster;

    public synchronized void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent.getSource() == this.contrastSlider) {
            this.contrastValue = this.contrastSlider.getValue();
        } else {
            this.brightnessValue = this.brightnessSlider.getValue();
        }
        this.notify();
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        Button button = (Button)actionEvent.getSource();
        if (button == null) {
            return;
        }
        if (button == this.resetB) {
            this.doReset = true;
        } else if (button == this.autoB) {
            this.doAutoAdjust = true;
        } else if (button == this.histB) {
            this.doHistogram = true;
        } else if (button == this.applyB) {
            this.doApplyLut = true;
        } else if (button == this.threshB) {
            this.doThreshold = true;
        } else if (button == this.updateB) {
            this.doUpdate = true;
        }
        this.notify();
    }

    ImageProcessor setup(ImagePlus imagePlus) {
        int n = imagePlus.getType();
        this.RGBImage = n == 4;
        boolean bl = !imagePlus.isProcessor();
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        if (imagePlus.getID() != this.previousImageID || this.RGBImage && bl || n != this.previousType) {
            if (this.RGBImage) {
                imageProcessor.snapshot();
            }
            if (imageProcessor instanceof ShortProcessor || imageProcessor instanceof FloatProcessor) {
                imageProcessor.resetMinAndMax();
                this.defaultMin = imageProcessor.getMin();
                this.defaultMax = imageProcessor.getMax();
            } else {
                this.defaultMin = 0.0;
                this.defaultMax = 255.0;
            }
            this.min = imageProcessor.getMin();
            this.max = imageProcessor.getMax();
            if (IJ.debugMode) {
                IJ.write("min: " + this.min);
                IJ.write("max: " + this.max);
                IJ.write("defaultMin: " + this.defaultMin);
                IJ.write("defaultMax: " + this.defaultMax);
            }
            this.plot.defaultMin = this.defaultMin;
            this.plot.defaultMax = this.defaultMax;
            this.plot.histogram = null;
        }
        this.previousImageID = imagePlus.getID();
        this.previousType = n;
        return imageProcessor;
    }

    void updatePlot() {
        this.plot.min = this.min;
        this.plot.max = this.max;
        this.plot.repaint();
    }

    void updateLabels(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        boolean bl;
        double d = imageProcessor.getMin();
        double d2 = imageProcessor.getMax();
        int n = imagePlus.getType();
        Calibration calibration = imagePlus.getCalibration();
        boolean bl2 = bl = n == 2;
        if (calibration.calibrated()) {
            d = calibration.getCValue((int)d);
            d2 = calibration.getCValue((int)d2);
            if (n != 1) {
                bl = true;
            }
        }
        if (bl) {
            this.minLabel.setText("" + IJ.d2s(d));
            this.maxLabel.setText("" + IJ.d2s(d2));
        } else {
            this.minLabel.setText(IJ.d2s(d, 0));
            this.maxLabel.setText(IJ.d2s(d2, 0));
        }
    }

    void updateScrollBars() {
        double d = this.sliderRange / 2;
        double d2 = (this.defaultMax - this.defaultMin) / (this.max - this.min) * d;
        if (d2 > d) {
            d2 = (double)this.sliderRange - (this.max - this.min) / (this.defaultMax - this.defaultMin) * d;
        }
        this.contrast = (int)d2;
        this.contrastSlider.setValue(this.contrast);
        double d3 = this.min + (this.max - this.min) / 2.0;
        double d4 = 1.0 - (d3 - this.defaultMin) / (this.defaultMax - this.defaultMin);
        this.brightness = (int)(d4 * (double)this.sliderRange);
        this.brightnessSlider.setValue(this.brightness);
    }

    void doMasking(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        int[] nArray = imagePlus.getMask();
        if (nArray != null) {
            imageProcessor.reset(nArray);
        }
    }

    void adjustBrightness(ImagePlus imagePlus, ImageProcessor imageProcessor, double d) {
        double d2 = this.defaultMin + (this.defaultMax - this.defaultMin) * (((double)this.sliderRange - d) / (double)this.sliderRange);
        double d3 = this.max - this.min;
        this.min = d2 - d3 / 2.0;
        this.max = d2 + d3 / 2.0;
        imageProcessor.setMinAndMax(this.min, this.max);
        if (this.min == this.max) {
            this.setThreshold(imageProcessor);
        }
        if (this.RGBImage) {
            this.doMasking(imagePlus, imageProcessor);
        }
    }

    void adjustContrast(ImagePlus imagePlus, ImageProcessor imageProcessor, int n) {
        double d = this.min + (this.max - this.min) / 2.0;
        double d2 = this.defaultMax - this.defaultMin;
        double d3 = this.sliderRange / 2;
        double d4 = (double)n <= d3 ? (double)n / d3 : d3 / (double)(this.sliderRange - n);
        if (d4 > 0.0) {
            this.min = d - 0.5 * d2 / d4;
            this.max = d + 0.5 * d2 / d4;
        }
        imageProcessor.setMinAndMax(this.min, this.max);
        if (this.RGBImage) {
            this.doMasking(imagePlus, imageProcessor);
        }
    }

    void reset(ImageProcessor imageProcessor) {
        if (this.RGBImage) {
            imageProcessor.reset();
        }
        if (imageProcessor instanceof ShortProcessor || imageProcessor instanceof FloatProcessor) {
            imageProcessor.resetMinAndMax();
            this.defaultMin = imageProcessor.getMin();
            this.defaultMax = imageProcessor.getMax();
            this.plot.defaultMin = this.defaultMin;
            this.plot.defaultMax = this.defaultMax;
        }
        this.min = this.defaultMin;
        this.max = this.defaultMax;
        imageProcessor.setMinAndMax(this.min, this.max);
        this.updateScrollBars();
    }

    void update(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        if (this.min == 0.0 && this.max == 0.0 || imagePlus.getType() != this.previousType) {
            IJ.beep();
        } else {
            imageProcessor.setMinAndMax(this.min, this.max);
            this.updateScrollBars();
        }
    }

    void plotHistogram(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        if (this.RGBImage) {
            this.reset(imageProcessor);
        }
        this.plot.setHistogram(imagePlus.getStatistics());
    }

    void apply(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        if (imagePlus.getType() == 4 && imagePlus.getStackSize() > 1) {
            this.applyRGBStack(imagePlus);
            return;
        }
        if (imagePlus.getType() != 0) {
            IJ.beep();
            IJ.showStatus("Apply requires an 8-bit grayscale image or an RGB stack");
            return;
        }
        int[] nArray = new int[256];
        LookUpTable lookUpTable = imagePlus.createLut();
        IndexColorModel indexColorModel = (IndexColorModel)lookUpTable.getColorModel();
        boolean bl = ((ByteProcessor)imageProcessor).isInvertedLut();
        int n = 0;
        while (n < indexColorModel.getMapSize()) {
            nArray[n] = bl ? 255 - indexColorModel.getRed(n) & 0xFF : indexColorModel.getRed(n) & 0xFF;
            ++n;
        }
        if (imagePlus.getStackSize() > 1) {
            ImageStack imageStack = imagePlus.getStack();
            YesNoCancelDialog yesNoCancelDialog = new YesNoCancelDialog((Frame)this, "Entire Stack?", "Apply LUT to all " + imageStack.getSize() + " slices in the stack?");
            if (yesNoCancelDialog.cancelPressed()) {
                return;
            }
            if (yesNoCancelDialog.yesPressed()) {
                new StackProcessor(imageStack, imageProcessor).applyTable(nArray);
            } else {
                imageProcessor.applyTable(nArray);
            }
        } else {
            imageProcessor.applyTable(nArray);
        }
        this.reset(imageProcessor);
        imagePlus.changes = true;
        if (this.plot.histogram != null) {
            this.plotHistogram(imagePlus, imageProcessor);
        }
    }

    void applyRGBStack(ImagePlus imagePlus) {
        int n = imagePlus.getCurrentSlice();
        int n2 = imagePlus.getStackSize();
        if (!IJ.showMessageWithCancel("Update Entire Stack?", "Apply brightness and contrast settings\nto all " + n2 + " slices in the stack?\n \n" + "NOTE: There is no Undo for this operation.")) {
            return;
        }
        int n3 = 1;
        while (n3 <= n2) {
            if (n3 != n) {
                imagePlus.setSlice(n3);
                ImageProcessor imageProcessor = imagePlus.getProcessor();
                imageProcessor.setMinAndMax(this.min, this.max);
                IJ.showProgress((double)n3 / (double)n2);
            }
            ++n3;
        }
        imagePlus.setSlice(n);
        imagePlus.changes = true;
    }

    void threshold(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        int n = (int)((this.defaultMax - this.defaultMin) / 2.0);
        this.min = n;
        this.max = n;
        imageProcessor.setMinAndMax(this.min, this.max);
        this.setThreshold(imageProcessor);
        this.updateScrollBars();
    }

    void setThreshold(ImageProcessor imageProcessor) {
        if (!(imageProcessor instanceof ByteProcessor)) {
            return;
        }
        if (((ByteProcessor)imageProcessor).isInvertedLut()) {
            imageProcessor.setThreshold(this.max, 255.0, 2);
        } else {
            imageProcessor.setThreshold(0.0, this.max, 2);
        }
    }

    void autoAdjust(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        int[] nArray;
        if (this.RGBImage) {
            imageProcessor.reset();
        }
        Calibration calibration = imagePlus.getCalibration();
        imagePlus.setCalibration(null);
        ImageStatistics imageStatistics = imagePlus.getStatistics();
        imagePlus.setCalibration(calibration);
        int[] nArray2 = imageStatistics.histogram;
        int n = imageStatistics.pixelCount / 5000;
        int n2 = -1;
        boolean bl = false;
        do {
            boolean bl2 = bl = nArray2[++n2] > n;
        } while (!bl && n2 < 255);
        int n3 = n2;
        n2 = 256;
        do {
            boolean bl3 = bl = nArray2[--n2] > n;
        } while (!bl && n2 > 0);
        int n4 = n2;
        if (n4 > n3) {
            imagePlus.killRoi();
            this.min = imageStatistics.histMin + (double)n3 * imageStatistics.binSize;
            this.max = imageStatistics.histMin + (double)n4 * imageStatistics.binSize;
            imageProcessor.setMinAndMax(this.min, this.max);
        }
        this.updateScrollBars();
        Roi roi = imagePlus.getRoi();
        if (roi != null && (nArray = roi.getMask()) != null) {
            imageProcessor.reset(nArray);
        }
    }

    public void run() {
        while (!this.done) {
            ContrastAdjuster contrastAdjuster = this;
            synchronized (contrastAdjuster) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.doUpdate();
        }
    }

    void doUpdate() {
        int n;
        int n2 = this.brightnessValue;
        int n3 = this.contrastValue;
        if (this.doReset) {
            n = 0;
        } else if (this.doAutoAdjust) {
            n = 1;
        } else if (this.doHistogram) {
            n = 2;
        } else if (this.doApplyLut) {
            n = 3;
        } else if (this.doThreshold) {
            n = 4;
        } else if (this.doUpdate) {
            n = 7;
        } else if (this.brightnessValue >= 0) {
            n = 5;
        } else if (this.contrastValue >= 0) {
            n = 6;
        } else {
            return;
        }
        this.brightnessValue = -1;
        this.contrastValue = -1;
        this.doReset = false;
        this.doAutoAdjust = false;
        this.doHistogram = false;
        this.doApplyLut = false;
        this.doThreshold = false;
        this.doUpdate = false;
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            IJ.beep();
            IJ.showStatus("No image");
            return;
        }
        if (!imagePlus.lock()) {
            imagePlus = null;
            return;
        }
        ImageProcessor imageProcessor = n != 7 ? this.setup(imagePlus) : imagePlus.getProcessor();
        switch (n) {
            case 0: {
                this.reset(imageProcessor);
                break;
            }
            case 1: {
                this.autoAdjust(imagePlus, imageProcessor);
                break;
            }
            case 2: {
                this.plotHistogram(imagePlus, imageProcessor);
                break;
            }
            case 3: {
                this.apply(imagePlus, imageProcessor);
                break;
            }
            case 4: {
                this.threshold(imagePlus, imageProcessor);
                break;
            }
            case 7: {
                this.update(imagePlus, imageProcessor);
                break;
            }
            case 5: {
                this.adjustBrightness(imagePlus, imageProcessor, n2);
                break;
            }
            case 6: {
                this.adjustContrast(imagePlus, imageProcessor, n3);
                break;
            }
        }
        this.updatePlot();
        this.updateLabels(imagePlus, imageProcessor);
        imagePlus.updateAndDraw();
        imagePlus.unlock();
    }

    public void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            instance = null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ContrastAdjuster() {
        super("B&C");
        if (instance != null) {
            instance.toFront();
            return;
        }
        instance = this;
        IJ.register(class$Lij$plugin$frame$ContrastAdjuster != null ? class$Lij$plugin$frame$ContrastAdjuster : (class$Lij$plugin$frame$ContrastAdjuster = ContrastAdjuster.class$("ij.plugin.frame.ContrastAdjuster")));
        this.ij = IJ.getInstance();
        Font font = new Font("Monospaced", 0, 12);
        Font font2 = new Font("SansSerif", 0, 12);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        int n = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        gridBagLayout.setConstraints(this.plot, gridBagConstraints);
        this.add(this.plot);
        this.panel = new Panel();
        gridBagConstraints.gridy = n++;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        gridBagLayout.setConstraints(this.panel, gridBagConstraints);
        this.panel.setLayout(new BorderLayout());
        this.minLabel = new Label("      ", 0);
        this.minLabel.setFont(font);
        this.panel.add("West", this.minLabel);
        this.maxLabel = new Label("      ", 2);
        this.maxLabel.setFont(font);
        this.panel.add("East", this.maxLabel);
        this.add(this.panel);
        this.brightnessSlider = new Scrollbar(0, this.sliderRange / 2, 1, 0, this.sliderRange);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        gridBagLayout.setConstraints(this.brightnessSlider, gridBagConstraints);
        this.add(this.brightnessSlider);
        this.brightnessSlider.addAdjustmentListener(this);
        this.brightnessSlider.setUnitIncrement(1);
        this.panel = new Panel();
        gridBagConstraints.gridy = n++;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        gridBagLayout.setConstraints(this.panel, gridBagConstraints);
        this.panel.setLayout(new FlowLayout(1, 0, 0));
        Label label = new Label("Brightness");
        label.setFont(font2);
        this.panel.add(label);
        this.brightnessLabel = new Label("", 0);
        this.brightnessLabel.setFont(font);
        this.panel.add(this.brightnessLabel);
        this.add(this.panel);
        this.contrastSlider = new Scrollbar(0, this.sliderRange / 2, 1, 0, this.sliderRange);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        gridBagLayout.setConstraints(this.contrastSlider, gridBagConstraints);
        this.add(this.contrastSlider);
        this.contrastSlider.addAdjustmentListener(this);
        this.contrastSlider.setUnitIncrement(1);
        this.panel = new Panel();
        gridBagConstraints.gridy = n++;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        gridBagLayout.setConstraints(this.panel, gridBagConstraints);
        this.panel.setLayout(new FlowLayout(1, 0, 0));
        label = new Label("Contrast");
        label.setFont(font2);
        this.panel.add(label);
        this.contrastLabel = new Label("", 0);
        this.contrastLabel.setFont(font);
        this.panel.add(this.contrastLabel);
        this.add(this.panel);
        this.panel = new Panel();
        this.panel.setLayout(new GridLayout(3, 2, 0, 0));
        this.autoB = new Button("Auto");
        this.autoB.addActionListener(this);
        this.autoB.addKeyListener(this.ij);
        this.panel.add(this.autoB);
        this.resetB = new Button("Reset");
        this.resetB.addActionListener(this);
        this.resetB.addKeyListener(this.ij);
        this.panel.add(this.resetB);
        this.histB = new Button("Hist");
        this.histB.addActionListener(this);
        this.histB.addKeyListener(this.ij);
        this.panel.add(this.histB);
        this.applyB = new Button("Apply");
        this.applyB.addActionListener(this);
        this.applyB.addKeyListener(this.ij);
        this.panel.add(this.applyB);
        this.threshB = new Button("Thresh");
        this.threshB.addActionListener(this);
        this.threshB.addKeyListener(this.ij);
        this.panel.add(this.threshB);
        this.updateB = new Button("Update");
        this.updateB.addActionListener(this);
        this.updateB.addKeyListener(this.ij);
        this.panel.add(this.updateB);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.insets = new Insets(10, 5, 10, 5);
        gridBagLayout.setConstraints(this.panel, gridBagConstraints);
        this.add(this.panel);
        this.addKeyListener(this.ij);
        this.pack();
        GUI.center(this);
        ((Component)this).setVisible(true);
        this.thread = new Thread((Runnable)this, "ContrastAdjuster");
        this.thread.start();
    }
}

