/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.PlotWindow;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import java.awt.Rectangle;

public class ZAxisProfiler
implements PlugInFilter,
Measurements {
    ImagePlus imp;

    public int setup(String string, ImagePlus imagePlus) {
        this.imp = imagePlus;
        return 1183;
    }

    public void run(ImageProcessor imageProcessor) {
        if (this.imp.getStackSize() < 2) {
            IJ.showMessage("ZAxisProfiler", "This command requires a stack.");
            return;
        }
        Roi roi = this.imp.getRoi();
        if (roi.getType() >= 5) {
            IJ.showMessage("ZAxisProfiler", "This command does not work with line selections.");
            return;
        }
        float[] fArray = this.getZAxisProfile(roi);
        if (fArray != null) {
            float[] fArray2 = new float[fArray.length];
            int n = 0;
            while (n < fArray2.length) {
                fArray2[n] = n + 1;
                ++n;
            }
            Rectangle rectangle = this.imp.getRoi().getBoundingRect();
            new PlotWindow(this.imp.getTitle() + "-" + rectangle.x + "-" + rectangle.y, "Slice", "Mean", fArray2, fArray).draw();
        }
    }

    float[] getZAxisProfile(Roi roi) {
        ImageStack imageStack = this.imp.getStack();
        int n = imageStack.getSize();
        float[] fArray = new float[n];
        int[] nArray = this.imp.getMask();
        Rectangle rectangle = this.imp.getRoi().getBoundingRect();
        Calibration calibration = this.imp.getCalibration();
        Analyzer analyzer = new Analyzer(this.imp);
        int n2 = Analyzer.getMeasurements();
        boolean bl = n2 != 0 && n2 != 256;
        n2 |= 2;
        if (bl && !Analyzer.resetCounter()) {
            return null;
        }
        int n3 = 1;
        while (n3 <= n) {
            ImageProcessor imageProcessor = imageStack.getProcessor(n3);
            imageProcessor.setRoi(rectangle);
            imageProcessor.setMask(nArray);
            ImageStatistics imageStatistics = ImageStatistics.getStatistics(imageProcessor, n2, calibration);
            analyzer.saveResults(imageStatistics, roi);
            if (bl) {
                analyzer.displayResults();
            }
            fArray[n3 - 1] = (float)imageStatistics.mean;
            ++n3;
        }
        return fArray;
    }
}

