/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.io.SaveDialog;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;

public class XYWriter
implements PlugInFilter {
    ImagePlus imp;

    public int setup(String string, ImagePlus imagePlus) {
        this.imp = imagePlus;
        return 1183;
    }

    public void run(ImageProcessor imageProcessor) {
        try {
            this.saveXYCoordinates(this.imp);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            IJ.showMessage("XYWriter", illegalArgumentException.getMessage());
        }
    }

    public void saveXYCoordinates(ImagePlus imagePlus) {
        Object object;
        Roi roi = imagePlus.getRoi();
        if (roi == null) {
            throw new IllegalArgumentException("ROI required");
        }
        if (!(roi instanceof PolygonRoi)) {
            throw new IllegalArgumentException("Irregular area or line selection required");
        }
        SaveDialog saveDialog = new SaveDialog("Save Coordinates as Text...", imagePlus.getTitle(), ".txt");
        String string = saveDialog.getFileName();
        if (string == null) {
            return;
        }
        String string2 = saveDialog.getDirectory();
        PrintWriter printWriter = null;
        try {
            object = new FileOutputStream(string2 + string);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)object);
            printWriter = new PrintWriter(bufferedOutputStream);
        }
        catch (IOException iOException) {
            IJ.showMessage("XYWriter", "" + iOException);
            return;
        }
        object = (PolygonRoi)roi;
        int n = ((PolygonRoi)object).getNCoordinates();
        int[] nArray = ((PolygonRoi)object).getXCoordinates();
        int[] nArray2 = ((PolygonRoi)object).getYCoordinates();
        Calibration calibration = imagePlus.getCalibration();
        String string3 = System.getProperty("line.separator");
        boolean bl = calibration.scaled();
        int n2 = 0;
        while (n2 < n) {
            if (bl) {
                printWriter.print(IJ.d2s((double)nArray[n2] * calibration.pixelWidth) + "\t" + IJ.d2s((double)nArray2[n2] * calibration.pixelHeight) + string3);
            } else {
                printWriter.print(nArray[n2] + "\t" + nArray2[n2] + string3);
            }
            ++n2;
        }
        printWriter.close();
    }
}

