/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.io.SaveDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;

public class XYCoordinates
implements PlugInFilter {
    ImagePlus imp;

    public int setup(String string, ImagePlus imagePlus) {
        this.imp = imagePlus;
        return 3;
    }

    public void run(ImageProcessor imageProcessor) {
        Object object;
        int n = this.imp.getWidth();
        int n2 = this.imp.getHeight();
        int n3 = imageProcessor.getPixel(0, 0);
        this.imp.killRoi();
        boolean bl = IJ.showMessageWithCancel("XY_Coordinates", "This plugin writes to a text file the XY coordinates and\npixel value of all non-background pixels. Backround\nis assumed to be the value of the pixel in the\nupper left corner of the image.\n \nwidth: " + n + "\n" + "height: " + n2 + "\n" + "background value: " + n3 + "\n");
        if (!bl) {
            return;
        }
        SaveDialog saveDialog = new SaveDialog("Save Coordinates as Text...", this.imp.getTitle(), ".txt");
        String string = saveDialog.getFileName();
        if (string == null) {
            return;
        }
        String string2 = saveDialog.getDirectory();
        PrintWriter printWriter = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2 + string);
            object = new BufferedOutputStream(fileOutputStream);
            printWriter = new PrintWriter((OutputStream)object);
        }
        catch (IOException iOException) {
            IJ.write("" + iOException);
            return;
        }
        IJ.showStatus("Saving coordinates...");
        int n4 = 0;
        object = (byte[])imageProcessor.getPixels();
        String string3 = System.getProperty("line.separator");
        int n5 = n2 - 1;
        while (n5 >= 0) {
            int n6 = 0;
            while (n6 < n) {
                int n7 = object[n5 * n + n6] & 0xFF;
                if (n7 != n3) {
                    printWriter.print(n6 + " " + (n2 - 1 - n5) + " " + n7 + string3);
                    ++n4;
                }
                ++n6;
            }
            if (n5 % 10 == 0) {
                IJ.showProgress((double)(n2 - n5) / (double)n2);
            }
            --n5;
        }
        IJ.showProgress(1.0);
        printWriter.close();
        IJ.write(this.imp.getTitle() + ": " + n4 + " pixels (" + IJ.d2s((double)n4 * 100.0 / (double)(n * n2)) + "%)\n");
    }
}

