/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Line;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.filter.Calibrator;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;

public class ScaleDialog
implements PlugInFilter {
    private ImagePlus imp;
    private static /* synthetic */ Class class$Lij$plugin$filter$ScaleDialog;

    public int setup(String string, ImagePlus imagePlus) {
        this.imp = imagePlus;
        IJ.register(class$Lij$plugin$filter$ScaleDialog != null ? class$Lij$plugin$filter$ScaleDialog : (class$Lij$plugin$filter$ScaleDialog = ScaleDialog.class$("ij.plugin.filter.ScaleDialog")));
        return 159;
    }

    public void run(ImageProcessor imageProcessor) {
        Roi roi;
        double d = 0.0;
        double d2 = 1.0;
        double d3 = 1.0;
        String string = "cm";
        boolean bl = Calibrator.global;
        Calibration calibration = this.imp.getCalibration();
        boolean bl2 = calibration.scaled();
        if (bl2) {
            d = 1.0 / calibration.pixelWidth;
            d2 = 1.0;
            d3 = calibration.pixelHeight / calibration.pixelWidth;
            string = calibration.getUnit();
        }
        if ((roi = this.imp.getRoi()) != null && roi instanceof Line) {
            d = ((Line)roi).getRawLength();
            d2 = 0.0;
        }
        GenericDialog genericDialog = new GenericDialog("Set Scale", IJ.getInstance());
        genericDialog.addNumericField("Distance in Pixels:", d, 2);
        genericDialog.addNumericField("Known Distance:", d2, 2);
        genericDialog.addNumericField("Pixel Aspect Ratio:", d3, 1);
        genericDialog.addStringField("Unit of Measurement:", string);
        genericDialog.addCheckbox("Global", Calibrator.global);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        d = genericDialog.getNextNumber();
        d2 = genericDialog.getNextNumber();
        d3 = genericDialog.getNextNumber();
        string = genericDialog.getNextString();
        Calibrator.global = genericDialog.getNextBoolean();
        if (d != 0.0 && d2 == 0.0) {
            this.imp.setGlobalCalibration(Calibrator.global ? calibration : null);
            return;
        }
        if (d <= 0.0 || string.startsWith("pixel") || string.startsWith("Pixel") || string.equals("")) {
            calibration.pixelWidth = 1.0;
            calibration.pixelHeight = 1.0;
            calibration.setUnit("pixel");
        } else {
            calibration.pixelWidth = d2 / d;
            calibration.pixelHeight = d3 != 0.0 ? calibration.pixelWidth * d3 : calibration.pixelWidth;
            calibration.setUnit(string);
        }
        if (bl && !Calibrator.global) {
            this.imp.setGlobalCalibration(null);
        } else {
            this.imp.setCalibration(calibration);
            this.imp.setGlobalCalibration(Calibrator.global ? calibration : null);
        }
        if (Calibrator.global || Calibrator.global != bl) {
            int[] nArray = WindowManager.getIDList();
            if (nArray == null) {
                return;
            }
            int n = 0;
            while (n < nArray.length) {
                ImagePlus imagePlus = WindowManager.getImage(nArray[n]);
                if (imagePlus != null) {
                    imagePlus.getWindow().repaint();
                }
                ++n;
            }
        } else {
            this.imp.getWindow().repaint();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

