/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.io.SaveDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.awt.Rectangle;
import java.io.FileOutputStream;

public class RoiWriter
implements PlugInFilter {
    static final int HEADER_SIZE = 64;
    static final int VERSION = 217;
    final int polygon;
    final int rect;
    final int oval;
    final int line;
    final int freeLine;
    final int segLine;
    final int noRoi;
    final int freehand;
    final int traced;
    ImagePlus imp;
    byte[] data;

    public int setup(String string, ImagePlus imagePlus) {
        this.imp = imagePlus;
        return 1183;
    }

    public void run(ImageProcessor imageProcessor) {
        try {
            this.saveRoi(this.imp);
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string == null || string.equals("")) {
                string = "" + exception;
            }
            IJ.showMessage("ROI Writer", string);
        }
    }

    public void saveRoi(ImagePlus imagePlus) throws Exception {
        Cloneable cloneable;
        String string;
        int n;
        Roi roi = imagePlus.getRoi();
        if (roi == null) {
            throw new IllegalArgumentException("ROI required");
        }
        int n2 = roi.getType();
        if (n2 >= 5) {
            throw new IllegalArgumentException("Area selection required");
        }
        if (n2 == 2) {
            n = 0;
            string = "Polygon.roi";
        } else if (n2 == 3) {
            n = 7;
            string = "Freehand.roi";
        } else if (n2 == 4) {
            n = 8;
            string = "TracedRoi.roi";
        } else if (n2 == 1) {
            n = 2;
            string = "Oval.roi";
        } else {
            n = 1;
            string = "Rectangle.roi";
        }
        SaveDialog saveDialog = new SaveDialog("Save ROI...", string, ".roi");
        string = saveDialog.getFileName();
        if (string == null) {
            return;
        }
        String string2 = saveDialog.getDirectory();
        FileOutputStream fileOutputStream = new FileOutputStream(string2 + string);
        int n3 = 0;
        int[] nArray = null;
        int[] nArray2 = null;
        if (roi instanceof PolygonRoi) {
            cloneable = (PolygonRoi)roi;
            n3 = cloneable.getNCoordinates();
            nArray = cloneable.getXCoordinates();
            nArray2 = cloneable.getYCoordinates();
        }
        this.data = new byte[64 + n3 * 4];
        cloneable = roi.getBoundingRect();
        this.data[0] = 73;
        this.data[1] = 111;
        this.data[2] = 117;
        this.data[3] = 116;
        this.putShort(4, 217);
        this.data[6] = (byte)n;
        this.putShort(8, ((Rectangle)cloneable).y);
        this.putShort(10, ((Rectangle)cloneable).x);
        this.putShort(12, ((Rectangle)cloneable).y + ((Rectangle)cloneable).height);
        this.putShort(14, ((Rectangle)cloneable).x + ((Rectangle)cloneable).width);
        this.putShort(16, n3);
        if (n3 > 0) {
            int n4 = 64;
            int n5 = n4 + 2 * n3;
            int n6 = 0;
            while (n6 < n3) {
                this.putShort(n4 + n6 * 2, nArray[n6]);
                this.putShort(n5 + n6 * 2, nArray2[n6]);
                ++n6;
            }
        }
        fileOutputStream.write(this.data);
        fileOutputStream.close();
    }

    void putShort(int n, int n2) {
        this.data[n] = (byte)(n2 >>> 8 & 0xFF);
        this.data[n + 1] = (byte)(n2 & 0xFF);
    }

    public RoiWriter() {
        this.polygon = 0;
        this.rect = 1;
        this.oval = 2;
        this.line = 3;
        this.freeLine = 4;
        this.segLine = 5;
        this.noRoi = 6;
        this.freehand = 7;
        this.traced = 8;
    }
}

