/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.process.StackProcessor;
import java.awt.Rectangle;

public class Resizer
implements PlugInFilter {
    private static int newWidth = 100;
    private static int newHeight = 100;
    private static boolean constrain = true;
    private static boolean interpolate = true;
    ImagePlus imp;
    private boolean crop;
    private static /* synthetic */ Class class$Lij$plugin$filter$Resizer;

    public int setup(String string, ImagePlus imagePlus) {
        this.crop = string.equals("crop");
        this.imp = imagePlus;
        IJ.register(class$Lij$plugin$filter$Resizer != null ? class$Lij$plugin$filter$Resizer : (class$Lij$plugin$filter$Resizer = Resizer.class$("ij.plugin.filter.Resizer")));
        if (this.crop) {
            return 1183;
        }
        return 159;
    }

    public void run(ImageProcessor imageProcessor) {
        Object object;
        boolean bl = false;
        if (this.crop) {
            object = this.imp.getRoi();
            Rectangle rectangle = ((Roi)object).getBoundingRect();
            newWidth = rectangle.width;
            newHeight = rectangle.height;
        } else {
            object = new GenericDialog("Resize", IJ.getInstance());
            ((GenericDialog)object).addNumericField("New width (pixels):", newWidth, 0);
            ((GenericDialog)object).addNumericField("New Height (pixels):", newHeight, 0);
            ((GenericDialog)object).addCheckbox("Constrain Aspect Ratio", constrain);
            ((GenericDialog)object).addCheckbox("Interpolate", interpolate);
            ((GenericDialog)object).addMessage("NOTE: Undo is not available");
            ((GenericDialog)object).showDialog();
            if (((GenericDialog)object).wasCanceled()) {
                return;
            }
            newWidth = (int)((GenericDialog)object).getNextNumber();
            newHeight = (int)((GenericDialog)object).getNextNumber();
            if (((GenericDialog)object).invalidNumber()) {
                IJ.error("Width or height are invalid.");
                return;
            }
            constrain = ((GenericDialog)object).getNextBoolean();
            interpolate = ((GenericDialog)object).getNextBoolean();
            boolean bl2 = bl = constrain && newWidth == 0;
            if ((double)newWidth <= 0.0 && !constrain) {
                newWidth = 50;
            }
            if ((double)newHeight <= 0.0) {
                newHeight = 50;
            }
        }
        object = imageProcessor.getRoi();
        double d = ((Rectangle)object).width;
        double d2 = ((Rectangle)object).height;
        if (!this.crop && constrain) {
            if (bl) {
                newWidth = (int)((double)newHeight * (d / d2));
            } else {
                newHeight = (int)((double)newWidth * (d2 / d));
            }
        }
        imageProcessor.setInterpolate(interpolate);
        int n = this.imp.getStackSize();
        try {
            StackProcessor stackProcessor = new StackProcessor(this.imp.getStack(), imageProcessor);
            ImageStack imageStack = stackProcessor.resize(newWidth, newHeight);
            int n2 = imageStack.getSize();
            if (imageStack.getWidth() > 0 && n2 > 0) {
                this.imp.hide();
                Calibration calibration = this.imp.getCalibration();
                if (calibration.scaled()) {
                    calibration.pixelWidth *= d / (double)newWidth;
                    calibration.pixelHeight *= d2 / (double)newHeight;
                    this.imp.setCalibration(calibration);
                }
                this.imp.setStack(null, imageStack);
                this.imp.show();
            }
            if (n > 1 && n2 < n) {
                IJ.error("ImageJ ran out of memory causing \nthe last " + (n - n2) + " slices to be lost.");
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            IJ.outOfMemory("Resize");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

