/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.gui.HistogramWindow;
import ij.gui.ImageWindow;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.Wand;
import ij.measure.Calibration;
import ij.measure.ResultsTable;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ByteStatistics;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.Hashtable;
import java.util.Properties;

public class ParticleAnalyzer
implements PlugInFilter {
    public static final int SHOW_RESULTS = 1;
    public static final int SHOW_SUMMARY = 2;
    public static final int SHOW_OUTLINES = 4;
    public static final int EXCLUDE_EDGE_PARTICLES = 8;
    public static final int SHOW_SIZE_DISTRIBUTION = 16;
    public static final int SHOW_PROGRESS = 32;
    public static final int CLEAR_WORKSHEET = 64;
    static final String OPTIONS = "ap.options";
    static final String BINS = "ap.bins";
    private static int staticMinSize = 1;
    private static int staticMaxSize = 999999;
    private static int staticOptions = Prefs.getInt("ap.options", 66);
    private static int staticBins = Prefs.getInt("ap.bins", 20);
    protected ImagePlus imp;
    protected ResultsTable rt;
    protected Analyzer analyzer;
    private int level1;
    private int level2;
    private int minSize;
    private int maxSize;
    private int sizeBins;
    private int options;
    private int measurements;
    private Calibration calibration;
    private String arg;
    private int fillColor;
    private boolean thresholdingLUT;
    private boolean showResults;
    private boolean showOutlines;
    private boolean showSummary;
    private boolean excludeEdgeParticles;
    private boolean showSizeDistribution;
    private boolean resetCounter;
    private boolean showProgress;
    private ImageProcessor ip2;
    private int width;
    private int height;
    private static /* synthetic */ Class class$Lij$plugin$filter$ParticleAnalyzer;

    public int setup(String string, ImagePlus imagePlus) {
        this.arg = string;
        this.imp = imagePlus;
        IJ.register(class$Lij$plugin$filter$ParticleAnalyzer != null ? class$Lij$plugin$filter$ParticleAnalyzer : (class$Lij$plugin$filter$ParticleAnalyzer = ParticleAnalyzer.class$("ij.plugin.filter.ParticleAnalyzer")));
        return 385;
    }

    public void run(ImageProcessor imageProcessor) {
        if (!this.showDialog()) {
            return;
        }
        this.imp.startTiming();
        this.analyze(this.imp, imageProcessor);
    }

    public boolean showDialog() {
        GenericDialog genericDialog = new GenericDialog("Analyze Particles", IJ.getInstance());
        this.minSize = staticMinSize;
        this.maxSize = staticMaxSize;
        this.sizeBins = staticBins;
        this.options = staticOptions;
        genericDialog.addNumericField("Minimum Size (pixels):", this.minSize, 0);
        genericDialog.addNumericField("Maximum Size (pixels):", this.maxSize, 0);
        genericDialog.addNumericField("Bins (2-256):", this.sizeBins, 0);
        genericDialog.addCheckbox("Display Results", (this.options & 1) != 0);
        genericDialog.addCheckbox("Show Outlines", (this.options & 4) != 0);
        genericDialog.addCheckbox("Exclude Edge Particles", (this.options & 8) != 0);
        genericDialog.addCheckbox("Size Distribution", (this.options & 0x10) != 0);
        genericDialog.addCheckbox("Clear Worksheet", (this.options & 0x40) != 0);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return false;
        }
        this.minSize = (int)genericDialog.getNextNumber();
        this.maxSize = (int)genericDialog.getNextNumber();
        this.sizeBins = (int)genericDialog.getNextNumber();
        if (genericDialog.invalidNumber()) {
            IJ.error("Minimum Size, Maximum Size or Bins invalid.");
            return false;
        }
        staticMinSize = this.minSize;
        staticMaxSize = this.maxSize;
        staticBins = this.sizeBins;
        this.options = genericDialog.getNextBoolean() ? (this.options |= 1) : (this.options &= 0xFFFFFFFE);
        this.options = genericDialog.getNextBoolean() ? (this.options |= 4) : (this.options &= 0xFFFFFFFB);
        this.options = genericDialog.getNextBoolean() ? (this.options |= 8) : (this.options &= 0xFFFFFFF7);
        this.options = genericDialog.getNextBoolean() ? (this.options |= 0x10) : (this.options &= 0xFFFFFFEF);
        this.options = genericDialog.getNextBoolean() ? (this.options |= 0x40) : (this.options &= 0xFFFFFFBF);
        staticOptions = this.options;
        this.options |= 0x20;
        return true;
    }

    public boolean analyze(ImagePlus imagePlus) {
        return this.analyze(imagePlus, imagePlus.getProcessor());
    }

    public boolean analyze(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        this.showResults = (this.options & 1) != 0;
        this.showOutlines = (this.options & 4) != 0;
        this.excludeEdgeParticles = (this.options & 8) != 0;
        this.showSizeDistribution = (this.options & 0x10) != 0;
        this.resetCounter = (this.options & 0x40) != 0;
        this.showProgress = (this.options & 0x20) != 0;
        imageProcessor.snapshot();
        imageProcessor.setProgressBar(null);
        if (!this.setThresholdLevels(imagePlus, imageProcessor)) {
            return false;
        }
        if (this.showOutlines) {
            this.ip2 = new ByteProcessor(imageProcessor.getWidth(), imageProcessor.getHeight());
            this.ip2.setColor(Color.white);
            this.ip2.fill();
            this.ip2.setColor(Color.black);
        }
        this.calibration = imagePlus.getCalibration();
        byte[] byArray = (byte[])imageProcessor.getPixels();
        this.width = imageProcessor.getWidth();
        this.height = imageProcessor.getHeight();
        Rectangle rectangle = imageProcessor.getRoi();
        int[] nArray = imagePlus.getMask();
        int n = rectangle.height / 20;
        if (n < 1) {
            n = 1;
        }
        int n2 = 0;
        if (this.rt == null) {
            this.rt = Analyzer.getResultsTable();
            this.analyzer = new Analyzer(imagePlus);
        } else {
            this.analyzer = new Analyzer(imagePlus, this.measurements, this.rt);
        }
        if (this.resetCounter && !Analyzer.resetCounter()) {
            return false;
        }
        ImageWindow imageWindow = imagePlus.getWindow();
        if (imageWindow != null) {
            imageWindow.running = true;
        }
        boolean bl = false;
        if (this.measurements == 0) {
            this.measurements = Analyzer.getMeasurements();
        }
        int n3 = rectangle.y;
        while (n3 < rectangle.y + rectangle.height) {
            int n4 = n3 * this.width;
            int n5 = rectangle.x;
            while (n5 < rectangle.x + rectangle.width) {
                int n6 = byArray[n4 + n5] & 0xFF;
                if (nArray != null && nArray[n2++] != ImageProcessor.BLACK) {
                    n6 = -1;
                }
                if (n6 >= this.level1 && n6 <= this.level2) {
                    this.analyzeParticle(n5, n3, imagePlus, imageProcessor);
                }
                ++n5;
            }
            if (this.showProgress && n3 % n == 0) {
                IJ.showProgress((double)(n3 - rectangle.y) / (double)rectangle.height);
            }
            if (imageWindow != null) {
                boolean bl2 = bl = !imageWindow.running;
            }
            if (bl) break;
            ++n3;
        }
        if (this.showProgress) {
            IJ.showProgress(1.0);
        }
        imagePlus.killRoi();
        imageProcessor.setRoi(null);
        imageProcessor.reset();
        if (!bl) {
            this.showResults();
        }
        return true;
    }

    boolean setThresholdLevels(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        double d = imageProcessor.getMinThreshold();
        double d2 = imageProcessor.getMaxThreshold();
        boolean bl = imagePlus.isInvertedLut();
        if (d == ImageProcessor.NO_THRESHOLD) {
            ImageStatistics imageStatistics = imagePlus.getStatistics();
            if (imageStatistics.histogram[0] + imageStatistics.histogram[255] != imageStatistics.pixelCount) {
                IJ.error("8-bit binary or thresholded image required.");
                return false;
            }
            if (bl) {
                this.level1 = 255;
                this.level2 = 255;
                this.fillColor = 64;
            } else {
                this.level1 = 0;
                this.level2 = 0;
                this.fillColor = 192;
            }
        } else {
            this.level1 = (int)d;
            this.level2 = (int)d2;
            if (this.level1 > 0) {
                this.fillColor = 0;
            } else if (this.level2 < 255) {
                this.fillColor = 255;
            } else {
                return false;
            }
        }
        return true;
    }

    void drawOutline(Roi roi, int n) {
        Rectangle rectangle = roi.getBoundingRect();
        int n2 = ((PolygonRoi)roi).getNCoordinates();
        int[] nArray = ((PolygonRoi)roi).getXCoordinates();
        int[] nArray2 = ((PolygonRoi)roi).getYCoordinates();
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        this.ip2.moveTo(n3 + nArray[0], n4 + nArray2[0]);
        int n5 = 1;
        while (n5 < n2) {
            this.ip2.lineTo(n3 + nArray[n5], n4 + nArray2[n5]);
            ++n5;
        }
        this.ip2.lineTo(n3 + nArray[0], n4 + nArray2[0]);
        String string = IJ.d2s(n, 0);
        this.ip2.moveTo(rectangle.x + rectangle.width / 2 - this.ip2.getStringWidth(string) / 2, rectangle.y + rectangle.height / 2 + 4);
        this.ip2.drawString(string);
    }

    void analyzeParticle(int n, int n2, ImagePlus imagePlus, ImageProcessor imageProcessor) {
        int[] nArray;
        Wand wand = new Wand(imageProcessor);
        wand.autoOutline(n, n2, this.level1, this.level2);
        if (wand.npoints == 0) {
            IJ.write("wand error: " + n + " " + n2);
            return;
        }
        PolygonRoi polygonRoi = new PolygonRoi(wand.xpoints, wand.ypoints, wand.npoints, imagePlus, 4);
        Rectangle rectangle = polygonRoi.getBoundingRect();
        imageProcessor.setRoi(rectangle);
        if (rectangle.width > 1 && rectangle.height > 1) {
            imageProcessor.setMask(((Roi)polygonRoi).getMask());
        }
        imageProcessor.setColor(this.fillColor);
        ByteStatistics byteStatistics = new ByteStatistics(imageProcessor, this.measurements, this.calibration);
        boolean bl = true;
        if (this.excludeEdgeParticles && (rectangle.x == 0 || rectangle.y == 0 || rectangle.x + rectangle.width == this.width || rectangle.y + rectangle.height == this.height)) {
            bl = false;
        }
        if (byteStatistics.pixelCount >= this.minSize && byteStatistics.pixelCount <= this.maxSize && bl) {
            this.saveResults(byteStatistics, polygonRoi);
        }
        if ((nArray = imageProcessor.getMask()) != null) {
            imageProcessor.fill(nArray);
        } else {
            imageProcessor.fill();
        }
    }

    protected void saveResults(ImageStatistics imageStatistics, Roi roi) {
        this.analyzer.saveResults(imageStatistics, roi);
        if (this.showResults) {
            this.analyzer.displayResults();
        }
        if (this.showOutlines) {
            this.drawOutline(roi, this.rt.getCounter());
        }
    }

    void showResults() {
        int n = this.rt.getCounter();
        if (n == 0) {
            return;
        }
        FloatProcessor floatProcessor = null;
        if (this.showSizeDistribution) {
            if (floatProcessor == null) {
                floatProcessor = new FloatProcessor(n, 1, this.rt.getColumn(0), null);
            }
            new HistogramWindow("Particle Size Distribution", new ImagePlus("", floatProcessor), this.sizeBins);
        }
        if (this.ip2 != null) {
            new ImagePlus("Outlines", this.ip2).show();
        }
    }

    public static void savePreferences(Properties properties) {
        ((Hashtable)properties).put(OPTIONS, Integer.toString(staticOptions));
        ((Hashtable)properties).put(BINS, Integer.toString(staticBins));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ParticleAnalyzer(int n, int n2, ResultsTable resultsTable, double d, double d2) {
        this.options = n;
        this.measurements = n2;
        this.rt = resultsTable;
        if (this.rt == null) {
            this.rt = new ResultsTable();
        }
        this.minSize = (int)d;
        this.maxSize = (int)d2;
        this.sizeBins = staticBins;
    }

    public ParticleAnalyzer() {
    }
}

