/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.LookUpTable;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;

public class LutViewer
implements PlugInFilter {
    ImagePlus imp;

    public int setup(String string, ImagePlus imagePlus) {
        this.imp = imagePlus;
        return 399;
    }

    public void run(ImageProcessor imageProcessor) {
        int n;
        int n2;
        int n3 = 35;
        int n4 = 20;
        int n5 = 256;
        int n6 = 128;
        int n7 = 12;
        LookUpTable lookUpTable = this.imp.createLut();
        int n8 = lookUpTable.getMapSize();
        if (n8 == 0) {
            return;
        }
        int n9 = n5 + 2 * n3;
        int n10 = n6 + 4 * n4;
        Image image = IJ.getInstance().createImage(n9, n10);
        Graphics graphics = image.getGraphics();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, n9, n10);
        graphics.setColor(Color.black);
        graphics.drawRect(n3, n4, n5, n6);
        byte[] byArray = lookUpTable.getReds();
        byte[] byArray2 = lookUpTable.getGreens();
        byte[] byArray3 = lookUpTable.getBlues();
        double d = 256.0 / (double)n8;
        boolean bl = lookUpTable.isGrayscale();
        if (bl) {
            graphics.setColor(Color.black);
        } else {
            graphics.setColor(Color.red);
        }
        int n11 = n3;
        int n12 = n4 + n6 - (byArray[0] & 0xFF) / 2;
        int n13 = 1;
        while (n13 < 256) {
            n2 = n3 + n13;
            n = n4 + n6 - (byArray[(int)((double)n13 / d)] & 0xFF) / 2;
            graphics.drawLine(n11, n12, n2, n);
            n11 = n2;
            n12 = n;
            ++n13;
        }
        if (!bl) {
            graphics.setColor(Color.green);
            n11 = n3;
            n12 = n4 + n6 - (byArray2[0] & 0xFF) / 2;
            n13 = 1;
            while (n13 < 256) {
                n2 = n3 + n13;
                n = n4 + n6 - (byArray2[(int)((double)n13 / d)] & 0xFF) / 2;
                graphics.drawLine(n11, n12, n2, n);
                n11 = n2;
                n12 = n;
                ++n13;
            }
        }
        if (!bl) {
            graphics.setColor(Color.blue);
            n11 = n3;
            n12 = n4 + n6 - (byArray3[0] & 0xFF) / 2;
            n13 = 1;
            while (n13 < 255) {
                n2 = n3 + n13;
                n = n4 + n6 - (byArray3[(int)((double)n13 / d)] & 0xFF) / 2;
                graphics.drawLine(n11, n12, n2, n);
                n11 = n2;
                n12 = n;
                ++n13;
            }
        }
        int n14 = n3;
        int n15 = n4 + n6 + 2;
        lookUpTable.drawColorBar(graphics, n14, n15, 256, n7);
        graphics.setColor(Color.black);
        graphics.drawString("0", n14 - 4, n15 += n7 + 15);
        graphics.drawString("" + (n8 - 1), n14 + n5 - 10, n15);
        graphics.drawString("255", 7, n4 + 4);
        graphics.dispose();
        ImagePlus imagePlus = new ImagePlus("Look-Up Table", image);
        imagePlus.show();
    }
}

