/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;

public class ImageMath
implements PlugInFilter {
    private static boolean first;
    private static double addValue;
    private static double mulValue;
    private static double minValue;
    private static double maxValue;
    private static final String defaultAndValue = "11110000";
    private static String andValue;
    private static final double defaultGammaValue = 0.5;
    private static double gammaValue;
    private String arg;
    private ImagePlus imp;
    private boolean canceled;
    private static /* synthetic */ Class class$Lij$plugin$filter$ImageMath;

    public int setup(String string, ImagePlus imagePlus) {
        this.arg = string;
        this.imp = imagePlus;
        first = true;
        IJ.register(class$Lij$plugin$filter$ImageMath != null ? class$Lij$plugin$filter$ImageMath : (class$Lij$plugin$filter$ImageMath = ImageMath.class$("ij.plugin.filter.ImageMath")));
        return IJ.setupDialog(imagePlus, 95);
    }

    public void run(ImageProcessor imageProcessor) {
        if (this.canceled) {
            return;
        }
        if (this.arg.equals("add")) {
            if (first) {
                addValue = this.getValue("Add: ", addValue, 0);
            }
            if (this.canceled) {
                return;
            }
            imageProcessor.add((int)addValue);
            return;
        }
        if (this.arg.equals("sub")) {
            if (first) {
                addValue = this.getValue("Subtract: ", addValue, 0);
            }
            if (this.canceled) {
                return;
            }
            imageProcessor.add((int)(-addValue));
            return;
        }
        if (this.arg.equals("mul")) {
            if (first) {
                mulValue = this.getValue("Multiple: ", mulValue, 2);
            }
            if (this.canceled) {
                return;
            }
            imageProcessor.multiply(mulValue);
            return;
        }
        if (this.arg.equals("div")) {
            if (first) {
                mulValue = this.getValue("Divide: ", mulValue, 2);
            }
            if (this.canceled) {
                return;
            }
            if (mulValue != 0.0) {
                imageProcessor.multiply(1.0 / mulValue);
            }
            return;
        }
        if (this.arg.equals("and")) {
            if (first) {
                andValue = this.getBinaryValue("AND (binary): ", andValue);
            }
            if (this.canceled) {
                return;
            }
            try {
                imageProcessor.and(Integer.parseInt(andValue, 2));
            }
            catch (NumberFormatException numberFormatException) {
                andValue = defaultAndValue;
                IJ.error("Binary number required");
            }
            return;
        }
        if (this.arg.equals("or")) {
            if (first) {
                andValue = this.getBinaryValue("OR (binary): ", andValue);
            }
            if (this.canceled) {
                return;
            }
            try {
                imageProcessor.or(Integer.parseInt(andValue, 2));
            }
            catch (NumberFormatException numberFormatException) {
                andValue = defaultAndValue;
                IJ.error("Binary number required");
            }
            return;
        }
        if (this.arg.equals("xor")) {
            if (first) {
                andValue = this.getBinaryValue("XOR (binary): ", andValue);
            }
            if (this.canceled) {
                return;
            }
            try {
                imageProcessor.xor(Integer.parseInt(andValue, 2));
            }
            catch (NumberFormatException numberFormatException) {
                andValue = defaultAndValue;
                IJ.error("Binary number required");
            }
            return;
        }
        if ((this.arg.equals("min") || this.arg.equals("max")) && imageProcessor instanceof ColorProcessor) {
            IJ.error("RGB images not supported");
            this.canceled = true;
            return;
        }
        if (this.arg.equals("min")) {
            if (first) {
                minValue = this.getValue("Minimum: ", minValue, 0);
            }
            if (this.canceled) {
                return;
            }
            int n = 0;
            while (n < imageProcessor.getHeight()) {
                int n2 = 0;
                while (n2 < imageProcessor.getWidth()) {
                    double d = imageProcessor.getPixelValue(n2, n);
                    if (d < minValue) {
                        d = minValue;
                    }
                    imageProcessor.putPixelValue(n2, n, d);
                    ++n2;
                }
                ++n;
            }
            return;
        }
        if (this.arg.equals("max")) {
            if (first) {
                maxValue = this.getValue("Maximum: ", maxValue, 0);
            }
            if (this.canceled) {
                return;
            }
            int n = 0;
            while (n < imageProcessor.getHeight()) {
                int n3 = 0;
                while (n3 < imageProcessor.getWidth()) {
                    double d = imageProcessor.getPixelValue(n3, n);
                    if (d > maxValue) {
                        d = maxValue;
                    }
                    imageProcessor.putPixelValue(n3, n, d);
                    ++n3;
                }
                ++n;
            }
            return;
        }
        if (this.arg.equals("gamma")) {
            if (first) {
                gammaValue = this.getValue("Gamma (0.1-5.0): ", gammaValue, 2);
            }
            if (this.canceled) {
                return;
            }
            if (gammaValue < 0.1 || gammaValue > 5.0) {
                IJ.error("Gamma must be between 0.1 and 5.0");
                gammaValue = 0.5;
                return;
            }
            imageProcessor.gamma(gammaValue);
            return;
        }
        if (this.arg.equals("log")) {
            imageProcessor.log();
            return;
        }
        if (this.arg.equals("reciprocal")) {
            if (!(imageProcessor instanceof FloatProcessor)) {
                IJ.error("32-bit float image required");
                this.canceled = true;
                return;
            }
            float[] fArray = (float[])imageProcessor.getPixels();
            int n = 0;
            while (n < imageProcessor.getWidth() * imageProcessor.getHeight()) {
                fArray[n] = fArray[n] == 0.0f ? Float.NaN : 1.0f / fArray[n];
                ++n;
            }
            return;
        }
    }

    double getValue(String string, double d, int n) {
        GenericDialog genericDialog = new GenericDialog("Math", IJ.getInstance());
        genericDialog.addNumericField(string, d, n);
        genericDialog.showDialog();
        if (first) {
            this.imp.startTiming();
        }
        first = false;
        this.canceled = genericDialog.wasCanceled();
        if (this.canceled) {
            return d;
        }
        return genericDialog.getNextNumber();
    }

    String getBinaryValue(String string, String string2) {
        GenericDialog genericDialog = new GenericDialog("Math", IJ.getInstance());
        genericDialog.addStringField(string, string2);
        genericDialog.showDialog();
        if (first) {
            this.imp.startTiming();
        }
        first = false;
        this.canceled = genericDialog.wasCanceled();
        if (this.canceled) {
            return string2;
        }
        return genericDialog.getNextString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        addValue = 25.0;
        mulValue = 1.25;
        minValue = 0.0;
        maxValue = 255.0;
        andValue = defaultAndValue;
        gammaValue = 0.5;
    }
}

