/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.PlotWindow;
import ij.measure.CurveFitter;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.util.Tools;
import java.awt.Rectangle;
import java.util.StringTokenizer;

public class FractalBoxCounter
implements PlugInFilter {
    static String sizes = "2,3,4,6,8,12,16,32,64";
    int[] boxSizes;
    float[] boxCountSums;
    int maxBoxSize;
    int[] counts;
    Rectangle roi;
    int foreground;
    ImagePlus imp;
    int boxSum;
    private static /* synthetic */ Class class$Lij$plugin$filter$FractalBoxCounter;

    public int setup(String string, ImagePlus imagePlus) {
        this.imp = imagePlus;
        return 129;
    }

    public void run(ImageProcessor imageProcessor) {
        String string = IJ.getString("Box sizes:", sizes);
        if (string.equals("")) {
            return;
        }
        this.boxSizes = this.s2ints(string);
        if (this.boxSizes == null || this.boxSizes.length < 1) {
            return;
        }
        this.boxCountSums = new float[this.boxSizes.length];
        sizes = string;
        int n = 0;
        while (n < this.boxSizes.length) {
            this.maxBoxSize = Math.max(this.maxBoxSize, this.boxSizes[n]);
            ++n;
        }
        this.counts = new int[this.maxBoxSize * this.maxBoxSize + 1];
        this.imp.killRoi();
        ImageStatistics imageStatistics = this.imp.getStatistics();
        if (imageStatistics.histogram[0] + imageStatistics.histogram[255] != imageStatistics.pixelCount) {
            IJ.error("8-bit binary image (0 and 255) required.");
            return;
        }
        this.foreground = imageStatistics.histogram[0] > imageStatistics.histogram[255] ? 255 : 0;
        this.doBoxCounts(imageProcessor);
        IJ.register(class$Lij$plugin$filter$FractalBoxCounter != null ? class$Lij$plugin$filter$FractalBoxCounter : (class$Lij$plugin$filter$FractalBoxCounter = FractalBoxCounter.class$("ij.plugin.filter.FractalBoxCounter")));
    }

    public int[] s2ints(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", \t");
        int n = stringTokenizer.countTokens();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            try {
                nArray[n2] = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                IJ.write("" + numberFormatException);
                return null;
            }
            ++n2;
        }
        return nArray;
    }

    boolean FindMargins(ImageProcessor imageProcessor) {
        if (IJ.debugMode) {
            IJ.write("FindMargins");
        }
        int[] nArray = new int[256];
        int n = this.imp.getWidth();
        int n2 = this.imp.getHeight();
        int n3 = -1;
        do {
            if (++n3 >= n) {
                IJ.error("No non-backround pixels found.");
                return false;
            }
            imageProcessor.setRoi(n3, 0, 1, n2);
        } while ((nArray = imageProcessor.getHistogram())[this.foreground] == 0);
        int n4 = -1;
        do {
            imageProcessor.setRoi(n3, ++n4, n - n3, 1);
        } while ((nArray = imageProcessor.getHistogram())[this.foreground] == 0);
        int n5 = n + 1;
        do {
            imageProcessor.setRoi(--n5 - 1, n4, 1, n2 - n4);
        } while ((nArray = imageProcessor.getHistogram())[this.foreground] == 0);
        int n6 = n2 + 1;
        do {
            imageProcessor.setRoi(n3, --n6 - 1, n5 - n3, 1);
        } while ((nArray = imageProcessor.getHistogram())[this.foreground] == 0);
        this.roi = new Rectangle(n3, n4, n5 - n3, n6 - n4);
        return true;
    }

    void displayCounts(int n) {
        this.boxSum = 0;
        int n2 = n * n;
        int n3 = 1;
        while (n3 <= n2) {
            int n4 = this.counts[n3];
            if (n4 != 0) {
                this.boxSum += n4;
            }
            ++n3;
        }
        IJ.write(n + "\t" + this.boxSum);
    }

    void count(int n, ImageProcessor imageProcessor) {
        int[] nArray = new int[256];
        int n2 = this.roi.x;
        int n3 = this.roi.y;
        int n4 = n <= this.roi.width ? n : this.roi.width;
        int n5 = n <= this.roi.height ? n : this.roi.height;
        int n6 = this.roi.x + this.roi.width;
        int n7 = this.roi.y + this.roi.height;
        int n8 = n * n;
        int n9 = 1;
        while (n9 <= n8) {
            this.counts[n9] = 0;
            ++n9;
        }
        n9 = 0;
        do {
            imageProcessor.setRoi(n2, n3, n4, n5);
            nArray = imageProcessor.getHistogram();
            int n10 = nArray[this.foreground];
            this.counts[n10] = this.counts[n10] + 1;
            if ((n2 += n) + n < n6) continue;
            n4 = n6 - n2;
            if (n2 < n6) continue;
            n4 = n;
            n2 = this.roi.x;
            if ((n3 += n) + n >= n7) {
                n5 = n7 - n3;
            }
            int n11 = n9 = n3 < n7 ? 0 : 1;
        } while (n9 == 0);
        this.displayCounts(n);
    }

    void plot() {
        int n = this.boxSizes.length;
        float[] fArray = new float[this.boxSizes.length];
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = (float)Math.log(this.boxSizes[n2]);
            ++n2;
        }
        CurveFitter curveFitter = new CurveFitter(Tools.toDouble(fArray), Tools.toDouble(this.boxCountSums));
        curveFitter.doFit(0);
        double[] dArray = curveFitter.getParams();
        String string = "D=" + IJ.d2s(-dArray[1], 4);
        float[] fArray2 = new float[100];
        float[] fArray3 = new float[100];
        double[] dArray2 = Tools.getMinMax(fArray);
        double d = dArray2[0];
        double d2 = dArray2[1];
        dArray2 = Tools.getMinMax(this.boxCountSums);
        double d3 = dArray2[0];
        double d4 = dArray2[1];
        double d5 = (d2 - d) / 99.0;
        double d6 = d;
        int n3 = 0;
        while (n3 < 100) {
            fArray2[n3] = (float)d6;
            d6 += d5;
            ++n3;
        }
        n3 = 0;
        while (n3 < 100) {
            fArray3[n3] = (float)CurveFitter.f(0, dArray, fArray2[n3]);
            ++n3;
        }
        dArray2 = Tools.getMinMax(fArray3);
        d3 = Math.min(d3, dArray2[0]);
        d4 = Math.max(d4, dArray2[1]);
        PlotWindow plotWindow = new PlotWindow("Plot", "log(box size)", "log(count)", fArray2, fArray3);
        plotWindow.setLimits(d, d2, d3, d4);
        plotWindow.addPoints(fArray, this.boxCountSums, 0);
        plotWindow.addLabel(0.8, 0.2, string);
        plotWindow.draw();
        IJ.write("");
        IJ.write(string);
    }

    void doBoxCounts(ImageProcessor imageProcessor) {
        if (!this.FindMargins(imageProcessor)) {
            return;
        }
        IJ.setColumnHeadings("size\tcount");
        int n = 0;
        while (n < this.boxSizes.length) {
            this.count(this.boxSizes[n], imageProcessor);
            this.boxCountSums[n] = (float)Math.log(this.boxSum);
            ++n;
        }
        this.plot();
        this.imp.killRoi();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

